/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.VersionedProtocol;

public class RPC {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.RPC");
    private static Client CLIENT;

    private RPC() {
    }

    private static synchronized Client getClient(Configuration conf) {
        if (CLIENT == null) {
            CLIENT = new Client(ObjectWritable.class, conf);
        }
        return CLIENT;
    }

    public static synchronized void stopClient() {
        if (CLIENT != null) {
            CLIENT.stop();
            CLIENT = null;
        }
    }

    public static VersionedProtocol waitForProxy(Class protocol, long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        while (true) {
            try {
                return RPC.getProxy(protocol, clientVersion, addr, conf);
            }
            catch (ConnectException se) {
                LOG.info((Object)("Server at " + addr + " not available yet, Zzzzz..."));
            }
            catch (SocketTimeoutException te) {
                LOG.info((Object)("Problem connecting to server: " + addr));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
            }
        }
    }

    public static VersionedProtocol getProxy(Class protocol, long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        VersionedProtocol proxy = (VersionedProtocol)Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new Invoker(addr, conf));
        long serverVersion = proxy.getProtocolVersion(protocol.getName(), clientVersion);
        if (serverVersion == clientVersion) {
            return proxy;
        }
        throw new VersionMismatch(protocol.getName(), clientVersion, serverVersion);
    }

    public static Object[] call(Method method, Object[][] params, InetSocketAddress[] addrs, Configuration conf) throws IOException {
        Writable[] invocations = new Invocation[params.length];
        for (int i = 0; i < params.length; ++i) {
            invocations[i] = new Invocation(method, params[i]);
        }
        Writable[] wrappedValues = RPC.getClient(conf).call(invocations, addrs);
        if (method.getReturnType() == Void.TYPE) {
            return null;
        }
        Object[] values = (Object[])Array.newInstance(method.getReturnType(), wrappedValues.length);
        for (int i = 0; i < values.length; ++i) {
            if (wrappedValues[i] == null) continue;
            values[i] = ((ObjectWritable)wrappedValues[i]).get();
        }
        return values;
    }

    public static Server getServer(Object instance, String bindAddress, int port, Configuration conf) throws IOException {
        return RPC.getServer(instance, bindAddress, port, 1, false, conf);
    }

    public static Server getServer(Object instance, String bindAddress, int port, int numHandlers, boolean verbose, Configuration conf) throws IOException {
        return new Server(instance, conf, bindAddress, port, numHandlers, verbose);
    }

    private static void log(String value) {
        if (value != null && value.length() > 55) {
            value = value.substring(0, 55) + "...";
        }
        LOG.info((Object)value);
    }

    public static class Server
    extends org.apache.hadoop.ipc.Server {
        private Object instance;
        private Class<?> implementation;
        private boolean verbose;

        public Server(Object instance, Configuration conf, String bindAddress, int port) throws IOException {
            this(instance, conf, bindAddress, port, 1, false);
        }

        public Server(Object instance, Configuration conf, String bindAddress, int port, int numHandlers, boolean verbose) throws IOException {
            super(bindAddress, port, Invocation.class, numHandlers, conf);
            this.instance = instance;
            this.implementation = instance.getClass();
            this.verbose = verbose;
        }

        public Writable call(Writable param) throws IOException {
            try {
                Invocation call = (Invocation)param;
                if (this.verbose) {
                    RPC.log("Call: " + call);
                }
                Method method = this.implementation.getMethod(call.getMethodName(), call.getParameterClasses());
                long startTime = System.currentTimeMillis();
                Object value = method.invoke(this.instance, call.getParameters());
                long callTime = System.currentTimeMillis() - startTime;
                LOG.debug((Object)("Served: " + call.getMethodName() + " " + callTime));
                if (this.verbose) {
                    RPC.log("Return: " + value);
                }
                return new ObjectWritable(method.getReturnType(), value);
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof IOException) {
                    throw (IOException)target;
                }
                IOException ioe = new IOException(target.toString());
                ioe.setStackTrace(target.getStackTrace());
                throw ioe;
            }
            catch (Throwable e) {
                IOException ioe = new IOException(e.toString());
                ioe.setStackTrace(e.getStackTrace());
                throw ioe;
            }
        }
    }

    public static class VersionMismatch
    extends IOException {
        private String interfaceName;
        private long clientVersion;
        private long serverVersion;

        public VersionMismatch(String interfaceName, long clientVersion, long serverVersion) {
            super("Protocol " + interfaceName + " version mismatch. (client = " + clientVersion + ", server = " + serverVersion + ")");
            this.interfaceName = interfaceName;
            this.clientVersion = clientVersion;
            this.serverVersion = serverVersion;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public long getClientVersion() {
            return this.clientVersion;
        }

        public long getServerVersion() {
            return this.serverVersion;
        }
    }

    private static class Invoker
    implements InvocationHandler {
        private InetSocketAddress address;
        private Client client;

        public Invoker(InetSocketAddress address, Configuration conf) {
            this.address = address;
            this.client = RPC.getClient(conf);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            long startTime = System.currentTimeMillis();
            ObjectWritable value = (ObjectWritable)this.client.call(new Invocation(method, args), this.address);
            long callTime = System.currentTimeMillis() - startTime;
            LOG.debug((Object)("Call: " + method.getName() + " " + callTime));
            return value.get();
        }
    }

    private static class Invocation
    implements Writable,
    Configurable {
        private String methodName;
        private Class[] parameterClasses;
        private Object[] parameters;
        private Configuration conf;

        public Invocation() {
        }

        public Invocation(Method method, Object[] parameters) {
            this.methodName = method.getName();
            this.parameterClasses = method.getParameterTypes();
            this.parameters = parameters;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class[] getParameterClasses() {
            return this.parameterClasses;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public void readFields(DataInput in) throws IOException {
            this.methodName = UTF8.readString(in);
            this.parameters = new Object[in.readInt()];
            this.parameterClasses = new Class[this.parameters.length];
            ObjectWritable objectWritable = new ObjectWritable();
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = ObjectWritable.readObject(in, objectWritable, this.conf);
                this.parameterClasses[i] = objectWritable.getDeclaredClass();
            }
        }

        public void write(DataOutput out) throws IOException {
            UTF8.writeString(out, this.methodName);
            out.writeInt(this.parameterClasses.length);
            for (int i = 0; i < this.parameterClasses.length; ++i) {
                ObjectWritable.writeObject(out, this.parameters[i], this.parameterClasses[i], this.conf);
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.methodName);
            buffer.append("(");
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i]);
            }
            buffer.append(")");
            return buffer.toString();
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        public Configuration getConf() {
            return this.conf;
        }
    }
}

