/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.lzo.LzoCompressor;
import org.apache.hadoop.io.compress.lzo.LzoDecompressor;
import org.apache.hadoop.util.NativeCodeLoader;

public class LzoCodec
implements Configurable,
CompressionCodec {
    private static final Log LOG = LogFactory.getLog((String)LzoCodec.class.getName());
    private Configuration conf;
    private static boolean nativeLzoLoaded = false;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public static boolean isNativeLzoLoaded() {
        return nativeLzoLoaded;
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        if (!LzoCodec.isNativeLzoLoaded()) {
            throw new IOException("native-lzo library not available");
        }
        LzoCompressor.CompressionStrategy strategy = LzoCompressor.CompressionStrategy.valueOf(this.conf.get("io.compression.codec.lzo.compressor", LzoCompressor.CompressionStrategy.LZO1X_1.name()));
        int bufferSize = this.conf.getInt("io.compression.codec.lzo.buffersize", 65536);
        int compressionOverhead = 0;
        compressionOverhead = strategy.name().contains("LZO1") ? (int)((double)(bufferSize - 67) * 16.0 / 17.0) : (int)((double)(bufferSize - 131) * 8.0 / 9.0);
        return new BlockCompressorStream(out, new LzoCompressor(strategy, bufferSize), bufferSize, compressionOverhead);
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        if (!LzoCodec.isNativeLzoLoaded()) {
            throw new IOException("native-lzo library not available");
        }
        LzoDecompressor.CompressionStrategy strategy = LzoDecompressor.CompressionStrategy.valueOf(this.conf.get("io.compression.codec.lzo.decompressor", LzoDecompressor.CompressionStrategy.LZO1X.name()));
        int bufferSize = this.conf.getInt("io.compression.codec.lzo.buffersize", 65536);
        return new BlockDecompressorStream(in, new LzoDecompressor(strategy, bufferSize), bufferSize);
    }

    public String getDefaultExtension() {
        return ".lzo";
    }

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            boolean bl = nativeLzoLoaded = LzoCompressor.isNativeLzoLoaded() && LzoDecompressor.isNativeLzoLoaded();
            if (nativeLzoLoaded) {
                LOG.info((Object)"Successfully loaded & initialized native-lzo library");
            } else {
                LOG.error((Object)"Failed to load/initialize native-lzo library");
            }
        } else {
            LOG.error((Object)"Cannot load native-lzo without native-hadoop");
        }
    }
}

