/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.io.compress.DecompressorStream;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;

public class DefaultCodec
implements Configurable,
CompressionCodec {
    Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new CompressorStream(out, ZlibFactory.getZlibCompressor(), this.conf.getInt("io.file.buffer.size", 4096));
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return new DecompressorStream(in, ZlibFactory.getZlibDecompressor(), this.conf.getInt("io.file.buffer.size", 4096));
    }

    public String getDefaultExtension() {
        return ".deflate";
    }
}

