/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.text.StringCharacterIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

public class Text
implements WritableComparable {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.io.Text");
    private static final CharsetDecoder DECODER = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    private static final CharsetEncoder ENCODER = Charset.forName("UTF-8").newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private byte[] bytes;
    private int length;
    private static final int LEAD_BYTE = 0;
    private static final int TRAIL_BYTE_1 = 1;
    private static final int TRAIL_BYTE = 2;
    static final int[] bytesFromUTF8;
    static final int[] offsetsFromUTF8;

    public Text() {
        this.bytes = EMPTY_BYTES;
    }

    public Text(String string) {
        this.set(string);
    }

    public Text(Text utf8) {
        this.set(utf8);
    }

    public Text(byte[] utf8) {
        this.set(utf8);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.length;
    }

    public int charAt(int position) {
        if (position > this.length) {
            return -1;
        }
        if (position < 0) {
            return -1;
        }
        ByteBuffer bb = (ByteBuffer)ByteBuffer.wrap(this.bytes).position(position);
        return Text.bytesToCodePoint(bb.slice());
    }

    public int find(String what) {
        return this.find(what, 0);
    }

    public int find(String what, int start) {
        try {
            ByteBuffer src = ByteBuffer.wrap(this.bytes);
            ByteBuffer tgt = Text.encode(what);
            byte b = tgt.get();
            src.position(start);
            while (src.hasRemaining()) {
                if (b != src.get()) continue;
                src.mark();
                tgt.mark();
                boolean found = true;
                int pos = src.position() - 1;
                while (tgt.hasRemaining()) {
                    if (!src.hasRemaining()) {
                        tgt.reset();
                        src.reset();
                        found = false;
                        break;
                    }
                    if (tgt.get() == src.get()) continue;
                    tgt.reset();
                    src.reset();
                    found = false;
                    break;
                }
                if (!found) continue;
                return pos;
            }
            return -1;
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void set(String string) {
        try {
            ByteBuffer bb = Text.encode(string, true);
            this.bytes = bb.array();
            this.length = bb.limit();
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException("Should not have happened " + e.toString());
        }
    }

    public void set(byte[] utf8) {
        this.set(utf8, 0, utf8.length);
    }

    public void set(Text other) {
        this.set(other.bytes, 0, other.length);
    }

    public void set(byte[] utf8, int start, int len) {
        this.setCapacity(len);
        System.arraycopy(utf8, start, this.bytes, 0, len);
        this.length = len;
    }

    private void setCapacity(int len) {
        if (this.bytes == null || this.bytes.length < len) {
            this.bytes = new byte[len];
        }
    }

    public String toString() {
        try {
            return Text.decode(this.bytes, 0, this.length);
        }
        catch (CharacterCodingException e) {
            return null;
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.length = WritableUtils.readVInt(in);
        this.setCapacity(this.length);
        in.readFully(this.bytes, 0, this.length);
    }

    public static void skip(DataInput in) throws IOException {
        int length = WritableUtils.readVInt(in);
        WritableUtils.skipFully(in, length);
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.length);
        out.write(this.bytes, 0, this.length);
    }

    public int compareTo(Object o) {
        Text that = (Text)o;
        if (this == that) {
            return 0;
        }
        return WritableComparator.compareBytes(this.bytes, 0, this.length, that.bytes, 0, that.length);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Text)) {
            return false;
        }
        Text that = (Text)o;
        if (this == that) {
            return true;
        }
        if (this.length != that.length) {
            return false;
        }
        return WritableComparator.compareBytes(this.bytes, 0, this.length, that.bytes, 0, that.length) == 0;
    }

    public int hashCode() {
        return WritableComparator.hashBytes(this.bytes, this.length);
    }

    public static String decode(byte[] utf8) throws CharacterCodingException {
        return Text.decode(ByteBuffer.wrap(utf8), true);
    }

    public static String decode(byte[] utf8, int start, int length) throws CharacterCodingException {
        return Text.decode(ByteBuffer.wrap(utf8, start, length), true);
    }

    public static String decode(byte[] utf8, int start, int length, boolean replace) throws CharacterCodingException {
        return Text.decode(ByteBuffer.wrap(utf8, start, length), replace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String decode(ByteBuffer utf8, boolean replace) throws CharacterCodingException {
        CharsetDecoder charsetDecoder = DECODER;
        synchronized (charsetDecoder) {
            if (replace) {
                DECODER.onMalformedInput(CodingErrorAction.REPLACE);
                DECODER.onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
            String str = DECODER.decode(utf8).toString();
            if (replace) {
                DECODER.onMalformedInput(CodingErrorAction.REPORT);
                DECODER.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
            return str;
        }
    }

    public static ByteBuffer encode(String string) throws CharacterCodingException {
        return Text.encode(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer encode(String string, boolean replace) throws CharacterCodingException {
        CharsetEncoder charsetEncoder = ENCODER;
        synchronized (charsetEncoder) {
            if (replace) {
                ENCODER.onMalformedInput(CodingErrorAction.REPLACE);
                ENCODER.onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
            ByteBuffer bytes = ENCODER.encode(CharBuffer.wrap(string.toCharArray()));
            if (replace) {
                ENCODER.onMalformedInput(CodingErrorAction.REPORT);
                ENCODER.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
            return bytes;
        }
    }

    public static String readString(DataInput in) throws IOException {
        int length = WritableUtils.readVInt(in);
        byte[] bytes = new byte[length];
        in.readFully(bytes, 0, length);
        return Text.decode(bytes);
    }

    public static int writeString(DataOutput out, String s) throws IOException {
        ByteBuffer bytes = Text.encode(s);
        int length = bytes.limit();
        WritableUtils.writeVInt(out, length);
        out.write(bytes.array(), 0, length);
        return length;
    }

    public static void validateUTF8(byte[] utf8) throws MalformedInputException {
        Text.validateUTF8(utf8, 0, utf8.length);
    }

    public static void validateUTF8(byte[] utf8, int start, int len) throws MalformedInputException {
        int leadByte = 0;
        int length = 0;
        int state = 0;
        block11: for (int count = start; count < start + len; ++count) {
            int aByte = utf8[count] & 0xFF;
            switch (state) {
                case 0: {
                    leadByte = aByte;
                    length = bytesFromUTF8[aByte];
                    switch (length) {
                        case 0: {
                            if (leadByte <= 127) continue block11;
                            throw new MalformedInputException(count);
                        }
                        case 1: {
                            if (leadByte < 194 || leadByte > 223) {
                                throw new MalformedInputException(count);
                            }
                            state = 1;
                            continue block11;
                        }
                        case 2: {
                            if (leadByte < 224 || leadByte > 239) {
                                throw new MalformedInputException(count);
                            }
                            state = 1;
                            continue block11;
                        }
                        case 3: {
                            if (leadByte < 240 || leadByte > 244) {
                                throw new MalformedInputException(count);
                            }
                            state = 1;
                            continue block11;
                        }
                    }
                    throw new MalformedInputException(count);
                }
                case 1: {
                    if (leadByte == 240 && aByte < 144) {
                        throw new MalformedInputException(count);
                    }
                    if (leadByte == 244 && aByte > 143) {
                        throw new MalformedInputException(count);
                    }
                    if (leadByte == 224 && aByte < 160) {
                        throw new MalformedInputException(count);
                    }
                    if (leadByte == 237 && aByte > 159) {
                        throw new MalformedInputException(count);
                    }
                }
                case 2: {
                    if (aByte < 128 || aByte > 191) {
                        throw new MalformedInputException(count);
                    }
                    state = --length == 0 ? 0 : 2;
                }
            }
        }
    }

    public static int bytesToCodePoint(ByteBuffer bytes) {
        bytes.mark();
        byte b = bytes.get();
        bytes.reset();
        int extraBytesToRead = bytesFromUTF8[b & 0xFF];
        if (extraBytesToRead < 0) {
            return -1;
        }
        int ch = 0;
        switch (extraBytesToRead) {
            case 5: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 4: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 3: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 2: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 1: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 0: {
                ch += bytes.get() & 0xFF;
            }
        }
        return ch -= offsetsFromUTF8[extraBytesToRead];
    }

    public static int utf8Length(String string) {
        StringCharacterIterator iter = new StringCharacterIterator(string);
        char ch = iter.first();
        int size = 0;
        while (ch != '\uffff') {
            if (ch >= '\ud800' && ch < '\udc00') {
                char trail = iter.next();
                if (trail > '\udbff' && trail < '\ue000') {
                    size += 4;
                } else {
                    size += 3;
                    iter.previous();
                }
            } else {
                size = ch < '\u0080' ? ++size : (ch < '\u0800' ? (size += 2) : (size += 3));
            }
            ch = iter.next();
        }
        return size;
    }

    static {
        WritableComparator.define(Text.class, new Comparator());
        bytesFromUTF8 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5};
        offsetsFromUTF8 = new int[]{0, 12416, 925824, 63447168, -100130688, -2113396608};
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(Text.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                int n1 = Comparator.readVInt(b1, s1);
                int n2 = Comparator.readVInt(b2, s2);
                return Comparator.compareBytes(b1, s1 + WritableUtils.getVIntSize(n1), n1, b2, s2 + WritableUtils.getVIntSize(n2), n2);
            }
            catch (IOException e) {
                LOG.warn((Object)e);
                throw new RuntimeException(e);
            }
        }
    }
}

