/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public abstract class GenericWritable
implements Writable {
    private static final byte NOT_SET = -1;
    private byte type = (byte)-1;
    private Writable instance;

    public void set(Writable obj) {
        this.instance = obj;
        Class[] clazzes = this.getTypes();
        for (int i = 0; i < clazzes.length; ++i) {
            Class clazz = clazzes[i];
            if (!clazz.isInstance(this.instance)) continue;
            this.type = (byte)i;
            return;
        }
        throw new RuntimeException("The type of instance is: " + this.instance.getClass() + ", which is NOT registered.");
    }

    public Writable get() {
        return this.instance;
    }

    public void readFields(DataInput in) throws IOException {
        this.type = in.readByte();
        Class clazz = this.getTypes()[this.type];
        try {
            this.instance = (Writable)clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Cannot initialize the class: " + clazz);
        }
        this.instance.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        if (this.type == -1 || this.instance == null) {
            throw new IOException("The GenericWritable has NOT been set correctly. type=" + this.type + ", instance=" + this.instance);
        }
        out.writeByte(this.type);
        this.instance.write(out);
    }

    protected abstract Class[] getTypes();
}

