/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;

public class FileUtil {
    public static boolean fullyDelete(File dir) throws IOException {
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i].isFile()) {
                    if (contents[i].delete()) continue;
                    return false;
                }
                boolean b = false;
                b = contents[i].delete();
                if (b || FileUtil.fullyDelete(contents[i])) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void fullyDelete(FileSystem fs, Path dir) throws IOException {
        Path[] paths = fs.listPaths(dir);
        if (paths != null) {
            for (Path p : paths) {
                if (fs.isFile(p)) {
                    fs.delete(p);
                    continue;
                }
                FileUtil.fullyDelete(fs, p);
            }
        }
        fs.delete(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, Configuration conf) throws IOException {
        dst = FileUtil.checkDest(src.getName(), dstFS, dst);
        if (srcFS.isDirectory(src)) {
            if (!dstFS.mkdirs(dst)) {
                return false;
            }
            Path[] contents = srcFS.listPaths(src);
            for (int i = 0; i < contents.length; ++i) {
                FileUtil.copy(srcFS, contents[i], dstFS, new Path(dst, contents[i].getName()), deleteSource, conf);
            }
        } else if (srcFS.isFile(src)) {
            FSDataInputStream in = srcFS.open(src);
            try {
                FSDataOutputStream out = dstFS.create(dst);
                FileUtil.copyContent(in, out, conf);
            }
            finally {
                ((InputStream)in).close();
            }
        } else {
            throw new IOException(src.toString() + ": No such file or directory");
        }
        if (deleteSource) {
            return srcFS.delete(src);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyMerge(FileSystem srcFS, Path srcDir, FileSystem dstFS, Path dstFile, boolean deleteSource, Configuration conf, String addString) throws IOException {
        dstFile = FileUtil.checkDest(srcDir.getName(), dstFS, dstFile);
        if (!srcFS.isDirectory(srcDir)) {
            return false;
        }
        FSDataOutputStream out = dstFS.create(dstFile);
        try {
            Path[] contents = srcFS.listPaths(srcDir);
            for (int i = 0; i < contents.length; ++i) {
                if (!srcFS.isFile(contents[i])) continue;
                FSDataInputStream in = srcFS.open(contents[i]);
                try {
                    FileUtil.copyContent(in, out, conf, false);
                    if (addString == null) continue;
                    ((OutputStream)out).write(addString.getBytes("UTF-8"));
                    continue;
                }
                finally {
                    ((InputStream)in).close();
                }
            }
        }
        finally {
            ((OutputStream)out).close();
        }
        if (deleteSource) {
            return srcFS.delete(srcDir);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File src, FileSystem dstFS, Path dst, boolean deleteSource, Configuration conf) throws IOException {
        dst = FileUtil.checkDest(src.getName(), dstFS, dst);
        if (src.isDirectory()) {
            if (!dstFS.mkdirs(dst)) {
                return false;
            }
            File[] contents = src.listFiles();
            for (int i = 0; i < contents.length; ++i) {
                FileUtil.copy(contents[i], dstFS, new Path(dst, contents[i].getName()), deleteSource, conf);
            }
        } else if (src.isFile()) {
            FileInputStream in = new FileInputStream(src);
            try {
                FileUtil.copyContent(in, dstFS.create(dst), conf);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        if (deleteSource) {
            return FileUtil.fullyDelete(src);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(FileSystem srcFS, Path src, File dst, boolean deleteSource, Configuration conf) throws IOException {
        dst = FileUtil.checkDest(src.getName(), dst);
        if (srcFS.isDirectory(src)) {
            if (!dst.mkdirs()) {
                return false;
            }
            Path[] contents = srcFS.listPaths(src);
            for (int i = 0; i < contents.length; ++i) {
                FileUtil.copy(srcFS, contents[i], new File(dst, contents[i].getName()), deleteSource, conf);
            }
        } else if (srcFS.isFile(src)) {
            FSDataInputStream in = srcFS.open(src);
            try {
                FileUtil.copyContent(in, new FileOutputStream(dst), conf);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        if (deleteSource) {
            return srcFS.delete(src);
        }
        return true;
    }

    private static void copyContent(InputStream in, OutputStream out, Configuration conf) throws IOException {
        FileUtil.copyContent(in, out, conf, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyContent(InputStream in, OutputStream out, Configuration conf, boolean close) throws IOException {
        byte[] buf = new byte[conf.getInt("io.file.buffer.size", 4096)];
        try {
            int bytesRead = in.read(buf);
            while (bytesRead >= 0) {
                out.write(buf, 0, bytesRead);
                bytesRead = in.read(buf);
            }
        }
        finally {
            if (close) {
                out.close();
            }
        }
    }

    private static Path checkDest(String srcName, FileSystem dstFS, Path dst) throws IOException {
        if (dstFS.exists(dst)) {
            if (!dstFS.isDirectory(dst)) {
                throw new IOException("Target " + dst + " already exists");
            }
            if (dstFS.exists(dst = new Path(dst, srcName))) {
                throw new IOException("Target " + dst + " already exists");
            }
        }
        return dst;
    }

    private static File checkDest(String srcName, File dst) throws IOException {
        if (dst.exists()) {
            if (!dst.isDirectory()) {
                throw new IOException("Target " + dst + " already exists");
            }
            if ((dst = new File(dst, srcName)).exists()) {
                throw new IOException("Target " + dst + " already exists");
            }
        }
        return dst;
    }

    public static long getDU(File dir) {
        long size = 0L;
        if (!dir.exists()) {
            return 0L;
        }
        if (!dir.isDirectory()) {
            return dir.length();
        }
        size = dir.length();
        File[] allFiles = dir.listFiles();
        for (int i = 0; i < allFiles.length; ++i) {
            size += FileUtil.getDU(allFiles[i]);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZip(File inFile, File unzipDir) throws IOException {
        ZipFile zipFile = new ZipFile(inFile);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                InputStream in = zipFile.getInputStream(entry);
                try {
                    File file = new File(unzipDir, entry.getName());
                    if (!file.getParentFile().mkdirs() && !file.getParentFile().isDirectory()) {
                        throw new IOException("Mkdirs failed to create " + file.getParentFile().toString());
                    }
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        int i;
                        byte[] buffer = new byte[8192];
                        while ((i = in.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, i);
                        }
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                finally {
                    in.close();
                }
            }
        }
        finally {
            zipFile.close();
        }
    }

    public static int symLink(String target, String linkname) throws IOException {
        String cmd = "ln -s " + target + " " + linkname;
        Process p = Runtime.getRuntime().exec(cmd, null);
        int returnVal = -1;
        try {
            returnVal = p.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return returnVal;
    }

    public static int chmod(String filename, String perm) throws IOException, InterruptedException {
        String cmd = "chmod " + perm + " " + filename;
        Process p = Runtime.getRuntime().exec(cmd, null);
        return p.waitFor();
    }

    public static class HardLink {
        private static String[] hardLinkCommand;

        static OSType getOSType() {
            String osName = System.getProperty("os.name");
            if (osName.indexOf("Windows") >= 0 && (osName.indexOf("XpP") >= 0 || osName.indexOf("2003") >= 0)) {
                return OSType.OS_TYPE_WINXP;
            }
            return OSType.OS_TYPE_UNIX;
        }

        public static void createHardLink(File target, File linkName) throws IOException {
            int len = hardLinkCommand.length;
            HardLink.hardLinkCommand[len - 2] = target.getCanonicalPath();
            HardLink.hardLinkCommand[len - 1] = linkName.getCanonicalPath();
            Process process = Runtime.getRuntime().exec(hardLinkCommand);
            try {
                if (process.waitFor() != 0) {
                    String inpMsg;
                    String errMsg = new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
                    if (errMsg == null) {
                        errMsg = "";
                    }
                    if ((inpMsg = new BufferedReader(new InputStreamReader(process.getErrorStream())).readLine()) == null) {
                        inpMsg = "";
                    }
                    throw new IOException(errMsg + inpMsg);
                }
            }
            catch (InterruptedException e) {
                throw new IOException(StringUtils.stringifyException(e));
            }
            finally {
                process.destroy();
            }
        }

        static {
            switch (HardLink.getOSType()) {
                case OS_TYPE_WINXP: {
                    hardLinkCommand = new String[]{"fsutil", "hardlink", "create", null, null};
                    break;
                }
                default: {
                    hardLinkCommand = new String[]{"ln", null, null};
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum OSType {
            OS_TYPE_UNIX,
            OS_TYPE_WINXP;

        }
    }
}

