/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;

public class DF {
    public static final long DF_INTERVAL_DEFAULT = 3000L;
    private String dirPath;
    private long dfInterval;
    private long lastDF;
    private String filesystem;
    private long capacity;
    private long used;
    private long available;
    private int percentUsed;
    private String mount;

    public DF(File path, Configuration conf) throws IOException {
        this(path, conf.getLong("dfs.df.interval", 3000L));
    }

    public DF(File path, long dfInterval) throws IOException {
        this.dirPath = path.getCanonicalPath();
        this.dfInterval = dfInterval;
        this.lastDF = dfInterval < 0L ? 0L : -dfInterval;
        this.doDF();
    }

    private void doDF() throws IOException {
        if (this.lastDF + this.dfInterval > System.currentTimeMillis()) {
            return;
        }
        Process process = Runtime.getRuntime().exec(this.getExecString());
        try {
            if (process.waitFor() != 0) {
                throw new IOException(new BufferedReader(new InputStreamReader(process.getErrorStream())).readLine());
            }
            this.parseExecResult(new BufferedReader(new InputStreamReader(process.getInputStream())));
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString());
        }
        finally {
            process.destroy();
        }
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public String getFilesystem() throws IOException {
        this.doDF();
        return this.filesystem;
    }

    public long getCapacity() throws IOException {
        this.doDF();
        return this.capacity;
    }

    public long getUsed() throws IOException {
        this.doDF();
        return this.used;
    }

    public long getAvailable() throws IOException {
        this.doDF();
        return this.available;
    }

    public int getPercentUsed() throws IOException {
        this.doDF();
        return this.percentUsed;
    }

    public String getMount() throws IOException {
        this.doDF();
        return this.mount;
    }

    public long getCapacitySkipRefresh() {
        return this.capacity;
    }

    public long getUsedSkipRefresh() {
        return this.used;
    }

    public long getAvailableSkipRefresh() {
        return this.available;
    }

    public int getPercentUsedSkipRefresh() {
        return this.percentUsed;
    }

    public String toString() {
        return "df -k " + this.mount + "\n" + this.filesystem + "\t" + this.capacity / 1024L + "\t" + this.used / 1024L + "\t" + this.available / 1024L + "\t" + this.percentUsed + "%\t" + this.mount;
    }

    private String[] getExecString() {
        return new String[]{"df", "-k", this.dirPath};
    }

    private void parseExecResult(BufferedReader lines) throws IOException {
        lines.readLine();
        StringTokenizer tokens = new StringTokenizer(lines.readLine(), " \t\n\r\f%");
        this.filesystem = tokens.nextToken();
        if (!tokens.hasMoreTokens()) {
            tokens = new StringTokenizer(lines.readLine(), " \t\n\r\f%");
        }
        this.capacity = Long.parseLong(tokens.nextToken()) * 1024L;
        this.used = Long.parseLong(tokens.nextToken()) * 1024L;
        this.available = Long.parseLong(tokens.nextToken()) * 1024L;
        this.percentUsed = Integer.parseInt(tokens.nextToken());
        this.mount = tokens.nextToken();
        this.lastDF = System.currentTimeMillis();
    }

    public static void main(String[] args) throws Exception {
        String path = ".";
        if (args.length > 0) {
            path = args[0];
        }
        System.out.println(new DF(new File(path), 3000L).toString());
    }
}

