/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.filecache;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.RunJar;
import org.apache.hadoop.util.StringUtils;

public class DistributedCache {
    private static TreeMap<String, CacheStatus> cachedArchives = new TreeMap();
    private static final int CRC_BUFFER_SIZE = 65536;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path getLocalCache(URI cache, Configuration conf, Path baseDir, boolean isArchive, String md5, Path currentWorkDir) throws IOException {
        Path localizedPath;
        CacheStatus lcacheStatus;
        String cacheId = DistributedCache.makeRelative(cache, conf);
        Object object = cachedArchives;
        synchronized (object) {
            if (!cachedArchives.containsKey(cacheId)) {
                lcacheStatus = new CacheStatus();
                lcacheStatus.currentStatus = false;
                lcacheStatus.refcount = 1;
                lcacheStatus.localLoadPath = new Path(baseDir, new Path(cacheId));
                cachedArchives.put(cacheId, lcacheStatus);
            } else {
                CacheStatus cacheStatus = lcacheStatus = cachedArchives.get(cacheId);
                synchronized (cacheStatus) {
                    ++lcacheStatus.refcount;
                }
            }
        }
        object = lcacheStatus;
        synchronized (object) {
            localizedPath = DistributedCache.localizeCache(cache, lcacheStatus, conf, isArchive, md5, currentWorkDir);
        }
        long size = FileUtil.getDU(new File(baseDir.toString()));
        long allowedSize = conf.getLong("local.cache.size", 0x100000L);
        if (allowedSize < size) {
            DistributedCache.deleteCache(conf);
        }
        return localizedPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseCache(URI cache, Configuration conf) throws IOException {
        String cacheId = DistributedCache.makeRelative(cache, conf);
        TreeMap<String, CacheStatus> treeMap = cachedArchives;
        synchronized (treeMap) {
            CacheStatus lcacheStatus = cachedArchives.get(cacheId);
            if (lcacheStatus == null) {
                return;
            }
            CacheStatus cacheStatus = lcacheStatus;
            synchronized (cacheStatus) {
                --lcacheStatus.refcount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteCache(Configuration conf) throws IOException {
        TreeMap<String, CacheStatus> treeMap = cachedArchives;
        synchronized (treeMap) {
            Iterator<String> it = cachedArchives.keySet().iterator();
            while (it.hasNext()) {
                String cacheId = it.next();
                CacheStatus lcacheStatus = cachedArchives.get(cacheId);
                if (lcacheStatus.refcount != 0) continue;
                FileSystem.getLocal(conf).delete(lcacheStatus.localLoadPath);
                it.remove();
            }
        }
    }

    private static String makeRelative(URI cache, Configuration conf) throws IOException {
        String path;
        String fsname = cache.getScheme();
        FileSystem dfs = FileSystem.get(conf);
        if ("hdfs".equals(fsname)) {
            path = cache.getHost() + cache.getPath();
        } else {
            String[] split = dfs.getName().split(":");
            path = split[0] + cache.getPath();
        }
        return path;
    }

    private static Path cacheFilePath(Path p) {
        return new Path(p, p.getName());
    }

    private static Path localizeCache(URI cache, CacheStatus cacheStatus, Configuration conf, boolean isArchive, String md5, Path currentWorkDir) throws IOException {
        boolean b = true;
        boolean doSymlink = DistributedCache.getSymlink(conf);
        FileSystem dfs = DistributedCache.getFileSystem(cache, conf);
        b = DistributedCache.ifExistsAndFresh(cacheStatus, cache, dfs, md5, conf);
        String link = currentWorkDir.toString() + "/" + cache.getFragment();
        File flink = new File(link);
        if (b) {
            if (isArchive) {
                if (doSymlink && !flink.exists()) {
                    FileUtil.symLink(cacheStatus.localLoadPath.toString(), link);
                }
                return cacheStatus.localLoadPath;
            }
            if (doSymlink && !flink.exists()) {
                FileUtil.symLink(DistributedCache.cacheFilePath(cacheStatus.localLoadPath).toString(), link);
            }
            return DistributedCache.cacheFilePath(cacheStatus.localLoadPath);
        }
        if (cacheStatus.refcount > 1 && cacheStatus.currentStatus) {
            throw new IOException("Cache " + cacheStatus.localLoadPath.toString() + " is in use and cannot be refreshed");
        }
        byte[] checkSum = DistributedCache.createMD5(cache, conf);
        LocalFileSystem localFs = FileSystem.getLocal(conf);
        ((FileSystem)localFs).delete(cacheStatus.localLoadPath);
        Path parchive = new Path(cacheStatus.localLoadPath, new Path(cacheStatus.localLoadPath.getName()));
        if (!((FileSystem)localFs).mkdirs(cacheStatus.localLoadPath)) {
            throw new IOException("Mkdirs failed to create directory " + cacheStatus.localLoadPath.toString());
        }
        String cacheId = cache.getPath();
        dfs.copyToLocalFile(new Path(cacheId), parchive);
        dfs.copyToLocalFile(new Path(cacheId + "_md5"), new Path(parchive.toString() + "_md5"));
        if (isArchive) {
            String tmpArchive = parchive.toString().toLowerCase();
            if (tmpArchive.endsWith(".jar")) {
                RunJar.unJar(new File(parchive.toString()), new File(parchive.getParent().toString()));
            } else if (tmpArchive.endsWith(".zip")) {
                FileUtil.unZip(new File(parchive.toString()), new File(parchive.getParent().toString()));
            }
        }
        cacheStatus.currentStatus = true;
        cacheStatus.md5 = checkSum;
        if (isArchive) {
            if (doSymlink && !flink.exists()) {
                FileUtil.symLink(cacheStatus.localLoadPath.toString(), link);
            }
            return cacheStatus.localLoadPath;
        }
        if (doSymlink && !flink.exists()) {
            FileUtil.symLink(DistributedCache.cacheFilePath(cacheStatus.localLoadPath).toString(), link);
        }
        return DistributedCache.cacheFilePath(cacheStatus.localLoadPath);
    }

    private static boolean ifExistsAndFresh(CacheStatus lcacheStatus, URI cache, FileSystem dfs, String confMD5, Configuration conf) throws IOException {
        byte[] digest = null;
        byte[] fsDigest = DistributedCache.createMD5(cache, conf);
        byte[] confDigest = StringUtils.hexStringToByte(confMD5);
        if (!lcacheStatus.currentStatus) {
            return false;
        }
        digest = lcacheStatus.md5;
        if (!MessageDigest.isEqual(confDigest, fsDigest)) {
            throw new IOException("Inconsistencty in data caching, Cache archives have been changed");
        }
        return MessageDigest.isEqual(confDigest, digest);
    }

    public static byte[] createMD5(URI cache, Configuration conf) throws IOException {
        byte[] b = new byte[65536];
        byte[] digest = null;
        FileSystem fileSystem = DistributedCache.getFileSystem(cache, conf);
        if (!(fileSystem instanceof ChecksumFileSystem)) {
            throw new IOException("Not a checksummed file system: " + fileSystem.getUri());
        }
        String filename = cache.getPath();
        Path filePath = new Path(filename);
        Path md5File = new Path(filePath.getParent().toString() + "/" + filePath.getName() + "_md5");
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException na) {
            // empty catch block
        }
        if (!fileSystem.exists(md5File)) {
            if (!(fileSystem instanceof ChecksumFileSystem)) {
                throw new IOException("Not a checksumed file system: " + fileSystem.getUri());
            }
            ChecksumFileSystem checksumFs = (ChecksumFileSystem)fileSystem;
            FSDataInputStream fsStream = checksumFs.getRawFileSystem().open(checksumFs.getChecksumFile(filePath));
            int read = fsStream.read(b);
            while (read != -1) {
                md5.update(b, 0, read);
                read = fsStream.read(b);
            }
            fsStream.close();
            digest = md5.digest();
            FSDataOutputStream out = fileSystem.create(md5File);
            out.write(digest);
            out.close();
        } else {
            FSDataInputStream fsStream = fileSystem.open(md5File);
            digest = new byte[md5.getDigestLength()];
            int read = fsStream.read(digest);
            fsStream.close();
        }
        return digest;
    }

    public static void createAllSymlink(Configuration conf, File jobCacheDir, File workDir) throws IOException {
        if (!jobCacheDir.isDirectory() || !workDir.isDirectory()) {
            return;
        }
        boolean createSymlink = DistributedCache.getSymlink(conf);
        if (createSymlink) {
            File[] list = jobCacheDir.listFiles();
            for (int i = 0; i < list.length; ++i) {
                FileUtil.symLink(list[i].getAbsolutePath(), new File(workDir, list[i].getName()).toString());
            }
        }
    }

    private static String getFileSysName(URI url) {
        String fsname = url.getScheme();
        if ("hdfs".equals(fsname)) {
            String host = url.getHost();
            int port = url.getPort();
            return port == -1 ? host : host + ":" + port;
        }
        return null;
    }

    private static FileSystem getFileSystem(URI cache, Configuration conf) throws IOException {
        String fileSysName = DistributedCache.getFileSysName(cache);
        if (fileSysName != null) {
            return FileSystem.getNamed(fileSysName, conf);
        }
        return FileSystem.get(conf);
    }

    public static void setCacheArchives(URI[] archives, Configuration conf) {
        String sarchives = StringUtils.uriToString(archives);
        conf.set("mapred.cache.archives", sarchives);
    }

    public static void setCacheFiles(URI[] files, Configuration conf) {
        String sfiles = StringUtils.uriToString(files);
        conf.set("mapred.cache.files", sfiles);
    }

    public static URI[] getCacheArchives(Configuration conf) throws IOException {
        return StringUtils.stringToURI(conf.getStrings("mapred.cache.archives"));
    }

    public static URI[] getCacheFiles(Configuration conf) throws IOException {
        return StringUtils.stringToURI(conf.getStrings("mapred.cache.files"));
    }

    public static Path[] getLocalCacheArchives(Configuration conf) throws IOException {
        return StringUtils.stringToPath(conf.getStrings("mapred.cache.localArchives"));
    }

    public static Path[] getLocalCacheFiles(Configuration conf) throws IOException {
        return StringUtils.stringToPath(conf.getStrings("mapred.cache.localFiles"));
    }

    public static String[] getArchiveMd5(Configuration conf) throws IOException {
        return conf.getStrings("mapred.cache.archivemd5");
    }

    public static String[] getFileMd5(Configuration conf) throws IOException {
        return conf.getStrings("mapred.cache.filemd5");
    }

    public static void setArchiveMd5(Configuration conf, String md5) {
        conf.set("mapred.cache.archivemd5", md5);
    }

    public static void setFileMd5(Configuration conf, String md5) {
        conf.set("mapred.cache.filemd5", md5);
    }

    public static void setLocalArchives(Configuration conf, String str) {
        conf.set("mapred.cache.localArchives", str);
    }

    public static void setLocalFiles(Configuration conf, String str) {
        conf.set("mapred.cache.localFiles", str);
    }

    public static void addCacheArchive(URI uri, Configuration conf) {
        String archives = conf.get("mapred.cache.archives");
        conf.set("mapred.cache.archives", archives == null ? uri.toString() : archives + "," + uri.toString());
    }

    public static void addCacheFile(URI uri, Configuration conf) {
        String files = conf.get("mapred.cache.files");
        conf.set("mapred.cache.files", files == null ? uri.toString() : files + "," + uri.toString());
    }

    public static void addFileToClassPath(Path file, Configuration conf) throws IOException {
        String classpath = conf.get("mapred.job.classpath.files");
        conf.set("mapred.job.classpath.files", classpath == null ? file.toString() : classpath + System.getProperty("path.separator") + file.toString());
        FileSystem fs = FileSystem.get(conf);
        URI uri = fs.makeQualified(file).toUri();
        DistributedCache.addCacheFile(uri, conf);
    }

    public static Path[] getFileClassPaths(Configuration conf) {
        String classpath = conf.get("mapred.job.classpath.files");
        if (classpath == null) {
            return null;
        }
        ArrayList<Object> list = Collections.list(new StringTokenizer(classpath, System.getProperty("path.separator")));
        Path[] paths = new Path[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            paths[i] = new Path((String)list.get(i));
        }
        return paths;
    }

    public static void addArchiveToClassPath(Path archive, Configuration conf) throws IOException {
        String classpath = conf.get("mapred.job.classpath.archives");
        conf.set("mapred.job.classpath.archives", classpath == null ? archive.toString() : classpath + System.getProperty("path.separator") + archive.toString());
        FileSystem fs = FileSystem.get(conf);
        URI uri = fs.makeQualified(archive).toUri();
        DistributedCache.addCacheArchive(uri, conf);
    }

    public static Path[] getArchiveClassPaths(Configuration conf) {
        String classpath = conf.get("mapred.job.classpath.archives");
        if (classpath == null) {
            return null;
        }
        ArrayList<Object> list = Collections.list(new StringTokenizer(classpath, System.getProperty("path.separator")));
        Path[] paths = new Path[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            paths[i] = new Path((String)list.get(i));
        }
        return paths;
    }

    public static void createSymlink(Configuration conf) {
        conf.set("mapred.create.symlink", "yes");
    }

    public static boolean getSymlink(Configuration conf) {
        String result = conf.get("mapred.create.symlink");
        return "yes".equals(result);
    }

    public static boolean checkURIs(URI[] uriFiles, URI[] uriArchives) {
        if (uriFiles == null && uriArchives == null) {
            return true;
        }
        if (uriFiles != null) {
            for (int i = 0; i < uriFiles.length; ++i) {
                String frag2;
                String frag1 = uriFiles[i].getFragment();
                if (frag1 == null) {
                    return false;
                }
                int j = i + 1;
                while (j < uriFiles.length) {
                    frag2 = uriFiles[j].getFragment();
                    if (frag2 == null) {
                        return false;
                    }
                    if (frag1.equalsIgnoreCase(frag2)) {
                        return false;
                    }
                    ++i;
                }
                if (uriArchives == null) continue;
                for (j = 0; j < uriArchives.length; ++j) {
                    frag2 = uriArchives[j].getFragment();
                    if (frag2 == null) {
                        return false;
                    }
                    if (frag1.equalsIgnoreCase(frag2)) {
                        return false;
                    }
                    for (int k = j + 1; k < uriArchives.length; ++k) {
                        String frag3 = uriArchives[k].getFragment();
                        if (frag3 == null) {
                            return false;
                        }
                        if (!frag2.equalsIgnoreCase(frag3)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static class CacheStatus {
        public boolean currentStatus;
        public Path localLoadPath;
        public int refcount;
        public byte[] md5;

        private CacheStatus() {
        }
    }
}

