/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.dfs.Storage;
import org.apache.hadoop.dfs.StorageInfo;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

class NamespaceInfo
extends StorageInfo
implements Writable {
    String buildVersion;

    public NamespaceInfo() {
        this.buildVersion = null;
    }

    public NamespaceInfo(int nsID, long cT) {
        super(-4, nsID, cT);
        this.buildVersion = Storage.getBuildVersion();
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public void write(DataOutput out) throws IOException {
        UTF8.writeString(out, this.getBuildVersion());
        out.writeInt(this.getLayoutVersion());
        out.writeInt(this.getNamespaceID());
        out.writeLong(this.getCTime());
    }

    public void readFields(DataInput in) throws IOException {
        this.buildVersion = UTF8.readString(in);
        this.layoutVersion = in.readInt();
        this.namespaceID = in.readInt();
        this.cTime = in.readLong();
    }

    static {
        WritableFactories.setFactory(NamespaceInfo.class, new WritableFactory(){

            public Writable newInstance() {
                return new NamespaceInfo();
            }
        });
    }
}

