/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.io.UTF8;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileUnderConstruction {
    private short blockReplication;
    private long blockSize;
    private Collection<Block> blocks;
    private UTF8 clientName;
    private UTF8 clientMachine;
    private DatanodeDescriptor clientNode;

    FileUnderConstruction(short replication, long blockSize, UTF8 clientName, UTF8 clientMachine, DatanodeDescriptor clientNode) throws IOException {
        this.blockReplication = replication;
        this.blockSize = blockSize;
        this.blocks = new ArrayList<Block>();
        this.clientName = clientName;
        this.clientMachine = clientMachine;
        this.clientNode = clientNode;
    }

    public short getReplication() {
        return this.blockReplication;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public Collection<Block> getBlocks() {
        return this.blocks;
    }

    public UTF8 getClientName() {
        return this.clientName;
    }

    public UTF8 getClientMachine() {
        return this.clientMachine;
    }

    public DatanodeDescriptor getClientNode() {
        return this.clientNode;
    }

    public Block getPenultimateBlock() {
        if (this.blocks.size() <= 1) {
            return null;
        }
        return (Block)((ArrayList)this.blocks).get(this.blocks.size() - 2);
    }
}

