/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DataNode;
import org.apache.hadoop.dfs.DataStorage;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.util.DiskChecker;

class FSDataset
implements FSConstants {
    FSVolumeSet volumes;
    private HashMap<Block, File> ongoingCreates = new HashMap();
    private int maxBlocksPerDir = 0;
    private HashMap<Block, FSVolume> volumeMap = null;
    private HashMap<Block, File> blockMap = null;
    static Random random = new Random();

    public FSDataset(DataStorage storage, Configuration conf) throws IOException {
        this.maxBlocksPerDir = conf.getInt("dfs.datanode.numblocks", 64);
        FSVolume[] volArray = new FSVolume[storage.getNumStorageDirs()];
        for (int idx = 0; idx < storage.getNumStorageDirs(); ++idx) {
            volArray[idx] = new FSVolume(storage.getStorageDir(idx).getCurrentDir(), conf);
        }
        this.volumes = new FSVolumeSet(volArray);
        this.volumeMap = new HashMap();
        this.volumes.getVolumeMap(this.volumeMap);
        this.blockMap = new HashMap();
        this.volumes.getBlockMap(this.blockMap);
    }

    public long getCapacity() throws IOException {
        return this.volumes.getCapacity();
    }

    public long getRemaining() throws IOException {
        return this.volumes.getRemaining();
    }

    public long getLength(Block b) throws IOException {
        if (!this.isValidBlock(b)) {
            throw new IOException("Block " + b + " is not valid.");
        }
        File f = this.getFile(b);
        return f.length();
    }

    public synchronized InputStream getBlockData(Block b) throws IOException {
        if (!this.isValidBlock(b)) {
            throw new IOException("Block " + b + " is not valid.");
        }
        return new FileInputStream(this.getFile(b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream writeToBlock(Block b) throws IOException {
        if (this.isValidBlock(b)) {
            throw new IOException("Block " + b + " is valid, and cannot be written to.");
        }
        long blockSize = b.getNumBytes();
        File f = null;
        FSDataset fSDataset = this;
        synchronized (fSDataset) {
            if (this.ongoingCreates.containsKey(b)) {
                File tmp = this.ongoingCreates.get(b);
                if (System.currentTimeMillis() - tmp.lastModified() < 3600000L) {
                    throw new IOException("Block " + b + " has already been started (though not completed), and thus cannot be created.");
                }
                if (!tmp.delete()) {
                    throw new IOException("Can't write the block - unable to remove stale temp file " + tmp);
                }
                this.ongoingCreates.remove(b);
            }
            FSVolume v = null;
            FSVolumeSet fSVolumeSet = this.volumes;
            synchronized (fSVolumeSet) {
                v = this.volumes.getNextVolume(blockSize);
                f = v.createTmpFile(b);
            }
            this.ongoingCreates.put(b, f);
            this.volumeMap.put(b, v);
        }
        return new FileOutputStream(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finalizeBlock(Block b) throws IOException {
        File f = this.ongoingCreates.get(b);
        if (f == null || !f.exists()) {
            throw new IOException("No temporary file " + f + " for block " + b);
        }
        long finalLen = f.length();
        b.setNumBytes(finalLen);
        FSVolume v = this.volumeMap.get(b);
        File dest = null;
        FSVolumeSet fSVolumeSet = this.volumes;
        synchronized (fSVolumeSet) {
            dest = v.addBlock(b, f);
        }
        this.blockMap.put(b, dest);
        this.ongoingCreates.remove(b);
    }

    public Block[] getBlockReport() {
        TreeSet<Block> blockSet = new TreeSet<Block>();
        this.volumes.getBlockInfo(blockSet);
        Block[] blockTable = new Block[blockSet.size()];
        int i = 0;
        Iterator<Block> it = blockSet.iterator();
        while (it.hasNext()) {
            blockTable[i] = it.next();
            ++i;
        }
        return blockTable;
    }

    public boolean isValidBlock(Block b) {
        File f = this.getFile(b);
        return f != null && f.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(Block[] invalidBlks) throws IOException {
        boolean error = false;
        for (int i = 0; i < invalidBlks.length; ++i) {
            File f = null;
            FSDataset fSDataset = this;
            synchronized (fSDataset) {
                f = this.getFile(invalidBlks[i]);
                FSVolume v = this.volumeMap.get(invalidBlks[i]);
                if (f == null) {
                    DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + ". Block not found in blockMap." + (v == null ? " " : " Block found in volumeMap.")));
                    error = true;
                    continue;
                }
                if (v == null) {
                    DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + ". No volume for this block." + " Block found in blockMap. " + f + "."));
                    error = true;
                    continue;
                }
                File parent = f.getParentFile();
                if (parent == null) {
                    DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + ". Parent not found for file " + f + "."));
                    error = true;
                    continue;
                }
                v.clearPath(parent);
                this.blockMap.remove(invalidBlks[i]);
                this.volumeMap.remove(invalidBlks[i]);
            }
            if (!f.delete()) {
                DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + " at file " + f));
                error = true;
                continue;
            }
            DataNode.LOG.info((Object)("Deleting block " + invalidBlks[i] + " file " + f));
            if (!f.exists()) continue;
            DataNode.LOG.info((Object)("File " + f + " was deleted but still exists!"));
        }
        if (error) {
            throw new IOException("Error in deleting blocks.");
        }
    }

    synchronized File getFile(Block b) {
        return this.blockMap.get(b);
    }

    void checkDataDir() throws DiskChecker.DiskErrorException {
        this.volumes.checkDirs();
    }

    public String toString() {
        return "FSDataset{dirpath='" + this.volumes + "'}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FSVolumeSet {
        FSVolume[] volumes = null;
        int curVolume = 0;

        FSVolumeSet(FSVolume[] volumes) {
            this.volumes = volumes;
        }

        synchronized FSVolume getNextVolume(long blockSize) throws IOException {
            int startVolume = this.curVolume;
            do {
                FSVolume volume = this.volumes[this.curVolume];
                this.curVolume = (this.curVolume + 1) % this.volumes.length;
                if (volume.getAvailable() < blockSize) continue;
                return volume;
            } while (this.curVolume != startVolume);
            throw new DiskChecker.DiskOutOfSpaceException("Insufficient space for an additional block");
        }

        synchronized long getCapacity() throws IOException {
            long capacity = 0L;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                capacity += this.volumes[idx].getCapacity();
            }
            return capacity;
        }

        synchronized long getRemaining() throws IOException {
            long remaining = 0L;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                remaining += this.volumes[idx].getAvailable();
            }
            return remaining;
        }

        synchronized void getBlockInfo(TreeSet<Block> blockSet) {
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                this.volumes[idx].getBlockInfo(blockSet);
            }
        }

        synchronized void getVolumeMap(HashMap<Block, FSVolume> volumeMap) {
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                this.volumes[idx].getVolumeMap(volumeMap);
            }
        }

        synchronized void getBlockMap(HashMap<Block, File> blockMap) {
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                this.volumes[idx].getBlockMap(blockMap);
            }
        }

        synchronized void checkDirs() throws DiskChecker.DiskErrorException {
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                this.volumes[idx].checkDirs();
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                sb.append(this.volumes[idx].toString());
                if (idx == this.volumes.length - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FSVolume {
        static final double USABLE_DISK_PCT_DEFAULT = (double)0.98f;
        private FSDir dataDir;
        private File tmpDir;
        private DF usage;
        private long reserved;
        private double usableDiskPct = 0.98f;

        FSVolume(File currentDir, Configuration conf) throws IOException {
            this.reserved = conf.getLong("dfs.datanode.du.reserved", 0L);
            this.usableDiskPct = conf.getFloat("dfs.datanode.du.pct", 0.98f);
            File parent = currentDir.getParentFile();
            this.dataDir = new FSDir(currentDir);
            this.tmpDir = new File(parent, "tmp");
            if (this.tmpDir.exists()) {
                FileUtil.fullyDelete(this.tmpDir);
            }
            if (!this.tmpDir.mkdirs() && !this.tmpDir.isDirectory()) {
                throw new IOException("Mkdirs failed to create " + this.tmpDir.toString());
            }
            this.usage = new DF(parent, conf);
        }

        long getCapacity() throws IOException {
            return this.usage.getCapacity();
        }

        long getAvailable() throws IOException {
            long capacity = this.usage.getCapacity();
            long freespace = Math.round((double)this.usage.getAvailableSkipRefresh() - (double)capacity * (1.0 - this.usableDiskPct) - (double)this.reserved);
            return freespace > 0L ? freespace : 0L;
        }

        String getMount() throws IOException {
            return this.usage.getMount();
        }

        File createTmpFile(Block b) throws IOException {
            File f = new File(this.tmpDir, b.getBlockName());
            try {
                if (f.exists()) {
                    throw new IOException("Unexpected problem in creating temporary file for " + b + ".  File " + f + " should not be present, but is.");
                }
                if (!f.createNewFile()) {
                    throw new IOException("Unexpected problem in creating temporary file for " + b + ".  File " + f + " should be creatable, but is already present.");
                }
            }
            catch (IOException ie) {
                System.out.println("Exception! " + ie);
                throw ie;
            }
            return f;
        }

        File addBlock(Block b, File f) throws IOException {
            return this.dataDir.addBlock(b, f);
        }

        void checkDirs() throws DiskChecker.DiskErrorException {
            this.dataDir.checkDirTree();
            DiskChecker.checkDir(this.tmpDir);
        }

        void getBlockInfo(TreeSet<Block> blockSet) {
            this.dataDir.getBlockInfo(blockSet);
        }

        void getVolumeMap(HashMap<Block, FSVolume> volumeMap) {
            this.dataDir.getVolumeMap(volumeMap, this);
        }

        void getBlockMap(HashMap<Block, File> blockMap) {
            this.dataDir.getBlockMap(blockMap);
        }

        void clearPath(File f) {
            this.dataDir.clearPath(f);
        }

        public String toString() {
            return this.dataDir.dir.getAbsolutePath();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FSDir {
        File dir;
        int numBlocks = 0;
        FSDir[] children;
        int lastChildIdx = 0;

        public FSDir(File dir) throws IOException {
            this.dir = dir;
            this.children = null;
            if (!dir.exists()) {
                if (!dir.mkdirs()) {
                    throw new IOException("Mkdirs failed to create " + dir.toString());
                }
            } else {
                File[] files = dir.listFiles();
                int numChildren = 0;
                for (int idx = 0; idx < files.length; ++idx) {
                    if (files[idx].isDirectory()) {
                        ++numChildren;
                        continue;
                    }
                    if (!Block.isBlockFilename(files[idx])) continue;
                    ++this.numBlocks;
                }
                if (numChildren > 0) {
                    this.children = new FSDir[numChildren];
                    int curdir = 0;
                    for (int idx = 0; idx < files.length; ++idx) {
                        if (!files[idx].isDirectory()) continue;
                        this.children[curdir] = new FSDir(files[idx]);
                        ++curdir;
                    }
                }
            }
        }

        public File addBlock(Block b, File src) throws IOException {
            File file = this.addBlock(b, src, false, false);
            return file != null ? file : this.addBlock(b, src, true, true);
        }

        private File addBlock(Block b, File src, boolean createOk, boolean resetIdx) throws IOException {
            if (this.numBlocks < FSDataset.this.maxBlocksPerDir) {
                File dest = new File(this.dir, b.getBlockName());
                src.renameTo(dest);
                ++this.numBlocks;
                return dest;
            }
            if (this.lastChildIdx < 0 && resetIdx) {
                this.lastChildIdx = random.nextInt(this.children.length);
            }
            if (this.lastChildIdx >= 0 && this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    int idx = (this.lastChildIdx + i) % this.children.length;
                    File file = this.children[idx].addBlock(b, src, false, resetIdx);
                    if (file == null) continue;
                    this.lastChildIdx = idx;
                    return file;
                }
                this.lastChildIdx = -1;
            }
            if (!createOk) {
                return null;
            }
            if (this.children == null || this.children.length == 0) {
                this.children = new FSDir[FSDataset.this.maxBlocksPerDir];
                for (int idx = 0; idx < FSDataset.this.maxBlocksPerDir; ++idx) {
                    this.children[idx] = new FSDir(new File(this.dir, "subdir" + idx));
                }
            }
            this.lastChildIdx = random.nextInt(this.children.length);
            return this.children[this.lastChildIdx].addBlock(b, src, true, false);
        }

        public void getBlockInfo(TreeSet<Block> blockSet) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].getBlockInfo(blockSet);
                }
            }
            File[] blockFiles = this.dir.listFiles();
            for (int i = 0; i < blockFiles.length; ++i) {
                if (!Block.isBlockFilename(blockFiles[i])) continue;
                blockSet.add(new Block(blockFiles[i], blockFiles[i].length()));
            }
        }

        void getVolumeMap(HashMap<Block, FSVolume> volumeMap, FSVolume volume) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].getVolumeMap(volumeMap, volume);
                }
            }
            File[] blockFiles = this.dir.listFiles();
            for (int i = 0; i < blockFiles.length; ++i) {
                if (!Block.isBlockFilename(blockFiles[i])) continue;
                volumeMap.put(new Block(blockFiles[i], blockFiles[i].length()), volume);
            }
        }

        void getBlockMap(HashMap<Block, File> blockMap) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].getBlockMap(blockMap);
                }
            }
            File[] blockFiles = this.dir.listFiles();
            for (int i = 0; i < blockFiles.length; ++i) {
                if (!Block.isBlockFilename(blockFiles[i])) continue;
                blockMap.put(new Block(blockFiles[i], blockFiles[i].length()), blockFiles[i]);
            }
        }

        public void checkDirTree() throws DiskChecker.DiskErrorException {
            DiskChecker.checkDir(this.dir);
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].checkDirTree();
                }
            }
        }

        void clearPath(File f) {
            String[] dirNames;
            String root = this.dir.getAbsolutePath();
            String dir = f.getAbsolutePath();
            if (dir.startsWith(root) && this.clearPath(f, dirNames = dir.substring(root.length()).split(File.separator + "subdir"), 1)) {
                return;
            }
            this.clearPath(f, null, -1);
        }

        private boolean clearPath(File f, String[] dirNames, int idx) {
            if ((dirNames == null || idx == dirNames.length) && this.dir.compareTo(f) == 0) {
                --this.numBlocks;
                return true;
            }
            if (dirNames != null) {
                int childIdx;
                if (idx > dirNames.length - 1 || this.children == null) {
                    return false;
                }
                try {
                    childIdx = Integer.parseInt(dirNames[idx]);
                }
                catch (NumberFormatException ignored) {
                    return false;
                }
                return childIdx >= 0 && childIdx < this.children.length ? this.children[childIdx].clearPath(f, dirNames, idx + 1) : false;
            }
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (!this.children[i].clearPath(f, null, -1)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "FSDir{dir=" + this.dir + ", children=" + (this.children == null ? null : Arrays.asList(this.children)) + "}";
        }
    }
}

