/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

class Block
implements Writable,
Comparable {
    long blkid;
    long len;

    public static boolean isBlockFilename(File f) {
        return f.getName().startsWith("blk_");
    }

    public Block() {
        this.blkid = 0L;
        this.len = 0L;
    }

    public Block(long blkid, long len) {
        this.blkid = blkid;
        this.len = len;
    }

    public Block(File f, long len) {
        String name = f.getName();
        name = name.substring("blk_".length());
        this.blkid = Long.parseLong(name);
        this.len = len;
    }

    public long getBlockId() {
        return this.blkid;
    }

    public String getBlockName() {
        return "blk_" + String.valueOf(this.blkid);
    }

    public long getNumBytes() {
        return this.len;
    }

    public void setNumBytes(long len) {
        this.len = len;
    }

    public String toString() {
        return this.getBlockName();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.blkid);
        out.writeLong(this.len);
    }

    public void readFields(DataInput in) throws IOException {
        this.blkid = in.readLong();
        this.len = in.readLong();
        if (this.len < 0L) {
            throw new IOException("Unexpected block size: " + this.len);
        }
    }

    public int compareTo(Object o) {
        Block b = (Block)o;
        if (this.blkid < b.blkid) {
            return -1;
        }
        if (this.blkid == b.blkid) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object o) {
        return this.blkid == ((Block)o).blkid;
    }

    public int hashCode() {
        return 629 + (int)(this.blkid ^ this.blkid >>> 32);
    }

    static {
        WritableFactories.setFactory(Block.class, new WritableFactory(){

            public Writable newInstance() {
                return new Block();
            }
        });
    }
}

