/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.service;

import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.binding.Binding;
import com.eucalyptus.binding.BindingException;
import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.ComputeMessage;
import com.eucalyptus.compute.service.ComputeServiceAuthorizationException;
import com.eucalyptus.compute.service.ComputeServiceClientException;
import com.eucalyptus.compute.service.ComputeServiceException;
import com.eucalyptus.compute.service.ComputeServiceUnavailableException;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.ServiceDispatchException;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.MessageValidation;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.FailedRequestException;
import com.eucalyptus.ws.EucalyptusRemoteFault;
import com.eucalyptus.ws.EucalyptusWebServiceException;
import com.google.common.base.Objects;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.BaseMessages;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.mule.component.ComponentException;

public class ComputeService {
    private static Logger LOG = Logger.getLogger(ComputeService.class);

    public ComputeMessage dispatchAction(ComputeMessage request) throws EucalyptusCloudException {
        Map validationErrorsByField;
        LOG.debug((Object)request.toSimpleString());
        AuthContextSupplier user = Contexts.lookup().getAuthContext();
        if (!Permissions.perhapsAuthorized((String)"ec2", (String)RestrictedTypes.getIamActionByMessageType((BaseMessage)request), (AuthContextSupplier)user)) {
            throw new ComputeServiceAuthorizationException("UnauthorizedOperation", "You are not authorized to perform this operation.");
        }
        if (request instanceof MessageValidation.ValidatableMessage && !(validationErrorsByField = ((MessageValidation.ValidatableMessage)request).validate()).isEmpty()) {
            String error = (String)validationErrorsByField.values().iterator().next();
            throw new ComputeServiceClientException("InvalidParameterValue", error);
        }
        try {
            BaseMessage backendRequest = BaseMessages.deepCopy((BaseMessage)request, (Class)ComputeService.getBackendMessageClass((BaseMessage)request));
            BaseMessage backendResponse = ComputeService.send(backendRequest);
            ComputeMessage response = (ComputeMessage)BaseMessages.deepCopy((BaseMessage)backendResponse, request.getReply().getClass());
            response.setCorrelationId(request.getCorrelationId());
            LOG.debug((Object)response.toSimpleString());
            return response;
        }
        catch (Exception e) {
            this.handleRemoteException(e);
            Exceptions.findAndRethrow((Throwable)e, EucalyptusWebServiceException.class, EucalyptusCloudException.class);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    private static Class getBackendMessageClass(BaseMessage request) throws BindingException {
        Binding binding = BindingManager.getDefaultBinding();
        return binding.getElementClass("Eucalyptus." + request.getClass().getSimpleName());
    }

    private static BaseMessage send(BaseMessage request) throws Exception {
        try {
            return AsyncRequests.sendSyncWithCurrentIdentity((ServiceConfiguration)Topology.lookup(Eucalyptus.class, (Partition[])new Partition[0]), (BaseMessage)request);
        }
        catch (NoSuchElementException e) {
            throw new ComputeServiceUnavailableException("Service Unavailable");
        }
        catch (ServiceDispatchException e) {
            ComponentException componentException = (ComponentException)Exceptions.findCause((Throwable)e, ComponentException.class);
            if (componentException != null && componentException.getCause() instanceof Exception) {
                throw (Exception)componentException.getCause();
            }
            throw e;
        }
        catch (FailedRequestException e) {
            if (request.getReply().getClass().isInstance(e.getRequest())) {
                return e.getRequest();
            }
            throw e.getRequest() == null ? e : new ComputeServiceException("InternalError", "Internal error " + e.getRequest().getClass().getSimpleName() + ":false");
        }
    }

    private void handleRemoteException(Exception e) throws EucalyptusCloudException {
        EucalyptusRemoteFault remoteFault = (EucalyptusRemoteFault)Exceptions.findCause((Throwable)e, EucalyptusRemoteFault.class);
        if (remoteFault != null) {
            HttpResponseStatus status = (HttpResponseStatus)Objects.firstNonNull((Object)remoteFault.getStatus(), (Object)HttpResponseStatus.INTERNAL_SERVER_ERROR);
            String code = remoteFault.getFaultCode();
            String message = remoteFault.getFaultDetail();
            switch (status.getCode()) {
                case 400: {
                    throw new ComputeServiceClientException(code, message);
                }
                case 403: {
                    throw new ComputeServiceAuthorizationException(code, message);
                }
                case 503: {
                    throw new ComputeServiceUnavailableException(message);
                }
            }
            throw new ComputeServiceException(code, message);
        }
    }
}

