/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud.ws;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.context.ServiceContext;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.async.AsyncRequests;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.ComponentMessageType;
import org.apache.log4j.Logger;

public class ComponentService {
    private static Logger LOG = Logger.getLogger(ComponentService.class);

    public BaseMessage handle(ComponentMessageType request) throws Exception {
        String component = request.getComponent();
        String host = request.getHost();
        String name = request.getName();
        ServiceConfiguration service = this.lookupService(component, host, name);
        LOG.info((Object)("Component: " + service));
        try {
            BaseMessage reply = null;
            reply = service.isVmLocal() != false ? (BaseMessage)ServiceContext.send((String)service.getComponentId().getLocalEndpointName(), (Object)request) : AsyncRequests.sendSync((ServiceConfiguration)service, (BaseMessage)request);
            return reply;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new EucalyptusCloudException("Unable to dispatch message to: " + service.getName());
        }
    }

    private ServiceConfiguration lookupService(String component, String name, String host) throws EucalyptusCloudException {
        ComponentId destCompId = ComponentIds.lookup((String)component);
        if (name != null) {
            return ServiceConfigurations.lookupByName(destCompId.getClass(), (String)name);
        }
        if (host != null) {
            return ServiceConfigurations.lookupByHost(destCompId.getClass(), (String)name);
        }
        throw new EucalyptusCloudException("Unable to dispatch message to: " + component + "@" + host);
    }
}

