/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.policy;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.policy.key.KeyUtils;
import com.eucalyptus.auth.policy.key.PolicyKey;
import com.eucalyptus.auth.policy.key.QuotaKey;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.loadbalancing.common.LoadBalancingMetadata;
import com.eucalyptus.util.RestrictedTypes;
import net.sf.json.JSONException;

@PolicyKey(value="elasticloadbalancing:quota-loadbalancernumber")
public class LoadBalancerNumberQuotaKey
extends QuotaKey {
    public static final String KEY = "elasticloadbalancing:quota-loadbalancernumber";

    public final void validateValueType(String value) throws JSONException {
        KeyUtils.validateIntegerValue((String)value, (String)KEY);
    }

    public final boolean canApply(String action, String resourceType) {
        return PolicySpec.qualifiedName((String)"elasticloadbalancing", (String)"createloadbalancer").equals(action);
    }

    public final String value(Authorization.Scope scope, String id, String resource, Long quantity) throws AuthException {
        AccountFullName name;
        switch (scope) {
            case ACCOUNT: {
                name = AccountFullName.getInstance((String)id, (String[])new String[0]);
                break;
            }
            case GROUP: {
                return "Not supported";
            }
            case USER: {
                name = UserFullName.getInstance((String)id, (String[])new String[0]);
                break;
            }
            default: {
                throw new AuthException("Invalid scope");
            }
        }
        return Long.toString((Long)RestrictedTypes.quantityMetricFunction(LoadBalancingMetadata.LoadBalancerMetadata.class).apply((Object)name) + quantity);
    }
}

