/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.backend;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.AuthQuotaException;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.cloudwatch.common.msgs.MetricData;
import com.eucalyptus.compute.common.ClusterInfoType;
import com.eucalyptus.compute.common.InternetGatewayType;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.compute.common.SecurityGroupItemType;
import com.eucalyptus.compute.common.SubnetType;
import com.eucalyptus.compute.common.VpcType;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.event.EventFailedException;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancerBackendInstance;
import com.eucalyptus.loadbalancing.LoadBalancerCwatchMetrics;
import com.eucalyptus.loadbalancing.LoadBalancerDnsRecord;
import com.eucalyptus.loadbalancing.LoadBalancerListener;
import com.eucalyptus.loadbalancing.LoadBalancerPolicies;
import com.eucalyptus.loadbalancing.LoadBalancerPolicyDescription;
import com.eucalyptus.loadbalancing.LoadBalancerPolicyTypeDescription;
import com.eucalyptus.loadbalancing.LoadBalancerSecurityGroup;
import com.eucalyptus.loadbalancing.LoadBalancerSecurityGroupRef;
import com.eucalyptus.loadbalancing.LoadBalancerZone;
import com.eucalyptus.loadbalancing.LoadBalancers;
import com.eucalyptus.loadbalancing.activities.ActivityManager;
import com.eucalyptus.loadbalancing.activities.ApplySecurityGroupsEvent;
import com.eucalyptus.loadbalancing.activities.CreateListenerEvent;
import com.eucalyptus.loadbalancing.activities.DeleteListenerEvent;
import com.eucalyptus.loadbalancing.activities.DeleteLoadbalancerEvent;
import com.eucalyptus.loadbalancing.activities.DeregisterInstancesEvent;
import com.eucalyptus.loadbalancing.activities.DisabledZoneEvent;
import com.eucalyptus.loadbalancing.activities.EnabledZoneEvent;
import com.eucalyptus.loadbalancing.activities.EucalyptusActivityTasks;
import com.eucalyptus.loadbalancing.activities.LoadBalancerServoInstance;
import com.eucalyptus.loadbalancing.activities.LoadbalancingUserEvent;
import com.eucalyptus.loadbalancing.activities.NewLoadbalancerEvent;
import com.eucalyptus.loadbalancing.activities.RegisterInstancesEvent;
import com.eucalyptus.loadbalancing.backend.AccessPointNotFoundException;
import com.eucalyptus.loadbalancing.backend.InternalFailure400Exception;
import com.eucalyptus.loadbalancing.backend.InternalFailureException;
import com.eucalyptus.loadbalancing.backend.InvalidConfigurationRequestException;
import com.eucalyptus.loadbalancing.backend.InvalidEndPointException;
import com.eucalyptus.loadbalancing.backend.ListenerNotFoundException;
import com.eucalyptus.loadbalancing.backend.LoadBalancingBackendClientException;
import com.eucalyptus.loadbalancing.backend.LoadBalancingException;
import com.eucalyptus.loadbalancing.backend.PolicyNotFoundException;
import com.eucalyptus.loadbalancing.backend.TooManyAccessPointsException;
import com.eucalyptus.loadbalancing.common.LoadBalancingMetadatas;
import com.eucalyptus.loadbalancing.common.backend.msgs.AddTagsResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.AddTagsType;
import com.eucalyptus.loadbalancing.common.backend.msgs.ApplySecurityGroupsToLoadBalancerResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.ApplySecurityGroupsToLoadBalancerType;
import com.eucalyptus.loadbalancing.common.backend.msgs.AttachLoadBalancerToSubnetsResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.AttachLoadBalancerToSubnetsType;
import com.eucalyptus.loadbalancing.common.backend.msgs.ConfigureHealthCheckResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.ConfigureHealthCheckType;
import com.eucalyptus.loadbalancing.common.backend.msgs.CreateAppCookieStickinessPolicyResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.CreateAppCookieStickinessPolicyType;
import com.eucalyptus.loadbalancing.common.backend.msgs.CreateLBCookieStickinessPolicyResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.CreateLBCookieStickinessPolicyType;
import com.eucalyptus.loadbalancing.common.backend.msgs.CreateLoadBalancerListenersResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.CreateLoadBalancerListenersType;
import com.eucalyptus.loadbalancing.common.backend.msgs.CreateLoadBalancerPolicyResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.CreateLoadBalancerPolicyType;
import com.eucalyptus.loadbalancing.common.backend.msgs.CreateLoadBalancerResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.CreateLoadBalancerType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DeleteLoadBalancerListenersResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DeleteLoadBalancerListenersType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DeleteLoadBalancerPolicyResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DeleteLoadBalancerPolicyType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DeleteLoadBalancerResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DeleteLoadBalancerType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DeregisterInstancesFromLoadBalancerResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DeregisterInstancesFromLoadBalancerType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DescribeInstanceHealthResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DescribeInstanceHealthType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DescribeLoadBalancerAttributesResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DescribeLoadBalancerAttributesType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DescribeLoadBalancerPoliciesResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DescribeLoadBalancerPoliciesType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DescribeLoadBalancerPolicyTypesResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DescribeLoadBalancerPolicyTypesType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DescribeLoadBalancersByServoResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DescribeLoadBalancersByServoType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DescribeLoadBalancersResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DescribeLoadBalancersType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DescribeTagsResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DescribeTagsType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DetachLoadBalancerFromSubnetsResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DetachLoadBalancerFromSubnetsType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DisableAvailabilityZonesForLoadBalancerResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.DisableAvailabilityZonesForLoadBalancerType;
import com.eucalyptus.loadbalancing.common.backend.msgs.EnableAvailabilityZonesForLoadBalancerResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.EnableAvailabilityZonesForLoadBalancerType;
import com.eucalyptus.loadbalancing.common.backend.msgs.ModifyLoadBalancerAttributesResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.ModifyLoadBalancerAttributesType;
import com.eucalyptus.loadbalancing.common.backend.msgs.PutServoStatesResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.PutServoStatesType;
import com.eucalyptus.loadbalancing.common.backend.msgs.RegisterInstancesWithLoadBalancerResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.RegisterInstancesWithLoadBalancerType;
import com.eucalyptus.loadbalancing.common.backend.msgs.RemoveTagsResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.RemoveTagsType;
import com.eucalyptus.loadbalancing.common.backend.msgs.SetLoadBalancerListenerSSLCertificateResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.SetLoadBalancerListenerSSLCertificateType;
import com.eucalyptus.loadbalancing.common.backend.msgs.SetLoadBalancerPoliciesForBackendServerResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.SetLoadBalancerPoliciesForBackendServerType;
import com.eucalyptus.loadbalancing.common.backend.msgs.SetLoadBalancerPoliciesOfListenerResponseType;
import com.eucalyptus.loadbalancing.common.backend.msgs.SetLoadBalancerPoliciesOfListenerType;
import com.eucalyptus.loadbalancing.common.msgs.AppCookieStickinessPolicies;
import com.eucalyptus.loadbalancing.common.msgs.AppCookieStickinessPolicy;
import com.eucalyptus.loadbalancing.common.msgs.AvailabilityZones;
import com.eucalyptus.loadbalancing.common.msgs.ConfigureHealthCheckResult;
import com.eucalyptus.loadbalancing.common.msgs.ConnectionSettings;
import com.eucalyptus.loadbalancing.common.msgs.CreateLoadBalancerResult;
import com.eucalyptus.loadbalancing.common.msgs.DeleteLoadBalancerResult;
import com.eucalyptus.loadbalancing.common.msgs.DeregisterInstancesFromLoadBalancerResult;
import com.eucalyptus.loadbalancing.common.msgs.DescribeInstanceHealthResult;
import com.eucalyptus.loadbalancing.common.msgs.DescribeLoadBalancerPoliciesResult;
import com.eucalyptus.loadbalancing.common.msgs.DescribeLoadBalancerPolicyTypesResult;
import com.eucalyptus.loadbalancing.common.msgs.DescribeLoadBalancersResult;
import com.eucalyptus.loadbalancing.common.msgs.DisableAvailabilityZonesForLoadBalancerResult;
import com.eucalyptus.loadbalancing.common.msgs.EnableAvailabilityZonesForLoadBalancerResult;
import com.eucalyptus.loadbalancing.common.msgs.HealthCheck;
import com.eucalyptus.loadbalancing.common.msgs.Instance;
import com.eucalyptus.loadbalancing.common.msgs.InstanceState;
import com.eucalyptus.loadbalancing.common.msgs.InstanceStates;
import com.eucalyptus.loadbalancing.common.msgs.Instances;
import com.eucalyptus.loadbalancing.common.msgs.LBCookieStickinessPolicies;
import com.eucalyptus.loadbalancing.common.msgs.LBCookieStickinessPolicy;
import com.eucalyptus.loadbalancing.common.msgs.Listener;
import com.eucalyptus.loadbalancing.common.msgs.ListenerDescription;
import com.eucalyptus.loadbalancing.common.msgs.ListenerDescriptions;
import com.eucalyptus.loadbalancing.common.msgs.LoadBalancerAttributes;
import com.eucalyptus.loadbalancing.common.msgs.LoadBalancerDescription;
import com.eucalyptus.loadbalancing.common.msgs.LoadBalancerDescriptions;
import com.eucalyptus.loadbalancing.common.msgs.LoadBalancerServoDescription;
import com.eucalyptus.loadbalancing.common.msgs.LoadBalancerServoDescriptions;
import com.eucalyptus.loadbalancing.common.msgs.Policies;
import com.eucalyptus.loadbalancing.common.msgs.PolicyAttribute;
import com.eucalyptus.loadbalancing.common.msgs.PolicyDescription;
import com.eucalyptus.loadbalancing.common.msgs.PolicyDescriptions;
import com.eucalyptus.loadbalancing.common.msgs.PolicyNames;
import com.eucalyptus.loadbalancing.common.msgs.PolicyTypeDescriptions;
import com.eucalyptus.loadbalancing.common.msgs.SecurityGroups;
import com.eucalyptus.loadbalancing.common.msgs.SetLoadBalancerListenerSSLCertificateResult;
import com.eucalyptus.loadbalancing.common.msgs.SourceSecurityGroup;
import com.eucalyptus.loadbalancing.common.msgs.Subnets;
import com.eucalyptus.loadbalancing.common.msgs.Tag;
import com.eucalyptus.loadbalancing.common.msgs.TagDescription;
import com.eucalyptus.loadbalancing.common.msgs.TagDescriptions;
import com.eucalyptus.loadbalancing.common.msgs.TagKeyOnly;
import com.eucalyptus.loadbalancing.common.msgs.TagList;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.net.HostSpecifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.EntityNotFoundException;
import javax.persistence.OptimisticLockException;
import org.apache.log4j.Logger;

public class LoadBalancingBackendService {
    private static Logger LOG = Logger.getLogger(LoadBalancingBackendService.class);
    private static final int MIN_HEALTHCHECK_INTERVAL_SEC = 5;
    private static final int MIN_HEALTHCHECK_THRESHOLDS = 2;
    private static final int MAX_TAGS = 10;
    private static final Set<String> reservedPrefixes = ImmutableSet.builder().add((Object)"aws:").add((Object)"euca:").build();

    private void isValidServoRequest(String instanceId, String remoteHost) throws LoadBalancingException {
        try {
            LoadBalancerServoInstance instance = LoadBalancers.lookupServoInstance(instanceId);
            if (!remoteHost.equals(instance.getAddress()) && !remoteHost.equals(instance.getPrivateIp())) {
                throw new LoadBalancingException(String.format("IP address (%s) not match with record (%s-%s)", remoteHost, instance.getAddress(), instance.getPrivateIp()));
            }
        }
        catch (LoadBalancingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new LoadBalancingException("unknown error", ex);
        }
    }

    public DescribeLoadBalancersByServoResponseType describeLoadBalancersByServo(DescribeLoadBalancersByServoType request) throws EucalyptusCloudException {
        LoadBalancerZone zone;
        DescribeLoadBalancersByServoResponseType reply = (DescribeLoadBalancersByServoResponseType)request.getReply();
        String instanceId = request.getInstanceId();
        try {
            this.isValidServoRequest(instanceId, request.getSourceIp());
            LoadBalancerServoInstance instance = LoadBalancers.lookupServoInstance(instanceId);
            LoadBalancerZone.LoadBalancerZoneCoreView zoneView = instance.getAvailabilityZone();
            zone = LoadBalancerZone.LoadBalancerZoneEntityTransform.INSTANCE.apply(zoneView);
        }
        catch (Exception ex) {
            throw new InternalFailureException("Failed to verify request sender");
        }
        Function<LoadBalancerZone, Optional<LoadBalancerServoDescription>> lookupLBDescriptions = new Function<LoadBalancerZone, Optional<LoadBalancerServoDescription>>(){

            public Optional<LoadBalancerServoDescription> apply(LoadBalancerZone zone) {
                LoadBalancer lb;
                LoadBalancer.LoadBalancerCoreView lbView = zone.getLoadbalancer();
                String lbName = lbView.getDisplayName();
                LoadBalancerServoDescription desc = new LoadBalancerServoDescription();
                desc.setLoadBalancerName(lbName);
                desc.setCreatedTime(lbView.getCreationTimestamp());
                try {
                    lb = LoadBalancer.LoadBalancerEntityTransform.INSTANCE.apply(lbView);
                }
                catch (Exception ex) {
                    return Optional.absent();
                }
                LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView dnsView = lb.getDns();
                desc.setDnsName(dnsView.getDnsName());
                Collection notInError = Collections2.filter(zone.getBackendInstances(), (Predicate)new Predicate<LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView>(){

                    public boolean apply(LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView arg0) {
                        return !LoadBalancerBackendInstance.STATE.Error.equals((Object)arg0.getBackendState()) && arg0.getIpAddress() != null && arg0.getIpAddress().length() > 0;
                    }
                });
                if (!notInError.isEmpty()) {
                    desc.setInstances(new Instances());
                    desc.getInstances().getMember().addAll(Collections2.transform((Collection)notInError, (Function)new Function<LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView, Instance>(){

                        public Instance apply(LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView be) {
                            Instance instance = new Instance();
                            instance.setInstanceId(be.getInstanceId() + ":" + be.getIpAddress());
                            return instance;
                        }
                    }));
                }
                desc.setAvailabilityZones(new AvailabilityZones());
                desc.getAvailabilityZones().getMember().add(zone.getName());
                if (lb.getListeners().size() > 0) {
                    desc.setListenerDescriptions(new ListenerDescriptions());
                    desc.getListenerDescriptions().setMember(new ArrayList(Collections2.transform(lb.getListeners(), (Function)new Function<LoadBalancerListener.LoadBalancerListenerCoreView, ListenerDescription>(){

                        public ListenerDescription apply(LoadBalancerListener.LoadBalancerListenerCoreView input) {
                            ListenerDescription desc = new ListenerDescription();
                            Listener listener = new Listener();
                            listener.setLoadBalancerPort(Integer.valueOf(input.getLoadbalancerPort()));
                            listener.setInstancePort(Integer.valueOf(input.getInstancePort()));
                            if (input.getInstanceProtocol() != LoadBalancerListener.PROTOCOL.NONE) {
                                listener.setInstanceProtocol(input.getInstanceProtocol().name());
                            }
                            listener.setProtocol(input.getProtocol().name());
                            if (input.getCertificateId() != null) {
                                listener.setSSLCertificateId(input.getCertificateId());
                            }
                            desc.setListener(listener);
                            LoadBalancerListener lbListener = LoadBalancerListener.LoadBalancerListenerEntityTransform.INSTANCE.apply(input);
                            PolicyNames pnames = new PolicyNames();
                            pnames.setMember(new ArrayList(Lists.transform(lbListener.getPolicies(), (Function)new Function<LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionCoreView, String>(){

                                public String apply(LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionCoreView arg0) {
                                    try {
                                        LoadBalancerPolicyDescription policy = LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionEntityTransform.INSTANCE.apply(arg0);
                                        if ("LBCookieStickinessPolicyType".equals(arg0.getPolicyTypeName())) {
                                            String expiration = policy.findAttributeDescription("CookieExpirationPeriod").getAttributeValue();
                                            return String.format("LBCookieStickinessPolicyType:%s", expiration);
                                        }
                                        if ("AppCookieStickinessPolicyType".equals(arg0.getPolicyTypeName())) {
                                            String cookieName = policy.findAttributeDescription("CookieName").getAttributeValue();
                                            return String.format("AppCookieStickinessPolicyType:%s", cookieName);
                                        }
                                        return arg0.getPolicyName();
                                    }
                                    catch (Exception ex) {
                                        return arg0.getPolicyName();
                                    }
                                }
                            })));
                            desc.setPolicyNames(pnames);
                            return desc;
                        }
                    })));
                }
                try {
                    int interval = lb.getHealthCheckInterval();
                    String target = lb.getHealthCheckTarget();
                    int timeout = lb.getHealthCheckTimeout();
                    int healthyThresholds = lb.getHealthyThreshold();
                    int unhealthyThresholds = lb.getHealthCheckUnhealthyThreshold();
                    HealthCheck hc = new HealthCheck();
                    hc.setInterval(Integer.valueOf(interval));
                    hc.setHealthyThreshold(Integer.valueOf(healthyThresholds));
                    hc.setTarget(target);
                    hc.setTimeout(Integer.valueOf(timeout));
                    hc.setUnhealthyThreshold(Integer.valueOf(unhealthyThresholds));
                    desc.setHealthCheck(hc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                desc.setLoadBalancerAttributes((LoadBalancerAttributes)TypeMappers.transform((Object)((Object)lb), LoadBalancerAttributes.class));
                return Optional.of((Object)desc);
            }
        };
        Optional descs = Optional.absent();
        try {
            LoadBalancer lb = LoadBalancer.LoadBalancerEntityTransform.INSTANCE.apply(zone.getLoadbalancer());
            if (zone != null && LoadBalancingMetadatas.filterPrivilegedWithoutOwner().apply((Object)lb) && zone.getState().equals((Object)LoadBalancerZone.STATE.InService)) {
                descs = (Optional)lookupLBDescriptions.apply((Object)zone);
            }
        }
        catch (Exception lb) {
            // empty catch block
        }
        LoadBalancerServoDescriptions lbDescs = new LoadBalancerServoDescriptions();
        lbDescs.getMember().addAll(descs.asSet());
        reply.getDescribeLoadBalancersResult().setLoadBalancerDescriptions(lbDescs);
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public PutServoStatesResponseType putServoStates(PutServoStatesType request) throws EucalyptusCloudException {
        PutServoStatesResponseType reply = (PutServoStatesResponseType)request.getReply();
        String servoId = request.getInstanceId();
        try {
            this.isValidServoRequest(servoId, request.getSourceIp());
        }
        catch (Exception ex) {
            throw new InternalFailureException("Failed to verify request sender");
        }
        Instances instances = request.getInstances();
        MetricData metric = request.getMetricData();
        LoadBalancer lb = null;
        if (servoId != null) {
            try {
                LoadBalancerServoInstance servo = LoadBalancers.lookupServoInstance(servoId);
                LoadBalancerZone.LoadBalancerZoneCoreView zoneView = servo.getAvailabilityZone();
                LoadBalancerZone zone = LoadBalancerZone.LoadBalancerZoneEntityTransform.INSTANCE.apply(zoneView);
                LoadBalancer.LoadBalancerCoreView lbView = zone.getLoadbalancer();
                lb = LoadBalancer.LoadBalancerEntityTransform.INSTANCE.apply(lbView);
                if (lb == null) {
                    throw new Exception("Failed to find the loadbalancer");
                }
                if (!servo.getAvailabilityZone().getState().equals((Object)LoadBalancerZone.STATE.InService)) {
                    lb = null;
                }
            }
            catch (NoSuchElementException ex) {
                LOG.warn((Object)("unknown servo VM id is used to query: " + servoId));
            }
            catch (Exception ex) {
                LOG.warn((Object)"failed to query servo instance");
            }
        }
        if (lb == null || !LoadBalancingMetadatas.filterPrivilegedWithoutOwner().apply(lb)) {
            return reply;
        }
        if (instances != null && instances.getMember() != null && instances.getMember().size() > 0) {
            Collection<LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView> lbInstances = lb.getBackendInstances();
            for (Instance instance : instances.getMember()) {
                String instanceId = instance.getInstanceId();
                String[] parts = instanceId.split(":");
                if (parts == null || parts.length != 2) {
                    LOG.warn((Object)("instance id is in wrong format:" + instanceId));
                    continue;
                }
                instanceId = parts[0];
                String state = parts[1];
                LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView found = null;
                for (LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView lbInstance : lbInstances) {
                    if (!instanceId.equals(lbInstance.getInstanceId())) continue;
                    found = lbInstance;
                    break;
                }
                if (found == null) continue;
                try {
                    TransactionResource db = Entities.transactionFor(LoadBalancerBackendInstance.class);
                    Throwable throwable = null;
                    try {
                        LoadBalancerBackendInstance update = (LoadBalancerBackendInstance)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerBackendInstance.named(lb, found.getInstanceId()))));
                        update.setState(Enum.valueOf(LoadBalancerBackendInstance.STATE.class, state));
                        if (state.equals(LoadBalancerBackendInstance.STATE.OutOfService.name())) {
                            update.setReasonCode("Instance");
                            update.setDescription("Instance has failed at least the UnhealthyThreshold number of health checks consecutively.");
                        } else {
                            update.setReasonCode("");
                            update.setDescription("");
                        }
                        update.updateInstanceStateTimestamp();
                        Entities.persist((Object)((Object)update));
                        db.commit();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (db == null) continue;
                        if (throwable != null) {
                            try {
                                db.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        db.close();
                    }
                }
                catch (NoSuchElementException ex) {
                    LOG.error((Object)"unable to find the loadbancer backend instance", (Throwable)ex);
                }
                catch (Exception ex) {
                    LOG.error((Object)"unable to update the state of loadbalancer backend instance", (Throwable)ex);
                }
            }
        }
        for (LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView sample : lb.getBackendInstances()) {
            try {
                TransactionResource db = Entities.transactionFor(LoadBalancerBackendInstance.class);
                Throwable throwable = null;
                try {
                    LoadBalancerBackendInstance found = (LoadBalancerBackendInstance)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerBackendInstance.named(lb, sample.getInstanceId()))));
                    String zoneName = found.getAvailabilityZone().getName();
                    if (((LoadBalancerBackendInstance.STATE)found.getState()).equals((Object)LoadBalancerBackendInstance.STATE.InService)) {
                        LoadBalancerCwatchMetrics.getInstance().updateHealthy(lb.getCoreView(), zoneName, found.getInstanceId());
                    } else if (((LoadBalancerBackendInstance.STATE)found.getState()).equals((Object)LoadBalancerBackendInstance.STATE.OutOfService)) {
                        LoadBalancerCwatchMetrics.getInstance().updateUnHealthy(lb.getCoreView(), zoneName, found.getInstanceId());
                    }
                    db.commit();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (db == null) continue;
                    if (throwable != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    db.close();
                }
            }
            catch (NoSuchElementException db) {
            }
            catch (Exception ex) {
                LOG.warn((Object)"Failed to query loadbalancer backend instance", (Throwable)ex);
            }
        }
        if (metric != null && metric.getMember() != null && metric.getMember().size() > 0) {
            try {
                LoadBalancerCwatchMetrics.getInstance().addMetric(servoId, metric);
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to add ELB cloudwatch metric", (Throwable)ex);
            }
        }
        return reply;
    }

    public CreateLoadBalancerResponseType createLoadBalancer(CreateLoadBalancerType request) throws EucalyptusCloudException {
        LoadbalancingUserEvent evt;
        LoadBalancer lb;
        List<Object> groups;
        LoadBalancer.Scheme reqScheme;
        CreateLoadBalancerResponseType reply = (CreateLoadBalancerResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        final UserFullName ownerFullName = ctx.getUserFullName();
        final String lbName = request.getLoadBalancerName();
        if (lbName == null || !HostSpecifier.isValid((String)String.format("%s.com", lbName)) || !lbName.matches("[a-zA-Z0-9-]{1,32}")) {
            throw new InvalidConfigurationRequestException("Invalid character found in the loadbalancer name");
        }
        final HashMap tags = Maps.newHashMap();
        if (request.getTags() != null) {
            for (Tag tag : request.getTags().getMember()) {
                if (tags.put(tag.getKey(), Strings.nullToEmpty((String)tag.getValue())) == null) continue;
                throw new LoadBalancingBackendClientException("DuplicateTagKeys", "Duplicate tag key (" + tag.getKey() + ")");
            }
            int userTags = Iterables.size((Iterable)Iterables.filter(tags.keySet(), (Predicate)Predicates.not(LoadBalancingBackendService.isReservedTagPrefix())));
            if (tags.size() - userTags > 0 && !Contexts.lookup().isPrivileged()) {
                throw new InvalidConfigurationRequestException("Invalid tag key (reserved prefix)");
            }
            if (userTags > 10) {
                throw Exceptions.toUndeclared((Throwable)((Object)new LoadBalancingBackendClientException("TooManyTags", "Tag limit exceeded")));
            }
        }
        ArrayList listeners = request.getListeners() != null ? request.getListeners().getMember() : Collections.emptyList();
        LoadBalancers.validateListener(listeners);
        try {
            for (Listener l : listeners) {
                if (!"HTTPS".equals(l.getProtocol().toUpperCase()) && !"SSL".equals(l.getProtocol().toUpperCase())) continue;
                String certArn = l.getSSLCertificateId();
                if (certArn == null || certArn.length() <= 0) {
                    throw new InvalidConfigurationRequestException("SSLCertificateId is required for HTTPS or SSL protocol");
                }
                LoadBalancers.checkSSLCertificate(ctx.getUser().getUserId(), certArn);
            }
        }
        catch (Exception ex2) {
            InternalFailure400Exception ex2;
            if (!(ex2 instanceof LoadBalancingException)) {
                LOG.error((Object)"failed to check SSL certificate Id", (Throwable)ex2);
                ex2 = new InternalFailure400Exception("failed to check SSL certificate Id", ex2);
            }
            throw (LoadBalancingException)ex2;
        }
        if (request.getAvailabilityZones() != null && !request.getAvailabilityZones().getMember().isEmpty()) {
            HashSet validZones = Sets.newHashSet();
            try {
                Iterables.addAll((Collection)validZones, (Iterable)Iterables.transform(EucalyptusActivityTasks.getInstance().describeAvailabilityZones(false), (Function)ClusterInfoType.zoneName()));
            }
            catch (Exception ex) {
                throw new InternalFailure400Exception("Unable to verify the requested zones");
            }
            for (String zone : request.getAvailabilityZones().getMember()) {
                if (validZones.contains(zone)) continue;
                throw new InvalidConfigurationRequestException("No cluster named " + zone + " is available");
            }
        }
        String subnetVpcId = null;
        HashMap zoneToSubnetIdMap = Maps.newHashMap();
        if (request.getSubnets() != null) {
            List<SubnetType> subnets = EucalyptusActivityTasks.getInstance().describeSubnets(request.getSubnets().getMember());
            if (subnets.size() != request.getSubnets().getMember().size()) {
                throw new LoadBalancingBackendClientException("SubnetNotFound", "Invalid subnet(s)");
            }
            for (SubnetType subnetType : subnets) {
                if (subnetVpcId == null) {
                    subnetVpcId = subnetType.getVpcId();
                } else if (!subnetVpcId.equals(subnetType.getVpcId())) {
                    throw new InvalidConfigurationRequestException("Subnets must belong to the same VPC");
                }
                if (zoneToSubnetIdMap.put(subnetType.getAvailabilityZone(), subnetType.getSubnetId()) == null) continue;
                throw new InvalidConfigurationRequestException("Multiple subnets for zone (" + subnetType.getAvailabilityZone() + ")");
            }
        }
        String adminUserId = LoadBalancingBackendService.lookupAdmin(ctx);
        boolean defaultVpc = false;
        if (subnetVpcId == null) {
            Optional<VpcType> vpcOptional = EucalyptusActivityTasks.getInstance().defaultVpc(adminUserId);
            subnetVpcId = (String)vpcOptional.transform(VpcType.id()).orNull();
            defaultVpc = subnetVpcId != null;
        }
        final String vpcId = subnetVpcId;
        if (defaultVpc && zoneToSubnetIdMap.isEmpty() && request.getAvailabilityZones() != null) {
            List<SubnetType> subnets = EucalyptusActivityTasks.getInstance().describeSubnetsByZone(vpcId, true, request.getAvailabilityZones().getMember());
            CollectionUtils.putAll(subnets, (Map)zoneToSubnetIdMap, (Function)SubnetType.zone(), (Function)SubnetType.id());
            if (request.getAvailabilityZones().getMember().size() != zoneToSubnetIdMap.size()) {
                throw new InvalidConfigurationRequestException("Default subnet not found for zone(s)");
            }
        }
        if ((reqScheme = (LoadBalancer.Scheme)((Object)LoadBalancer.Scheme.fromString(request.getScheme()).orNull())) == null && !Strings.isNullOrEmpty((String)request.getScheme())) {
            throw new InvalidConfigurationRequestException("Invalid scheme (" + request.getScheme() + ")");
        }
        if (reqScheme != null && vpcId == null) {
            if (reqScheme != LoadBalancer.Scheme.InternetFacing) {
                throw new InvalidConfigurationRequestException("Scheme (" + request.getScheme() + ") should not be specified for EC2-Classic platform");
            }
            reqScheme = null;
        }
        final LoadBalancer.Scheme scheme = reqScheme;
        if (vpcId != null && scheme != LoadBalancer.Scheme.Internal) {
            try {
                List<InternetGatewayType> internetGateways = EucalyptusActivityTasks.getInstance().describeInternetGateways(Collections.singleton(vpcId));
                if (internetGateways.isEmpty()) {
                    throw new LoadBalancingBackendClientException("InvalidSubnet", "VPC " + vpcId + " has no internet gateway");
                }
            }
            catch (LoadBalancingException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)"Error checking internet gateway", (Throwable)e);
                throw new InternalFailureException("Unable to verify VPC configuration");
            }
        }
        HashSet securityGroupIds = Sets.newHashSet();
        if (request.getSecurityGroups() != null) {
            securityGroupIds.addAll(request.getSecurityGroups().getMember());
        } else if (vpcId != null && !defaultVpc) {
            groups = EucalyptusActivityTasks.getInstance().describeUserSecurityGroupsByName(adminUserId, vpcId, "default");
            if (groups.isEmpty()) {
                throw new InvalidConfigurationRequestException("Default security group not found for VPC " + vpcId);
            }
            securityGroupIds.add(((SecurityGroupItemType)groups.get(0)).getGroupId());
        }
        if (!securityGroupIds.isEmpty() && vpcId == null) {
            throw new InvalidConfigurationRequestException("Security groups should not be specified for EC2-Classic platform");
        }
        List<Object> list = groups = securityGroupIds.isEmpty() ? Collections.emptyList() : EucalyptusActivityTasks.getInstance().describeUserSecurityGroupsById(adminUserId, vpcId, securityGroupIds);
        if (groups.size() != securityGroupIds.size()) {
            throw new LoadBalancingBackendClientException("InvalidSecurityGroup", "Invalid security group(s)");
        }
        final ArrayList zones = Lists.newArrayList();
        if (request.getAvailabilityZones() != null) {
            zones.addAll(request.getAvailabilityZones().getMember());
        }
        if (zones.isEmpty()) {
            zones.addAll(zoneToSubnetIdMap.keySet());
        }
        if (!zoneToSubnetIdMap.isEmpty() && !zoneToSubnetIdMap.keySet().equals(Sets.newHashSet((Iterable)zones))) {
            throw new InvalidConfigurationRequestException("Availability zones and subnets are inconsistent");
        }
        Supplier<LoadBalancer> allocator = new Supplier<LoadBalancer>(){

            public LoadBalancer get() {
                try {
                    Map securityGroupIdsToNames = CollectionUtils.putAll((Iterable)groups, (Map)Maps.newHashMap(), (Function)SecurityGroupItemType.groupId(), (Function)SecurityGroupItemType.groupName());
                    return LoadBalancers.addLoadbalancer(ownerFullName, lbName, vpcId, scheme, securityGroupIdsToNames, tags);
                }
                catch (LoadBalancingException e) {
                    throw Exceptions.toUndeclared((Throwable)((Object)e));
                }
            }
        };
        try {
            lb = (LoadBalancer)LoadBalancingMetadatas.allocateUnitlessResource((Supplier)allocator);
        }
        catch (Exception e) {
            throw LoadBalancingBackendService.handleException(e);
        }
        Function<String, Boolean> rollback = new Function<String, Boolean>(){

            public Boolean apply(String lbName) {
                try {
                    LoadBalancers.unsetForeignKeys(ctx, lbName);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"unable to unset foreign keys", (Throwable)ex);
                }
                try {
                    LoadBalancers.removeZone(lbName, ctx, zones);
                }
                catch (Exception ex) {
                    LOG.error((Object)"unable to delete availability zones during rollback", (Throwable)ex);
                }
                try {
                    LoadBalancers.deleteLoadbalancer(ownerFullName, lbName);
                }
                catch (LoadBalancingException ex) {
                    LOG.error((Object)("failed to rollback the loadbalancer: " + lbName), (Throwable)((Object)ex));
                    return false;
                }
                return true;
            }
        };
        LoadBalancerDnsRecord dns = LoadBalancers.getDnsRecord(lb);
        if (dns == null || dns.getName() == null) {
            rollback.apply((Object)lbName);
            throw new InternalFailure400Exception("Dns name could not be created");
        }
        if (zones != null && zones.size() > 0) {
            try {
                LoadBalancers.addZone(lbName, ctx, zones, zoneToSubnetIdMap);
            }
            catch (LoadBalancingException ex) {
                rollback.apply((Object)lbName);
                throw ex;
            }
            catch (Exception ex) {
                rollback.apply((Object)lbName);
                throw new InternalFailure400Exception("Failed to persist the zone");
            }
        }
        Entities.evictCache(LoadBalancer.class);
        try {
            evt = new NewLoadbalancerEvent();
            evt.setLoadBalancer(lbName);
            evt.setContext(ctx);
            ((NewLoadbalancerEvent)evt).setZones(zones);
            ActivityManager.getInstance().fire(evt);
        }
        catch (EventFailedException e) {
            LOG.error((Object)"failed to handle new loadbalancer event", (Throwable)e);
            rollback.apply((Object)lbName);
            String reason = e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : "internal error";
            throw new InternalFailure400Exception(String.format("Failed to create the loadbalancer: %s", reason), e);
        }
        if (!listeners.isEmpty()) {
            LoadBalancers.createLoadbalancerListener(lbName, ctx, Lists.newArrayList((Iterable)listeners));
            try {
                evt = new CreateListenerEvent();
                evt.setLoadBalancer(lbName);
                ((CreateListenerEvent)evt).setListeners(listeners);
                evt.setContext(ctx);
                ActivityManager.getInstance().fire(evt);
            }
            catch (EventFailedException e) {
                LOG.error((Object)"failed to handle createListener event", (Throwable)e);
                String reason = e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : "internal error";
                throw new InternalFailure400Exception(String.format("Failed to setup the listener: %s", reason), e);
            }
        }
        CreateLoadBalancerResult result = new CreateLoadBalancerResult();
        result.setDnsName(dns.getDnsName());
        reply.setCreateLoadBalancerResult(result);
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public DescribeLoadBalancersResponseType describeLoadBalancers(DescribeLoadBalancersType request) throws EucalyptusCloudException {
        DescribeLoadBalancersResponseType reply = (DescribeLoadBalancersResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final String accountNumber = ctx.getAccount().getAccountNumber();
        HashSet requestedNames = Sets.newHashSet();
        if (request.getLoadBalancerNames() != null) {
            requestedNames.addAll(request.getLoadBalancerNames().getMember());
        }
        final boolean showAll = requestedNames.remove("verbose") && ctx.isAdministrator();
        Function<Set<String>, Set<LoadBalancer>> lookupAccountLBs = new Function<Set<String>, Set<LoadBalancer>>(){

            public Set<LoadBalancer> apply(Set<String> identifiers) {
                try {
                    Predicate requestedAndAccessible = LoadBalancingMetadatas.filteringFor(LoadBalancer.class).byId(identifiers).byPrivileges().buildPredicate();
                    LoadBalancer example = showAll ? LoadBalancer.named(null, null) : LoadBalancer.namedByAccountId(accountNumber, null);
                    List lbs = Entities.query((Object)((Object)example), (boolean)true);
                    return Sets.newHashSet((Iterable)Iterables.filter((Iterable)lbs, (Predicate)requestedAndAccessible));
                }
                catch (EntityNotFoundException e) {
                    Entities.evictCache(LoadBalancer.class);
                    throw new OptimisticLockException("Error loading load balancers", (Throwable)e);
                }
            }
        };
        Set allowedLBs = (Set)Entities.asTransaction(LoadBalancer.class, (Function)lookupAccountLBs).apply((Object)requestedNames);
        Function<Set<LoadBalancer>, Set<LoadBalancerDescription>> lookupLBDescriptions = new Function<Set<LoadBalancer>, Set<LoadBalancerDescription>>(){

            public Set<LoadBalancerDescription> apply(Set<LoadBalancer> input) {
                HashSet descs = Sets.newHashSet();
                for (LoadBalancer lb : input) {
                    LoadBalancerDescription desc = new LoadBalancerDescription();
                    if (lb == null) continue;
                    String lbName = lb.getDisplayName();
                    desc.setLoadBalancerName(lbName);
                    desc.setCreatedTime(lb.getCreationTimestamp());
                    LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView dns = lb.getDns();
                    if (dns != null) {
                        desc.setDnsName(dns.getDnsName());
                    }
                    if (lb.getBackendInstances().size() > 0) {
                        desc.setInstances(new Instances());
                        Iterables.addAll((Collection)desc.getInstances().getMember(), (Iterable)Iterables.transform(lb.getBackendInstances(), (Function)Functions.compose((Function)Instance.instance(), LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView.instanceId())));
                    }
                    ArrayList subnetIds = Lists.newArrayList();
                    if (!lb.getZones().isEmpty()) {
                        desc.setAvailabilityZones(new AvailabilityZones());
                        ArrayList currentZones = Lists.newArrayList((Iterable)Iterables.filter(lb.getZones(), (Predicate)new Predicate<LoadBalancerZone.LoadBalancerZoneCoreView>(){

                            public boolean apply(LoadBalancerZone.LoadBalancerZoneCoreView arg0) {
                                return arg0.getState().equals((Object)LoadBalancerZone.STATE.InService);
                            }
                        }));
                        Iterables.addAll((Collection)desc.getAvailabilityZones().getMember(), (Iterable)Iterables.transform((Iterable)currentZones, LoadBalancerZone.LoadBalancerZoneCoreView.name()));
                        Iterables.addAll((Collection)subnetIds, (Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)currentZones, LoadBalancerZone.LoadBalancerZoneCoreView.subnetId()), (Predicate)Predicates.notNull()));
                    }
                    if (!subnetIds.isEmpty()) {
                        desc.setSubnets(new Subnets((Collection)subnetIds));
                    }
                    desc.setVpcId(lb.getVpcId());
                    if (lb.getListeners().size() > 0) {
                        desc.setListenerDescriptions(new ListenerDescriptions());
                        desc.getListenerDescriptions().setMember(new ArrayList(Collections2.transform(lb.getListeners(), (Function)new Function<LoadBalancerListener.LoadBalancerListenerCoreView, ListenerDescription>(){

                            public ListenerDescription apply(LoadBalancerListener.LoadBalancerListenerCoreView input) {
                                ListenerDescription desc = new ListenerDescription();
                                Listener listener = new Listener();
                                listener.setLoadBalancerPort(Integer.valueOf(input.getLoadbalancerPort()));
                                listener.setInstancePort(Integer.valueOf(input.getInstancePort()));
                                if (input.getInstanceProtocol() != LoadBalancerListener.PROTOCOL.NONE) {
                                    listener.setInstanceProtocol(input.getInstanceProtocol().name());
                                }
                                listener.setProtocol(input.getProtocol().name());
                                if (input.getCertificateId() != null) {
                                    listener.setSSLCertificateId(input.getCertificateId());
                                }
                                desc.setListener(listener);
                                LoadBalancerListener lbListener = LoadBalancerListener.LoadBalancerListenerEntityTransform.INSTANCE.apply(input);
                                PolicyNames pnames = new PolicyNames();
                                pnames.setMember(new ArrayList(Lists.transform(lbListener.getPolicies(), (Function)new Function<LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionCoreView, String>(){

                                    public String apply(LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionCoreView arg0) {
                                        return arg0.getPolicyName();
                                    }
                                })));
                                desc.setPolicyNames(pnames);
                                return desc;
                            }
                        })));
                    }
                    try {
                        int interval = lb.getHealthCheckInterval();
                        String target = lb.getHealthCheckTarget();
                        int timeout = lb.getHealthCheckTimeout();
                        int healthyThresholds = lb.getHealthyThreshold();
                        int unhealthyThresholds = lb.getHealthCheckUnhealthyThreshold();
                        HealthCheck hc = new HealthCheck();
                        hc.setInterval(Integer.valueOf(interval));
                        hc.setHealthyThreshold(Integer.valueOf(healthyThresholds));
                        hc.setTarget(target);
                        hc.setTimeout(Integer.valueOf(timeout));
                        hc.setUnhealthyThreshold(Integer.valueOf(unhealthyThresholds));
                        desc.setHealthCheck(hc);
                    }
                    catch (Exception interval) {
                        // empty catch block
                    }
                    try {
                        LoadBalancerSecurityGroup.LoadBalancerSecurityGroupCoreView group = lb.getGroup();
                        if (group != null) {
                            desc.setSourceSecurityGroup(new SourceSecurityGroup(group.getGroupOwnerAccountId(), group.getName()));
                        }
                    }
                    catch (Exception group) {
                        // empty catch block
                    }
                    if (!lb.getCoreView().getSecurityGroupIdsToNames().isEmpty()) {
                        desc.setSecurityGroups(new SecurityGroups(lb.getCoreView().getSecurityGroupIdsToNames().keySet()));
                        if (desc.getSourceSecurityGroup() == null) {
                            desc.setSourceSecurityGroup(new SourceSecurityGroup(lb.getOwnerAccountNumber(), (String)Iterables.get(lb.getCoreView().getSecurityGroupIdsToNames().values(), (int)0)));
                        }
                    }
                    try {
                        AppCookieStickinessPolicies app;
                        List<LoadBalancerPolicyDescription> lbPolicies = LoadBalancerPolicies.getLoadBalancerPolicyDescription(lb);
                        ArrayList appCookiePolicies = Lists.newArrayList();
                        ArrayList lbCookiePolicies = Lists.newArrayList();
                        ArrayList otherPolicies = Lists.newArrayList();
                        for (LoadBalancerPolicyDescription policy : lbPolicies) {
                            if ("LBCookieStickinessPolicyType".equals(policy.getPolicyTypeName())) {
                                LBCookieStickinessPolicy lbp = new LBCookieStickinessPolicy();
                                lbp.setPolicyName(policy.getPolicyName());
                                lbp.setCookieExpirationPeriod(Long.valueOf(Long.parseLong(policy.findAttributeDescription("CookieExpirationPeriod").getAttributeValue())));
                                lbCookiePolicies.add(lbp);
                                continue;
                            }
                            if ("AppCookieStickinessPolicyType".equals(policy.getPolicyTypeName())) {
                                app = new AppCookieStickinessPolicy();
                                app.setPolicyName(policy.getPolicyName());
                                app.setCookieName(policy.findAttributeDescription("CookieName").getAttributeValue());
                                appCookiePolicies.add(app);
                                continue;
                            }
                            otherPolicies.add(policy.getPolicyName());
                        }
                        Policies p = new Policies();
                        LBCookieStickinessPolicies lbp = new LBCookieStickinessPolicies();
                        lbp.setMember(lbCookiePolicies);
                        app = new AppCookieStickinessPolicies();
                        app.setMember(appCookiePolicies);
                        PolicyNames other = new PolicyNames();
                        other.setMember(otherPolicies);
                        p.setAppCookieStickinessPolicies(app);
                        p.setLbCookieStickinessPolicies(lbp);
                        p.setOtherPolicies(other);
                        desc.setPolicies(p);
                        desc.setScheme(Objects.toString((Object)lb.getScheme(), "internet-facing"));
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Failed to retrieve policies", (Throwable)ex);
                    }
                    descs.add(desc);
                }
                return descs;
            }
        };
        Set descs = (Set)lookupLBDescriptions.apply((Object)allowedLBs);
        DescribeLoadBalancersResult descResult = new DescribeLoadBalancersResult();
        LoadBalancerDescriptions lbDescs = new LoadBalancerDescriptions();
        lbDescs.setMember(new ArrayList(descs));
        descResult.setLoadBalancerDescriptions(lbDescs);
        reply.setDescribeLoadBalancersResult(descResult);
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public DeleteLoadBalancerResponseType deleteLoadBalancer(DeleteLoadBalancerType request) throws EucalyptusCloudException {
        DeleteLoadBalancerResponseType reply;
        block13: {
            reply = (DeleteLoadBalancerResponseType)request.getReply();
            String candidateLB = request.getLoadBalancerName();
            final Context ctx = Contexts.lookup();
            Function<String, LoadBalancer> findLoadBalancer = new Function<String, LoadBalancer>(){

                @Nullable
                public LoadBalancer apply(@Nullable String lbName) {
                    try {
                        LoadBalancer lb = LoadBalancers.getLoadbalancer(ctx, lbName);
                        return lb;
                    }
                    catch (NoSuchElementException ex) {
                        if (ctx.isAdministrator()) {
                            try {
                                LoadBalancer lb = LoadBalancers.getLoadBalancerByDnsName(lbName);
                                User owner = Accounts.lookupUserById((String)lb.getOwnerUserId());
                                ctx.setUser(owner);
                                return lb;
                            }
                            catch (Exception ex2) {
                                if (ex2 instanceof NoSuchElementException) {
                                    throw Exceptions.toUndeclared((Throwable)((Object)new LoadBalancingException("Unable to find the loadbalancer (use DNS name if you are Cloud admin)")));
                                }
                                throw Exceptions.toUndeclared((Throwable)ex2);
                            }
                        }
                        throw ex;
                    }
                }
            };
            try {
                LoadbalancingUserEvent evt;
                if (candidateLB == null) break block13;
                String lbToDelete = null;
                LoadBalancer lb = null;
                try {
                    lb = (LoadBalancer)((Object)findLoadBalancer.apply((Object)candidateLB));
                    lbToDelete = lb.getDisplayName();
                }
                catch (NoSuchElementException noSuchElementException) {
                }
                catch (Exception ex) {
                    if (ex.getCause() != null && ex.getCause() instanceof LoadBalancingException) {
                        throw (LoadBalancingException)((Object)ex.getCause());
                    }
                    throw ex;
                }
                if (lb != null && !LoadBalancingMetadatas.filterPrivileged().apply((Object)lb)) {
                    throw new AccessPointNotFoundException();
                }
                if (lb == null) break block13;
                Collection<LoadBalancerListener.LoadBalancerListenerCoreView> listeners = lb.getListeners();
                ArrayList ports = Lists.newArrayList((Iterable)Collections2.transform(listeners, (Function)new Function<LoadBalancerListener.LoadBalancerListenerCoreView, Integer>(){

                    public Integer apply(@Nullable LoadBalancerListener.LoadBalancerListenerCoreView arg0) {
                        return arg0.getLoadbalancerPort();
                    }
                }));
                try {
                    evt = new DeleteListenerEvent();
                    evt.setLoadBalancer(lbToDelete);
                    evt.setContext(ctx);
                    ((DeleteListenerEvent)evt).setPorts(ports);
                    ActivityManager.getInstance().fire(evt);
                }
                catch (EventFailedException e) {
                    LOG.error((Object)"failed to handle DeleteListener event", (Throwable)e);
                }
                try {
                    evt = new DeleteLoadbalancerEvent();
                    evt.setLoadBalancer(lbToDelete);
                    evt.setContext(ctx);
                    ActivityManager.getInstance().fire(evt);
                }
                catch (EventFailedException e) {
                    LOG.error((Object)"failed to handle DeleteLoadbalancer event", (Throwable)e);
                    throw e;
                }
                LoadBalancers.deleteLoadbalancer(UserFullName.getInstance((String)lb.getOwnerUserId(), (String[])new String[0]), lbToDelete);
            }
            catch (EventFailedException e) {
                LOG.error((Object)("Error deleting the loadbalancer: " + e.getMessage()), (Throwable)e);
                String reason = e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : "internal error";
                throw new InternalFailure400Exception(String.format("Failed to delete the loadbalancer: %s", reason), e);
            }
            catch (LoadBalancingException e) {
                throw new InternalFailure400Exception(e.getMessage());
            }
            catch (Exception e) {
                if (e.getCause() instanceof NoSuchElementException) break block13;
                LOG.error((Object)("Error deleting the loadbalancer: " + e.getMessage()), (Throwable)e);
                String reason = "internal error";
                throw new InternalFailure400Exception(String.format("Failed to delete the loadbalancer: %s", "internal error"), e);
            }
        }
        DeleteLoadBalancerResult result = new DeleteLoadBalancerResult();
        reply.setDeleteLoadBalancerResult(result);
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public CreateLoadBalancerListenersResponseType createLoadBalancerListeners(CreateLoadBalancerListenersType request) throws EucalyptusCloudException {
        String reason;
        LoadBalancer lb;
        CreateLoadBalancerListenersResponseType reply = (CreateLoadBalancerListenersResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String lbName = request.getLoadBalancerName();
        ArrayList listeners = request.getListeners().getMember();
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (Exception ex) {
            throw new AccessPointNotFoundException();
        }
        if (lb != null && !LoadBalancingMetadatas.filterPrivileged().apply((Object)lb)) {
            throw new AccessPointNotFoundException();
        }
        if (listeners != null) {
            LoadBalancers.validateListener(lb, listeners);
        }
        try {
            for (Listener l : listeners) {
                if (!"HTTPS".equals(l.getProtocol().toUpperCase()) && !"SSL".equals(l.getProtocol().toUpperCase())) continue;
                String certArn = l.getSSLCertificateId();
                if (certArn == null || certArn.length() <= 0) {
                    throw new InvalidConfigurationRequestException("SSLCertificateId is required for HTTPS or SSL protocol");
                }
                LoadBalancers.checkSSLCertificate(ctx.getUser().getUserId(), certArn);
            }
        }
        catch (Exception ex2) {
            InternalFailure400Exception ex2;
            if (!(ex2 instanceof LoadBalancingException)) {
                LOG.error((Object)"failed to check SSL certificate Id", (Throwable)ex2);
                ex2 = new InternalFailure400Exception("failed to check SSL certificate Id", ex2);
            }
            throw (LoadBalancingException)ex2;
        }
        try {
            CreateListenerEvent evt = new CreateListenerEvent();
            evt.setLoadBalancer(lbName);
            evt.setContext(ctx);
            evt.setListeners(listeners);
            ActivityManager.getInstance().fire(evt);
        }
        catch (EventFailedException e) {
            LOG.error((Object)"failed to handle CreateListener event", (Throwable)e);
            reason = e.getCause() != null && e.getCause().getMessage() != null ? e.getMessage() : "internal error";
            throw new InternalFailure400Exception(String.format("Failed to create listener: %s", reason), e);
        }
        try {
            LoadBalancers.createLoadbalancerListener(lbName, ctx, listeners);
        }
        catch (LoadBalancingException ex) {
            throw ex;
        }
        catch (Exception e) {
            reason = e.getCause() != null && e.getCause().getMessage() != null ? e.getMessage() : "internal error";
            throw new InternalFailure400Exception(String.format("Failed to create listener: %s", reason), e);
        }
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public DeleteLoadBalancerListenersResponseType deleteLoadBalancerListeners(DeleteLoadBalancerListenersType request) throws EucalyptusCloudException {
        LoadBalancer lb;
        Collection listenerPorts;
        DeleteLoadBalancerListenersResponseType reply = (DeleteLoadBalancerListenersResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String lbName = request.getLoadBalancerName();
        try {
            listenerPorts = Collections2.transform((Collection)request.getLoadBalancerPorts().getMember(), (Function)new Function<String, Integer>(){

                public Integer apply(String input) {
                    return new Integer(input);
                }
            });
        }
        catch (Exception ex) {
            throw new InvalidConfigurationRequestException("Invalid port number");
        }
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (NoSuchElementException ex) {
            throw new AccessPointNotFoundException();
        }
        catch (Exception ex) {
            LOG.error((Object)"failed to query loadbalancer due to unknown reason", (Throwable)ex);
            String reason = ex.getCause() != null && ex.getCause().getMessage() != null ? ex.getMessage() : "internal error";
            throw new InternalFailure400Exception(String.format("Failed to delete the listener: %s", reason), ex);
        }
        if (lb != null && !LoadBalancingMetadatas.filterPrivileged().apply((Object)lb)) {
            throw new AccessPointNotFoundException();
        }
        Function<Void, Collection<Integer>> filter = new Function<Void, Collection<Integer>>(){

            public Collection<Integer> apply(Void v) {
                HashSet filtered = Sets.newHashSet();
                for (Integer port : listenerPorts) {
                    LoadBalancerListener.LoadBalancerListenerCoreView found = lb.findListener(port);
                    if (found == null) continue;
                    filtered.add(port);
                }
                return filtered;
            }
        };
        Collection toDelete = (Collection)Entities.asTransaction(LoadBalancer.class, (Function)filter).apply(null);
        Predicate<Collection<Integer>> remover = new Predicate<Collection<Integer>>(){

            public boolean apply(Collection<Integer> listeners) {
                for (Integer port : listenerPorts) {
                    try {
                        LoadBalancerListener exist = (LoadBalancerListener)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerListener.named(lb, port))));
                        Entities.delete((Object)((Object)exist));
                    }
                    catch (NoSuchElementException exist) {
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Failed to delete the listener", (Throwable)ex);
                        throw Exceptions.toUndeclared((Throwable)ex);
                    }
                }
                return true;
            }
        };
        try {
            DeleteListenerEvent evt = new DeleteListenerEvent();
            evt.setLoadBalancer(lbName);
            evt.setContext(ctx);
            evt.setPorts(listenerPorts);
            ActivityManager.getInstance().fire(evt);
        }
        catch (EventFailedException e) {
            LOG.error((Object)"failed to handle DeleteListener event", (Throwable)e);
            String reason = e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : "internal error";
            throw new InternalFailure400Exception(String.format("Failed to delete listener: %s", reason), e);
        }
        try {
            Entities.asTransaction(LoadBalancerListener.class, (Predicate)remover).apply((Object)toDelete);
        }
        catch (Exception ex) {
            String reason = ex.getCause() != null && ex.getCause().getMessage() != null ? ex.getCause().getMessage() : "internal error";
            throw new InternalFailure400Exception(String.format("Failed to delete listener: %s", reason), ex);
        }
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public RegisterInstancesWithLoadBalancerResponseType registerInstancesWithLoadBalancer(RegisterInstancesWithLoadBalancerType request) throws EucalyptusCloudException {
        LoadBalancer lb;
        RegisterInstancesWithLoadBalancerResponseType reply = (RegisterInstancesWithLoadBalancerResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final UserFullName ownerFullName = ctx.getUserFullName();
        String lbName = request.getLoadBalancerName();
        final ArrayList instances = request.getInstances().getMember();
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (Exception ex) {
            throw new AccessPointNotFoundException();
        }
        if (!LoadBalancingMetadatas.filterPrivileged().apply((Object)lb)) {
            throw new AccessPointNotFoundException();
        }
        HashSet backends = Sets.newHashSet((Iterable)Iterables.transform(lb.getBackendInstances(), LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView.instanceId()));
        if (lb.getVpcId() != null) {
            List<RunningInstancesItemType> instanceItems = EucalyptusActivityTasks.getInstance().describeSystemInstances(Lists.newArrayList((Iterable)Iterables.transform((Iterable)instances, (Function)Instance.instanceId())));
            for (RunningInstancesItemType instanceItem : instanceItems) {
                if (lb.getVpcId().equals(instanceItem.getVpcId())) continue;
                throw new InvalidConfigurationRequestException("Invalid instance(s) for load balancer.");
            }
        }
        Predicate<LoadBalancer> creator = new Predicate<LoadBalancer>(){

            public boolean apply(LoadBalancer lb) {
                for (Instance vm : instances) {
                    if (lb.hasBackendInstance(vm.getInstanceId())) continue;
                    try {
                        LoadBalancerBackendInstance beInstance = LoadBalancerBackendInstance.newInstance((OwnerFullName)ownerFullName, lb, vm.getInstanceId());
                        beInstance.setState(LoadBalancerBackendInstance.STATE.OutOfService);
                        Entities.persist((Object)((Object)beInstance));
                    }
                    catch (LoadBalancingException ex) {
                        throw Exceptions.toUndeclared((Throwable)((Object)ex));
                    }
                }
                return true;
            }
        };
        try {
            RegisterInstancesEvent evt = new RegisterInstancesEvent();
            evt.setLoadBalancer(lbName);
            evt.setContext(ctx);
            evt.setInstances(instances);
            ActivityManager.getInstance().fire(evt);
        }
        catch (EventFailedException e) {
            LOG.error((Object)"failed to handle RegisterInstances event", (Throwable)e);
            String reason = e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : "internal error";
            throw new InternalFailure400Exception(String.format("Failed to register instances: %s", reason), e);
        }
        try {
            Entities.asTransaction(LoadBalancerBackendInstance.class, (Predicate)creator).apply((Object)lb);
            Iterables.addAll((Collection)backends, (Iterable)Iterables.transform((Iterable)instances, (Function)Instance.instanceId()));
        }
        catch (Exception ex) {
            throw LoadBalancingBackendService.handleException(ex);
        }
        Instances returnInstances = new Instances();
        Iterables.addAll((Collection)returnInstances.getMember(), (Iterable)Iterables.transform((Iterable)backends, (Function)Instance.instance()));
        reply.getRegisterInstancesWithLoadBalancerResult().setInstances(returnInstances);
        return reply;
    }

    public DeregisterInstancesFromLoadBalancerResponseType deregisterInstancesFromLoadBalancer(DeregisterInstancesFromLoadBalancerType request) throws EucalyptusCloudException {
        LoadBalancer lb;
        DeregisterInstancesFromLoadBalancerResponseType reply = (DeregisterInstancesFromLoadBalancerResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        final String lbName = request.getLoadBalancerName();
        final ArrayList instances = request.getInstances().getMember();
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (Exception ex) {
            throw new AccessPointNotFoundException();
        }
        if (lb != null && !LoadBalancingMetadatas.filterPrivileged().apply((Object)lb)) {
            throw new AccessPointNotFoundException();
        }
        ArrayList allInstances = Lists.newArrayList(lb.getBackendInstances());
        Function<LoadBalancer, Collection<LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView>> filter = new Function<LoadBalancer, Collection<LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView>>(){

            public Collection<LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView> apply(LoadBalancer lb) {
                HashSet filtered = Sets.newHashSet();
                block0: for (LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView be : lb.getBackendInstances()) {
                    for (Instance inst : instances) {
                        if (be.getInstanceId() == null || !be.getInstanceId().equals(inst.getInstanceId())) continue;
                        filtered.add(be);
                        continue block0;
                    }
                }
                return filtered;
            }
        };
        final Collection instancesToRemove = (Collection)Entities.asTransaction(LoadBalancer.class, (Function)filter).apply((Object)lb);
        if (instancesToRemove == null) {
            reply.set_return(Boolean.valueOf(false));
            return reply;
        }
        Predicate<Void> remover = new Predicate<Void>(){

            public boolean apply(Void v) {
                for (LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView instanceView : instancesToRemove) {
                    LoadBalancerBackendInstance toDelete;
                    LoadBalancerBackendInstance sample = LoadBalancerBackendInstance.LoadBalancerBackendInstanceEntityTransform.INSTANCE.apply(instanceView);
                    try {
                        toDelete = (LoadBalancerBackendInstance)((Object)Entities.uniqueResult((Object)((Object)sample)));
                    }
                    catch (NoSuchElementException ex) {
                        toDelete = null;
                        throw Exceptions.toUndeclared((Throwable)((Object)new InvalidEndPointException()));
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Can't query loadbalancer backend instance for " + instanceView.getInstanceId()), (Throwable)ex);
                        toDelete = null;
                    }
                    if (toDelete == null) continue;
                    Entities.delete((Object)((Object)toDelete));
                }
                return true;
            }
        };
        Function<Void, ArrayList<Instance>> finder = new Function<Void, ArrayList<Instance>>(){

            public ArrayList<Instance> apply(Void v) {
                LoadBalancer lb;
                try {
                    lb = LoadBalancers.getLoadbalancer(ctx, lbName);
                }
                catch (Exception ex) {
                    LOG.warn((Object)("No loadbalancer is found with name=" + lbName));
                    return Lists.newArrayList();
                }
                Entities.refresh((Object)((Object)lb));
                ArrayList<Instance> result = new ArrayList<Instance>(Collections2.transform(lb.getBackendInstances(), (Function)new Function<LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView, Instance>(){

                    public Instance apply(LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView input) {
                        Instance newInst = new Instance();
                        newInst.setInstanceId(input.getInstanceId());
                        return newInst;
                    }
                }));
                return result;
            }
        };
        try {
            DeregisterInstancesEvent evt = new DeregisterInstancesEvent();
            evt.setLoadBalancer(lbName);
            evt.setContext(ctx);
            evt.setInstances(instances);
            ActivityManager.getInstance().fire(evt);
        }
        catch (EventFailedException e) {
            LOG.error((Object)"failed to handle DeregisterInstances event", (Throwable)e);
            String reason = e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : "internal error";
            throw new InternalFailure400Exception(String.format("Failed to deregister instances: %s", reason), e);
        }
        try {
            reply.set_return(Boolean.valueOf(Entities.asTransaction(LoadBalancerBackendInstance.class, (Predicate)remover).apply(null)));
            allInstances.removeAll(instancesToRemove);
        }
        catch (Exception ex) {
            String reason = ex.getCause() != null && ex.getCause().getMessage() != null ? ex.getCause().getMessage() : "internal error";
            throw new InternalFailure400Exception(String.format("Failed to deregister instances: %s", reason), ex);
        }
        DeregisterInstancesFromLoadBalancerResult result = new DeregisterInstancesFromLoadBalancerResult();
        Instances returnInstances = new Instances();
        returnInstances.setMember(new ArrayList(Collections2.transform((Collection)allInstances, (Function)new Function<LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView, Instance>(){

            public Instance apply(LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView input) {
                Instance newInst = new Instance();
                newInst.setInstanceId(input.getInstanceId());
                return newInst;
            }
        })));
        result.setInstances(returnInstances);
        reply.setDeregisterInstancesFromLoadBalancerResult(result);
        return reply;
    }

    public EnableAvailabilityZonesForLoadBalancerResponseType enableAvailabilityZonesForLoadBalancer(EnableAvailabilityZonesForLoadBalancerType request) throws EucalyptusCloudException {
        LoadBalancer lb;
        EnableAvailabilityZonesForLoadBalancerResponseType reply = (EnableAvailabilityZonesForLoadBalancerResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String lbName = request.getLoadBalancerName();
        ArrayList requestedZones = request.getAvailabilityZones().getMember();
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (Exception ex) {
            throw new AccessPointNotFoundException();
        }
        if (!LoadBalancingMetadatas.filterPrivileged().apply((Object)lb)) {
            throw new AccessPointNotFoundException();
        }
        HashSet allZones = Sets.newHashSet((Iterable)Iterables.transform(lb.getZones(), LoadBalancerZone.LoadBalancerZoneCoreView.name()));
        Optional<VpcType> vpcOptional = EucalyptusActivityTasks.getInstance().defaultVpc(LoadBalancingBackendService.lookupAdmin(ctx));
        HashMap zoneToSubnetIdMap = Maps.newHashMap();
        if (vpcOptional.isPresent() && Objects.equals(lb.getVpcId(), vpcOptional.get())) {
            List<SubnetType> subnets = EucalyptusActivityTasks.getInstance().describeSubnetsByZone(lb.getVpcId(), true, requestedZones);
            CollectionUtils.putAll(subnets, (Map)zoneToSubnetIdMap, (Function)SubnetType.zone(), (Function)SubnetType.id());
            if (requestedZones.size() != zoneToSubnetIdMap.size()) {
                throw new InvalidConfigurationRequestException("Cannot enable zone for VPC loadbalancer, default subnet not found.");
            }
        } else if (lb.getVpcId() != null) {
            throw new InvalidConfigurationRequestException("Cannot enable zone for VPC loadbalancer");
        }
        if (!requestedZones.isEmpty()) {
            try {
                EnabledZoneEvent evt = new EnabledZoneEvent();
                evt.setLoadBalancer(lbName);
                evt.setContext(ctx);
                evt.setZones(requestedZones);
                evt.setZoneToSubnetIdMap(zoneToSubnetIdMap);
                ActivityManager.getInstance().fire(evt);
            }
            catch (EventFailedException e) {
                LOG.error((Object)"failed to handle EnabledZone event", (Throwable)e);
                String reason = e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : "internal error";
                throw new InternalFailure400Exception(String.format("Failed to enable zones: %s", reason), e);
            }
        }
        allZones.addAll(requestedZones);
        EnableAvailabilityZonesForLoadBalancerResult result = new EnableAvailabilityZonesForLoadBalancerResult();
        AvailabilityZones availZones = new AvailabilityZones();
        availZones.getMember().addAll(allZones);
        reply.getEnableAvailabilityZonesForLoadBalancerResult().setAvailabilityZones(availZones);
        return reply;
    }

    public DisableAvailabilityZonesForLoadBalancerResponseType disableAvailabilityZonesForLoadBalancer(DisableAvailabilityZonesForLoadBalancerType request) throws EucalyptusCloudException {
        LoadBalancer lb;
        DisableAvailabilityZonesForLoadBalancerResponseType reply = (DisableAvailabilityZonesForLoadBalancerResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String lbName = request.getLoadBalancerName();
        ArrayList zones = request.getAvailabilityZones().getMember();
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (Exception ex) {
            throw new AccessPointNotFoundException();
        }
        if (lb != null && !LoadBalancingMetadatas.filterPrivileged().apply((Object)lb)) {
            throw new AccessPointNotFoundException();
        }
        if (zones != null && zones.size() > 0) {
            try {
                DisabledZoneEvent evt = new DisabledZoneEvent();
                evt.setLoadBalancer(lbName);
                evt.setContext(ctx);
                evt.setZones(zones);
                ActivityManager.getInstance().fire(evt);
            }
            catch (EventFailedException e) {
                LOG.error((Object)"failed to handle DisabledZone event", (Throwable)e);
                String reason = e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : "internal error";
                throw new InternalFailure400Exception(String.format("Failed to disable zones: %s", reason), e);
            }
        }
        List availableZones = Lists.newArrayList();
        try {
            LoadBalancer updatedLb = LoadBalancers.getLoadbalancer(ctx, lbName);
            availableZones = Lists.transform(LoadBalancers.findZonesInService(updatedLb), (Function)new Function<LoadBalancerZone.LoadBalancerZoneCoreView, String>(){

                public String apply(@Nullable LoadBalancerZone.LoadBalancerZoneCoreView arg0) {
                    return arg0.getName();
                }
            });
        }
        catch (Exception updatedLb) {
            // empty catch block
        }
        DisableAvailabilityZonesForLoadBalancerResult result = new DisableAvailabilityZonesForLoadBalancerResult();
        AvailabilityZones availZones = new AvailabilityZones();
        availZones.setMember(Lists.newArrayList((Iterable)availableZones));
        result.setAvailabilityZones(availZones);
        reply.setDisableAvailabilityZonesForLoadBalancerResult(result);
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public ConfigureHealthCheckResponseType configureHealthCheck(ConfigureHealthCheckType request) throws EucalyptusCloudException {
        LoadBalancer lb;
        ConfigureHealthCheckResponseType reply = (ConfigureHealthCheckResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String lbName = request.getLoadBalancerName();
        HealthCheck hc = request.getHealthCheck();
        Integer healthyThreshold = hc.getHealthyThreshold();
        if (healthyThreshold == null) {
            throw new InvalidConfigurationRequestException("Healthy tresholds must be specified");
        }
        Integer interval = hc.getInterval();
        if (interval == null) {
            throw new InvalidConfigurationRequestException("Interval must be specified");
        }
        String target = hc.getTarget();
        if (target == null) {
            throw new InvalidConfigurationRequestException("Target must be specified");
        }
        Integer timeout = hc.getTimeout();
        if (timeout == null) {
            throw new InvalidConfigurationRequestException("Timeout must be specified");
        }
        Integer unhealthyThreshold = hc.getUnhealthyThreshold();
        if (unhealthyThreshold == null) {
            throw new InvalidConfigurationRequestException("Unhealthy tresholds must be specified");
        }
        if (interval < 5) {
            throw new InvalidConfigurationRequestException(String.format("Interval must be longer than %d seconds", 5));
        }
        if (healthyThreshold < 2) {
            throw new InvalidConfigurationRequestException(String.format("Healthy thresholds must be larger than %d", 2));
        }
        if (unhealthyThreshold < 2) {
            throw new InvalidConfigurationRequestException(String.format("Unhealthy thresholds must be larger than %d", 2));
        }
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (NoSuchElementException ex) {
            throw new AccessPointNotFoundException();
        }
        catch (Exception ex) {
            throw new InternalFailure400Exception("Failed to find the loadbalancer");
        }
        if (lb != null && !LoadBalancingMetadatas.filterPrivileged().apply((Object)lb)) {
            throw new AccessPointNotFoundException();
        }
        try (TransactionResource db = Entities.transactionFor(LoadBalancer.class);){
            LoadBalancer update = (LoadBalancer)((Object)Entities.uniqueResult((Object)((Object)lb)));
            update.setHealthCheck(healthyThreshold, interval, target, timeout, unhealthyThreshold);
            Entities.persist((Object)((Object)update));
            db.commit();
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidConfigurationRequestException(ex.getMessage());
        }
        catch (Exception ex) {
            LOG.error((Object)"failed to persist health check config", (Throwable)ex);
            throw new InternalFailure400Exception("Failed to persist the health check config", ex);
        }
        ConfigureHealthCheckResult result = new ConfigureHealthCheckResult();
        result.setHealthCheck(hc);
        reply.setConfigureHealthCheckResult(result);
        return reply;
    }

    public DescribeInstanceHealthResponseType describeInstanceHealth(DescribeInstanceHealthType request) throws EucalyptusCloudException {
        ArrayList instancesFound;
        LoadBalancer lb;
        DescribeInstanceHealthResponseType reply = (DescribeInstanceHealthResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String lbName = request.getLoadBalancerName();
        Instances instances = request.getInstances();
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (NoSuchElementException ex) {
            throw new AccessPointNotFoundException();
        }
        catch (Exception ex) {
            throw new InternalFailure400Exception("Failed to find the loadbalancer");
        }
        if (lb != null && !LoadBalancingMetadatas.filterPrivileged().apply((Object)lb)) {
            throw new AccessPointNotFoundException();
        }
        ArrayList lbInstances = Lists.newArrayList(lb.getBackendInstances());
        ArrayList stateOutdated = Lists.newArrayList();
        int healthyTimeoutSec = 3 * (lb.getHealthCheckInterval() * lb.getHealthyThreshold());
        long currentTime = System.currentTimeMillis();
        if (instances != null && instances.getMember() != null && instances.getMember().size() > 0) {
            instancesFound = Lists.newArrayList();
            block14: for (Instance inst : instances.getMember()) {
                String instId = inst.getInstanceId();
                for (LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView lbInstance : lbInstances) {
                    if (!instId.equals(lbInstance.getInstanceId())) continue;
                    instancesFound.add(lbInstance);
                    continue block14;
                }
            }
        } else {
            instancesFound = Lists.newArrayList(lb.getBackendInstances());
        }
        ArrayList stateList = Lists.newArrayList();
        for (Object instance : instancesFound) {
            boolean outdated = false;
            Date lastUpdated = ((LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView)instance).instanceStateLastUpdated();
            if (lastUpdated != null) {
                int diffSec = (int)((double)(currentTime - lastUpdated.getTime()) / 1000.0);
                if (LoadBalancerBackendInstance.STATE.InService.equals((Object)((LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView)instance).getState()) && diffSec > healthyTimeoutSec) {
                    stateOutdated.add(instance);
                    outdated = true;
                }
            }
            InstanceState state = new InstanceState();
            state.setInstanceId(((LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView)instance).getDisplayName());
            if (outdated) {
                state.setState(LoadBalancerBackendInstance.STATE.OutOfService.toString());
                state.setReasonCode("ELB");
                state.setDescription("Internal error: instance health not updated for extended period of time");
            } else {
                state.setState(((LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView)instance).getState().name());
                if (((LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView)instance).getState().equals((Object)LoadBalancerBackendInstance.STATE.OutOfService) && ((LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView)instance).getReasonCode() != null) {
                    state.setReasonCode(((LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView)instance).getReasonCode());
                }
                if (((LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView)instance).getDescription() != null) {
                    state.setDescription(((LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView)instance).getDescription());
                }
            }
            stateList.add(state);
        }
        if (!stateOutdated.isEmpty()) {
            try {
                Object instance;
                TransactionResource db = Entities.transactionFor(LoadBalancerBackendInstance.class);
                instance = null;
                try {
                    for (LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView instanceView : stateOutdated) {
                        LoadBalancerBackendInstance sample = LoadBalancerBackendInstance.LoadBalancerBackendInstanceEntityTransform.INSTANCE.apply(instanceView);
                        LoadBalancerBackendInstance update = (LoadBalancerBackendInstance)((Object)Entities.uniqueResult((Object)((Object)sample)));
                        update.setState(LoadBalancerBackendInstance.STATE.OutOfService);
                        update.setReasonCode("ELB");
                        update.setDescription("Internal error: instance health not updated for extended period of time");
                        Entities.persist((Object)((Object)update));
                    }
                    db.commit();
                }
                catch (Throwable throwable) {
                    instance = throwable;
                    throw throwable;
                }
                finally {
                    if (db != null) {
                        if (instance != null) {
                            try {
                                db.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)instance).addSuppressed(x2);
                            }
                        } else {
                            db.close();
                        }
                    }
                }
            }
            catch (Exception db) {
                // empty catch block
            }
        }
        InstanceStates states = new InstanceStates();
        states.setMember(stateList);
        DescribeInstanceHealthResult result = new DescribeInstanceHealthResult();
        result.setInstanceStates(states);
        reply.setDescribeInstanceHealthResult(result);
        return reply;
    }

    public SetLoadBalancerListenerSSLCertificateResponseType setLoadBalancerListenerSSLCertificate(SetLoadBalancerListenerSSLCertificateType request) throws EucalyptusCloudException {
        LoadBalancer lb;
        SetLoadBalancerListenerSSLCertificateResponseType reply = (SetLoadBalancerListenerSSLCertificateResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String lbName = request.getLoadBalancerName();
        int lbPort = request.getLoadBalancerPort();
        String certArn = request.getSSLCertificateId();
        if (lbPort <= 0 || lbPort > 65535) {
            throw new InvalidConfigurationRequestException("Invalid port");
        }
        if (certArn == null || certArn.length() <= 0) {
            throw new InvalidConfigurationRequestException("SSLCertificateId is not specified");
        }
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (NoSuchElementException ex) {
            throw new AccessPointNotFoundException();
        }
        catch (Exception ex) {
            throw new InternalFailure400Exception("Failed to find the loadbalancer");
        }
        try {
            LoadBalancers.setLoadBalancerListenerSSLCertificate(lb, lbPort, certArn);
        }
        catch (LoadBalancingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to set loadbalancer listener SSL certificate", (Throwable)ex);
            throw new InternalFailure400Exception("Failed to set loadbalancer listener SSL certificate", ex);
        }
        reply.setSetLoadBalancerListenerSSLCertificateResult(new SetLoadBalancerListenerSSLCertificateResult());
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public DescribeLoadBalancerPolicyTypesResponseType describeLoadBalancerPolicyTypes(DescribeLoadBalancerPolicyTypesType request) throws EucalyptusCloudException {
        ArrayList policyTypes = Lists.newArrayList();
        try {
            List<LoadBalancerPolicyTypeDescription> internalPolicyTypes = LoadBalancerPolicies.getLoadBalancerPolicyTypeDescriptions();
            for (LoadBalancerPolicyTypeDescription from : internalPolicyTypes) {
                policyTypes.add(LoadBalancerPolicies.AsPolicyTypeDescription.INSTANCE.apply(from));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to retrieve policy types", (Throwable)ex);
            throw new InternalFailure400Exception("Failed to retrieve policy types", ex);
        }
        DescribeLoadBalancerPolicyTypesResponseType reply = (DescribeLoadBalancerPolicyTypesResponseType)request.getReply();
        PolicyTypeDescriptions desc = new PolicyTypeDescriptions();
        desc.setMember(policyTypes);
        DescribeLoadBalancerPolicyTypesResult result = new DescribeLoadBalancerPolicyTypesResult();
        result.setPolicyTypeDescriptions(desc);
        reply.setDescribeLoadBalancerPolicyTypesResult(result);
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public DescribeLoadBalancerPoliciesResponseType describeLoadBalancerPolicies(DescribeLoadBalancerPoliciesType request) throws EucalyptusCloudException {
        DescribeLoadBalancerPoliciesResponseType reply = (DescribeLoadBalancerPoliciesResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String lbName = request.getLoadBalancerName();
        PolicyNames policyNames = request.getPolicyNames();
        if (lbName == null || lbName.isEmpty()) {
            DescribeLoadBalancerPoliciesResult result = new DescribeLoadBalancerPoliciesResult();
            PolicyDescriptions descs = new PolicyDescriptions();
            List<PolicyDescription> policies = LoadBalancerPolicies.getSamplePolicyDescription();
            descs.setMember((ArrayList)policies);
            result.setPolicyDescriptions(descs);
            reply.setDescribeLoadBalancerPoliciesResult(result);
        } else {
            List<LoadBalancerPolicyDescription> lbPolicies;
            LoadBalancer lb;
            try {
                lb = LoadBalancers.getLoadbalancer(ctx, lbName);
            }
            catch (NoSuchElementException ex) {
                throw new AccessPointNotFoundException();
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to find the loadbalancer", (Throwable)ex);
                throw new InternalFailure400Exception("Failed to find the loadbalancer");
            }
            if (lb != null && !LoadBalancingMetadatas.filterPrivileged().apply((Object)lb)) {
                throw new AccessPointNotFoundException();
            }
            try {
                lbPolicies = policyNames != null && policyNames.getMember() != null && policyNames.getMember().size() > 0 ? LoadBalancerPolicies.getLoadBalancerPolicyDescription(lb, policyNames.getMember()) : LoadBalancerPolicies.getLoadBalancerPolicyDescription(lb);
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to find policy descriptions", (Throwable)ex);
                throw new InternalFailure400Exception("Failed to retrieve the policy descriptions", ex);
            }
            DescribeLoadBalancerPoliciesResult result = new DescribeLoadBalancerPoliciesResult();
            PolicyDescriptions descs = new PolicyDescriptions();
            ArrayList policies = Lists.newArrayList();
            for (LoadBalancerPolicyDescription lbPolicy : lbPolicies) {
                policies.add(LoadBalancerPolicies.AsPolicyDescription.INSTANCE.apply(lbPolicy));
            }
            descs.setMember(policies);
            result.setPolicyDescriptions(descs);
            reply.setDescribeLoadBalancerPoliciesResult(result);
        }
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public CreateLoadBalancerPolicyResponseType createLoadBalancerPolicy(CreateLoadBalancerPolicyType request) throws EucalyptusCloudException {
        LoadBalancer lb;
        CreateLoadBalancerPolicyResponseType reply = (CreateLoadBalancerPolicyResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String lbName = request.getLoadBalancerName();
        String policyName = request.getPolicyName();
        String policyTypeName = request.getPolicyTypeName();
        if (lbName == null || lbName.isEmpty()) {
            throw new InvalidConfigurationRequestException("Loadbalancer name must be specified");
        }
        if (policyName == null || policyName.isEmpty()) {
            throw new InvalidConfigurationRequestException("policy name must be specified");
        }
        if (policyTypeName == null || policyTypeName.isEmpty()) {
            throw new InvalidConfigurationRequestException("policy type name must be specified");
        }
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (NoSuchElementException ex) {
            throw new AccessPointNotFoundException();
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to find the loadbalancer", (Throwable)ex);
            throw new InternalFailure400Exception("Failed to find the loadbalancer");
        }
        if (lb != null && !LoadBalancingMetadatas.filterPrivileged().apply((Object)lb)) {
            throw new AccessPointNotFoundException();
        }
        ArrayList attrs = request.getPolicyAttributes() != null ? request.getPolicyAttributes().getMember() : Lists.newArrayList();
        try {
            LoadBalancerPolicies.addLoadBalancerPolicy(lb, policyName, policyTypeName, attrs);
        }
        catch (LoadBalancingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to add the policy", (Throwable)ex);
            throw new InternalFailure400Exception("Failed to add the policy", ex);
        }
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public DeleteLoadBalancerPolicyResponseType deleteLoadBalancerPolicy(DeleteLoadBalancerPolicyType request) throws EucalyptusCloudException {
        LoadBalancer lb;
        DeleteLoadBalancerPolicyResponseType reply = (DeleteLoadBalancerPolicyResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String lbName = request.getLoadBalancerName();
        String policyName = request.getPolicyName();
        if (lbName == null || lbName.isEmpty()) {
            throw new InvalidConfigurationRequestException("Loadbalancer name must be specified");
        }
        if (policyName == null || policyName.isEmpty()) {
            throw new InvalidConfigurationRequestException("policy name must be specified");
        }
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (NoSuchElementException ex) {
            throw new AccessPointNotFoundException();
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to find the loadbalancer", (Throwable)ex);
            throw new InternalFailure400Exception("Failed to find the loadbalancer");
        }
        if (lb != null && !LoadBalancingMetadatas.filterPrivileged().apply((Object)lb)) {
            throw new AccessPointNotFoundException();
        }
        try {
            LoadBalancerPolicies.deleteLoadBalancerPolicy(lb, policyName);
        }
        catch (LoadBalancingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to delete policy", (Throwable)ex);
            throw new InternalFailure400Exception("Failed to delete policy", ex);
        }
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public CreateLBCookieStickinessPolicyResponseType createLBCookieStickinessPolicy(CreateLBCookieStickinessPolicyType request) throws EucalyptusCloudException {
        LoadBalancer lb;
        CreateLBCookieStickinessPolicyResponseType reply = (CreateLBCookieStickinessPolicyResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String lbName = request.getLoadBalancerName();
        String policyName = request.getPolicyName();
        Long expiration = request.getCookieExpirationPeriod();
        if (lbName == null || lbName.isEmpty()) {
            throw new InvalidConfigurationRequestException("Loadbalancer name must be specified");
        }
        if (policyName == null || policyName.isEmpty()) {
            throw new InvalidConfigurationRequestException("Policy name must be specified");
        }
        if (expiration == null || expiration <= 0L) {
            throw new InvalidConfigurationRequestException("Expiration period must be bigger than 0");
        }
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (NoSuchElementException ex) {
            throw new AccessPointNotFoundException();
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to find the loadbalancer", (Throwable)ex);
            throw new InternalFailure400Exception("Failed to find the loadbalancer");
        }
        if (lb != null && !LoadBalancingMetadatas.filterPrivileged().apply((Object)lb)) {
            throw new AccessPointNotFoundException();
        }
        try {
            PolicyAttribute attr = new PolicyAttribute();
            attr.setAttributeName("CookieExpirationPeriod");
            attr.setAttributeValue(expiration.toString());
            LoadBalancerPolicies.addLoadBalancerPolicy(lb, policyName, "LBCookieStickinessPolicyType", Lists.newArrayList((Object[])new PolicyAttribute[]{attr}));
        }
        catch (LoadBalancingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to create policy", (Throwable)ex);
            throw new InternalFailure400Exception("Failed to create policy", ex);
        }
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public CreateAppCookieStickinessPolicyResponseType createAppCookieStickinessPolicy(CreateAppCookieStickinessPolicyType request) throws EucalyptusCloudException {
        LoadBalancer lb;
        CreateAppCookieStickinessPolicyResponseType reply = (CreateAppCookieStickinessPolicyResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String lbName = request.getLoadBalancerName();
        String policyName = request.getPolicyName();
        String cookieName = request.getCookieName();
        if (lbName == null || lbName.isEmpty()) {
            throw new InvalidConfigurationRequestException("Loadbalancer name must be specified");
        }
        if (policyName == null || policyName.isEmpty()) {
            throw new InvalidConfigurationRequestException("Policy name must be specified");
        }
        if (cookieName == null) {
            throw new InvalidConfigurationRequestException("Cookie name must be specified");
        }
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (NoSuchElementException ex) {
            throw new AccessPointNotFoundException();
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to find the loadbalancer", (Throwable)ex);
            throw new InternalFailure400Exception("Failed to find the loadbalancer");
        }
        if (lb != null && !LoadBalancingMetadatas.filterPrivileged().apply((Object)lb)) {
            throw new AccessPointNotFoundException();
        }
        try {
            PolicyAttribute attr = new PolicyAttribute();
            attr.setAttributeName("CookieName");
            attr.setAttributeValue(cookieName);
            LoadBalancerPolicies.addLoadBalancerPolicy(lb, policyName, "AppCookieStickinessPolicyType", Lists.newArrayList((Object[])new PolicyAttribute[]{attr}));
        }
        catch (LoadBalancingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to create policy", (Throwable)ex);
            throw new InternalFailure400Exception("Failed to create policy", ex);
        }
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public SetLoadBalancerPoliciesOfListenerResponseType setLoadBalancerPoliciesOfListener(SetLoadBalancerPoliciesOfListenerType request) throws EucalyptusCloudException {
        LoadBalancer lb;
        SetLoadBalancerPoliciesOfListenerResponseType reply = (SetLoadBalancerPoliciesOfListenerResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String lbName = request.getLoadBalancerName();
        int portNum = request.getLoadBalancerPort();
        PolicyNames pNames = request.getPolicyNames();
        if (lbName == null || lbName.isEmpty()) {
            throw new InvalidConfigurationRequestException("Loadbalancer name must be specified");
        }
        if (portNum < 0 || portNum > 65535) {
            throw new InvalidConfigurationRequestException("Invalid port number specified");
        }
        ArrayList policyNames = pNames.getMember();
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (NoSuchElementException ex) {
            throw new AccessPointNotFoundException();
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to find the loadbalancer", (Throwable)ex);
            throw new InternalFailure400Exception("Failed to find the loadbalancer");
        }
        if (lb != null && !LoadBalancingMetadatas.filterPrivileged().apply((Object)lb)) {
            throw new AccessPointNotFoundException();
        }
        try {
            LoadBalancerListener listener = null;
            for (LoadBalancerListener.LoadBalancerListenerCoreView l : lb.getListeners()) {
                if (l.getLoadbalancerPort() != portNum) continue;
                listener = LoadBalancerListener.LoadBalancerListenerEntityTransform.INSTANCE.apply(l);
                break;
            }
            if (listener == null) {
                throw new ListenerNotFoundException();
            }
            ArrayList policies = Lists.newArrayList();
            if (policyNames != null) {
                for (String policyName : policyNames) {
                    try {
                        policies.add(LoadBalancerPolicies.getLoadBalancerPolicyDescription(lb, policyName));
                    }
                    catch (Exception ex) {
                        throw new PolicyNotFoundException();
                    }
                }
            }
            List<LoadBalancerPolicyDescription> oldPolicies = LoadBalancerPolicies.getPoliciesOfListener(listener);
            LoadBalancerPolicies.removePoliciesFromListener(listener);
            try {
                if (policies.size() > 0) {
                    LoadBalancerPolicies.addPoliciesToListener(listener, policies);
                }
            }
            catch (Exception ex) {
                LoadBalancerPolicies.addPoliciesToListener(listener, oldPolicies);
                throw ex;
            }
        }
        catch (LoadBalancingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to set policies to listener", (Throwable)ex);
            throw new InternalFailure400Exception("Failed to set policies to listener", ex);
        }
        return reply;
    }

    public SetLoadBalancerPoliciesForBackendServerResponseType setLoadBalancerPoliciesForBackendServer(SetLoadBalancerPoliciesForBackendServerType request) throws EucalyptusCloudException {
        SetLoadBalancerPoliciesForBackendServerResponseType reply = (SetLoadBalancerPoliciesForBackendServerResponseType)request.getReply();
        return reply;
    }

    public ApplySecurityGroupsToLoadBalancerResponseType applySecurityGroupsToLoadBalancer(ApplySecurityGroupsToLoadBalancerType request) throws EucalyptusCloudException {
        ApplySecurityGroupsEvent event;
        String adminUserId;
        ApplySecurityGroupsToLoadBalancerResponseType reply = (ApplySecurityGroupsToLoadBalancerResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        final String accountNumber = ctx.getAccount().getAccountNumber();
        try {
            adminUserId = ctx.getAccount().lookupAdmin().getUserId();
        }
        catch (AuthException e) {
            throw new LoadBalancingException("Error accessing default security group");
        }
        HashSet securityGroupIds = Sets.newHashSet((Iterable)request.getSecurityGroups().getMember());
        final List<SecurityGroupItemType> groups = EucalyptusActivityTasks.getInstance().describeUserSecurityGroupsById(adminUserId, null, securityGroupIds);
        if (groups.size() != securityGroupIds.size()) {
            throw new LoadBalancingBackendClientException("InvalidSecurityGroup", "Invalid security group(s)");
        }
        Function<String, ApplySecurityGroupsEvent> updateSecurityGroups = new Function<String, ApplySecurityGroupsEvent>(){

            public ApplySecurityGroupsEvent apply(String identifier) {
                try {
                    LoadBalancer example = LoadBalancer.namedByAccountId(accountNumber, identifier);
                    LoadBalancer loadBalancer = (LoadBalancer)((Object)Entities.uniqueResult((Object)((Object)example)));
                    if (RestrictedTypes.filterPrivileged().apply((Object)loadBalancer)) {
                        List sortedGroups = Ordering.natural().onResultOf(SecurityGroupItemType.groupId()).sortedCopy((Iterable)groups);
                        loadBalancer.setSecurityGroupRefs(Lists.newArrayList((Iterable)Iterables.transform((Iterable)sortedGroups, (Function)TypeMappers.lookup(SecurityGroupItemType.class, LoadBalancerSecurityGroupRef.class))));
                        ApplySecurityGroupsEvent evt = new ApplySecurityGroupsEvent();
                        evt.setContext(ctx);
                        evt.setLoadBalancer(loadBalancer.getDisplayName());
                        evt.setSecurityGroupIdsToNames(CollectionUtils.putAll((Iterable)sortedGroups, (Map)Maps.newLinkedHashMap(), (Function)SecurityGroupItemType.groupId(), (Function)SecurityGroupItemType.groupName()));
                        return evt;
                    }
                    throw new NoSuchElementException();
                }
                catch (NoSuchElementException e) {
                    throw Exceptions.toUndeclared((Throwable)((Object)new AccessPointNotFoundException()));
                }
                catch (TransactionException e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
            }
        };
        try {
            event = (ApplySecurityGroupsEvent)((Object)Entities.asTransaction(LoadBalancer.class, (Function)updateSecurityGroups).apply((Object)request.getLoadBalancerName()));
        }
        catch (Exception e) {
            throw LoadBalancingBackendService.handleException(e);
        }
        try {
            ActivityManager.getInstance().fire(event);
        }
        catch (EventFailedException e) {
            LOG.error((Object)"Failed to handle new apply security groups event", (Throwable)e);
            String reason = (String)Optional.fromNullable((Object)e.getCause()).transform(Exceptions.message()).or((Object)"internal error");
            throw new InternalFailure400Exception(String.format("Failed to apply security groups to loadbalancer: %s", reason), e);
        }
        return reply;
    }

    public AttachLoadBalancerToSubnetsResponseType attachLoadBalancerToSubnets(AttachLoadBalancerToSubnetsType request) throws EucalyptusCloudException {
        String vpcId;
        AttachLoadBalancerToSubnetsResponseType reply = (AttachLoadBalancerToSubnetsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String lbName = request.getLoadBalancerName();
        ArrayList requestedSubnetIds = request.getSubnets().getMember();
        HashBiMap zoneToSubnetIdMap = HashBiMap.create();
        try {
            LoadBalancer lbEntity = LoadBalancers.getLoadbalancer(ctx, lbName);
            if (!LoadBalancingMetadatas.filterPrivileged().apply((Object)lbEntity)) {
                throw new AccessPointNotFoundException();
            }
            LoadBalancer.LoadBalancerCoreView lb = lbEntity.getCoreView();
            vpcId = lb.getVpcId();
            CollectionUtils.putAll(lbEntity.getZones(), (Map)zoneToSubnetIdMap, LoadBalancerZone.LoadBalancerZoneCoreView.name(), LoadBalancerZone.LoadBalancerZoneCoreView.subnetId());
        }
        catch (LoadBalancingException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new AccessPointNotFoundException();
        }
        if (vpcId == null) {
            throw new InvalidConfigurationRequestException("Invalid subnet for load balancer");
        }
        List<SubnetType> subnets = EucalyptusActivityTasks.getInstance().describeSubnets(requestedSubnetIds);
        if (subnets.size() != requestedSubnetIds.size()) {
            throw new LoadBalancingBackendClientException("SubnetNotFound", "Invalid subnet(s)");
        }
        for (SubnetType subnetType : subnets) {
            if (!vpcId.equals(subnetType.getVpcId())) {
                throw new InvalidConfigurationRequestException("Invalid subnet for load balancer");
            }
            String previousSubnetId = (String)zoneToSubnetIdMap.put((Object)subnetType.getAvailabilityZone(), (Object)subnetType.getSubnetId());
            if (previousSubnetId == null || previousSubnetId.equals(subnetType.getSubnetId())) continue;
            throw new InvalidConfigurationRequestException("Multiple subnets for zone (" + subnetType.getAvailabilityZone() + ")");
        }
        ArrayList requestedZones = Lists.newArrayList();
        Iterables.addAll((Collection)requestedZones, (Iterable)Iterables.transform((Iterable)requestedSubnetIds, (Function)Functions.forMap((Map)zoneToSubnetIdMap.inverse())));
        try {
            EnabledZoneEvent evt = new EnabledZoneEvent();
            evt.setLoadBalancer(lbName);
            evt.setContext(ctx);
            evt.setZones(requestedZones);
            evt.setZoneToSubnetIdMap((Map<String, String>)zoneToSubnetIdMap);
            ActivityManager.getInstance().fire(evt);
        }
        catch (EventFailedException e) {
            LOG.error((Object)"failed to handle EnabledZone event", (Throwable)e);
            String reason = e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : "internal error";
            throw new InternalFailure400Exception(String.format("Failed to enable zones: %s", reason), e);
        }
        Subnets replySubnets = new Subnets();
        replySubnets.getMember().addAll(zoneToSubnetIdMap.values());
        reply.getAttachLoadBalancerToSubnetsResult().setSubnets(replySubnets);
        return reply;
    }

    public DetachLoadBalancerFromSubnetsResponseType detachLoadBalancerFromSubnets(DetachLoadBalancerFromSubnetsType request) throws EucalyptusCloudException {
        String vpcId;
        DetachLoadBalancerFromSubnetsResponseType reply = (DetachLoadBalancerFromSubnetsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String lbName = request.getLoadBalancerName();
        ArrayList requestedSubnetIds = request.getSubnets().getMember();
        HashBiMap zoneToSubnetIdMap = HashBiMap.create();
        try {
            LoadBalancer lbEntity = LoadBalancers.getLoadbalancer(ctx, lbName);
            if (!LoadBalancingMetadatas.filterPrivileged().apply((Object)lbEntity)) {
                throw new AccessPointNotFoundException();
            }
            LoadBalancer.LoadBalancerCoreView lb = lbEntity.getCoreView();
            vpcId = lb.getVpcId();
            CollectionUtils.putAll(lbEntity.getZones(), (Map)zoneToSubnetIdMap, LoadBalancerZone.LoadBalancerZoneCoreView.name(), LoadBalancerZone.LoadBalancerZoneCoreView.subnetId());
        }
        catch (LoadBalancingException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new AccessPointNotFoundException();
        }
        if (vpcId == null) {
            throw new InvalidConfigurationRequestException("Invalid subnet for load balancer");
        }
        ArrayList zones = Lists.newArrayList();
        Iterables.addAll((Collection)zones, (Iterable)Iterables.transform((Iterable)requestedSubnetIds, (Function)Functions.forMap((Map)zoneToSubnetIdMap.inverse())));
        if (!zones.isEmpty()) {
            try {
                DisabledZoneEvent evt = new DisabledZoneEvent();
                evt.setLoadBalancer(lbName);
                evt.setContext(ctx);
                evt.setZones(zones);
                ActivityManager.getInstance().fire(evt);
            }
            catch (EventFailedException e) {
                LOG.error((Object)"failed to handle DisabledZone event", (Throwable)e);
                String reason = e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : "internal error";
                throw new InternalFailure400Exception(String.format("Failed to disable zones: %s", reason), e);
            }
        }
        List availableZones = Lists.newArrayList();
        try {
            LoadBalancer updatedLb = LoadBalancers.getLoadbalancer(ctx, lbName);
            availableZones = Lists.transform(LoadBalancers.findZonesInService(updatedLb), (Function)new Function<LoadBalancerZone.LoadBalancerZoneCoreView, String>(){

                public String apply(@Nullable LoadBalancerZone.LoadBalancerZoneCoreView arg0) {
                    return arg0.getName();
                }
            });
        }
        catch (Exception updatedLb) {
            // empty catch block
        }
        Subnets replySubnets = new Subnets();
        replySubnets.getMember().addAll(zoneToSubnetIdMap.values());
        reply.getDetachLoadBalancerFromSubnetsResult().setSubnets(replySubnets);
        return reply;
    }

    public AddTagsResponseType addTags(AddTagsType request) throws EucalyptusCloudException {
        AddTagsResponseType reply = (AddTagsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final String accountNumber = ctx.getAccount().getAccountNumber();
        HashSet requestedNames = Sets.newHashSet();
        if (request.getLoadBalancerNames() != null) {
            requestedNames.addAll(request.getLoadBalancerNames().getMember());
        }
        if (requestedNames.size() > 1) {
            throw new LoadBalancingBackendClientException("InvalidParameterValue", "Too many load balancers");
        }
        final HashMap tags = Maps.newHashMap();
        if (request.getTags() != null) {
            for (Tag tag : request.getTags().getMember()) {
                if (tags.put(tag.getKey(), Strings.nullToEmpty((String)tag.getValue())) == null) continue;
                throw new LoadBalancingBackendClientException("DuplicateTagKeys", "Duplicate tag key (" + tag.getKey() + ")");
            }
            int reservedTags = Iterables.size((Iterable)Iterables.filter(tags.keySet(), LoadBalancingBackendService.isReservedTagPrefix()));
            if (reservedTags > 0 && !Contexts.lookup().isPrivileged()) {
                throw new InvalidConfigurationRequestException("Invalid tag key (reserved prefix)");
            }
        }
        Function<String, Void> updateTags = new Function<String, Void>(){

            public Void apply(String identifier) {
                try {
                    LoadBalancer example = LoadBalancer.namedByAccountId(accountNumber, identifier);
                    LoadBalancer loadBalancer = (LoadBalancer)((Object)Entities.uniqueResult((Object)((Object)example)));
                    if (RestrictedTypes.filterPrivileged().apply((Object)loadBalancer)) {
                        Map<String, String> lbTags = loadBalancer.getTags();
                        lbTags.putAll(tags);
                        if (Iterables.size((Iterable)Iterables.filter(lbTags.keySet(), (Predicate)Predicates.not((Predicate)LoadBalancingBackendService.isReservedTagPrefix()))) > 10) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new LoadBalancingBackendClientException("TooManyTags", "Tag limit exceeded")));
                        }
                        return null;
                    }
                    throw new NoSuchElementException();
                }
                catch (NoSuchElementException e) {
                    throw Exceptions.toUndeclared((Throwable)((Object)new AccessPointNotFoundException()));
                }
                catch (TransactionException e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
            }
        };
        try {
            Entities.asTransaction(LoadBalancer.class, (Function)updateTags).apply(Iterables.getOnlyElement((Iterable)requestedNames));
        }
        catch (Exception e) {
            throw LoadBalancingBackendService.handleException(e);
        }
        return reply;
    }

    public DescribeTagsResponseType describeTags(DescribeTagsType request) throws EucalyptusCloudException {
        DescribeTagsResponseType reply = (DescribeTagsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final String accountNumber = ctx.getAccount().getAccountNumber();
        HashSet requestedNames = Sets.newHashSet();
        if (request.getLoadBalancerNames() != null) {
            requestedNames.addAll(request.getLoadBalancerNames().getMember());
        }
        final boolean showAll = requestedNames.remove("verbose") && ctx.isAdministrator();
        Function<Set<String>, TagDescriptions> lookupAccountLBs = new Function<Set<String>, TagDescriptions>(){

            public TagDescriptions apply(Set<String> identifiers) {
                try {
                    Predicate requestedAndAccessible = LoadBalancingMetadatas.filteringFor(LoadBalancer.class).byId(identifiers).byPrivileges().buildPredicate();
                    LoadBalancer example = showAll ? LoadBalancer.named(null, null) : LoadBalancer.namedByAccountId(accountNumber, null);
                    List lbs = Entities.query((Object)((Object)example), (boolean)true);
                    TagDescriptions tagDescriptions = new TagDescriptions();
                    for (LoadBalancer loadBalancer : Iterables.filter((Iterable)lbs, (Predicate)requestedAndAccessible)) {
                        TagDescription tagDescription = new TagDescription();
                        tagDescription.setLoadBalancerName(loadBalancer.getName());
                        TagList tagList = new TagList();
                        tagDescription.setTags(tagList);
                        for (Map.Entry<String, String> tagKeyAndValue : loadBalancer.getTags().entrySet()) {
                            Tag tag = new Tag();
                            tag.setKey(tagKeyAndValue.getKey());
                            tag.setValue(Strings.emptyToNull((String)tagKeyAndValue.getValue()));
                            tagList.getMember().add(tag);
                        }
                        tagDescriptions.getMember().add(tagDescription);
                    }
                    return tagDescriptions;
                }
                catch (EntityNotFoundException e) {
                    Entities.evictCache(LoadBalancer.class);
                    throw new OptimisticLockException("Error loading load balancers", (Throwable)e);
                }
            }
        };
        TagDescriptions tagDescriptions = (TagDescriptions)Entities.asTransaction(LoadBalancer.class, (Function)lookupAccountLBs).apply((Object)requestedNames);
        reply.getDescribeTagsResult().setTagDescriptions(tagDescriptions);
        return reply;
    }

    public RemoveTagsResponseType removeTags(RemoveTagsType request) throws EucalyptusCloudException {
        RemoveTagsResponseType reply = (RemoveTagsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final String accountNumber = ctx.getAccount().getAccountNumber();
        HashSet requestedNames = Sets.newHashSet();
        if (request.getLoadBalancerNames() != null) {
            requestedNames.addAll(request.getLoadBalancerNames().getMember());
        }
        if (requestedNames.size() > 1) {
            throw new LoadBalancingBackendClientException("InvalidParameterValue", "Too many load balancers");
        }
        final HashSet tags = Sets.newHashSet();
        if (request.getTags() != null) {
            for (TagKeyOnly tag : request.getTags().getMember()) {
                tags.add(tag.getKey());
            }
            int reservedTags = Iterables.size((Iterable)Iterables.filter((Iterable)tags, LoadBalancingBackendService.isReservedTagPrefix()));
            if (reservedTags > 0 && !Contexts.lookup().isPrivileged()) {
                throw new InvalidConfigurationRequestException("Invalid tag key (reserved prefix)");
            }
        }
        Function<String, Void> removeTags = new Function<String, Void>(){

            public Void apply(String identifier) {
                try {
                    LoadBalancer example = LoadBalancer.namedByAccountId(accountNumber, identifier);
                    LoadBalancer loadBalancer = (LoadBalancer)((Object)Entities.uniqueResult((Object)((Object)example)));
                    if (RestrictedTypes.filterPrivileged().apply((Object)loadBalancer)) {
                        Map<String, String> lbTags = loadBalancer.getTags();
                        lbTags.keySet().removeAll(tags);
                        return null;
                    }
                    throw new NoSuchElementException();
                }
                catch (NoSuchElementException e) {
                    throw Exceptions.toUndeclared((Throwable)((Object)new AccessPointNotFoundException()));
                }
                catch (TransactionException e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
            }
        };
        try {
            Entities.asTransaction(LoadBalancer.class, (Function)removeTags).apply(Iterables.getOnlyElement((Iterable)requestedNames));
        }
        catch (Exception e) {
            throw LoadBalancingBackendService.handleException(e);
        }
        return reply;
    }

    public ModifyLoadBalancerAttributesResponseType modifyLoadBalancerAttributes(final ModifyLoadBalancerAttributesType request) throws EucalyptusCloudException {
        ModifyLoadBalancerAttributesResponseType reply = (ModifyLoadBalancerAttributesResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final String accountNumber = ctx.getAccount().getAccountNumber();
        Function<String, LoadBalancerAttributes> modifyAttributes = new Function<String, LoadBalancerAttributes>(){

            public LoadBalancerAttributes apply(String identifier) {
                try {
                    LoadBalancer example = LoadBalancer.namedByAccountId(accountNumber, identifier);
                    LoadBalancer loadBalancer = (LoadBalancer)((Object)Entities.uniqueResult((Object)((Object)example)));
                    if (RestrictedTypes.filterPrivileged().apply((Object)loadBalancer)) {
                        ConnectionSettings connectionSettings = request.getLoadBalancerAttributes().getConnectionSettings();
                        if (connectionSettings != null) {
                            loadBalancer.setConnectionIdleTimeout(connectionSettings.getIdleTimeout());
                        }
                        return (LoadBalancerAttributes)TypeMappers.transform((Object)((Object)loadBalancer), LoadBalancerAttributes.class);
                    }
                    throw new NoSuchElementException();
                }
                catch (NoSuchElementException e) {
                    throw Exceptions.toUndeclared((Throwable)((Object)new AccessPointNotFoundException()));
                }
                catch (TransactionException e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
            }
        };
        LoadBalancerAttributes attributes = (LoadBalancerAttributes)Entities.asTransaction(LoadBalancer.class, (Function)modifyAttributes).apply((Object)request.getLoadBalancerName());
        reply.getModifyLoadBalancerAttributesResult().setLoadBalancerAttributes(attributes);
        return reply;
    }

    public DescribeLoadBalancerAttributesResponseType describeLoadBalancerAttributes(DescribeLoadBalancerAttributesType request) throws EucalyptusCloudException {
        DescribeLoadBalancerAttributesResponseType reply = (DescribeLoadBalancerAttributesResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final String accountNumber = ctx.getAccount().getAccountNumber();
        Function<String, LoadBalancerAttributes> lookupAttributes = new Function<String, LoadBalancerAttributes>(){

            public LoadBalancerAttributes apply(String identifier) {
                try {
                    LoadBalancer example = LoadBalancer.namedByAccountId(accountNumber, identifier);
                    LoadBalancer loadBalancer = (LoadBalancer)((Object)Entities.uniqueResult((Object)((Object)example)));
                    if (RestrictedTypes.filterPrivileged().apply((Object)loadBalancer)) {
                        return (LoadBalancerAttributes)TypeMappers.transform((Object)((Object)loadBalancer), LoadBalancerAttributes.class);
                    }
                    throw new NoSuchElementException();
                }
                catch (NoSuchElementException e) {
                    throw Exceptions.toUndeclared((Throwable)((Object)new AccessPointNotFoundException()));
                }
                catch (TransactionException e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
            }
        };
        LoadBalancerAttributes attributes = (LoadBalancerAttributes)Entities.asTransaction(LoadBalancer.class, (Function)lookupAttributes).apply((Object)request.getLoadBalancerName());
        reply.getDescribeLoadBalancerAttributesResult().setLoadBalancerAttributes(attributes);
        return reply;
    }

    private static Predicate<String> isReservedTagPrefix() {
        ArrayList predicates = Lists.newArrayList();
        for (String prefix : reservedPrefixes) {
            predicates.add(com.eucalyptus.util.Strings.startsWith((String)prefix));
        }
        return Predicates.or((Iterable)predicates);
    }

    private static String lookupAdmin(Context ctx) throws LoadBalancingException {
        try {
            return ctx.getAccount().lookupAdmin().getUserId();
        }
        catch (AuthException e) {
            throw new LoadBalancingException("Error accessing account information");
        }
    }

    private static LoadBalancingException handleException(Exception e) throws LoadBalancingException {
        LoadBalancingException cause = (LoadBalancingException)((Object)Exceptions.findCause((Throwable)e, LoadBalancingException.class));
        if (cause != null) {
            throw cause;
        }
        AuthQuotaException quotaCause = (AuthQuotaException)Exceptions.findCause((Throwable)e, AuthQuotaException.class);
        if (quotaCause != null) {
            throw new TooManyAccessPointsException();
        }
        AuthException authCause = (AuthException)Exceptions.findCause((Throwable)e, AuthException.class);
        if (authCause != null) {
            throw new InternalFailure400Exception(authCause.getMessage());
        }
        LOG.error((Object)e, (Throwable)e);
        InternalFailureException exception = new InternalFailureException(String.valueOf(e.getMessage()));
        if (Contexts.lookup().hasAdministrativePrivileges()) {
            exception.initCause(e);
        }
        throw exception;
    }
}

