/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.activities;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancerDnsRecord;
import com.eucalyptus.loadbalancing.LoadBalancerSecurityGroup;
import com.eucalyptus.loadbalancing.LoadBalancerZone;
import com.eucalyptus.loadbalancing.activities.EucalyptusActivityTasks;
import com.eucalyptus.loadbalancing.activities.LoadBalancerAutoScalingGroup;
import com.eucalyptus.loadbalancing.common.LoadBalancingBackend;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_loadbalancing")
@Table(name="metadata_servo_instance")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class LoadBalancerServoInstance
extends AbstractPersistent {
    private static Logger LOG = Logger.getLogger(LoadBalancerServoInstance.class);
    @Transient
    private static final long serialVersionUID = 1L;
    @Transient
    private LoadBalancerServoInstanceRelationView view = null;
    @ManyToOne
    @JoinColumn(name="metadata_zone_fk", nullable=true)
    private LoadBalancerZone zone = null;
    @ManyToOne
    @JoinColumn(name="metadata_group_fk", nullable=true)
    private LoadBalancerSecurityGroup security_group = null;
    @ManyToOne
    @JoinColumn(name="metadata_dns_fk", nullable=true)
    private LoadBalancerDnsRecord dns = null;
    @ManyToOne
    @JoinColumn(name="metadata_asg_fk", nullable=true)
    private LoadBalancerAutoScalingGroup autoscaling_group = null;
    @Transient
    private LoadBalancer loadbalancer = null;
    @Column(name="metadata_instance_id", nullable=false, unique=true)
    private String instanceId = null;
    @Column(name="metadata_state", nullable=false)
    private String state = null;
    @Column(name="metadata_address", nullable=true)
    private String address = null;
    @Column(name="metadata_private_ip", nullable=true)
    private String privateIp = null;
    @Column(name="metadata_dns_state", nullable=true)
    private String dnsState = null;

    @PostLoad
    private void onLoad() {
        if (this.view == null) {
            this.view = new LoadBalancerServoInstanceRelationView(this);
        }
    }

    private LoadBalancerServoInstance() {
    }

    private LoadBalancerServoInstance(LoadBalancerZone lbzone) {
        this.state = STATE.Pending.name();
        this.zone = lbzone;
        try {
            this.loadbalancer = LoadBalancer.LoadBalancerEntityTransform.INSTANCE.apply(this.zone.getLoadbalancer());
            this.dns = LoadBalancerDnsRecord.LoadBalancerDnsRecordEntityTransform.INSTANCE.apply(this.loadbalancer.getDns());
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private LoadBalancerServoInstance(LoadBalancerZone lbzone, LoadBalancerSecurityGroup group) {
        this.state = STATE.Pending.name();
        this.zone = lbzone;
        try {
            this.loadbalancer = LoadBalancer.LoadBalancerEntityTransform.INSTANCE.apply(this.zone.getLoadbalancer());
            this.dns = LoadBalancerDnsRecord.LoadBalancerDnsRecordEntityTransform.INSTANCE.apply(this.loadbalancer.getDns());
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
        this.security_group = group;
    }

    private LoadBalancerServoInstance(LoadBalancerZone lbzone, LoadBalancerSecurityGroup group, LoadBalancerDnsRecord dns) {
        this.state = STATE.Pending.name();
        this.zone = lbzone;
        try {
            this.loadbalancer = LoadBalancer.LoadBalancerEntityTransform.INSTANCE.apply(this.zone.getLoadbalancer());
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
        this.security_group = group;
        this.dns = dns;
    }

    public static LoadBalancerServoInstance newInstance(LoadBalancerZone lbzone, LoadBalancerSecurityGroup group, LoadBalancerDnsRecord dns, LoadBalancerAutoScalingGroup as_group, String instanceId) {
        LoadBalancerServoInstance instance = new LoadBalancerServoInstance(lbzone, group, dns);
        instance.setInstanceId(instanceId);
        instance.setAutoScalingGroup(as_group);
        instance.dnsState = DNS_STATE.None.name();
        return instance;
    }

    public static LoadBalancerServoInstance named(LoadBalancerZone lbzone) {
        LoadBalancerServoInstance sample = new LoadBalancerServoInstance(lbzone);
        return sample;
    }

    public static LoadBalancerServoInstance named(String instanceId) {
        LoadBalancerServoInstance sample = new LoadBalancerServoInstance();
        sample.instanceId = instanceId;
        return sample;
    }

    public static LoadBalancerServoInstance named() {
        return new LoadBalancerServoInstance();
    }

    public static LoadBalancerServoInstance withState(String state) {
        LoadBalancerServoInstance sample = new LoadBalancerServoInstance();
        sample.state = state;
        return sample;
    }

    public void leaveZone() {
        this.zone = null;
    }

    public void unmapDns() {
        this.dns = null;
    }

    public void setInstanceId(String id) {
        this.instanceId = id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setState(STATE update) {
        this.state = update.name();
    }

    public STATE getState() {
        return Enum.valueOf(STATE.class, this.state);
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setSecurityGroup(LoadBalancerSecurityGroup group) {
        this.security_group = group;
    }

    public void setDns(LoadBalancerDnsRecord dns) {
        this.dns = dns;
    }

    public LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView getDns() {
        return this.view.getDns();
    }

    public void setAutoScalingGroup(LoadBalancerAutoScalingGroup group) {
        this.autoscaling_group = group;
    }

    public void setAvailabilityZone(LoadBalancerZone zone) {
        this.zone = zone;
    }

    public LoadBalancerZone.LoadBalancerZoneCoreView getAvailabilityZone() {
        return this.view.getZone();
    }

    public String getPrivateIp() {
        return this.privateIp;
    }

    public void setPrivateIp(String ipAddr) {
        this.privateIp = ipAddr;
    }

    public void setDnsState(DNS_STATE dnsState) {
        this.dnsState = dnsState.toString();
    }

    public DNS_STATE getDnsState() {
        return Enum.valueOf(DNS_STATE.class, this.dnsState);
    }

    public String toString() {
        String id = this.instanceId == null ? "unassigned" : this.instanceId;
        return String.format("Servo-instance (%s) for loadbalancer %s in %s", id, this.loadbalancer.getDisplayName(), this.zone.getName());
    }

    public static class ServoInstanceDnsCheck
    implements EventListener<ClockTick> {
        static final int CHECK_EVERY_SECONDS = 10;

        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new ServoInstanceDnsCheck());
        }

        public void fireEvent(ClockTick event) {
            LoadBalancerServoInstance update;
            if (!(Bootstrap.isFinished().booleanValue() && Topology.isEnabledLocally(LoadBalancingBackend.class) && Topology.isEnabled(Eucalyptus.class))) {
                return;
            }
            ArrayList allInstances = Lists.newArrayList();
            ArrayList stateOutdated = Lists.newArrayList();
            try (TransactionResource db2 = Entities.transactionFor(LoadBalancerServoInstance.class);){
                allInstances.addAll(Entities.query((Object)((Object)LoadBalancerServoInstance.named())));
            }
            catch (Exception db2) {
                // empty catch block
            }
            Date current = new Date(System.currentTimeMillis());
            for (Object se : allInstances) {
                Date lastUpdate = se.getLastUpdateTimestamp();
                int elapsedSec = (int)((double)(current.getTime() - lastUpdate.getTime()) / 1000.0);
                if (elapsedSec <= 10) continue;
                stateOutdated.add(se);
            }
            try {
                Object se;
                TransactionResource db = Entities.transactionFor(LoadBalancerServoInstance.class);
                se = null;
                try {
                    for (LoadBalancerServoInstance se2 : stateOutdated) {
                        update = (LoadBalancerServoInstance)((Object)Entities.uniqueResult((Object)((Object)se2)));
                        update.setLastUpdateTimestamp(current);
                    }
                    db.commit();
                }
                catch (Throwable x2) {
                    se = x2;
                    throw x2;
                }
                finally {
                    if (db != null) {
                        if (se != null) {
                            try {
                                db.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)se).addSuppressed(x2);
                            }
                        } else {
                            db.close();
                        }
                    }
                }
            }
            catch (Exception db) {
                // empty catch block
            }
            for (LoadBalancerServoInstance instance : stateOutdated) {
                String ipAddr;
                if (STATE.InService.equals((Object)instance.getState())) {
                    if (DNS_STATE.Registered.equals((Object)instance.getDnsState())) continue;
                    ipAddr = null;
                    String privateIpAddr = null;
                    if (instance.getAddress() == null) {
                        block71: {
                            try {
                                List<RunningInstancesItemType> result = EucalyptusActivityTasks.getInstance().describeSystemInstances(Lists.newArrayList((Object[])new String[]{instance.getInstanceId()}));
                                if (result == null || result.size() <= 0) break block71;
                                ipAddr = result.get(0).getIpAddress();
                                privateIpAddr = result.get(0).getPrivateIpAddress();
                            }
                            catch (Exception ex) {
                                LOG.warn((Object)"failed to run describe-instances", (Throwable)ex);
                                continue;
                            }
                        }
                        if (ipAddr == null || ipAddr.length() <= 0) {
                            LOG.warn((Object)("no ipaddress found for instance " + instance.getInstanceId()));
                            continue;
                        }
                    } else {
                        ipAddr = instance.getAddress();
                        privateIpAddr = instance.getPrivateIp();
                    }
                    try {
                        String zone = instance.getDns().getZone();
                        String name = instance.getDns().getName();
                        EucalyptusActivityTasks.getInstance().addARecord(zone, name, ipAddr);
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"failed to register new ipaddress with dns A record", (Throwable)ex);
                        continue;
                    }
                    try {
                        TransactionResource db = Entities.transactionFor(LoadBalancerServoInstance.class);
                        Throwable throwable = null;
                        try {
                            LoadBalancerServoInstance update2 = (LoadBalancerServoInstance)((Object)Entities.uniqueResult((Object)((Object)instance)));
                            update2.setAddress(ipAddr);
                            if (privateIpAddr != null) {
                                update2.setPrivateIp(privateIpAddr);
                            }
                            update2.setDnsState(DNS_STATE.Registered);
                            db.commit();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (db == null) continue;
                            if (throwable != null) {
                                try {
                                    db.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            db.close();
                        }
                    }
                    catch (NoSuchElementException ex) {
                        LOG.warn((Object)("failed to find the servo instance named " + instance.getInstanceId()), (Throwable)ex);
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"failed to update servo instance's ip address", (Throwable)ex);
                    }
                    continue;
                }
                if (!STATE.OutOfService.equals((Object)instance.getState()) && !STATE.Error.equals((Object)instance.getState()) || DNS_STATE.Deregistered.equals((Object)instance.getDnsState())) continue;
                try {
                    ipAddr = instance.getAddress();
                    if (ipAddr == null) continue;
                    String zone = instance.getDns().getZone();
                    String name = instance.getDns().getName();
                    EucalyptusActivityTasks.getInstance().removeARecord(zone, name, ipAddr);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"failed to remove IP address from the dns A record", (Throwable)ex);
                    continue;
                }
                try {
                    TransactionResource db = Entities.transactionFor(LoadBalancerServoInstance.class);
                    Throwable throwable = null;
                    try {
                        update = (LoadBalancerServoInstance)((Object)Entities.uniqueResult((Object)((Object)instance)));
                        update.setDnsState(DNS_STATE.Deregistered);
                        db.commit();
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (db == null) continue;
                        if (throwable != null) {
                            try {
                                db.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        db.close();
                    }
                }
                catch (NoSuchElementException ex) {
                    LOG.warn((Object)("failed to find the servo instance named " + instance.getInstanceId()), (Throwable)ex);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"failed to update servo instance's ip address", (Throwable)ex);
                }
            }
        }
    }

    public static class LoadBalancerServoInstanceRelationView {
        private LoadBalancerZone.LoadBalancerZoneCoreView zone = null;
        private LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView dns = null;
        private LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupCoreView autoscaling_group = null;

        private LoadBalancerServoInstanceRelationView(LoadBalancerServoInstance servo) {
            if (servo.zone != null) {
                this.zone = (LoadBalancerZone.LoadBalancerZoneCoreView)TypeMappers.transform((Object)((Object)servo.zone), LoadBalancerZone.LoadBalancerZoneCoreView.class);
            }
            if (servo.dns != null) {
                this.dns = (LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView)TypeMappers.transform((Object)((Object)servo.dns), LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView.class);
            }
            if (servo.autoscaling_group != null) {
                this.autoscaling_group = (LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupCoreView)TypeMappers.transform((Object)((Object)servo.autoscaling_group), LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupCoreView.class);
            }
        }

        public LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView getDns() {
            return this.dns;
        }

        public LoadBalancerZone.LoadBalancerZoneCoreView getZone() {
            return this.zone;
        }
    }

    public static enum LoadBalancerServoInstanceEntityTransform implements Function<LoadBalancerServoInstanceCoreView, LoadBalancerServoInstance>
    {
        INSTANCE;


        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        public LoadBalancerServoInstance apply(@Nullable LoadBalancerServoInstanceCoreView arg0) {
            try (TransactionResource db = Entities.transactionFor(LoadBalancerServoInstance.class);){
                LoadBalancerServoInstance loadBalancerServoInstance = (LoadBalancerServoInstance)((Object)Entities.uniqueResult((Object)((Object)arg0.entity)));
                return loadBalancerServoInstance;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    @TypeMapper
    public static enum LoadBalancerServoInstanceCoreViewTransform implements Function<LoadBalancerServoInstance, LoadBalancerServoInstanceCoreView>
    {
        INSTANCE;


        public LoadBalancerServoInstanceCoreView apply(LoadBalancerServoInstance servo) {
            return new LoadBalancerServoInstanceCoreView(servo);
        }
    }

    public static class LoadBalancerServoInstanceCoreView {
        private LoadBalancerServoInstance entity = null;

        LoadBalancerServoInstanceCoreView(LoadBalancerServoInstance servo) {
            this.entity = servo;
        }

        public String getInstanceId() {
            return this.entity.getInstanceId();
        }

        public STATE getState() {
            return this.entity.getState();
        }

        public String getAddress() {
            return this.entity.getAddress();
        }

        public String getPrivateIp() {
            return this.entity.getPrivateIp();
        }
    }

    static enum DNS_STATE {
        Registered,
        Deregistered,
        None;

    }

    static enum STATE {
        Pending,
        InService,
        Error,
        OutOfService,
        Retired;

    }
}

