/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.activities;

import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.activities.LoadBalancerServoInstance;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_loadbalancing")
@Table(name="metadata_autoscale_group")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class LoadBalancerAutoScalingGroup
extends AbstractPersistent {
    private static Logger LOG = Logger.getLogger(LoadBalancerAutoScalingGroup.class);
    @Transient
    private static final long serialVersionUID = 1L;
    @Transient
    private LoadBalancerAutoScalingGroupRelationView view = null;
    @OneToOne
    @JoinColumn(name="metadata_loadbalancer_fk", nullable=true)
    private LoadBalancer loadbalancer = null;
    @OneToMany(fetch=FetchType.LAZY, orphanRemoval=false, mappedBy="autoscaling_group")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Collection<LoadBalancerServoInstance> servos = null;
    @Column(name="metadata_group_name", nullable=false)
    private String groupName = null;
    @Column(name="metadata_capacity", nullable=true)
    private Integer capacity = null;
    @Column(name="metadata_launch_config_name", nullable=true)
    private String launchConfig = null;
    @Column(name="unique_name", nullable=false, unique=true)
    private String uniqueName = null;

    @PostLoad
    private void onLoad() {
        if (this.view == null) {
            this.view = new LoadBalancerAutoScalingGroupRelationView(this);
        }
    }

    private LoadBalancerAutoScalingGroup() {
    }

    private LoadBalancerAutoScalingGroup(LoadBalancer lb, String groupName, String launchConfig) {
        this.loadbalancer = lb;
        this.groupName = groupName;
        this.launchConfig = launchConfig;
        this.uniqueName = this.createUniqueName();
        this.view = new LoadBalancerAutoScalingGroupRelationView(this);
    }

    public static LoadBalancerAutoScalingGroup newInstance(LoadBalancer lb, String groupName, String launchConfig) {
        LoadBalancerAutoScalingGroup instance = new LoadBalancerAutoScalingGroup(lb, groupName, launchConfig);
        return instance;
    }

    public static LoadBalancerAutoScalingGroup named(LoadBalancer lb) {
        LoadBalancerAutoScalingGroup instance = new LoadBalancerAutoScalingGroup();
        instance.loadbalancer = lb;
        instance.uniqueName = instance.createUniqueName();
        return instance;
    }

    public static LoadBalancerAutoScalingGroup named() {
        return new LoadBalancerAutoScalingGroup();
    }

    public String getName() {
        return this.groupName;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public List<LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView> getServos() {
        return this.view.getServos();
    }

    public void setLoadBalancer(LoadBalancer lb) {
        this.loadbalancer = lb;
    }

    public LoadBalancer.LoadBalancerCoreView getLoadBalancer() {
        return this.view.getLoadBalancer();
    }

    @PrePersist
    private void generateOnCommit() {
        if (this.uniqueName == null) {
            this.uniqueName = this.createUniqueName();
        }
    }

    protected String createUniqueName() {
        return String.format("autoscale-group-%s-%s", this.loadbalancer.getOwnerAccountNumber(), this.loadbalancer.getDisplayName());
    }

    public static class LoadBalancerAutoScalingGroupRelationView {
        private ImmutableList<LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView> servos = null;
        private LoadBalancer loadbalancer = null;

        LoadBalancerAutoScalingGroupRelationView(LoadBalancerAutoScalingGroup group) {
            if (group.servos != null) {
                this.servos = ImmutableList.copyOf((Collection)Collections2.transform((Collection)group.servos, (Function)LoadBalancerServoInstance.LoadBalancerServoInstanceCoreViewTransform.INSTANCE));
            }
            if (group.loadbalancer != null) {
                Entities.initialize((Object)((Object)group.loadbalancer));
                this.loadbalancer = group.loadbalancer;
            }
        }

        public ImmutableList<LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView> getServos() {
            return this.servos;
        }

        public LoadBalancer.LoadBalancerCoreView getLoadBalancer() {
            return this.loadbalancer.getCoreView();
        }
    }

    public static enum LoadBalancerAutoScalingGroupEntityTransform implements Function<LoadBalancerAutoScalingGroupCoreView, LoadBalancerAutoScalingGroup>
    {
        INSTANCE;


        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        public LoadBalancerAutoScalingGroup apply(@Nullable LoadBalancerAutoScalingGroupCoreView arg0) {
            try (TransactionResource db = Entities.transactionFor(LoadBalancerAutoScalingGroup.class);){
                LoadBalancerAutoScalingGroup loadBalancerAutoScalingGroup = (LoadBalancerAutoScalingGroup)((Object)Entities.uniqueResult((Object)((Object)arg0.group)));
                return loadBalancerAutoScalingGroup;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    @TypeMapper
    public static enum LoadBalancerAutoScalingGroupCoreViewTransform implements Function<LoadBalancerAutoScalingGroup, LoadBalancerAutoScalingGroupCoreView>
    {
        INSTANCE;


        @Nullable
        public LoadBalancerAutoScalingGroupCoreView apply(@Nullable LoadBalancerAutoScalingGroup arg0) {
            return new LoadBalancerAutoScalingGroupCoreView(arg0);
        }
    }

    public static class LoadBalancerAutoScalingGroupCoreView {
        private LoadBalancerAutoScalingGroup group = null;

        LoadBalancerAutoScalingGroupCoreView(LoadBalancerAutoScalingGroup group) {
            this.group = group;
        }

        public String getName() {
            return this.group.getName();
        }

        public int getCapacity() {
            return this.group.getCapacity();
        }
    }
}

