/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.activities;

import com.eucalyptus.autoscaling.common.msgs.AutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResponseType;
import com.eucalyptus.autoscaling.common.msgs.LaunchConfigurationType;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.DependsLocal;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.DescribeKeyPairsResponseItemType;
import com.eucalyptus.compute.common.ImageDetails;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.empyrean.ServiceStatusType;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancerPolicies;
import com.eucalyptus.loadbalancing.LoadBalancerZone;
import com.eucalyptus.loadbalancing.LoadBalancers;
import com.eucalyptus.loadbalancing.activities.AbstractEventHandler;
import com.eucalyptus.loadbalancing.activities.ApplySecurityGroupsEvent;
import com.eucalyptus.loadbalancing.activities.EucalyptusActivityException;
import com.eucalyptus.loadbalancing.activities.EucalyptusActivityTasks;
import com.eucalyptus.loadbalancing.activities.EventHandlerChain;
import com.eucalyptus.loadbalancing.activities.EventHandlerChainNew;
import com.eucalyptus.loadbalancing.activities.EventHandlerException;
import com.eucalyptus.loadbalancing.activities.LoadBalancerAutoScalingGroup;
import com.eucalyptus.loadbalancing.activities.LoadbalancingEvent;
import com.eucalyptus.loadbalancing.activities.NewLoadbalancerEvent;
import com.eucalyptus.loadbalancing.activities.StoredResult;
import com.eucalyptus.loadbalancing.common.LoadBalancingBackend;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.DNSProperties;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.fsm.TransitionRecord;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.net.HostSpecifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

@ConfigurableClass(root="services.loadbalancing.worker", description="Parameters controlling loadbalancing")
public class LoadBalancerASGroupCreator
extends AbstractEventHandler<LoadbalancingEvent>
implements StoredResult<String> {
    private static Logger LOG = Logger.getLogger(LoadBalancerASGroupCreator.class);
    @ConfigurableField(displayName="image", description="EMI containing haproxy and the controller", initial="NULL", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=ElbEmiChangeListener.class)
    public static String IMAGE = "NULL";
    @ConfigurableField(displayName="instance_type", description="instance type for loadbalancer instances", initial="m1.small", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=ElbInstanceTypeChangeListener.class)
    public static String INSTANCE_TYPE = "m1.small";
    @ConfigurableField(displayName="keyname", description="keyname to use when debugging loadbalancer VMs", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=ElbKeyNameChangeListener.class)
    public static String KEYNAME = null;
    @ConfigurableField(displayName="ntp_server", description="the address of the NTP server used by loadbalancer VMs", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=ElbNTPServerChangeListener.class)
    public static String NTP_SERVER = null;
    @ConfigurableField(displayName="app_cookie_duration", description="duration of app-controlled cookie to be kept in-memory (hours)", initial="24", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=ElbAppCookieDurationChangeListener.class)
    public static String APP_COOKIE_DURATION = "24";
    @ConfigurableField(displayName="expiration_days", description="the days after which the loadbalancer Vms expire", initial="365", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=ElbVmExpirationDaysChangeListener.class)
    public static String EXPIRATION_DAYS = "365";
    @ConfigurableField(displayName="init_script", description="bash script that will be executed before service configuration and start up", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=InitScriptChangeListener.class)
    public static String INIT_SCRIPT = null;
    private int capacityPerZone = 1;
    private String launchConfigName = null;
    private String asgName = null;

    private static void onPropertyChange(String emi, String instanceType, String keyname, String initScript) throws EucalyptusCloudException {
        if (!(Bootstrap.isFinished().booleanValue() && Topology.isEnabledLocally(LoadBalancingBackend.class) && Topology.isEnabled(Eucalyptus.class))) {
            return;
        }
        if (emi != null) {
            try {
                List<ImageDetails> images = EucalyptusActivityTasks.getInstance().describeImages(Lists.newArrayList((Object[])new String[]{emi}));
                if (images == null || images.size() <= 0) {
                    throw new EucalyptusCloudException("No such EMI is found in the system");
                }
                if (!images.get(0).getImageId().toLowerCase().equals(emi.toLowerCase())) {
                    throw new EucalyptusCloudException("No such EMI is found in the system");
                }
            }
            catch (EucalyptusCloudException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new EucalyptusCloudException("Failed to verify EMI in the system");
            }
        }
        if (keyname != null && !keyname.equals("")) {
            try {
                List<DescribeKeyPairsResponseItemType> keypairs = EucalyptusActivityTasks.getInstance().describeKeyPairs(Lists.newArrayList((Object[])new String[]{keyname}));
                if (keypairs == null || keypairs.size() <= 0) {
                    throw new EucalyptusCloudException("No such keypair is found in the system");
                }
                if (!keypairs.get(0).getKeyName().equals(keyname)) {
                    throw new EucalyptusCloudException("No such keypair is found in the system");
                }
            }
            catch (EucalyptusCloudException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new EucalyptusCloudException("Failed to verify the keyname in the system");
            }
        }
        if (emi != null && emi.length() > 0 || instanceType != null && instanceType.length() > 0 || keyname != null && keyname.length() > 0 || initScript != null) {
            List<LoadBalancer> lbs = LoadBalancers.listLoadbalancers();
            for (LoadBalancer lb : lbs) {
                LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupCoreView asg = lb.getAutoScaleGroup();
                if (asg == null || asg.getName() == null) continue;
                String asgName = asg.getName();
                try {
                    String launchConfigName;
                    AutoScalingGroupType asgType;
                    block30: {
                        asgType = null;
                        try {
                            DescribeAutoScalingGroupsResponseType resp = EucalyptusActivityTasks.getInstance().describeAutoScalingGroups(Lists.newArrayList((Object[])new String[]{asgName}));
                            if (resp.getDescribeAutoScalingGroupsResult() == null || resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups() == null || resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember() == null || resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember().size() <= 0) break block30;
                            asgType = (AutoScalingGroupType)resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember().get(0);
                        }
                        catch (Exception ex) {
                            LOG.warn((Object)("can't find autoscaling group named " + asgName));
                            continue;
                        }
                    }
                    if (asgType == null) continue;
                    String lcName = asgType.getLaunchConfigurationName();
                    LaunchConfigurationType lc = EucalyptusActivityTasks.getInstance().describeLaunchConfiguration(lcName);
                    do {
                        if ((launchConfigName = String.format("lc-euca-internal-elb-%s-%s-%s", lb.getOwnerAccountNumber(), lb.getDisplayName(), UUID.randomUUID().toString().substring(0, 8))).length() <= 255) continue;
                        launchConfigName = launchConfigName.substring(0, 255);
                    } while (launchConfigName.equals(asgType.getLaunchConfigurationName()));
                    String newEmi = emi != null ? emi : lc.getImageId();
                    String newType = instanceType != null ? instanceType : lc.getInstanceType();
                    String newKeyname = keyname != null ? keyname : lc.getKeyName();
                    String newUserdata = B64.standard.encString((String)String.format("%s\n%s", LoadBalancerASGroupCreator.getCredentialsString(), LoadBalancerASGroupCreator.getLoadBalancerUserData(initScript)));
                    try {
                        EucalyptusActivityTasks.getInstance().createLaunchConfiguration(newEmi, newType, lc.getIamInstanceProfile(), launchConfigName, lc.getSecurityGroups().getMember(), newKeyname, newUserdata, Boolean.TRUE.equals(lc.getAssociatePublicIpAddress()));
                    }
                    catch (Exception ex) {
                        throw new EucalyptusCloudException("failed to create new launch config", (Throwable)ex);
                    }
                    try {
                        EucalyptusActivityTasks.getInstance().updateAutoScalingGroup(asgName, null, asgType.getDesiredCapacity(), launchConfigName);
                    }
                    catch (Exception ex) {
                        throw new EucalyptusCloudException("failed to update the autoscaling group", (Throwable)ex);
                    }
                    try {
                        EucalyptusActivityTasks.getInstance().deleteLaunchConfiguration(asgType.getLaunchConfigurationName());
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"unable to delete the old launch configuration", (Throwable)ex);
                    }
                    try {
                        List<ImageDetails> images = EucalyptusActivityTasks.getInstance().describeImages(Lists.newArrayList((Object[])new String[]{emi}));
                        for (ResourceTag tag : images.get(0).getTagSet()) {
                            EucalyptusActivityTasks.getInstance().createOrUpdateAutoscalingTags(tag.getKey(), tag.getValue(), asgName);
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"unable to propogate tags from image to ASG", (Throwable)ex);
                    }
                    LOG.debug((Object)String.format("autoscaling group '%s' was updated", asgName));
                }
                catch (EucalyptusCloudException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new EucalyptusCloudException("Unable to update the autoscaling group", (Throwable)ex);
                }
            }
        }
    }

    public LoadBalancerASGroupCreator(EventHandlerChain<? extends LoadbalancingEvent> chain, int capacityPerZone) {
        super(chain);
        this.capacityPerZone = capacityPerZone;
    }

    public static String getCredentialsString() {
        String credStr = String.format("euca-%s:%s", B64.standard.encString((String)"setup-credential"), EXPIRATION_DAYS);
        return credStr;
    }

    @Override
    public void apply(LoadbalancingEvent evt) throws EventHandlerException {
        Integer capacity;
        ArrayList availabilityZones;
        LoadBalancer.LoadBalancerCoreView lb;
        LoadBalancer lbEntity;
        if (IMAGE == null) {
            throw new EventHandlerException("Loadbalancer's EMI is not configured");
        }
        Collection<String> eventZones = null;
        Set eventSecurityGroupIds = Collections.emptySet();
        Map zoneToSubnetIdMap = null;
        if (evt instanceof NewLoadbalancerEvent) {
            eventZones = ((NewLoadbalancerEvent)evt).getZones();
            zoneToSubnetIdMap = ((NewLoadbalancerEvent)evt).getZoneToSubnetIdMap();
        } else if (evt instanceof ApplySecurityGroupsEvent) {
            Map<String, String> groupIdToNameMap = ((ApplySecurityGroupsEvent)evt).getSecurityGroupIdsToNames();
            Set<Object> set = eventSecurityGroupIds = groupIdToNameMap == null ? eventSecurityGroupIds : groupIdToNameMap.keySet();
        }
        if (eventZones == null && eventSecurityGroupIds.isEmpty()) {
            return;
        }
        try {
            lbEntity = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
            lb = lbEntity.getCoreView();
            if (zoneToSubnetIdMap == null) {
                zoneToSubnetIdMap = CollectionUtils.putAll((Iterable)Iterables.filter(lbEntity.getZones(), (Predicate)Predicates.compose((Predicate)Predicates.notNull(), LoadBalancerZone.LoadBalancerZoneCoreView.subnetId())), (Map)Maps.newHashMap(), LoadBalancerZone.LoadBalancerZoneCoreView.name(), LoadBalancerZone.LoadBalancerZoneCoreView.subnetId());
            }
        }
        catch (NoSuchElementException ex) {
            throw new EventHandlerException("Failed to find the loadbalancer " + evt.getLoadBalancer(), ex);
        }
        catch (Exception ex) {
            throw new EventHandlerException("Failed due to query exception", ex);
        }
        String newlaunchConfigName = String.format("lc-euca-internal-elb-%s-%s-%s", lb.getOwnerAccountNumber(), lb.getDisplayName(), UUID.randomUUID().toString().substring(0, 8));
        if (newlaunchConfigName.length() > 255) {
            newlaunchConfigName = newlaunchConfigName.substring(0, 255);
        }
        String launchConfigName = newlaunchConfigName;
        String launchConfigToDelete = null;
        String groupName = LoadBalancerASGroupCreator.getAutoScalingGroupName(lb.getOwnerAccountNumber(), lb.getDisplayName());
        String instanceProfileName = null;
        try {
            List<String> result = this.chain.findHandler(EventHandlerChainNew.InstanceProfileSetup.class).getResult();
            instanceProfileName = result.get(0);
        }
        catch (Exception result) {
            // empty catch block
        }
        boolean asgFound = false;
        boolean updateLaunchConfig = false;
        try {
            DescribeAutoScalingGroupsResponseType response = EucalyptusActivityTasks.getInstance().describeAutoScalingGroups(Lists.newArrayList((Object[])new String[]{groupName}));
            ArrayList groups = response.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember();
            if (groups.size() > 0 && ((AutoScalingGroupType)groups.get(0)).getAutoScalingGroupName().equals(groupName)) {
                asgFound = true;
                launchConfigName = ((AutoScalingGroupType)groups.get(0)).getLaunchConfigurationName();
                if (!eventSecurityGroupIds.isEmpty()) {
                    LaunchConfigurationType lc = EucalyptusActivityTasks.getInstance().describeLaunchConfiguration(launchConfigName);
                    boolean bl = updateLaunchConfig = lc == null || lc.getSecurityGroups() == null || !Sets.newHashSet((Iterable)lc.getSecurityGroups().getMember()).equals(Sets.newHashSet(eventSecurityGroupIds));
                    if (updateLaunchConfig) {
                        launchConfigToDelete = launchConfigName;
                        launchConfigName = newlaunchConfigName;
                    }
                }
            }
        }
        catch (Exception ex) {
            asgFound = false;
        }
        if (!asgFound || updateLaunchConfig) {
            try {
                HashSet securityGroupNamesOrIds = Sets.newHashSet(eventSecurityGroupIds);
                if (securityGroupNamesOrIds.isEmpty()) {
                    if (!lb.getSecurityGroupIdsToNames().isEmpty()) {
                        securityGroupNamesOrIds.addAll(lb.getSecurityGroupIdsToNames().keySet());
                    } else {
                        StoredResult sgroupSetup = this.getChain().findHandler(EventHandlerChainNew.SecurityGroupSetup.class);
                        List group = sgroupSetup.getResult();
                        if (!group.isEmpty()) {
                            securityGroupNamesOrIds.add(group.get(0));
                        }
                    }
                }
                String keyName = KEYNAME != null && KEYNAME.length() > 0 ? KEYNAME : null;
                String userData = B64.standard.encString((String)String.format("%s\n%s", LoadBalancerASGroupCreator.getCredentialsString(), LoadBalancerASGroupCreator.getLoadBalancerUserData(INIT_SCRIPT)));
                EucalyptusActivityTasks.getInstance().createLaunchConfiguration(IMAGE, INSTANCE_TYPE, instanceProfileName, launchConfigName, securityGroupNamesOrIds, keyName, userData, !zoneToSubnetIdMap.isEmpty());
                this.launchConfigName = launchConfigName;
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to create launch configuration", ex);
            }
        }
        if (!asgFound) {
            if (eventZones == null) {
                throw new EventHandlerException("Availability zones required to create auto scaling group.");
            }
            try {
                availabilityZones = Lists.newArrayList(eventZones);
                String vpcZoneIdentifier = zoneToSubnetIdMap.isEmpty() ? null : Strings.emptyToNull((String)Joiner.on((char)',').skipNulls().join(Iterables.transform((Iterable)availabilityZones, (Function)Functions.forMap((Map)zoneToSubnetIdMap))));
                capacity = availabilityZones.size() * this.capacityPerZone;
                EucalyptusActivityTasks.getInstance().createAutoScalingGroup(groupName, availabilityZones, vpcZoneIdentifier, capacity, launchConfigName, "Name", "loadbalancer-resources");
                this.asgName = groupName;
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to create autoscaling group", ex);
            }
        }
        try {
            availabilityZones = eventZones == null ? null : Lists.newArrayList(eventZones);
            capacity = availabilityZones == null ? null : Integer.valueOf(availabilityZones.size() * this.capacityPerZone);
            EucalyptusActivityTasks.getInstance().updateAutoScalingGroup(groupName, availabilityZones, capacity, launchConfigName);
        }
        catch (Exception ex) {
            throw new EventHandlerException("Failed to update the autoscaling group", ex);
        }
        if (launchConfigToDelete != null) {
            try {
                EucalyptusActivityTasks.getInstance().deleteLaunchConfiguration(launchConfigToDelete);
            }
            catch (Exception ex) {
                LOG.warn((Object)("unable to delete launch configuration (" + launchConfigToDelete + ")"), (Throwable)ex);
            }
        }
        this.asgName = groupName;
        this.launchConfigName = launchConfigName;
        try (TransactionResource db = Entities.transactionFor(LoadBalancerAutoScalingGroup.class);){
            try {
                LoadBalancerAutoScalingGroup group = (LoadBalancerAutoScalingGroup)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerAutoScalingGroup.named(lbEntity))));
                if (capacity != null) {
                    group.setCapacity(capacity);
                }
            }
            catch (NoSuchElementException ex) {
                LoadBalancerAutoScalingGroup group = LoadBalancerAutoScalingGroup.newInstance(lbEntity, groupName, this.launchConfigName);
                if (capacity != null) {
                    group.setCapacity(capacity);
                }
                Entities.persist((Object)((Object)group));
            }
            db.commit();
        }
        catch (Exception ex) {
            throw new EventHandlerException("Failed to commit the database", ex);
        }
    }

    @Override
    public void rollback() throws EventHandlerException {
        if (this.asgName != null) {
            try {
                EucalyptusActivityTasks.getInstance().deleteAutoScalingGroup(this.asgName, true);
            }
            catch (Exception ex) {
                LOG.error((Object)("failed to delete autoscaling group - " + this.asgName));
            }
        }
        if (this.launchConfigName != null) {
            try {
                EucalyptusActivityTasks.getInstance().deleteLaunchConfiguration(this.launchConfigName);
            }
            catch (Exception ex) {
                LOG.error((Object)("failed to delete launch configuration - " + this.launchConfigName));
            }
        }
    }

    @Override
    public List<String> getResult() {
        ArrayList result = Lists.newArrayList();
        if (this.launchConfigName != null) {
            result.add(this.launchConfigName);
        }
        if (this.asgName != null) {
            result.add(this.asgName);
        }
        return result;
    }

    static String getAutoScalingGroupName(String ownerAccountNumber, String loadBalancerName) {
        String groupName = String.format("asg-euca-internal-elb-%s-%s", ownerAccountNumber, loadBalancerName);
        if (groupName.length() > 255) {
            groupName = groupName.substring(0, 255);
        }
        return groupName;
    }

    public static String getLoadBalancerUserData(String initScript) {
        HashMap<String, String> kvMap = new HashMap<String, String>();
        if (NTP_SERVER != null) {
            kvMap.put("ntp_server", NTP_SERVER);
        }
        if (APP_COOKIE_DURATION != null) {
            kvMap.put("app-cookie-duration", APP_COOKIE_DURATION);
        }
        kvMap.put("elb_service_url", String.format("loadbalancing.%s", DNSProperties.DOMAIN));
        kvMap.put("euare_service_url", String.format("euare.%s", DNSProperties.DOMAIN));
        try {
            List<ServiceStatusType> services = EucalyptusActivityTasks.getInstance().describeServices("eucalyptus");
            if (services == null || services.size() <= 0) {
                throw new EucalyptusActivityException("failed to describe eucalyptus services");
            }
            ServiceStatusType service = services.get(0);
            String serviceUrl = service.getServiceId().getUri();
            String tmp = serviceUrl.replace("http://", "").replace("https://", "");
            String host = tmp.substring(0, tmp.indexOf(":"));
            tmp = tmp.replace(host + ":", "");
            String port = tmp.substring(0, tmp.indexOf("/"));
            String path = tmp.replace(port + "/", "");
            kvMap.put("eucalyptus_host", host);
            kvMap.put("eucalyptus_port", port);
            kvMap.put("eucalyptus_path", path);
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
        StringBuilder sb = new StringBuilder("#!/bin/bash").append("\n");
        if (initScript != null && initScript.length() > 0) {
            sb.append(initScript);
        }
        sb.append("\n#System generated Load Balancer Servo config\n");
        sb.append("mkdir -p /etc/load-balancer-servo/\n");
        sb.append("yum -y --disablerepo \\* --enablerepo eucalyptus-service-image install load-balancer-servo\n");
        sb.append("echo \"");
        for (String key : kvMap.keySet()) {
            String value = (String)kvMap.get(key);
            sb.append(String.format("\n%s=%s", key, value));
        }
        sb.append("\" > /etc/load-balancer-servo/servo.conf");
        sb.append("\ntouch /var/lib/load-balancer-servo/ntp.lock");
        sb.append("\nchown -R servo:servo /etc/load-balancer-servo");
        sb.append("\nservice load-balancer-servo start");
        return sb.toString();
    }

    public static class InitScriptChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            try {
                if (t.getValue() != null && !t.getValue().equals(newValue)) {
                    LoadBalancerASGroupCreator.onPropertyChange(null, null, null, newValue);
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change init script", (Throwable)e);
            }
        }
    }

    @Provides(value=LoadBalancingBackend.class)
    @RunDuring(value=Bootstrap.Stage.Final)
    @DependsLocal(value={LoadBalancingBackend.class})
    public static class LoadBalancingPropertyBootstrapper
    extends Bootstrapper.Simple {
        private static LoadBalancingPropertyBootstrapper singleton;
        private static final Callable<String> imageNotConfiguredFaultRunnable;
        private static int CheckCounter;
        private static boolean EmiCheckResult;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Bootstrapper getInstance() {
            Class<LoadBalancingPropertyBootstrapper> clazz = LoadBalancingPropertyBootstrapper.class;
            synchronized (LoadBalancingPropertyBootstrapper.class) {
                if (singleton == null) {
                    singleton = new LoadBalancingPropertyBootstrapper();
                    LOG.info((Object)"Creating Load Balancing Bootstrapper instance.");
                } else {
                    LOG.info((Object)"Returning Load Balancing Bootstrapper instance.");
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
        }

        public boolean check() throws Exception {
            if (CloudMetadatas.isMachineImageIdentifier((String)IMAGE)) {
                if (CheckCounter >= 3 && Topology.isEnabled(Eucalyptus.class)) {
                    try {
                        List<ImageDetails> emis = EucalyptusActivityTasks.getInstance().describeImages(Lists.newArrayList((Object[])new String[]{IMAGE}));
                        EmiCheckResult = IMAGE.equals(emis.get(0).getImageId());
                    }
                    catch (Exception ex) {
                        EmiCheckResult = false;
                    }
                    CheckCounter = 0;
                } else {
                    ++CheckCounter;
                }
                return EmiCheckResult;
            }
            try {
                ServiceConfiguration localService = Components.lookup(LoadBalancingBackend.class).getLocalServiceConfiguration();
                Faults.CheckException ex = Faults.failure((ServiceConfiguration)localService, (String[])new String[]{imageNotConfiguredFaultRunnable.call().split("\n")[1]});
                Faults.submit((ServiceConfiguration)localService, (TransitionRecord)localService.lookupStateMachine().getTransitionRecord(), (Faults.CheckException)ex);
            }
            catch (Exception e) {
                LOG.debug((Object)e);
            }
            return false;
        }

        public boolean enable() throws Exception {
            if (!super.enable()) {
                return false;
            }
            try {
                LoadBalancerPolicies.initialize();
            }
            catch (Exception ex) {
                LOG.error((Object)"Unable to initialize ELB policy types", (Throwable)ex);
                return false;
            }
            return true;
        }

        static {
            imageNotConfiguredFaultRunnable = Faults.forComponent(LoadBalancingBackend.class).havingId(1014).logOnFirstRun();
            CheckCounter = 0;
            EmiCheckResult = true;
        }
    }

    public static class ElbAppCookieDurationChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            block6: {
                try {
                    if (!(newValue instanceof String)) break block6;
                    try {
                        int appCookieDuration = Integer.parseInt((String)newValue);
                        if (appCookieDuration <= 0) {
                            throw new Exception();
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new ConfigurablePropertyException("Duration must be in number type and bigger than 0 (in hours)");
                    }
                }
                catch (ConfigurablePropertyException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new ConfigurablePropertyException("Could not change ELB app cookie duration", (Throwable)ex);
                }
            }
        }
    }

    public static class ElbNTPServerChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            block8: {
                try {
                    if (newValue instanceof String) {
                        if (((String)newValue).contains(",")) {
                            String[] addresses = ((String)newValue).split(",");
                            if (addresses.length - 1 != StringUtils.countOccurrencesOf((String)((String)newValue), (String)",")) {
                                throw new EucalyptusCloudException("Invalid address");
                            }
                            for (String address : addresses) {
                                if (HostSpecifier.isValid((String)String.format("%s.com", address))) continue;
                                throw new EucalyptusCloudException("Invalid address");
                            }
                        } else {
                            String address = (String)newValue;
                            if (!address.equals("") && !HostSpecifier.isValid((String)String.format("%s.com", address))) {
                                throw new EucalyptusCloudException("Invalid address");
                            }
                        }
                        break block8;
                    }
                    throw new EucalyptusCloudException("Address is not string type");
                }
                catch (Exception e) {
                    throw new ConfigurablePropertyException("Could not change ntp server address", (Throwable)e);
                }
            }
        }
    }

    public static class ElbVmExpirationDaysChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            try {
                int newExp = Integer.parseInt(newValue);
                if (newExp <= 0) {
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                throw new ConfigurablePropertyException("The value must be number type and bigger than 0");
            }
        }
    }

    public static class ElbKeyNameChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                if (newValue instanceof String && t.getValue() != null && !t.getValue().equals(newValue)) {
                    LoadBalancerASGroupCreator.onPropertyChange(null, null, (String)newValue, null);
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change key name", (Throwable)e);
            }
        }
    }

    public static class ElbInstanceTypeChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                if (newValue instanceof String) {
                    if (newValue.equals("")) {
                        throw new EucalyptusCloudException("Instance type cannot be unset");
                    }
                    if (t.getValue() != null && !t.getValue().equals(newValue)) {
                        LoadBalancerASGroupCreator.onPropertyChange(null, (String)newValue, null, null);
                    }
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change instance type", (Throwable)e);
            }
        }
    }

    public static class ElbEmiChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                if (newValue instanceof String && t.getValue() != null && !t.getValue().equals(newValue)) {
                    LoadBalancerASGroupCreator.onPropertyChange((String)newValue, null, null, null);
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change EMI ID", (Throwable)e);
            }
        }
    }
}

