/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.activities;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.loadbalancing.activities.AbstractEventHandler;
import com.eucalyptus.loadbalancing.activities.EventHandlerChain;
import com.eucalyptus.loadbalancing.activities.EventHandlerException;
import com.eucalyptus.loadbalancing.activities.LoadBalancerServoInstance;
import com.eucalyptus.loadbalancing.activities.RegisterInstancesEvent;
import com.eucalyptus.loadbalancing.common.msgs.Instance;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class EventHandlerChainRegisterInstances
extends EventHandlerChain<RegisterInstancesEvent> {
    @Override
    public EventHandlerChain<RegisterInstancesEvent> build() {
        this.insert(new RequestVerifier(this));
        return this;
    }

    private static class RequestVerifier
    extends AbstractEventHandler<RegisterInstancesEvent> {
        protected RequestVerifier(EventHandlerChain<RegisterInstancesEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(RegisterInstancesEvent evt) throws EventHandlerException {
            if (evt.getInstances() == null || evt.getInstances().size() <= 0) {
                return;
            }
            ArrayList instances = Lists.newArrayList(evt.getInstances());
            try (TransactionResource db = Entities.transactionFor(LoadBalancerServoInstance.class);){
                for (Instance instance : instances) {
                    try {
                        LoadBalancerServoInstance servo = (LoadBalancerServoInstance)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerServoInstance.named(instance.getInstanceId()))));
                        if (servo == null) continue;
                        throw new EventHandlerException("Loadbalancer VM cannot be registered");
                    }
                    catch (EventHandlerException ex) {
                        throw ex;
                    }
                    catch (NoSuchElementException ex) {
                    }
                    catch (Exception ex) {
                        break;
                    }
                }
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
        }
    }
}

