/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.activities;

import com.eucalyptus.auth.euare.ServerCertificateType;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancerListener;
import com.eucalyptus.loadbalancing.LoadBalancerSecurityGroup;
import com.eucalyptus.loadbalancing.LoadBalancers;
import com.eucalyptus.loadbalancing.activities.AbstractEventHandler;
import com.eucalyptus.loadbalancing.activities.CreateListenerEvent;
import com.eucalyptus.loadbalancing.activities.EucalyptusActivityTasks;
import com.eucalyptus.loadbalancing.activities.EventHandlerChain;
import com.eucalyptus.loadbalancing.activities.EventHandlerChainNew;
import com.eucalyptus.loadbalancing.activities.EventHandlerException;
import com.eucalyptus.loadbalancing.common.msgs.Listener;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class EventHandlerChainNewListeners
extends EventHandlerChain<CreateListenerEvent> {
    private static Logger LOG = Logger.getLogger(EventHandlerChainNewListeners.class);

    @Override
    public EventHandlerChain<CreateListenerEvent> build() {
        this.insert(new CheckSSLCertificateId(this));
        this.insert(new AuthorizeSSLCertificate(this));
        this.insert(new AuthorizeIngressRule(this));
        this.insert(new UpdateHealthCheckConfig(this));
        return this;
    }

    static class UpdateHealthCheckConfig
    extends AbstractEventHandler<CreateListenerEvent> {
        private static final int DEFAULT_HEALTHY_THRESHOLD = 3;
        private static final int DEFAULT_INTERVAL = 30;
        private static final int DEFAULT_TIMEOUT = 5;
        private static final int DEFAULT_UNHEALTHY_THRESHOLD = 2;

        protected UpdateHealthCheckConfig(EventHandlerChain<CreateListenerEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(CreateListenerEvent evt) throws EventHandlerException {
            LoadBalancer lb;
            try {
                lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
            }
            catch (NoSuchElementException ex) {
                throw new EventHandlerException("Could not find the loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Error while looking for loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            try {
                lb.getHealthCheckTarget();
                lb.getHealthCheckInterval();
                lb.getHealthCheckTimeout();
                lb.getHealthCheckUnhealthyThreshold();
                lb.getHealthyThreshold();
            }
            catch (IllegalStateException ex) {
                if (evt.getListeners() == null || evt.getListeners().size() <= 0) {
                    throw new EventHandlerException("No listener requested");
                }
                ArrayList listeners = Lists.newArrayList(evt.getListeners());
                Listener firstListener = (Listener)listeners.get(0);
                String target = String.format("TCP:%d", firstListener.getInstancePort());
                try (TransactionResource db = Entities.transactionFor(LoadBalancer.class);){
                    LoadBalancer update = (LoadBalancer)((Object)Entities.uniqueResult((Object)((Object)lb)));
                    update.setHealthCheck(3, 30, target, 5, 2);
                    db.commit();
                }
                catch (NoSuchElementException exx) {
                    LOG.warn((Object)"Loadbalancer not found in the database");
                }
                catch (Exception exx) {
                    LOG.warn((Object)"Unable to query the loadbalancer", (Throwable)ex);
                }
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
        }
    }

    public static class AuthorizeSSLCertificate
    extends AbstractEventHandler<CreateListenerEvent> {
        private String roleName = null;
        private List<String> policyNames = Lists.newArrayList();
        public static final String SERVER_CERT_ROLE_POLICY_NAME_PREFIX = "loadbalancer-iam-policy";
        public static final String ROLE_SERVER_CERT_POLICY_DOCUMENT = "{\"Statement\":[{\"Action\": [\"iam:DownloadServerCertificate\"],\"Effect\": \"Allow\",\"Resource\": \"CERT_ARN_PLACEHOLDER\"}]}";

        protected AuthorizeSSLCertificate(EventHandlerChain<CreateListenerEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(CreateListenerEvent evt) throws EventHandlerException {
            Collection<Listener> listeners = evt.getListeners();
            HashSet certArns = Sets.newHashSet();
            for (Listener listener : listeners) {
                LoadBalancerListener.PROTOCOL protocol = LoadBalancerListener.PROTOCOL.valueOf(listener.getProtocol().toUpperCase());
                if (!protocol.equals((Object)LoadBalancerListener.PROTOCOL.HTTPS) && !protocol.equals((Object)LoadBalancerListener.PROTOCOL.SSL)) continue;
                certArns.add(listener.getSSLCertificateId());
            }
            if (certArns.size() <= 0) {
                return;
            }
            this.roleName = String.format("%s-%s-%s", "loadbalancer-vm", evt.getContext().getAccount().getAccountNumber(), evt.getLoadBalancer());
            String prefix = String.format("arn:aws:iam::%s:server-certificate", evt.getContext().getAccount().getAccountNumber());
            for (String arn : certArns) {
                if (!arn.startsWith(prefix)) continue;
                String pathAndName = arn.replace(prefix, "");
                String certName = pathAndName.substring(pathAndName.lastIndexOf("/") + 1);
                String policyName = String.format("%s-%s-%s-%s", SERVER_CERT_ROLE_POLICY_NAME_PREFIX, evt.getContext().getAccount().getAccountNumber(), evt.getLoadBalancer(), certName);
                String rolePolicyDoc = ROLE_SERVER_CERT_POLICY_DOCUMENT.replace("CERT_ARN_PLACEHOLDER", arn);
                try {
                    EucalyptusActivityTasks.getInstance().putRolePolicy(this.roleName, policyName, rolePolicyDoc);
                    this.policyNames.add(policyName);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to authorize server certificate for SSL listener", ex);
                }
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
            if (this.roleName != null && this.policyNames.size() > 0) {
                for (String policyName : this.policyNames) {
                    try {
                        EucalyptusActivityTasks.getInstance().deleteRolePolicy(this.roleName, policyName);
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Failed to delete role policy during listener creation rollback", (Throwable)ex);
                    }
                }
            }
        }
    }

    public static class AuthorizeIngressRule
    extends AbstractEventHandler<CreateListenerEvent> {
        private CreateListenerEvent event = null;

        protected AuthorizeIngressRule(EventHandlerChain<CreateListenerEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(CreateListenerEvent evt) throws EventHandlerException {
            block11: {
                String protocol;
                Map<String, String> securityGroupIdsToNames;
                LoadBalancer lb;
                Collection<Listener> listeners;
                block10: {
                    this.event = evt;
                    listeners = evt.getListeners();
                    String groupName = null;
                    try {
                        lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
                        LoadBalancerSecurityGroup.LoadBalancerSecurityGroupCoreView group = lb.getGroup();
                        if (group != null) {
                            groupName = group.getName();
                        }
                    }
                    catch (Exception ex) {
                        throw new EventHandlerException("could not find the loadbalancer", ex);
                    }
                    securityGroupIdsToNames = lb.getCoreView().getSecurityGroupIdsToNames();
                    protocol = "tcp";
                    if (lb.getVpcId() != null) break block10;
                    if (groupName == null) {
                        throw new EventHandlerException("Group name is not found");
                    }
                    for (Listener listener : listeners) {
                        int port = listener.getLoadBalancerPort();
                        try {
                            EucalyptusActivityTasks.getInstance().authorizeSystemSecurityGroup(groupName, protocol, port);
                        }
                        catch (Exception ex) {
                            throw new EventHandlerException(String.format("failed to authorize %s, %s, %d", groupName, protocol, port), ex);
                        }
                    }
                    break block11;
                }
                if (securityGroupIdsToNames.size() != 1 || !securityGroupIdsToNames.values().contains(EventHandlerChainNew.SecurityGroupSetup.generateDefaultVPCSecurityGroupName(lb.getVpcId()))) break block11;
                String groupId = (String)Iterables.getOnlyElement(securityGroupIdsToNames.keySet());
                for (Listener listener : listeners) {
                    int port = listener.getLoadBalancerPort();
                    try {
                        EucalyptusActivityTasks.getInstance().authorizeSystemSecurityGroup(groupId, protocol, port);
                    }
                    catch (Exception ex) {
                        throw new EventHandlerException(String.format("failed to authorize %s, %s, %d", groupId, protocol, port), ex);
                    }
                }
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
            if (this.event == null) {
                return;
            }
            Collection<Listener> listeners = this.event.getListeners();
            String groupName = null;
            try {
                LoadBalancer lb = LoadBalancers.getLoadbalancer(this.event.getContext(), this.event.getLoadBalancer());
                LoadBalancerSecurityGroup.LoadBalancerSecurityGroupCoreView group = lb.getGroup();
                if (group != null) {
                    groupName = group.getName();
                }
            }
            catch (Exception group) {
                // empty catch block
            }
            if (groupName == null) {
                return;
            }
            for (Listener listener : listeners) {
                int port = listener.getLoadBalancerPort();
                String protocol = listener.getProtocol();
                protocol = protocol.toLowerCase();
                try {
                    EucalyptusActivityTasks.getInstance().revokeSystemSecurityGroup(groupName, protocol, port);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class CheckSSLCertificateId
    extends AbstractEventHandler<CreateListenerEvent> {
        protected CheckSSLCertificateId(EventHandlerChain<CreateListenerEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(CreateListenerEvent evt) throws EventHandlerException {
            Collection<Listener> listeners = evt.getListeners();
            String acctNumber = evt.getContext().getAccount().getAccountNumber();
            for (Listener listener : listeners) {
                LoadBalancerListener.PROTOCOL protocol = LoadBalancerListener.PROTOCOL.valueOf(listener.getProtocol().toUpperCase());
                if (!protocol.equals((Object)LoadBalancerListener.PROTOCOL.HTTPS) && !protocol.equals((Object)LoadBalancerListener.PROTOCOL.SSL)) continue;
                String certArn = listener.getSSLCertificateId();
                if (certArn == null || certArn.length() <= 0) {
                    throw new EventHandlerException("No SSLCertificateId is specified");
                }
                String prefix = String.format("arn:aws:iam::%s:server-certificate", acctNumber);
                if (!certArn.startsWith(prefix)) {
                    throw new EventHandlerException("SSLCertificateId is not ARN format");
                }
                try {
                    String pathAndName = certArn.replace(prefix, "");
                    String certName = pathAndName.substring(pathAndName.lastIndexOf("/") + 1);
                    ServerCertificateType cert = EucalyptusActivityTasks.getInstance().getServerCertificate(evt.getContext().getUser().getUserId(), certName);
                    if (cert == null) {
                        throw new EventHandlerException("No SSL certificate is found with the ARN");
                    }
                    if (certArn.equals(cert.getServerCertificateMetadata().getArn())) continue;
                    throw new EventHandlerException("Returned certificate's ARN doesn't match the request");
                }
                catch (EventHandlerException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new EventHandlerException("Failed to get SSL server certificate", ex);
                }
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
        }
    }
}

