/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.activities;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.euare.GetRolePolicyResult;
import com.eucalyptus.auth.euare.InstanceProfileType;
import com.eucalyptus.auth.euare.RoleType;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.autoscaling.common.AutoScaling;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResponseType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResult;
import com.eucalyptus.autoscaling.common.msgs.Instance;
import com.eucalyptus.autoscaling.common.msgs.Instances;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.ClusterInfoType;
import com.eucalyptus.compute.common.DescribeKeyPairsResponseItemType;
import com.eucalyptus.compute.common.ImageDetails;
import com.eucalyptus.compute.common.SecurityGroupItemType;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancerDnsRecord;
import com.eucalyptus.loadbalancing.LoadBalancerSecurityGroup;
import com.eucalyptus.loadbalancing.LoadBalancerSecurityGroupRef;
import com.eucalyptus.loadbalancing.LoadBalancerZone;
import com.eucalyptus.loadbalancing.LoadBalancers;
import com.eucalyptus.loadbalancing.activities.AbstractEventHandler;
import com.eucalyptus.loadbalancing.activities.EucalyptusActivityTasks;
import com.eucalyptus.loadbalancing.activities.EventHandlerChain;
import com.eucalyptus.loadbalancing.activities.EventHandlerException;
import com.eucalyptus.loadbalancing.activities.LoadBalancerASGroupCreator;
import com.eucalyptus.loadbalancing.activities.LoadBalancerAutoScalingGroup;
import com.eucalyptus.loadbalancing.activities.LoadBalancerServoInstance;
import com.eucalyptus.loadbalancing.activities.NewLoadbalancerEvent;
import com.eucalyptus.loadbalancing.activities.StoredResult;
import com.eucalyptus.loadbalancing.common.LoadBalancingBackend;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

@ConfigurableClass(root="services.loadbalancing", description="Parameters controlling loadbalancing")
public class EventHandlerChainNew
extends EventHandlerChain<NewLoadbalancerEvent> {
    private static Logger LOG = Logger.getLogger(EventHandlerChainNew.class);
    @ConfigurableField(displayName="number_of_vm_per_zone", description="number of VMs per loadbalancer zone", initial="1", readonly=false, type=ConfigurableFieldType.KEYVALUE)
    public static String VM_PER_ZONE = "1";

    public static int getCapacityPerZone() {
        int numVm = 1;
        try {
            numVm = Integer.parseInt(VM_PER_ZONE);
        }
        catch (NumberFormatException ex) {
            LOG.warn((Object)"unable to parse loadbalancer_num_vm");
        }
        return numVm;
    }

    @Override
    public EventHandlerChain<NewLoadbalancerEvent> build() {
        this.insert(new AdmissionControl(this));
        this.insert(new IAMRoleSetup(this));
        this.insert(new InstanceProfileSetup(this));
        this.insert(new IAMPolicySetup(this));
        this.insert(new DNSANameSetup(this));
        this.insert(new SecurityGroupSetup(this));
        this.insert(new LoadBalancerASGroupCreator(this, EventHandlerChainNew.getCapacityPerZone()));
        this.insert(new TagCreator(this));
        return this;
    }

    public static class AutoscalingGroupInstanceChecker
    implements EventListener<ClockTick> {
        private static int AUTOSCALE_GROUP_CHECK_INTERVAL_SEC = 10;

        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new AutoscalingGroupInstanceChecker());
        }

        public void fireEvent(ClockTick event) {
            if (Bootstrap.isFinished().booleanValue() && Topology.isEnabledLocally(LoadBalancingBackend.class) && Topology.isEnabled(AutoScaling.class) && Topology.isEnabled(Eucalyptus.class)) {
                Object instanceId;
                ArrayList queriedGroups;
                Object asgroups;
                TransactionResource db3;
                List groups = Lists.newArrayList();
                ConcurrentHashMap<String, LoadBalancerAutoScalingGroup> allGroupMap = new ConcurrentHashMap<String, LoadBalancerAutoScalingGroup>();
                try (TransactionResource db22 = Entities.transactionFor(LoadBalancerAutoScalingGroup.class);){
                    groups = Entities.query((Object)((Object)LoadBalancerAutoScalingGroup.named()), (boolean)true);
                    db22.commit();
                    for (LoadBalancerAutoScalingGroup g : groups) {
                        allGroupMap.put(g.getName(), g);
                    }
                }
                catch (Exception db22) {
                    // empty catch block
                }
                ConcurrentHashMap<String, LoadBalancerAutoScalingGroup> groupToQuery = new ConcurrentHashMap<String, LoadBalancerAutoScalingGroup>();
                Date current = new Date(System.currentTimeMillis());
                for (LoadBalancerAutoScalingGroup group : groups) {
                    Date lastUpdate = group.getLastUpdateTimestamp();
                    int elapsedSec = (int)((double)(current.getTime() - lastUpdate.getTime()) / 1000.0);
                    if (elapsedSec <= AUTOSCALE_GROUP_CHECK_INTERVAL_SEC) continue;
                    try {
                        db3 = Entities.transactionFor(LoadBalancerAutoScalingGroup.class);
                        Throwable throwable = null;
                        try {
                            LoadBalancerAutoScalingGroup update = (LoadBalancerAutoScalingGroup)((Object)Entities.uniqueResult((Object)((Object)group)));
                            update.setLastUpdateTimestamp(current);
                            Entities.persist((Object)((Object)update));
                            db3.commit();
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                        finally {
                            if (db3 != null) {
                                if (throwable != null) {
                                    try {
                                        db3.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    db3.close();
                                }
                            }
                        }
                    }
                    catch (Exception db3) {
                        // empty catch block
                    }
                    groupToQuery.put(group.getName(), group);
                }
                if (groupToQuery.size() <= 0) {
                    return;
                }
                try {
                    DescribeAutoScalingGroupsResponseType response = EucalyptusActivityTasks.getInstance().describeAutoScalingGroups(Lists.newArrayList(groupToQuery.keySet()));
                    DescribeAutoScalingGroupsResult result = response.getDescribeAutoScalingGroupsResult();
                    asgroups = result.getAutoScalingGroups();
                    queriedGroups = asgroups.getMember();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Failed to describe autoscaling groups", (Throwable)ex);
                    return;
                }
                ConcurrentHashMap<String, LoadBalancerServoInstance> servoMap = new ConcurrentHashMap<String, LoadBalancerServoInstance>();
                try {
                    TransactionResource db4 = Entities.transactionFor(LoadBalancerServoInstance.class);
                    asgroups = null;
                    try {
                        List result = Entities.query((Object)((Object)LoadBalancerServoInstance.named()), (boolean)true);
                        db4.commit();
                        for (LoadBalancerServoInstance inst : result) {
                            servoMap.put(inst.getInstanceId(), inst);
                        }
                    }
                    catch (Throwable x2) {
                        asgroups = x2;
                        throw x2;
                    }
                    finally {
                        if (db4 != null) {
                            if (asgroups != null) {
                                try {
                                    db4.close();
                                }
                                catch (Throwable x2) {
                                    ((Throwable)asgroups).addSuppressed(x2);
                                }
                            } else {
                                db4.close();
                            }
                        }
                    }
                }
                catch (Exception db4) {
                    // empty catch block
                }
                ArrayList newServos = Lists.newArrayList();
                ConcurrentHashMap<String, Instance> foundInstances = new ConcurrentHashMap<String, Instance>();
                for (Object asg : queriedGroups) {
                    Instances instances = asg.getInstances();
                    if (instances == null || instances.getMember() == null || instances.getMember().size() <= 0) continue;
                    for (Instance instance : instances.getMember()) {
                        instanceId = instance.getInstanceId();
                        foundInstances.put((String)instanceId, instance);
                        if (servoMap.containsKey(instanceId)) continue;
                        try {
                            LoadBalancerDnsRecord dns;
                            LoadBalancerSecurityGroup sgroup;
                            LoadBalancerZone zone;
                            Object lb;
                            LoadBalancerAutoScalingGroup group = (LoadBalancerAutoScalingGroup)((Object)allGroupMap.get(asg.getAutoScalingGroupName()));
                            if (group == null) {
                                throw new IllegalArgumentException("The group with name " + asg.getAutoScalingGroupName() + " not found in the database");
                            }
                            LoadBalancer.LoadBalancerCoreView lbView = group.getLoadBalancer();
                            try {
                                lb = LoadBalancer.LoadBalancerEntityTransform.INSTANCE.apply(lbView);
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"unable to transfrom loadbalancer from the viewer", (Throwable)ex);
                                throw ex;
                            }
                            LoadBalancerZone.LoadBalancerZoneCoreView zoneView = null;
                            for (LoadBalancerZone.LoadBalancerZoneCoreView z : ((LoadBalancer)((Object)lb)).getZones()) {
                                if (!z.getName().equals(instance.getAvailabilityZone())) continue;
                                zoneView = z;
                                break;
                            }
                            if (zoneView == null) {
                                throw new Exception("No availability zone with name=" + instance.getAvailabilityZone() + " found for loadbalancer " + lb.getDisplayName());
                            }
                            LoadBalancerSecurityGroup.LoadBalancerSecurityGroupCoreView sgroupView = ((LoadBalancer)((Object)lb)).getGroup();
                            if (sgroupView == null && ((LoadBalancer)((Object)lb)).getVpcId() == null) {
                                throw new Exception("No security group is found for loadbalancer " + lb.getDisplayName());
                            }
                            LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView dnsView = ((LoadBalancer)((Object)lb)).getDns();
                            try {
                                zone = LoadBalancerZone.LoadBalancerZoneEntityTransform.INSTANCE.apply(zoneView);
                                sgroup = sgroupView == null ? null : LoadBalancerSecurityGroup.LoadBalancerSecurityGroupEntityTransform.INSTANCE.apply(sgroupView);
                                dns = LoadBalancerDnsRecord.LoadBalancerDnsRecordEntityTransform.INSTANCE.apply(dnsView);
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"unable to transform entity", (Throwable)ex);
                                throw ex;
                            }
                            LoadBalancerServoInstance newInstance = LoadBalancerServoInstance.newInstance(zone, sgroup, dns, group, (String)instanceId);
                            newServos.add(newInstance);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Failed to construct new servo instance", (Throwable)ex);
                        }
                    }
                }
                if (newServos.size() > 0) {
                    try {
                        Object asg;
                        db3 = Entities.transactionFor(LoadBalancerServoInstance.class);
                        asg = null;
                        try {
                            for (LoadBalancerServoInstance instance2 : newServos) {
                                Entities.persist((Object)((Object)instance2));
                            }
                            db3.commit();
                        }
                        catch (Throwable x2) {
                            asg = x2;
                            throw x2;
                        }
                        finally {
                            if (db3 != null) {
                                if (asg != null) {
                                    try {
                                        db3.close();
                                    }
                                    catch (Throwable x2) {
                                        ((Throwable)asg).addSuppressed(x2);
                                    }
                                } else {
                                    db3.close();
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Failed to persist the servo instance record", (Throwable)ex);
                    }
                }
                ArrayList servoRecords = Lists.newArrayList();
                for (String groupName : groupToQuery.keySet()) {
                    LoadBalancerAutoScalingGroup group = (LoadBalancerAutoScalingGroup)((Object)groupToQuery.get(groupName));
                    servoRecords.addAll(group.getServos());
                }
                for (LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView instanceView : servoRecords) {
                    LoadBalancerServoInstance instance;
                    LoadBalancerServoInstance.STATE curState;
                    if (!foundInstances.containsKey(instanceView.getInstanceId()) && !instanceView.getState().equals((Object)LoadBalancerServoInstance.STATE.Retired)) {
                        LoadBalancerServoInstance instance2;
                        try {
                            instance2 = LoadBalancerServoInstance.LoadBalancerServoInstanceEntityTransform.INSTANCE.apply(instanceView);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"unable to transform servo instance from the view", (Throwable)ex);
                            continue;
                        }
                        try {
                            TransactionResource db5 = Entities.transactionFor(LoadBalancerServoInstance.class);
                            instanceId = null;
                            try {
                                LoadBalancerServoInstance update = (LoadBalancerServoInstance)((Object)Entities.uniqueResult((Object)((Object)instance2)));
                                update.setState(LoadBalancerServoInstance.STATE.Error);
                                Entities.persist((Object)((Object)update));
                                db5.commit();
                            }
                            catch (Throwable x2) {
                                instanceId = x2;
                                throw x2;
                            }
                            finally {
                                if (db5 == null) continue;
                                if (instanceId != null) {
                                    try {
                                        db5.close();
                                    }
                                    catch (Throwable x2) {
                                        ((Throwable)instanceId).addSuppressed(x2);
                                    }
                                    continue;
                                }
                                db5.close();
                            }
                        }
                        catch (Exception db5) {}
                        continue;
                    }
                    Instance instanceCurrent = (Instance)foundInstances.get(instanceView.getInstanceId());
                    String healthState = instanceCurrent.getHealthStatus();
                    String lifecycleState = instanceCurrent.getLifecycleState();
                    LoadBalancerServoInstance.STATE newState = curState = instanceView.getState();
                    if (healthState != null && !healthState.equals("Healthy")) {
                        newState = LoadBalancerServoInstance.STATE.Error;
                    } else if (lifecycleState != null) {
                        switch (lifecycleState) {
                            case "Pending": {
                                newState = LoadBalancerServoInstance.STATE.Pending;
                                break;
                            }
                            case "Quarantined": {
                                newState = LoadBalancerServoInstance.STATE.Error;
                                break;
                            }
                            case "InService": {
                                newState = LoadBalancerServoInstance.STATE.InService;
                                break;
                            }
                            case "Terminating": 
                            case "Terminated": {
                                newState = LoadBalancerServoInstance.STATE.OutOfService;
                            }
                        }
                    }
                    if (curState.equals((Object)LoadBalancerServoInstance.STATE.Retired) || curState.equals((Object)newState)) continue;
                    try {
                        instance = LoadBalancerServoInstance.LoadBalancerServoInstanceEntityTransform.INSTANCE.apply(instanceView);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"unable to transform servo instance from the view", (Throwable)ex);
                        continue;
                    }
                    try {
                        TransactionResource db6 = Entities.transactionFor(LoadBalancerServoInstance.class);
                        Throwable throwable = null;
                        try {
                            LoadBalancerServoInstance update = (LoadBalancerServoInstance)((Object)Entities.uniqueResult((Object)((Object)instance)));
                            update.setState(newState);
                            Entities.persist((Object)((Object)update));
                            db6.commit();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (db6 == null) continue;
                            if (throwable != null) {
                                try {
                                    db6.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            db6.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static class TagCreator
    extends AbstractEventHandler<NewLoadbalancerEvent> {
        public static final String TAG_KEY = "Name";
        public static final String TAG_VALUE = "loadbalancer-resources";
        private String sgroup = null;

        protected TagCreator(EventHandlerChain<NewLoadbalancerEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(NewLoadbalancerEvent evt) throws EventHandlerException {
            try {
                StoredResult result = this.chain.findHandler(SecurityGroupSetup.class);
                this.sgroup = (String)result.getResult().get(1);
            }
            catch (Exception ex) {
                LOG.warn((Object)"could not find the security group for the loadbalancer", (Throwable)ex);
                this.sgroup = null;
            }
            if (this.sgroup != null) {
                boolean tagGroup;
                try {
                    LoadBalancer lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
                    tagGroup = lb.getVpcId() == null;
                }
                catch (NoSuchElementException ex) {
                    throw new EventHandlerException("Failed to find the loadbalancer " + evt.getLoadBalancer(), ex);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("Failed due to query exception", ex);
                }
                if (tagGroup) {
                    try {
                        EucalyptusActivityTasks.getInstance().createTags(TAG_KEY, TAG_VALUE, Lists.newArrayList((Object[])new String[]{this.sgroup}));
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"could not tag the security group", (Throwable)ex);
                    }
                }
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
            if (this.sgroup != null) {
                try {
                    EucalyptusActivityTasks.getInstance().deleteTags(TAG_KEY, TAG_VALUE, Lists.newArrayList((Object[])new String[]{this.sgroup}));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    static class SecurityGroupSetup
    extends AbstractEventHandler<NewLoadbalancerEvent>
    implements StoredResult<String> {
        private String createdGroup = null;
        private String createdGroupId = null;
        private String groupOwnerAccountId = null;
        private boolean rollbackCreate = true;
        private NewLoadbalancerEvent event = null;

        SecurityGroupSetup(EventHandlerChain<NewLoadbalancerEvent> chain) {
            super(chain);
        }

        static String generateDefaultVPCSecurityGroupName(String vpcId) {
            return String.format("default_elb_%s", UUID.nameUUIDFromBytes(vpcId.getBytes(StandardCharsets.UTF_8)).toString());
        }

        @Override
        public void apply(NewLoadbalancerEvent evt) throws EventHandlerException {
            block35: {
                LoadBalancer.LoadBalancerCoreView lb;
                LoadBalancer lbEntity;
                this.event = evt;
                try {
                    lbEntity = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
                    lb = lbEntity.getCoreView();
                }
                catch (NoSuchElementException ex) {
                    throw new EventHandlerException("Could not find the loadbalancer with name=" + evt.getLoadBalancer(), ex);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("Error while looking for loadbalancer with name=" + evt.getLoadBalancer(), ex);
                }
                if (lb.getVpcId() == null) {
                    block34: {
                        List<SecurityGroupItemType> groups;
                        boolean groupFound;
                        String groupDesc;
                        String groupName;
                        block33: {
                            groupName = String.format("euca-internal-%s-%s", lb.getOwnerAccountNumber(), lb.getDisplayName());
                            groupDesc = String.format("group for loadbalancer %s", evt.getLoadBalancer());
                            groupFound = false;
                            try {
                                groups = EucalyptusActivityTasks.getInstance().describeSystemSecurityGroups(Lists.newArrayList((Object[])new String[]{groupName}));
                                if (groups == null) break block33;
                                for (SecurityGroupItemType group : groups) {
                                    if (!groupName.equals(group.getGroupName()) || group.getVpcId() != null) continue;
                                    groupFound = true;
                                    this.createdGroup = groupName;
                                    this.createdGroupId = group.getGroupId();
                                    this.groupOwnerAccountId = group.getAccountId();
                                    break;
                                }
                            }
                            catch (Exception ex) {
                                groupFound = false;
                            }
                        }
                        if (!groupFound) {
                            try {
                                EucalyptusActivityTasks.getInstance().createSystemSecurityGroup(groupName, groupDesc);
                                this.createdGroup = groupName;
                                groups = EucalyptusActivityTasks.getInstance().describeSystemSecurityGroups(Lists.newArrayList((Object[])new String[]{groupName}));
                                if (groups == null) break block34;
                                for (SecurityGroupItemType group : groups) {
                                    if (!groupName.equals(group.getGroupName()) || group.getVpcId() != null) continue;
                                    this.createdGroupId = group.getGroupId();
                                    this.groupOwnerAccountId = group.getAccountId();
                                    break;
                                }
                            }
                            catch (Exception ex) {
                                throw new EventHandlerException("Failed to create the security group for loadbalancer", ex);
                            }
                        }
                    }
                    if (this.createdGroup == null || this.groupOwnerAccountId == null) {
                        throw new EventHandlerException("Failed to create the security group for loadbalancer");
                    }
                    try {
                        TransactionResource db = Entities.transactionFor(LoadBalancerSecurityGroup.class);
                        Iterator<SecurityGroupItemType> i$ = null;
                        try {
                            try {
                                Entities.uniqueResult((Object)((Object)LoadBalancerSecurityGroup.named(lbEntity, this.groupOwnerAccountId, this.createdGroup)));
                            }
                            catch (NoSuchElementException ex) {
                                Entities.persist((Object)((Object)LoadBalancerSecurityGroup.create(lbEntity, this.groupOwnerAccountId, this.createdGroup)));
                            }
                            db.commit();
                            break block35;
                        }
                        catch (Throwable x2) {
                            i$ = x2;
                            throw x2;
                        }
                        finally {
                            if (db != null) {
                                if (i$ != null) {
                                    try {
                                        db.close();
                                    }
                                    catch (Throwable x2) {
                                        ((Throwable)((Object)i$)).addSuppressed(x2);
                                    }
                                } else {
                                    db.close();
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        throw new EventHandlerException("Error while persisting security group", ex);
                    }
                }
                if (lb.getSecurityGroupIdsToNames().isEmpty()) {
                    SecurityGroupItemType elbVpcGroup;
                    String userId;
                    String groupName = SecurityGroupSetup.generateDefaultVPCSecurityGroupName(lb.getVpcId());
                    String groupDesc = String.format("ELB created security group used when no security group is specified during ELB creation - modifications could impact traffic to future ELBs", new Object[0]);
                    final Account account = evt.getContext().getAccount();
                    try {
                        userId = account.lookupAdmin().getUserId();
                    }
                    catch (AuthException e) {
                        throw Exceptions.toUndeclared((Throwable)e);
                    }
                    List<SecurityGroupItemType> groups = EucalyptusActivityTasks.getInstance().describeUserSecurityGroupsByName(userId, lb.getVpcId(), groupName);
                    if (groups.isEmpty()) {
                        EucalyptusActivityTasks.getInstance().createUserSecurityGroup(userId, groupName, groupDesc);
                        List<SecurityGroupItemType> createdGroupList = EucalyptusActivityTasks.getInstance().describeUserSecurityGroupsByName(userId, lb.getVpcId(), groupName);
                        elbVpcGroup = (SecurityGroupItemType)Iterables.getOnlyElement(createdGroupList);
                    } else {
                        elbVpcGroup = (SecurityGroupItemType)Iterables.get(groups, (int)0);
                    }
                    Entities.asDistinctTransaction(LoadBalancer.class, (Predicate)new Predicate<String>(){

                        public boolean apply(@Nullable String loadBalancerName) {
                            try {
                                LoadBalancer lb = (LoadBalancer)((Object)Entities.uniqueResult((Object)((Object)LoadBalancer.namedByAccountId(account.getAccountNumber(), loadBalancerName))));
                                lb.setSecurityGroupRefs(Lists.newArrayList((Object[])new LoadBalancerSecurityGroupRef[]{new LoadBalancerSecurityGroupRef(elbVpcGroup.getGroupId(), elbVpcGroup.getGroupName())}));
                            }
                            catch (TransactionException e) {
                                throw Exceptions.toUndeclared((Throwable)e);
                            }
                            return true;
                        }
                    }).apply((Object)lb.getDisplayName());
                    this.rollbackCreate = false;
                    this.createdGroupId = elbVpcGroup.getGroupId();
                    this.createdGroup = elbVpcGroup.getGroupName();
                    this.groupOwnerAccountId = elbVpcGroup.getAccountId();
                }
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
            LoadBalancer lb;
            if (this.createdGroup == null || !this.rollbackCreate) {
                return;
            }
            try {
                lb = LoadBalancers.getLoadbalancer(this.event.getContext(), this.event.getLoadBalancer());
            }
            catch (Exception ex) {
                return;
            }
            try {
                EucalyptusActivityTasks.getInstance().deleteSystemSecurityGroup(this.createdGroup);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try (TransactionResource db2 = Entities.transactionFor(LoadBalancerSecurityGroup.class);){
                LoadBalancerSecurityGroup group = (LoadBalancerSecurityGroup)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerSecurityGroup.named(lb, this.groupOwnerAccountId, this.createdGroup))));
                group.setState(LoadBalancerSecurityGroup.STATE.OutOfService);
                group.setLoadBalancer(null);
                Entities.persist((Object)((Object)group));
                db2.commit();
            }
            catch (NoSuchElementException db2) {
            }
            catch (Exception ex) {
                LOG.error((Object)"failed to mark the security group OutOfService", (Throwable)ex);
            }
        }

        @Override
        public List<String> getResult() {
            ArrayList result = Lists.newArrayList();
            if (this.createdGroup != null) {
                result.add(this.createdGroup);
            }
            if (this.createdGroupId != null) {
                result.add(this.createdGroupId);
            }
            return result;
        }
    }

    static class DNSANameSetup
    extends AbstractEventHandler<NewLoadbalancerEvent> {
        private String dnsName = null;
        private String dnsZone = null;

        DNSANameSetup(EventHandlerChain<NewLoadbalancerEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(NewLoadbalancerEvent evt) throws EventHandlerException {
            LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView dns;
            try {
                LoadBalancer lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
                dns = lb.getDns();
            }
            catch (NoSuchElementException ex) {
                throw new EventHandlerException("Failed to find the loadbalancer " + evt.getLoadBalancer(), ex);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed due to query exception", ex);
            }
            if (dns == null) {
                throw new EventHandlerException("No dns record is found with the loadbalancer " + evt.getLoadBalancer());
            }
            try {
                EucalyptusActivityTasks.getInstance().removeMultiARecord(dns.getZone(), dns.getName());
                EucalyptusActivityTasks.getInstance().createARecord(dns.getZone(), dns.getName());
                this.dnsName = dns.getName();
                this.dnsZone = dns.getZone();
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to create new multiA name record");
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
            if (this.dnsName != null && this.dnsZone != null) {
                try {
                    EucalyptusActivityTasks.getInstance().removeMultiARecord(this.dnsZone, this.dnsName);
                }
                catch (Exception ex) {
                    LOG.warn((Object)String.format("failed to remove the multi A record (%s-%s)", this.dnsZone, this.dnsName), (Throwable)ex);
                }
            }
        }
    }

    static class IAMPolicySetup
    extends AbstractEventHandler<NewLoadbalancerEvent> {
        static final String SERVO_ROLE_POLICY_NAME = "euca-internal-loadbalancer-vm-policy";
        private static final String SERVO_ROLE_POLICY_DOCUMENT = "{\"Statement\":[{\"Action\": [\"elasticloadbalancing:DescribeLoadBalancersByServo\", \"elasticloadbalancing:PutServoStates\", \"elasticloadbalancing:DescribeLoadBalancerAttributes\"],\"Effect\": \"Allow\",\"Resource\": \"*\"}]}";

        protected IAMPolicySetup(EventHandlerChain<NewLoadbalancerEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(NewLoadbalancerEvent evt) throws EventHandlerException {
            boolean putPolicy;
            String roleName = null;
            try {
                StoredResult roleResult = this.chain.findHandler(IAMRoleSetup.class);
                if (roleResult.getResult() != null && roleResult.getResult().size() > 0) {
                    roleName = (String)roleResult.getResult().get(0);
                }
                if (roleName == null) {
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                throw new EventHandlerException("could not find the role name for loadbalancer vm");
            }
            GetRolePolicyResult policy = null;
            try {
                List<String> policies = EucalyptusActivityTasks.getInstance().listRolePolicies(roleName);
                if (policies.contains(SERVO_ROLE_POLICY_NAME)) {
                    policy = EucalyptusActivityTasks.getInstance().getRolePolicy(roleName, SERVO_ROLE_POLICY_NAME);
                }
            }
            catch (Exception policies) {
                // empty catch block
            }
            if (policy == null || policy.getPolicyName() == null || !policy.getPolicyName().equals(SERVO_ROLE_POLICY_NAME)) {
                putPolicy = true;
            } else if (!SERVO_ROLE_POLICY_DOCUMENT.toLowerCase().equals(policy.getPolicyDocument().toLowerCase())) {
                try {
                    EucalyptusActivityTasks.getInstance().deleteRolePolicy(roleName, SERVO_ROLE_POLICY_NAME);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"failed to delete role policy", (Throwable)ex);
                }
                putPolicy = true;
            } else {
                putPolicy = false;
            }
            if (putPolicy) {
                try {
                    EucalyptusActivityTasks.getInstance().putRolePolicy(roleName, SERVO_ROLE_POLICY_NAME, SERVO_ROLE_POLICY_DOCUMENT);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to put role policy for loadbalancer vm");
                }
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
        }
    }

    static class InstanceProfileSetup
    extends AbstractEventHandler<NewLoadbalancerEvent>
    implements StoredResult<String> {
        public static final String DEFAULT_INSTANCE_PROFILE_PATH_PREFIX = "/internal/loadbalancer";
        public static final String INSTANCE_PROFILE_NAME_PREFIX = "loadbalancer-vm";
        private InstanceProfileType instanceProfile = null;

        protected InstanceProfileSetup(EventHandlerChain<NewLoadbalancerEvent> chain) {
            super(chain);
        }

        @Override
        public List<String> getResult() {
            return this.instanceProfile != null ? Lists.newArrayList((Object[])new String[]{this.instanceProfile.getInstanceProfileName()}) : Lists.newArrayList();
        }

        @Override
        public void apply(NewLoadbalancerEvent evt) throws EventHandlerException {
            String instanceProfileName = String.format("%s-%s-%s", INSTANCE_PROFILE_NAME_PREFIX, evt.getContext().getAccount().getAccountNumber(), evt.getLoadBalancer());
            try {
                List<InstanceProfileType> instanceProfiles = EucalyptusActivityTasks.getInstance().listInstanceProfiles(DEFAULT_INSTANCE_PROFILE_PATH_PREFIX);
                for (InstanceProfileType ip : instanceProfiles) {
                    if (!instanceProfileName.equals(ip.getInstanceProfileName())) continue;
                    this.instanceProfile = ip;
                    break;
                }
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to list instance profiles", ex);
            }
            if (this.instanceProfile == null) {
                try {
                    this.instanceProfile = EucalyptusActivityTasks.getInstance().createInstanceProfile(instanceProfileName, DEFAULT_INSTANCE_PROFILE_PATH_PREFIX);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("Failed to create instance profile", ex);
                }
            }
            if (this.instanceProfile == null) {
                throw new EventHandlerException("No instance profile for loadbalancer VM is found");
            }
            List<String> result = this.chain.findHandler(IAMRoleSetup.class).getResult();
            String lbRoleName = null;
            if (result != null && result.size() > 0) {
                lbRoleName = result.get(0);
            }
            try {
                ArrayList roles = this.instanceProfile.getRoles().getMember();
                boolean roleFound = false;
                for (RoleType role : roles) {
                    if (!role.getRoleName().equals(lbRoleName)) continue;
                    roleFound = true;
                    break;
                }
                if (!roleFound) {
                    throw new NoSuchElementException();
                }
            }
            catch (Exception ex) {
                if (lbRoleName == null) {
                    throw new EventHandlerException("No role name is found for loadbalancer VMs");
                }
                try {
                    EucalyptusActivityTasks.getInstance().addRoleToInstanceProfile(this.instanceProfile.getInstanceProfileName(), lbRoleName);
                }
                catch (Exception ex2) {
                    throw new EventHandlerException("Failed to add role to the instance profile", ex2);
                }
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
        }
    }

    public static class IAMRoleSetup
    extends AbstractEventHandler<NewLoadbalancerEvent>
    implements StoredResult<String> {
        public static final String DEFAULT_ROLE_PATH_PREFIX = "/internal/loadbalancer";
        public static final String ROLE_NAME_PREFIX = "loadbalancer-vm";
        public static final String DEFAULT_ASSUME_ROLE_POLICY = "{\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"Service\":[\"ec2.amazonaws.com\"]},\"Action\":[\"sts:AssumeRole\"]}]}";
        private RoleType role = null;

        protected IAMRoleSetup(EventHandlerChain<NewLoadbalancerEvent> chain) {
            super(chain);
        }

        @Override
        public List<String> getResult() {
            return this.role != null ? Lists.newArrayList((Object[])new String[]{this.role.getRoleName()}) : Lists.newArrayList();
        }

        @Override
        public void apply(NewLoadbalancerEvent evt) throws EventHandlerException {
            String roleName;
            block7: {
                roleName = String.format("%s-%s-%s", ROLE_NAME_PREFIX, evt.getContext().getAccount().getAccountNumber(), evt.getLoadBalancer());
                try {
                    List<RoleType> result = EucalyptusActivityTasks.getInstance().listRoles(DEFAULT_ROLE_PATH_PREFIX);
                    if (result == null) break block7;
                    for (RoleType r : result) {
                        if (!roleName.equals(r.getRoleName())) continue;
                        this.role = r;
                        break;
                    }
                }
                catch (Exception ex) {
                    throw new EventHandlerException("Failed to list IAM roles", ex);
                }
            }
            if (this.role == null) {
                try {
                    this.role = EucalyptusActivityTasks.getInstance().createRole(roleName, DEFAULT_ROLE_PATH_PREFIX, DEFAULT_ASSUME_ROLE_POLICY);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("Failed to create the role for ELB Vms");
                }
            }
            if (this.role == null) {
                throw new EventHandlerException("No role is found for LoadBalancer Vms");
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
        }
    }

    static class AdmissionControl
    extends AbstractEventHandler<NewLoadbalancerEvent> {
        AdmissionControl(EventHandlerChain<NewLoadbalancerEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(NewLoadbalancerEvent evt) throws EventHandlerException {
            List<ClusterInfoType> clusters;
            String emi = LoadBalancerASGroupCreator.IMAGE;
            try {
                List<ImageDetails> images = EucalyptusActivityTasks.getInstance().describeImages(Lists.newArrayList((Object[])new String[]{emi}));
                if (images == null || images.size() <= 0 || !images.get(0).getImageId().toLowerCase().equals(emi.toLowerCase())) {
                    throw new EventHandlerException("No loadbalancer EMI is found");
                }
            }
            catch (EventHandlerException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new EventHandlerException("failed to validate the loadbalancer EMI", ex);
            }
            ArrayList requestedZones = Lists.newArrayList(evt.getZones());
            try {
                clusters = EucalyptusActivityTasks.getInstance().describeAvailabilityZones(true);
                for (ClusterInfoType cc : clusters) {
                    requestedZones.remove(cc.getZoneName());
                }
            }
            catch (Exception ex) {
                throw new EventHandlerException("failed to validate the requested zones", ex);
            }
            if (requestedZones.size() > 0) {
                throw new EventHandlerException("unknown zone is requested");
            }
            String instanceType = LoadBalancerASGroupCreator.INSTANCE_TYPE;
            int numVm = 1;
            try {
                numVm = Integer.parseInt(VM_PER_ZONE);
            }
            catch (NumberFormatException ex) {
                LOG.warn((Object)"unable to parse loadbalancer_num_vm");
            }
            for (String zone : evt.getZones()) {
                int capacity = this.findAvailableResources(clusters, zone, instanceType);
                if (numVm <= capacity) continue;
                throw new EventHandlerException(String.format("Not enough resources in %s", zone));
            }
            String keyName = LoadBalancerASGroupCreator.KEYNAME;
            if (keyName != null && keyName.length() > 0) {
                try {
                    List<DescribeKeyPairsResponseItemType> keypairs = EucalyptusActivityTasks.getInstance().describeKeyPairs(Lists.newArrayList((Object[])new String[]{keyName}));
                    if (keypairs == null || keypairs.size() <= 0 || !keypairs.get(0).getKeyName().equals(keyName)) {
                        throw new Exception();
                    }
                }
                catch (Exception ex) {
                    throw new EventHandlerException(String.format("The configured keyname is not found", new Object[0]));
                }
            }
        }

        private int findAvailableResources(List<ClusterInfoType> clusters, String zoneName, String instanceType) {
            block3: for (int i = 0; i < clusters.size(); ++i) {
                ClusterInfoType cc = clusters.get(i);
                if (!zoneName.equals(cc.getZoneName())) continue;
                for (int j = i + 1; j < clusters.size(); ++j) {
                    String state;
                    String[] tokens;
                    ClusterInfoType candidate = clusters.get(j);
                    if (candidate.getZoneName() == null || !candidate.getZoneName().toLowerCase().contains(instanceType.toLowerCase()) || (tokens = (state = candidate.getZoneState()).split("/")).length <= 0) continue;
                    try {
                        String strNum = tokens[0].trim().replaceFirst("0+", "");
                        if (strNum.length() <= 0) {
                            strNum = "0";
                        }
                        return Integer.parseInt(strNum);
                    }
                    catch (NumberFormatException ex) {
                        break block3;
                    }
                    catch (Exception ex) {
                        break block3;
                    }
                }
                break;
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public void rollback() throws EventHandlerException {
        }
    }
}

