/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.activities;

import com.eucalyptus.compute.common.ClusterInfoType;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancerBackendInstance;
import com.eucalyptus.loadbalancing.LoadBalancerZone;
import com.eucalyptus.loadbalancing.LoadBalancers;
import com.eucalyptus.loadbalancing.activities.AbstractEventHandler;
import com.eucalyptus.loadbalancing.activities.EnabledZoneEvent;
import com.eucalyptus.loadbalancing.activities.EucalyptusActivityTasks;
import com.eucalyptus.loadbalancing.activities.EventHandlerChain;
import com.eucalyptus.loadbalancing.activities.EventHandlerChainException;
import com.eucalyptus.loadbalancing.activities.EventHandlerChainNew;
import com.eucalyptus.loadbalancing.activities.EventHandlerException;
import com.eucalyptus.loadbalancing.activities.LoadBalancerASGroupCreator;
import com.eucalyptus.loadbalancing.activities.LoadBalancerAutoScalingGroup;
import com.eucalyptus.loadbalancing.activities.NewLoadbalancerEvent;
import com.eucalyptus.loadbalancing.activities.StoredResult;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class EventHandlerChainEnableZone
extends EventHandlerChain<EnabledZoneEvent> {
    private static Logger LOG = Logger.getLogger(EventHandlerChainEnableZone.class);

    @Override
    public EventHandlerChain<EnabledZoneEvent> build() {
        this.insert(new CheckAndModifyRequest(this));
        this.insert(new CreateOrUpdateAutoscalingGroup(this));
        this.insert(new PersistUpdatedZones(this));
        this.insert(new PersistBackendInstanceState(this));
        return this;
    }

    private static class PersistBackendInstanceState
    extends AbstractEventHandler<EnabledZoneEvent> {
        protected PersistBackendInstanceState(EventHandlerChain<EnabledZoneEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(EnabledZoneEvent evt) throws EventHandlerException {
            LoadBalancer lb;
            try {
                lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
            }
            catch (NoSuchElementException ex) {
                LOG.warn((Object)("Could not find the loadbalancer with name=" + evt.getLoadBalancer()), (Throwable)ex);
                return;
            }
            catch (Exception ex) {
                LOG.warn((Object)("Error while looking for loadbalancer with name=" + evt.getLoadBalancer()), (Throwable)ex);
                return;
            }
            try {
                for (String enabledZone : evt.getZones()) {
                    LoadBalancerZone zone = LoadBalancers.findZone(lb, enabledZone);
                    for (LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView instance : zone.getBackendInstances()) {
                        try {
                            TransactionResource db = Entities.transactionFor(LoadBalancerBackendInstance.class);
                            Throwable throwable = null;
                            try {
                                LoadBalancerBackendInstance update = (LoadBalancerBackendInstance)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerBackendInstance.named(lb, instance.getInstanceId()))));
                                update.setReasonCode("");
                                update.setDescription("");
                                db.commit();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (db == null) continue;
                                if (throwable != null) {
                                    try {
                                        db.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                db.close();
                            }
                        }
                        catch (NoSuchElementException ex) {
                            LOG.warn((Object)"failed to find the backend instance");
                        }
                        catch (Exception ex) {
                            LOG.warn((Object)"failed to query the backend instance", (Throwable)ex);
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"unable to update backend instances after enabling zone", (Throwable)ex);
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
        }
    }

    private static class PersistUpdatedZones
    extends AbstractEventHandler<EnabledZoneEvent> {
        private List<LoadBalancerZone> persistedZones = Lists.newArrayList();

        protected PersistUpdatedZones(EventHandlerChain<EnabledZoneEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(EnabledZoneEvent evt) throws EventHandlerException {
            LoadBalancer lb;
            try {
                lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
            }
            catch (NoSuchElementException ex) {
                throw new EventHandlerException("Could not find the loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Error while looking for loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            StoredResult updated = this.getChain().findHandler(CreateOrUpdateAutoscalingGroup.class);
            if (updated != null && updated.getResult() != null) {
                for (String zone : updated.getResult()) {
                    try {
                        TransactionResource db = Entities.transactionFor(LoadBalancerZone.class);
                        Throwable throwable = null;
                        try {
                            try {
                                LoadBalancerZone exist = (LoadBalancerZone)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerZone.named(lb, zone))));
                                exist.setState(LoadBalancerZone.STATE.InService);
                            }
                            catch (NoSuchElementException ex) {
                                String subnetId = evt.getZoneToSubnetIdMap() == null ? null : evt.getZoneToSubnetIdMap().get(zone);
                                LoadBalancerZone newZone = LoadBalancerZone.create(lb, zone, subnetId);
                                newZone.setState(LoadBalancerZone.STATE.InService);
                                Entities.persist((Object)((Object)newZone));
                                this.persistedZones.add(newZone);
                            }
                            db.commit();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (db == null) continue;
                            if (throwable != null) {
                                try {
                                    db.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            db.close();
                        }
                    }
                    catch (Exception ex) {
                        LOG.debug((Object)"Error adding load balancer zone", (Throwable)ex);
                    }
                }
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
            for (LoadBalancerZone zone : this.persistedZones) {
                try {
                    TransactionResource db = Entities.transactionFor(LoadBalancerZone.class);
                    Throwable throwable = null;
                    try {
                        LoadBalancerZone update = (LoadBalancerZone)((Object)Entities.uniqueResult((Object)((Object)zone)));
                        update.setState(LoadBalancerZone.STATE.OutOfService);
                        db.commit();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (db == null) continue;
                        if (throwable != null) {
                            try {
                                db.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        db.close();
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"could not mark out of state for the zone", (Throwable)ex);
                }
            }
        }
    }

    private static class CreateOrUpdateAutoscalingGroup
    extends AbstractEventHandler<EnabledZoneEvent>
    implements StoredResult<String> {
        private String groupName = null;
        private List<String> newZones = null;
        private List<String> oldZones = null;
        private LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupCoreView group = null;

        protected CreateOrUpdateAutoscalingGroup(EventHandlerChain<EnabledZoneEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(EnabledZoneEvent evt) throws EventHandlerException {
            LoadBalancer lb;
            ArrayList zones = Lists.newArrayList(evt.getZones());
            if (zones == null || zones.size() <= 0) {
                return;
            }
            try {
                lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
            }
            catch (NoSuchElementException ex) {
                throw new EventHandlerException("Could not find the loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Error while looking for loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            this.group = lb.getAutoScaleGroup();
            if (this.group == null) {
                EventHandlerChain<NewLoadbalancerEvent> newChain = new EventHandlerChain<NewLoadbalancerEvent>(){

                    @Override
                    public EventHandlerChain<NewLoadbalancerEvent> build() {
                        this.insert(new EventHandlerChainNew.IAMRoleSetup(this));
                        this.insert(new EventHandlerChainNew.InstanceProfileSetup(this));
                        this.insert(new EventHandlerChainNew.SecurityGroupSetup(this));
                        this.insert(new LoadBalancerASGroupCreator(this, EventHandlerChainNew.getCapacityPerZone()));
                        return this;
                    }
                }.build();
                try {
                    NewLoadbalancerEvent newEvt = new NewLoadbalancerEvent();
                    newEvt.setContext(evt.getContext());
                    newEvt.setLoadBalancer(evt.getLoadBalancer());
                    newEvt.setZones(evt.getZones());
                    newEvt.setZoneToSubnetIdMap(evt.getZoneToSubnetIdMap());
                    newChain.execute(newEvt);
                    this.newZones = Lists.newArrayList(evt.getZones());
                    this.oldZones = Lists.newArrayList();
                }
                catch (EventHandlerChainException e) {
                    throw new EventHandlerException("failed to create autoscaling group", (Throwable)((Object)e));
                }
            }
            this.groupName = this.group.getName();
            ArrayList requestedZones = Lists.newArrayList(evt.getZones());
            ArrayList currentZones = Lists.newArrayList((Iterable)Collections2.filter(lb.getZones(), (Predicate)new Predicate<LoadBalancerZone.LoadBalancerZoneCoreView>(){

                public boolean apply(@Nullable LoadBalancerZone.LoadBalancerZoneCoreView arg0) {
                    return arg0.getState().equals((Object)LoadBalancerZone.STATE.InService);
                }
            }));
            HashSet availableZones = Sets.newHashSet((Iterable)Iterables.transform((Iterable)currentZones, LoadBalancerZone.LoadBalancerZoneCoreView.name()));
            HashSet newZones = Sets.newHashSet((Iterable)Iterables.concat((Iterable)availableZones, (Iterable)requestedZones));
            if (Sets.difference((Set)newZones, (Set)availableZones).size() > 0) {
                try {
                    LoadBalancerAutoScalingGroup scaleGroup;
                    int capacityPerZone = Integer.parseInt(EventHandlerChainNew.VM_PER_ZONE);
                    if (capacityPerZone <= 0) {
                        capacityPerZone = 1;
                    }
                    int newCapacity = capacityPerZone * newZones.size();
                    try {
                        scaleGroup = LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupEntityTransform.INSTANCE.apply(this.group);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"unable to transform scaling group from the view", (Throwable)ex);
                        throw ex;
                    }
                    EucalyptusActivityTasks.getInstance().updateAutoScalingGroup(this.group.getName(), Lists.newArrayList((Iterable)newZones), newCapacity);
                    try (TransactionResource db = Entities.transactionFor(LoadBalancerAutoScalingGroup.class);){
                        LoadBalancerAutoScalingGroup update = (LoadBalancerAutoScalingGroup)((Object)Entities.uniqueResult((Object)((Object)scaleGroup)));
                        update.setCapacity(newCapacity);
                        db.commit();
                    }
                    catch (NoSuchElementException ex) {
                        LOG.error((Object)"failed to find the autoscaling group record", (Throwable)ex);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"failed to update the autoscaling group record", (Throwable)ex);
                    }
                    this.newZones = Lists.newArrayList((Iterable)newZones);
                    this.oldZones = Lists.newArrayList((Iterable)availableZones);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to update autoscaling group", ex);
                }
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
            if (this.oldZones != null && this.groupName != null) {
                try {
                    LoadBalancerAutoScalingGroup scaleGroup;
                    int capacityPerZone = Integer.parseInt(EventHandlerChainNew.VM_PER_ZONE);
                    if (capacityPerZone <= 0) {
                        capacityPerZone = 1;
                    }
                    int oldCapacity = capacityPerZone * this.oldZones.size();
                    EucalyptusActivityTasks.getInstance().updateAutoScalingGroup(this.groupName, this.oldZones, oldCapacity);
                    try {
                        scaleGroup = LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupEntityTransform.INSTANCE.apply(this.group);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"unable to transform scaling group from the view", (Throwable)ex);
                        throw ex;
                    }
                    try (TransactionResource db = Entities.transactionFor(LoadBalancerAutoScalingGroup.class);){
                        LoadBalancerAutoScalingGroup update = (LoadBalancerAutoScalingGroup)((Object)Entities.uniqueResult((Object)((Object)scaleGroup)));
                        update.setCapacity(oldCapacity);
                        db.commit();
                    }
                    catch (NoSuchElementException ex) {
                        LOG.error((Object)"failed to find the autoscaling group record", (Throwable)ex);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"failed to update the autoscaling group record", (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to update the zone to the original list", ex);
                }
            }
        }

        @Override
        public List<String> getResult() {
            return this.newZones != null ? this.newZones : Lists.newArrayList();
        }
    }

    private static class CheckAndModifyRequest
    extends AbstractEventHandler<EnabledZoneEvent> {
        protected CheckAndModifyRequest(EventHandlerChain<EnabledZoneEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(EnabledZoneEvent evt) throws EventHandlerException {
            LoadBalancer lb;
            try {
                lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
            }
            catch (NoSuchElementException ex) {
                throw new EventHandlerException("Could not find the loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Error while looking for loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            ArrayList availableZones = Lists.newArrayList((Iterable)Collections2.filter(lb.getZones(), (Predicate)new Predicate<LoadBalancerZone.LoadBalancerZoneCoreView>(){

                public boolean apply(@Nullable LoadBalancerZone.LoadBalancerZoneCoreView arg0) {
                    return arg0.getState().equals((Object)LoadBalancerZone.STATE.InService);
                }
            }));
            ArrayList zoneNames = Lists.newArrayList((Iterable)Iterables.transform((Iterable)availableZones, LoadBalancerZone.LoadBalancerZoneCoreView.name()));
            evt.getZones().removeAll(zoneNames);
            try {
                List<ClusterInfoType> zones = EucalyptusActivityTasks.getInstance().describeAvailabilityZones(false);
                List foundZones = Lists.transform(zones, (Function)new Function<ClusterInfoType, String>(){

                    public String apply(@Nullable ClusterInfoType arg0) {
                        return arg0.getZoneName();
                    }
                });
                for (String requestedZone : evt.getZones()) {
                    if (foundZones.contains(requestedZone)) continue;
                    throw new EventHandlerException(String.format("The requested zone %s is not valid", requestedZone));
                }
            }
            catch (EventHandlerException ex) {
                throw ex;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
        }
    }
}

