/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.activities;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancerBackendInstance;
import com.eucalyptus.loadbalancing.LoadBalancerDnsRecord;
import com.eucalyptus.loadbalancing.LoadBalancerZone;
import com.eucalyptus.loadbalancing.LoadBalancers;
import com.eucalyptus.loadbalancing.activities.AbstractEventHandler;
import com.eucalyptus.loadbalancing.activities.DisabledZoneEvent;
import com.eucalyptus.loadbalancing.activities.EucalyptusActivityTasks;
import com.eucalyptus.loadbalancing.activities.EventHandlerChain;
import com.eucalyptus.loadbalancing.activities.EventHandlerChainEnableZone;
import com.eucalyptus.loadbalancing.activities.EventHandlerChainNew;
import com.eucalyptus.loadbalancing.activities.EventHandlerException;
import com.eucalyptus.loadbalancing.activities.LoadBalancerAutoScalingGroup;
import com.eucalyptus.loadbalancing.activities.LoadBalancerServoInstance;
import com.eucalyptus.loadbalancing.activities.StoredResult;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class EventHandlerChainDisableZone
extends EventHandlerChain<DisabledZoneEvent> {
    private static Logger LOG = Logger.getLogger(EventHandlerChainEnableZone.class);

    @Override
    public EventHandlerChain<DisabledZoneEvent> build() {
        this.insert(new CheckAndModifyRequest(this));
        this.insert(new RemoveDnsRecord(this));
        this.insert(new PersistUpdatedServoInstances(this));
        this.insert(new UpdateAutoScalingGroup(this));
        this.insert(new PersistUpdatedZones(this));
        this.insert(new PersistBackendInstanceState(this));
        return this;
    }

    private static class PersistBackendInstanceState
    extends AbstractEventHandler<DisabledZoneEvent> {
        private List<LoadBalancerBackendInstance> updatedInstances = null;

        protected PersistBackendInstanceState(EventHandlerChain<DisabledZoneEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(DisabledZoneEvent evt) throws EventHandlerException {
            LoadBalancer lb;
            try {
                lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
            }
            catch (NoSuchElementException ex) {
                throw new EventHandlerException("Could not find the loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Error while looking for loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            StoredResult updated = this.getChain().findHandler(UpdateAutoScalingGroup.class);
            if (updated != null && updated.getResult() != null) {
                try {
                    this.updatedInstances = Lists.newArrayList();
                    for (String removedZone : updated.getResult()) {
                        LoadBalancerZone zone = LoadBalancers.findZone(lb, removedZone);
                        for (LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView instance : zone.getBackendInstances()) {
                            try {
                                TransactionResource db = Entities.transactionFor(LoadBalancerBackendInstance.class);
                                Throwable throwable = null;
                                try {
                                    LoadBalancerBackendInstance update = (LoadBalancerBackendInstance)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerBackendInstance.named(lb, instance.getInstanceId()))));
                                    update.setState(LoadBalancerBackendInstance.STATE.OutOfService);
                                    update.setReasonCode("ELB");
                                    update.setDescription("Zone disabled");
                                    Entities.persist((Object)((Object)update));
                                    db.commit();
                                    this.updatedInstances.add(update);
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (db == null) continue;
                                    if (throwable != null) {
                                        try {
                                            db.close();
                                        }
                                        catch (Throwable x2) {
                                            throwable.addSuppressed(x2);
                                        }
                                        continue;
                                    }
                                    db.close();
                                }
                            }
                            catch (NoSuchElementException ex) {
                                LOG.warn((Object)"failed to find the backend instance");
                            }
                            catch (Exception ex) {
                                LOG.warn((Object)"failed to query the backend instance", (Throwable)ex);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)"failed to update the backend instance's state to OutOfService", (Throwable)ex);
                }
            }
        }

        @Override
        public void rollback() {
        }
    }

    private static class PersistUpdatedZones
    extends AbstractEventHandler<DisabledZoneEvent> {
        protected PersistUpdatedZones(EventHandlerChain<DisabledZoneEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(DisabledZoneEvent evt) throws EventHandlerException {
            LoadBalancer lb;
            try {
                lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
            }
            catch (NoSuchElementException ex) {
                throw new EventHandlerException("Could not find the loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Error while looking for loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            StoredResult updated = this.getChain().findHandler(UpdateAutoScalingGroup.class);
            if (updated != null && updated.getResult() != null) {
                for (String removedZone : updated.getResult()) {
                    try {
                        TransactionResource db = Entities.transactionFor(LoadBalancerZone.class);
                        Throwable throwable = null;
                        try {
                            LoadBalancerZone update = (LoadBalancerZone)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerZone.named(lb, removedZone))));
                            update.setState(LoadBalancerZone.STATE.OutOfService);
                            db.commit();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (db == null) continue;
                            if (throwable != null) {
                                try {
                                    db.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            db.close();
                        }
                    }
                    catch (Exception ex) {
                        LOG.debug((Object)"Error updating state for load balancer zone", (Throwable)ex);
                    }
                }
            }
        }

        @Override
        public void rollback() {
        }
    }

    private static class UpdateAutoScalingGroup
    extends AbstractEventHandler<DisabledZoneEvent>
    implements StoredResult<String> {
        private LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupCoreView group = null;
        private String groupName = null;
        private List<String> beforeUpdate = null;
        private List<String> afterUpdate = null;

        protected UpdateAutoScalingGroup(EventHandlerChain<DisabledZoneEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(DisabledZoneEvent evt) throws EventHandlerException {
            LoadBalancer lb;
            try {
                lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
            }
            catch (NoSuchElementException ex) {
                throw new EventHandlerException("Could not find the loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Error while looking for loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            this.group = lb.getAutoScaleGroup();
            if (this.group == null) {
                LOG.warn((Object)String.format("No autoscaling group found for %s-%s", evt.getContext().getUserFullName(), evt.getLoadBalancer()));
                return;
            }
            this.groupName = this.group.getName();
            ArrayList currentZones = Lists.newArrayList((Iterable)Collections2.filter(lb.getZones(), (Predicate)new Predicate<LoadBalancerZone.LoadBalancerZoneCoreView>(){

                public boolean apply(@Nullable LoadBalancerZone.LoadBalancerZoneCoreView arg0) {
                    return arg0.getState().equals((Object)LoadBalancerZone.STATE.InService);
                }
            }));
            ArrayList availableZones = Lists.newArrayList((Iterable)Collections2.transform((Collection)currentZones, (Function)new Function<LoadBalancerZone.LoadBalancerZoneCoreView, String>(){

                public String apply(@Nullable LoadBalancerZone.LoadBalancerZoneCoreView arg0) {
                    return arg0.getName();
                }
            }));
            ArrayList updatedZones = Lists.newArrayList();
            updatedZones.addAll(availableZones);
            for (String req : evt.getZones()) {
                updatedZones.remove(req);
            }
            try {
                LoadBalancerAutoScalingGroup scaleGroup;
                int capacityPerZone = Integer.parseInt(EventHandlerChainNew.VM_PER_ZONE);
                if (capacityPerZone <= 0) {
                    capacityPerZone = 1;
                }
                int newCapacity = capacityPerZone * updatedZones.size();
                EucalyptusActivityTasks.getInstance().updateAutoScalingGroup(this.groupName, updatedZones, newCapacity);
                this.beforeUpdate = availableZones;
                this.afterUpdate = updatedZones;
                try {
                    scaleGroup = LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupEntityTransform.INSTANCE.apply(this.group);
                }
                catch (Exception ex) {
                    LOG.error((Object)"unable to transform autoscale group from the view", (Throwable)ex);
                    throw ex;
                }
                try (TransactionResource db = Entities.transactionFor(LoadBalancerAutoScalingGroup.class);){
                    LoadBalancerAutoScalingGroup update = (LoadBalancerAutoScalingGroup)((Object)Entities.uniqueResult((Object)((Object)scaleGroup)));
                    update.setCapacity(newCapacity);
                    Entities.persist((Object)((Object)update));
                    db.commit();
                }
                catch (NoSuchElementException ex) {
                    LOG.error((Object)"failed to find the autoscaling group record", (Throwable)ex);
                }
                catch (Exception ex) {
                    LOG.error((Object)"failed to update the autoscaling group record", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                throw new EventHandlerException("failed to update the autoscaling group", ex);
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
            if (this.groupName != null && this.beforeUpdate != null) {
                try {
                    LoadBalancerAutoScalingGroup scaleGroup;
                    int capacityPerZone = Integer.parseInt(EventHandlerChainNew.VM_PER_ZONE);
                    if (capacityPerZone <= 0) {
                        capacityPerZone = 1;
                    }
                    int oldCapacity = capacityPerZone * this.beforeUpdate.size();
                    EucalyptusActivityTasks.getInstance().updateAutoScalingGroup(this.groupName, this.beforeUpdate, oldCapacity);
                    try {
                        scaleGroup = LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupEntityTransform.INSTANCE.apply(this.group);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"unable to transfrom scaling group from the view", (Throwable)ex);
                        throw ex;
                    }
                    try (TransactionResource db = Entities.transactionFor(LoadBalancerAutoScalingGroup.class);){
                        LoadBalancerAutoScalingGroup update = (LoadBalancerAutoScalingGroup)((Object)Entities.uniqueResult((Object)((Object)scaleGroup)));
                        update.setCapacity(oldCapacity);
                        Entities.persist((Object)((Object)update));
                        db.commit();
                    }
                    catch (NoSuchElementException ex) {
                        LOG.error((Object)"failed to find the autoscaling group record", (Throwable)ex);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"failed to update the autoscaling group record", (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to update the zone to the original list", ex);
                }
            }
        }

        @Override
        public List<String> getResult() {
            ArrayList removed = Lists.newArrayList((Iterable)Sets.difference((Set)Sets.newHashSet(this.beforeUpdate), (Set)Sets.newHashSet(this.afterUpdate)));
            return removed;
        }
    }

    private static class PersistUpdatedServoInstances
    extends AbstractEventHandler<DisabledZoneEvent> {
        private List<LoadBalancerServoInstance> retiredInstances = null;

        protected PersistUpdatedServoInstances(EventHandlerChain<DisabledZoneEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(DisabledZoneEvent evt) throws EventHandlerException {
            LoadBalancer lb;
            try {
                lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
            }
            catch (NoSuchElementException ex) {
                throw new EventHandlerException("Could not find the loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Error while looking for loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            this.retiredInstances = Lists.newArrayList();
            ArrayList currentZones = Lists.newArrayList(lb.getZones());
            for (LoadBalancerZone.LoadBalancerZoneCoreView zoneView : currentZones) {
                LoadBalancerZone zone;
                if (!evt.getZones().contains(zoneView.getName())) continue;
                try {
                    zone = LoadBalancerZone.LoadBalancerZoneEntityTransform.INSTANCE.apply(zoneView);
                }
                catch (Exception ex) {
                    LOG.error((Object)"unable to transform zone from the view", (Throwable)ex);
                    continue;
                }
                for (LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView instanceView : zone.getServoInstances()) {
                    LoadBalancerServoInstance instance;
                    try {
                        instance = LoadBalancerServoInstance.LoadBalancerServoInstanceEntityTransform.INSTANCE.apply(instanceView);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"unable to transfrom servo-instance from the view", (Throwable)ex);
                        continue;
                    }
                    try {
                        TransactionResource db = Entities.transactionFor(LoadBalancerServoInstance.class);
                        Throwable throwable = null;
                        try {
                            LoadBalancerServoInstance update = (LoadBalancerServoInstance)((Object)Entities.uniqueResult((Object)((Object)instance)));
                            update.setState(LoadBalancerServoInstance.STATE.Retired);
                            Entities.persist((Object)((Object)update));
                            db.commit();
                            this.retiredInstances.add(update);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (db == null) continue;
                            if (throwable != null) {
                                try {
                                    db.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            db.close();
                        }
                    }
                    catch (NoSuchElementException ex) {
                        LOG.warn((Object)"Failed to update the servo instance's state: no such instance found");
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Failed to update the servo instance's state", (Throwable)ex);
                    }
                }
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
            if (this.retiredInstances != null) {
                for (LoadBalancerServoInstance instance : this.retiredInstances) {
                    try {
                        TransactionResource db = Entities.transactionFor(LoadBalancerServoInstance.class);
                        Throwable throwable = null;
                        try {
                            LoadBalancerServoInstance update = (LoadBalancerServoInstance)((Object)Entities.uniqueResult((Object)((Object)instance)));
                            update.setState(LoadBalancerServoInstance.STATE.InService);
                            Entities.persist((Object)((Object)update));
                            db.commit();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (db == null) continue;
                            if (throwable != null) {
                                try {
                                    db.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            db.close();
                        }
                    }
                    catch (NoSuchElementException ex) {
                        LOG.warn((Object)"Failed to update the servo instance's state: no such instance found");
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Failed to update the servo instance's state", (Throwable)ex);
                    }
                }
            }
        }
    }

    private static class RemoveDnsRecord
    extends AbstractEventHandler<DisabledZoneEvent> {
        private String dnsName = null;
        private String dnsZone = null;
        private List<String> ipAddressRemoved = null;

        protected RemoveDnsRecord(EventHandlerChain<DisabledZoneEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(DisabledZoneEvent evt) throws EventHandlerException {
            LoadBalancer lb;
            try {
                lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
            }
            catch (NoSuchElementException ex) {
                throw new EventHandlerException("Could not find the loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Error while looking for loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView dnsRec = lb.getDns();
            if (dnsRec == null) {
                LOG.warn((Object)"failed to find the dns record for the loadbalancer");
                return;
            }
            this.dnsName = dnsRec.getName();
            this.dnsZone = dnsRec.getZone();
            ArrayList ipAddressToRemove = Lists.newArrayList();
            ArrayList currentZones = Lists.newArrayList(lb.getZones());
            for (LoadBalancerZone.LoadBalancerZoneCoreView zoneView : currentZones) {
                LoadBalancerZone zone;
                if (!evt.getZones().contains(zoneView.getName())) continue;
                try {
                    zone = LoadBalancerZone.LoadBalancerZoneEntityTransform.INSTANCE.apply(zoneView);
                }
                catch (Exception ex) {
                    LOG.error((Object)"unable to transform the zone from its view", (Throwable)ex);
                    continue;
                }
                for (LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView instance : zone.getServoInstances()) {
                    if (!LoadBalancerServoInstance.STATE.InService.equals((Object)instance.getState())) continue;
                    String ipAddr = instance.getAddress();
                    ipAddressToRemove.add(ipAddr);
                }
            }
            this.ipAddressRemoved = Lists.newArrayList();
            for (String ipAddr : ipAddressToRemove) {
                try {
                    EucalyptusActivityTasks.getInstance().removeARecord(this.dnsZone, this.dnsName, ipAddr);
                    this.ipAddressRemoved.add(ipAddr);
                }
                catch (Exception ex) {
                    LOG.warn((Object)String.format("failed to remove A record %s-%s-%s", this.dnsZone, this.dnsName, ipAddr));
                }
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
            if (this.dnsName != null && this.dnsZone != null && this.ipAddressRemoved != null) {
                for (String ipAddr : this.ipAddressRemoved) {
                    try {
                        EucalyptusActivityTasks.getInstance().addARecord(this.dnsZone, this.dnsName, ipAddr);
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"failed to add A record back to the service", (Throwable)ex);
                    }
                }
            }
        }
    }

    private static class CheckAndModifyRequest
    extends AbstractEventHandler<DisabledZoneEvent> {
        protected CheckAndModifyRequest(EventHandlerChain<DisabledZoneEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(DisabledZoneEvent evt) throws EventHandlerException {
            LoadBalancer lb;
            try {
                lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
            }
            catch (NoSuchElementException ex) {
                throw new EventHandlerException("Could not find the loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Error while looking for loadbalancer with name=" + evt.getLoadBalancer(), ex);
            }
            ArrayList currentZones = Lists.newArrayList((Iterable)Collections2.filter(lb.getZones(), (Predicate)new Predicate<LoadBalancerZone.LoadBalancerZoneCoreView>(){

                public boolean apply(@Nullable LoadBalancerZone.LoadBalancerZoneCoreView arg0) {
                    return arg0.getState().equals((Object)LoadBalancerZone.STATE.InService);
                }
            }));
            ArrayList availableZones = Lists.newArrayList((Iterable)Collections2.transform((Collection)currentZones, (Function)new Function<LoadBalancerZone.LoadBalancerZoneCoreView, String>(){

                public String apply(@Nullable LoadBalancerZone.LoadBalancerZoneCoreView arg0) {
                    return arg0.getName();
                }
            }));
            ArrayList unknownZones = Lists.newArrayList();
            for (String requested : evt.getZones()) {
                if (availableZones.contains(requested)) continue;
                unknownZones.add(requested);
            }
            for (String unknown : unknownZones) {
                evt.getZones().remove(unknown);
            }
        }

        @Override
        public void rollback() {
        }
    }
}

