/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.activities;

import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancerListener;
import com.eucalyptus.loadbalancing.LoadBalancerSecurityGroup;
import com.eucalyptus.loadbalancing.LoadBalancers;
import com.eucalyptus.loadbalancing.activities.AbstractEventHandler;
import com.eucalyptus.loadbalancing.activities.DeleteListenerEvent;
import com.eucalyptus.loadbalancing.activities.EucalyptusActivityTasks;
import com.eucalyptus.loadbalancing.activities.EventHandlerChain;
import com.eucalyptus.loadbalancing.activities.EventHandlerException;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class EventHandlerChainDeleteListeners
extends EventHandlerChain<DeleteListenerEvent> {
    private static Logger LOG = Logger.getLogger(EventHandlerChainDeleteListeners.class);

    @Override
    public EventHandlerChain<DeleteListenerEvent> build() {
        this.insert(new RevokeSSLCertificate(this));
        this.insert(new RevokeIngressRule(this));
        return this;
    }

    public static class RevokeIngressRule
    extends AbstractEventHandler<DeleteListenerEvent> {
        protected RevokeIngressRule(EventHandlerChain<DeleteListenerEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(DeleteListenerEvent evt) throws EventHandlerException {
            String[] protocols;
            Collection<Integer> ports = evt.getPorts();
            String groupName = null;
            try {
                LoadBalancer lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
                LoadBalancerSecurityGroup.LoadBalancerSecurityGroupCoreView group = lb.getGroup();
                if (group != null) {
                    groupName = group.getName();
                }
            }
            catch (Exception ex) {
                throw new EventHandlerException("could not find the loadbalancer", ex);
            }
            if (groupName == null) {
                return;
            }
            for (String protocol : protocols = new String[]{"tcp"}) {
                for (Integer port : ports) {
                    try {
                        EucalyptusActivityTasks.getInstance().revokeSystemSecurityGroup(groupName, protocol, port);
                        LOG.debug((Object)String.format("rule revoked (%s-%d)", groupName, port));
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Unable to revoke the security group", (Throwable)ex);
                    }
                }
            }
        }

        @Override
        public void rollback() {
        }
    }

    public static class RevokeSSLCertificate
    extends AbstractEventHandler<DeleteListenerEvent> {
        protected RevokeSSLCertificate(EventHandlerChain<DeleteListenerEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(DeleteListenerEvent evt) throws EventHandlerException {
            LoadBalancer lb;
            Collection<Integer> portsToDelete = evt.getPorts();
            try {
                lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
            }
            catch (Exception ex) {
                throw new EventHandlerException("could not find the loadbalancer", ex);
            }
            HashSet allArns = Sets.newHashSet();
            HashSet arnsToKeep = Sets.newHashSet();
            for (LoadBalancerListener.LoadBalancerListenerCoreView listener : lb.getListeners()) {
                LoadBalancerListener.PROTOCOL protocol = listener.getProtocol();
                if (!protocol.equals((Object)LoadBalancerListener.PROTOCOL.HTTPS) && !protocol.equals((Object)LoadBalancerListener.PROTOCOL.SSL)) continue;
                allArns.add(listener.getCertificateId());
                if (portsToDelete.contains(listener.getLoadbalancerPort())) continue;
                arnsToKeep.add(listener.getCertificateId());
            }
            Sets.SetView arnToDelete = Sets.difference((Set)allArns, (Set)arnsToKeep);
            if (arnToDelete.size() <= 0) {
                return;
            }
            String roleName = String.format("%s-%s-%s", "loadbalancer-vm", evt.getContext().getAccount().getAccountNumber(), evt.getLoadBalancer());
            String prefix = String.format("arn:aws:iam::%s:server-certificate", evt.getContext().getAccount().getAccountNumber());
            for (String arn : arnToDelete) {
                if (!arn.startsWith(prefix)) continue;
                String pathAndName = arn.replace(prefix, "");
                String certName = pathAndName.substring(pathAndName.lastIndexOf("/") + 1);
                String policyName = String.format("%s-%s-%s-%s", "loadbalancer-iam-policy", evt.getContext().getAccount().getAccountNumber(), evt.getLoadBalancer(), certName);
                try {
                    EucalyptusActivityTasks.getInstance().deleteRolePolicy(roleName, policyName);
                }
                catch (Exception ex) {
                    LOG.warn((Object)String.format("Failed to delete role (%s) policy (%s)", roleName, policyName), (Throwable)ex);
                }
            }
        }

        @Override
        public void rollback() {
        }
    }
}

