/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.activities;

import com.eucalyptus.autoscaling.common.msgs.AutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResponseType;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancerDnsRecord;
import com.eucalyptus.loadbalancing.LoadBalancerSecurityGroup;
import com.eucalyptus.loadbalancing.LoadBalancerZone;
import com.eucalyptus.loadbalancing.LoadBalancers;
import com.eucalyptus.loadbalancing.activities.AbstractEventHandler;
import com.eucalyptus.loadbalancing.activities.DeleteLoadbalancerEvent;
import com.eucalyptus.loadbalancing.activities.EucalyptusActivityTasks;
import com.eucalyptus.loadbalancing.activities.EventHandlerChain;
import com.eucalyptus.loadbalancing.activities.EventHandlerException;
import com.eucalyptus.loadbalancing.activities.LoadBalancerAutoScalingGroup;
import com.eucalyptus.loadbalancing.activities.LoadBalancerServoInstance;
import com.eucalyptus.loadbalancing.common.LoadBalancingBackend;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class EventHandlerChainDelete
extends EventHandlerChain<DeleteLoadbalancerEvent> {
    private static Logger LOG = Logger.getLogger(EventHandlerChainDelete.class);

    @Override
    public EventHandlerChain<DeleteLoadbalancerEvent> build() {
        this.insert(new DnsARecordRemover(this));
        this.insert(new AutoScalingGroupRemover(this));
        this.insert(new InstanceProfileRemover(this));
        this.insert(new IAMRoleRemover(this));
        this.insert(new SecurityGroupRemover(this));
        return this;
    }

    public static class ServoInstanceCleanup
    implements EventListener<ClockTick> {
        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new ServoInstanceCleanup());
        }

        public void fireEvent(ClockTick event) {
            if (!(Bootstrap.isFinished().booleanValue() && Topology.isEnabledLocally(LoadBalancingBackend.class) && Topology.isEnabled(Eucalyptus.class))) {
                return;
            }
            List retired = null;
            try (TransactionResource db = Entities.transactionFor(LoadBalancerServoInstance.class);){
                LoadBalancerServoInstance sample = LoadBalancerServoInstance.withState(LoadBalancerServoInstance.STATE.Retired.name());
                retired = Entities.query((Object)((Object)sample));
                sample = LoadBalancerServoInstance.withState(LoadBalancerServoInstance.STATE.Error.name());
                retired.addAll(Entities.query((Object)((Object)sample)));
                db.commit();
            }
            catch (Exception ex) {
                LOG.warn((Object)"failed to query loadbalancer servo instance", (Throwable)ex);
            }
            if (retired == null || retired.size() <= 0) {
                return;
            }
            ArrayList retiredAndDnsClean = Lists.newArrayList();
            for (LoadBalancerServoInstance instance : retired) {
                if (LoadBalancerServoInstance.DNS_STATE.Registered.equals((Object)instance.getDnsState())) continue;
                retiredAndDnsClean.add(instance);
            }
            ArrayList param = Lists.newArrayList();
            HashMap latestState = Maps.newHashMap();
            for (LoadBalancerServoInstance instance : retiredAndDnsClean) {
                String instanceState;
                String instanceId = instance.getInstanceId();
                if (instanceId == null) continue;
                param.clear();
                param.add(instanceId);
                try {
                    List<RunningInstancesItemType> result = EucalyptusActivityTasks.getInstance().describeSystemInstances(param);
                    instanceState = result.isEmpty() ? "terminated" : result.get(0).getStateName();
                }
                catch (Exception ex) {
                    LOG.warn((Object)"failed to query instances", (Throwable)ex);
                    continue;
                }
                latestState.put(instanceId, instanceState);
            }
            for (String instanceId : latestState.keySet()) {
                String state = (String)latestState.get(instanceId);
                if (!state.equals("terminated")) continue;
                try {
                    TransactionResource db2 = Entities.transactionFor(LoadBalancerServoInstance.class);
                    Throwable throwable = null;
                    try {
                        LoadBalancerServoInstance toDelete = (LoadBalancerServoInstance)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerServoInstance.named(instanceId))));
                        Entities.delete((Object)((Object)toDelete));
                        db2.commit();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (db2 == null) continue;
                        if (throwable != null) {
                            try {
                                db2.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        db2.close();
                    }
                }
                catch (Exception ex) {
                    LOG.trace((Object)("Unable to delete load balancer servo instance: " + ex));
                }
            }
        }
    }

    public static class SecurityGroupCleanup
    implements EventListener<ClockTick> {
        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new SecurityGroupCleanup());
        }

        public void fireEvent(ClockTick event) {
            if (!(Bootstrap.isFinished().booleanValue() && Topology.isEnabledLocally(LoadBalancingBackend.class) && Topology.isEnabled(Eucalyptus.class))) {
                return;
            }
            List allGroups = null;
            try (TransactionResource db2 = Entities.transactionFor(LoadBalancerSecurityGroup.class);){
                allGroups = Entities.query((Object)((Object)LoadBalancerSecurityGroup.withState(LoadBalancerSecurityGroup.STATE.OutOfService)));
                db2.commit();
            }
            catch (Exception db2) {
                // empty catch block
            }
            if (allGroups == null || allGroups.size() <= 0) {
                return;
            }
            ArrayList toDelete = Lists.newArrayList();
            for (LoadBalancerSecurityGroup group : allGroups) {
                Collection<LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView> instances = group.getServoInstances();
                if (instances != null && instances.size() > 0) continue;
                toDelete.add(group);
            }
            for (LoadBalancerSecurityGroup group : toDelete) {
                try {
                    EucalyptusActivityTasks.getInstance().deleteSystemSecurityGroup(group.getName());
                    LOG.info((Object)("deleted security group: " + group.getName()));
                }
                catch (Exception ex) {
                    LOG.warn((Object)"failed to delete the security group from eucalyptus", (Throwable)ex);
                }
            }
            try (TransactionResource db22 = Entities.transactionFor(LoadBalancerSecurityGroup.class);){
                for (LoadBalancerSecurityGroup group : toDelete) {
                    LoadBalancerSecurityGroup g = (LoadBalancerSecurityGroup)((Object)Entities.uniqueResult((Object)((Object)group)));
                    Entities.delete((Object)((Object)g));
                }
                db22.commit();
            }
            catch (NoSuchElementException db22) {
            }
            catch (Exception ex) {
                LOG.warn((Object)"failed to delete the securty group from entity", (Throwable)ex);
            }
        }
    }

    private static class SecurityGroupRemover
    extends AbstractEventHandler<DeleteLoadbalancerEvent> {
        SecurityGroupRemover(EventHandlerChain<DeleteLoadbalancerEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(DeleteLoadbalancerEvent evt) throws EventHandlerException {
            LoadBalancer lb;
            LoadBalancerSecurityGroup.LoadBalancerSecurityGroupCoreView groupView = null;
            try {
                lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
                if (lb.getGroup() != null) {
                    groupView = lb.getGroup();
                }
            }
            catch (NoSuchElementException ex) {
                return;
            }
            catch (Exception ex) {
                LOG.error((Object)("Error while looking for loadbalancer with name=" + evt.getLoadBalancer()), (Throwable)ex);
                return;
            }
            if (lb.getVpcId() == null) {
                LoadBalancerSecurityGroup group;
                try {
                    group = LoadBalancerSecurityGroup.LoadBalancerSecurityGroupEntityTransform.INSTANCE.apply(groupView);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Erorr while looking for loadbalancer group", (Throwable)ex);
                    return;
                }
                try (TransactionResource db = Entities.transactionFor(LoadBalancerSecurityGroup.class);){
                    LoadBalancerSecurityGroup exist = (LoadBalancerSecurityGroup)((Object)Entities.uniqueResult((Object)((Object)group)));
                    exist.setLoadBalancer(null);
                    exist.setState(LoadBalancerSecurityGroup.STATE.OutOfService);
                    Entities.persist((Object)((Object)exist));
                    db.commit();
                }
                catch (Exception ex) {
                    LOG.warn((Object)"Could not disassociate the group from loadbalancer");
                }
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
        }
    }

    public static class IAMRoleRemover
    extends AbstractEventHandler<DeleteLoadbalancerEvent> {
        protected IAMRoleRemover(EventHandlerChain<DeleteLoadbalancerEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(DeleteLoadbalancerEvent evt) throws EventHandlerException {
            String roleName = String.format("%s-%s-%s", "loadbalancer-vm", evt.getContext().getAccount().getAccountNumber(), evt.getLoadBalancer());
            try {
                EucalyptusActivityTasks.getInstance().deleteRolePolicy(roleName, "euca-internal-loadbalancer-vm-policy");
            }
            catch (Exception ex) {
                LOG.error((Object)"failed to delete role policy", (Throwable)ex);
            }
            try {
                EucalyptusActivityTasks.getInstance().deleteRole(roleName);
            }
            catch (Exception ex) {
                LOG.error((Object)"failed to delete role", (Throwable)ex);
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
        }
    }

    public static class InstanceProfileRemover
    extends AbstractEventHandler<DeleteLoadbalancerEvent> {
        protected InstanceProfileRemover(EventHandlerChain<DeleteLoadbalancerEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(DeleteLoadbalancerEvent evt) throws EventHandlerException {
            String instanceProfileName = String.format("%s-%s-%s", "loadbalancer-vm", evt.getContext().getAccount().getAccountNumber(), evt.getLoadBalancer());
            String roleName = String.format("%s-%s-%s", "loadbalancer-vm", evt.getContext().getAccount().getAccountNumber(), evt.getLoadBalancer());
            try {
                EucalyptusActivityTasks.getInstance().removeRoleFromInstanceProfile(instanceProfileName, roleName);
            }
            catch (Exception ex) {
                LOG.error((Object)String.format("Failed to remove role(%s) from the instance profile(%s)", roleName, instanceProfileName), (Throwable)ex);
            }
            try {
                EucalyptusActivityTasks.getInstance().deleteInstanceProfile(instanceProfileName);
            }
            catch (Exception ex) {
                LOG.error((Object)String.format("Failed to delete instance profile (%s)", instanceProfileName), (Throwable)ex);
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
        }
    }

    public static class AutoScalingGroupRemover
    extends AbstractEventHandler<DeleteLoadbalancerEvent> {
        protected AutoScalingGroupRemover(EventHandlerChain<DeleteLoadbalancerEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(DeleteLoadbalancerEvent evt) throws EventHandlerException {
            LoadBalancer lb;
            try {
                lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
            }
            catch (NoSuchElementException ex) {
                return;
            }
            catch (Exception ex) {
                LOG.warn((Object)("Failed to find the loadbalancer named " + evt.getLoadBalancer()), (Throwable)ex);
                return;
            }
            LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupCoreView group = lb.getAutoScaleGroup();
            if (group == null) {
                LOG.warn((Object)String.format("Loadbalancer %s had no autoscale group associated with it", lb.getDisplayName()));
                return;
            }
            String groupName = group.getName();
            String launchConfigName = null;
            try {
                DescribeAutoScalingGroupsResponseType resp = EucalyptusActivityTasks.getInstance().describeAutoScalingGroups(Lists.newArrayList((Object[])new String[]{groupName}));
                AutoScalingGroupType asgType = (AutoScalingGroupType)resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember().get(0);
                launchConfigName = asgType.getLaunchConfigurationName();
            }
            catch (Exception ex) {
                LOG.warn((Object)String.format("Unable to find the launch config associated with %s", groupName));
            }
            try {
                EucalyptusActivityTasks.getInstance().updateAutoScalingGroup(groupName, null, 0);
            }
            catch (Exception ex) {
                LOG.warn((Object)String.format("Unable to set desired capacity for %s", groupName), (Throwable)ex);
            }
            int NUM_DELETE_ASG_RETRY = 4;
            for (int i = 0; i < 4; ++i) {
                boolean error;
                try {
                    EucalyptusActivityTasks.getInstance().deleteAutoScalingGroup(groupName, true);
                    error = false;
                }
                catch (Exception ex) {
                    error = true;
                    LOG.warn((Object)String.format("Failed to delete autoscale group (%d'th attempt): %s", i + 1, groupName));
                    try {
                        long sleepMs = (i + 1) * 500;
                        Thread.sleep(sleepMs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!error) break;
            }
            if (launchConfigName != null) {
                try {
                    EucalyptusActivityTasks.getInstance().deleteLaunchConfiguration(launchConfigName);
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Failed to delete launch configuration " + launchConfigName), (Throwable)ex);
                }
            }
            LoadBalancerAutoScalingGroup scaleGroup = null;
            try {
                LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupCoreView groupView = lb.getAutoScaleGroup();
                scaleGroup = LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupEntityTransform.INSTANCE.apply(groupView);
            }
            catch (Exception ex) {
                LOG.error((Object)"falied to update servo instance record", (Throwable)ex);
            }
            if (scaleGroup == null) {
                return;
            }
            try (TransactionResource db = Entities.transactionFor(LoadBalancerServoInstance.class);){
                for (LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView instanceView : scaleGroup.getServos()) {
                    LoadBalancerServoInstance instance;
                    try {
                        instance = LoadBalancerServoInstance.LoadBalancerServoInstanceEntityTransform.INSTANCE.apply(instanceView);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    LoadBalancerServoInstance found = (LoadBalancerServoInstance)((Object)Entities.uniqueResult((Object)((Object)instance)));
                    found.setDns(null);
                    found.setAvailabilityZone(null);
                    found.setAutoScalingGroup(null);
                    found.setState(LoadBalancerServoInstance.STATE.Retired);
                    Entities.persist((Object)((Object)found));
                }
                db.commit();
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to update servo instance record", (Throwable)ex);
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
        }
    }

    private static class DnsARecordRemover
    extends AbstractEventHandler<DeleteLoadbalancerEvent> {
        DnsARecordRemover(EventHandlerChain<DeleteLoadbalancerEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(DeleteLoadbalancerEvent evt) throws EventHandlerException {
            LoadBalancer lb;
            ArrayList servos;
            block23: {
                servos = Lists.newArrayList();
                try {
                    lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer());
                    if (lb.getZones() == null) break block23;
                    for (LoadBalancerZone.LoadBalancerZoneCoreView zoneView : lb.getZones()) {
                        LoadBalancerZone zone;
                        try {
                            zone = LoadBalancerZone.LoadBalancerZoneEntityTransform.INSTANCE.apply(zoneView);
                        }
                        catch (Exception ex) {
                            continue;
                        }
                        servos.addAll(zone.getServoInstances());
                    }
                }
                catch (NoSuchElementException ex) {
                    return;
                }
                catch (Exception ex) {
                    LOG.warn((Object)"Failed to find the loadbalancer", (Throwable)ex);
                    return;
                }
            }
            LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView dns = lb.getDns();
            for (LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView instance : servos) {
                String address = instance.getAddress();
                if (address == null || address.length() <= 0) continue;
                try {
                    EucalyptusActivityTasks.getInstance().removeARecord(dns.getZone(), dns.getName(), address);
                    TransactionResource db = Entities.transactionFor(LoadBalancerServoInstance.class);
                    Throwable throwable = null;
                    try {
                        try {
                            LoadBalancerServoInstance entity = (LoadBalancerServoInstance)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerServoInstance.named(instance.getInstanceId()))));
                            entity.setDnsState(LoadBalancerServoInstance.DNS_STATE.Deregistered);
                            Entities.persist((Object)((Object)entity));
                            db.commit();
                        }
                        catch (Exception ex) {
                            LOG.error((Object)String.format("failed to set servo instance(%s)'s dns state to deregistered", instance.getInstanceId()), (Throwable)ex);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (db == null) continue;
                        if (throwable != null) {
                            try {
                                db.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        db.close();
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)String.format("failed to remove dns a record (zone=%s, name=%s, address=%s)", dns.getZone(), dns.getName(), address), (Throwable)ex);
                }
            }
            try {
                EucalyptusActivityTasks.getInstance().removeMultiARecord(dns.getZone(), dns.getName());
            }
            catch (Exception ex) {
                LOG.error((Object)String.format("failed to remove dns a record (zone=%s,  name=%s)", dns.getZone(), dns.getName()), (Throwable)ex);
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
        }
    }
}

