/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.activities;

import com.eucalyptus.autoscaling.common.msgs.AutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingGroupsType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResponseType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResult;
import com.eucalyptus.autoscaling.common.msgs.Instance;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancers;
import com.eucalyptus.loadbalancing.activities.AbstractEventHandler;
import com.eucalyptus.loadbalancing.activities.ApplySecurityGroupsEvent;
import com.eucalyptus.loadbalancing.activities.EucalyptusActivityTasks;
import com.eucalyptus.loadbalancing.activities.EventHandlerChain;
import com.eucalyptus.loadbalancing.activities.EventHandlerChainNew;
import com.eucalyptus.loadbalancing.activities.EventHandlerException;
import com.eucalyptus.loadbalancing.activities.LoadBalancerASGroupCreator;
import com.google.common.collect.Lists;
import java.util.NoSuchElementException;

public class EventHandlerChainApplySecurityGroups
extends EventHandlerChain<ApplySecurityGroupsEvent> {
    @Override
    public EventHandlerChain<ApplySecurityGroupsEvent> build() {
        this.insert(new LoadBalancerASGroupCreator(this, EventHandlerChainNew.getCapacityPerZone()));
        this.insert(new LoadBalancerSecurityGroupUpdate(this));
        return this;
    }

    public static class LoadBalancerSecurityGroupUpdate
    extends AbstractEventHandler<ApplySecurityGroupsEvent> {
        protected LoadBalancerSecurityGroupUpdate(EventHandlerChain<? extends ApplySecurityGroupsEvent> chain) {
            super(chain);
        }

        @Override
        public void apply(ApplySecurityGroupsEvent evt) throws EventHandlerException {
            AutoScalingGroupsType autoScalingGroupsType;
            LoadBalancer.LoadBalancerCoreView lb;
            try {
                lb = LoadBalancers.getLoadbalancer(evt.getContext(), evt.getLoadBalancer()).getCoreView();
            }
            catch (NoSuchElementException ex) {
                throw new EventHandlerException("Failed to find the loadbalancer " + evt.getLoadBalancer(), ex);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Unable to access loadbalancer metadata", ex);
            }
            String groupName = LoadBalancerASGroupCreator.getAutoScalingGroupName(lb.getOwnerAccountNumber(), lb.getDisplayName());
            DescribeAutoScalingGroupsResponseType response = EucalyptusActivityTasks.getInstance().describeAutoScalingGroups(Lists.newArrayList((Object[])new String[]{groupName}));
            DescribeAutoScalingGroupsResult describeAutoScalingGroupsResult = response.getDescribeAutoScalingGroupsResult();
            if (describeAutoScalingGroupsResult != null && (autoScalingGroupsType = describeAutoScalingGroupsResult.getAutoScalingGroups()) != null && autoScalingGroupsType.getMember() != null && !autoScalingGroupsType.getMember().isEmpty() && ((AutoScalingGroupType)autoScalingGroupsType.getMember().get(0)).getInstances() != null) {
                for (Instance instance : ((AutoScalingGroupType)autoScalingGroupsType.getMember().get(0)).getInstances().getMember()) {
                    EucalyptusActivityTasks.getInstance().modifySecurityGroups(instance.getInstanceId(), evt.getSecurityGroupIdsToNames().keySet());
                }
            }
        }

        @Override
        public void rollback() throws EventHandlerException {
        }
    }
}

