/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.activities;

import com.eucalyptus.loadbalancing.activities.EventHandler;
import com.eucalyptus.loadbalancing.activities.EventHandlerChainException;
import com.eucalyptus.loadbalancing.activities.LoadbalancingEvent;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public abstract class EventHandlerChain<T extends LoadbalancingEvent> {
    private static Logger LOG = Logger.getLogger(EventHandlerChain.class);
    private final List<EventHandler<? super T>> handlers = Lists.newArrayList();

    protected void insert(EventHandler<? super T> next) {
        this.handlers.add(next);
    }

    public void execute(T evt) throws EventHandlerChainException {
        LinkedList reverseHandler = Lists.newLinkedList();
        for (EventHandler<T> handler : this.handlers) {
            try {
                reverseHandler.addFirst(handler);
                handler.apply(evt);
                if (!handler.skipRemaining()) continue;
                LOG.info((Object)"skipping the remaining handlers");
                break;
            }
            catch (Exception e) {
                LOG.warn((Object)"starting to rollback");
                String msg = e.getMessage() != null ? e.getMessage() : String.format("failed handling %s at %s", evt, handler);
                EventHandlerChainException toThrow = new EventHandlerChainException(msg, e, true);
                for (EventHandler h : reverseHandler) {
                    try {
                        h.rollback();
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)("rollback failed at " + h.toString()), (Throwable)ex);
                        toThrow.setRollback(false);
                    }
                }
                LOG.info((Object)"finished rollback");
                throw toThrow;
            }
        }
    }

    public abstract EventHandlerChain<T> build();

    public <HT> HT findHandler(Class<HT> handlerType) {
        for (EventHandler<T> handler : this.handlers) {
            if (!handler.getClass().isAssignableFrom(handlerType)) continue;
            return (HT)handler;
        }
        throw new NoSuchElementException();
    }
}

