/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.activities;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.euare.AddRoleToInstanceProfileType;
import com.eucalyptus.auth.euare.CreateInstanceProfileResponseType;
import com.eucalyptus.auth.euare.CreateInstanceProfileType;
import com.eucalyptus.auth.euare.CreateRoleResponseType;
import com.eucalyptus.auth.euare.CreateRoleType;
import com.eucalyptus.auth.euare.DeleteInstanceProfileType;
import com.eucalyptus.auth.euare.DeleteRolePolicyType;
import com.eucalyptus.auth.euare.DeleteRoleType;
import com.eucalyptus.auth.euare.EuareMessage;
import com.eucalyptus.auth.euare.GetRolePolicyResponseType;
import com.eucalyptus.auth.euare.GetRolePolicyResult;
import com.eucalyptus.auth.euare.GetRolePolicyType;
import com.eucalyptus.auth.euare.GetServerCertificateResponseType;
import com.eucalyptus.auth.euare.GetServerCertificateType;
import com.eucalyptus.auth.euare.InstanceProfileType;
import com.eucalyptus.auth.euare.ListInstanceProfilesResponseType;
import com.eucalyptus.auth.euare.ListInstanceProfilesType;
import com.eucalyptus.auth.euare.ListRolePoliciesResponseType;
import com.eucalyptus.auth.euare.ListRolePoliciesType;
import com.eucalyptus.auth.euare.ListRolesResponseType;
import com.eucalyptus.auth.euare.ListRolesType;
import com.eucalyptus.auth.euare.PutRolePolicyType;
import com.eucalyptus.auth.euare.RemoveRoleFromInstanceProfileType;
import com.eucalyptus.auth.euare.RoleType;
import com.eucalyptus.auth.euare.ServerCertificateType;
import com.eucalyptus.autoscaling.common.AutoScaling;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingGroupNames;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingMessage;
import com.eucalyptus.autoscaling.common.msgs.AvailabilityZones;
import com.eucalyptus.autoscaling.common.msgs.CreateAutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.CreateLaunchConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.CreateOrUpdateTagsType;
import com.eucalyptus.autoscaling.common.msgs.DeleteAutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.DeleteLaunchConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResponseType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsType;
import com.eucalyptus.autoscaling.common.msgs.DescribeLaunchConfigurationsResponseType;
import com.eucalyptus.autoscaling.common.msgs.DescribeLaunchConfigurationsType;
import com.eucalyptus.autoscaling.common.msgs.LaunchConfigurationNames;
import com.eucalyptus.autoscaling.common.msgs.LaunchConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.SecurityGroups;
import com.eucalyptus.autoscaling.common.msgs.TagType;
import com.eucalyptus.autoscaling.common.msgs.Tags;
import com.eucalyptus.autoscaling.common.msgs.UpdateAutoScalingGroupType;
import com.eucalyptus.cloudwatch.common.CloudWatch;
import com.eucalyptus.cloudwatch.common.msgs.CloudWatchMessage;
import com.eucalyptus.cloudwatch.common.msgs.MetricData;
import com.eucalyptus.cloudwatch.common.msgs.PutMetricDataType;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.id.Dns;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.ClusterInfoType;
import com.eucalyptus.compute.common.ComputeMessage;
import com.eucalyptus.compute.common.DeleteResourceTag;
import com.eucalyptus.compute.common.DescribeKeyPairsResponseItemType;
import com.eucalyptus.compute.common.Filter;
import com.eucalyptus.compute.common.GroupIdSetType;
import com.eucalyptus.compute.common.ImageDetails;
import com.eucalyptus.compute.common.InternetGatewayIdSetItemType;
import com.eucalyptus.compute.common.InternetGatewayIdSetType;
import com.eucalyptus.compute.common.InternetGatewayType;
import com.eucalyptus.compute.common.IpPermissionType;
import com.eucalyptus.compute.common.ReservationInfoType;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.compute.common.SecurityGroupIdSetItemType;
import com.eucalyptus.compute.common.SecurityGroupItemType;
import com.eucalyptus.compute.common.SubnetIdSetItemType;
import com.eucalyptus.compute.common.SubnetIdSetType;
import com.eucalyptus.compute.common.SubnetType;
import com.eucalyptus.compute.common.VpcType;
import com.eucalyptus.compute.common.backend.AuthorizeSecurityGroupIngressType;
import com.eucalyptus.compute.common.backend.CreateSecurityGroupResponseType;
import com.eucalyptus.compute.common.backend.CreateSecurityGroupType;
import com.eucalyptus.compute.common.backend.CreateTagsType;
import com.eucalyptus.compute.common.backend.DeleteSecurityGroupType;
import com.eucalyptus.compute.common.backend.DeleteTagsType;
import com.eucalyptus.compute.common.backend.DescribeAvailabilityZonesResponseType;
import com.eucalyptus.compute.common.backend.DescribeAvailabilityZonesType;
import com.eucalyptus.compute.common.backend.DescribeImagesResponseType;
import com.eucalyptus.compute.common.backend.DescribeImagesType;
import com.eucalyptus.compute.common.backend.DescribeInstancesResponseType;
import com.eucalyptus.compute.common.backend.DescribeInstancesType;
import com.eucalyptus.compute.common.backend.DescribeInternetGatewaysResponseType;
import com.eucalyptus.compute.common.backend.DescribeInternetGatewaysType;
import com.eucalyptus.compute.common.backend.DescribeKeyPairsResponseType;
import com.eucalyptus.compute.common.backend.DescribeKeyPairsType;
import com.eucalyptus.compute.common.backend.DescribeSecurityGroupsResponseType;
import com.eucalyptus.compute.common.backend.DescribeSecurityGroupsType;
import com.eucalyptus.compute.common.backend.DescribeSubnetsResponseType;
import com.eucalyptus.compute.common.backend.DescribeSubnetsType;
import com.eucalyptus.compute.common.backend.DescribeVpcsResponseType;
import com.eucalyptus.compute.common.backend.DescribeVpcsType;
import com.eucalyptus.compute.common.backend.ModifyInstanceAttributeType;
import com.eucalyptus.compute.common.backend.RevokeSecurityGroupIngressType;
import com.eucalyptus.empyrean.DescribeServicesResponseType;
import com.eucalyptus.empyrean.DescribeServicesType;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.empyrean.EmpyreanMessage;
import com.eucalyptus.empyrean.ServiceStatusType;
import com.eucalyptus.loadbalancing.LoadBalancerDnsRecord;
import com.eucalyptus.loadbalancing.activities.EucalyptusActivityException;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.DispatchingClient;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.Futures;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.AddMultiARecordType;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.CreateMultiARecordType;
import edu.ucsb.eucalyptus.msgs.DnsMessage;
import edu.ucsb.eucalyptus.msgs.RemoveMultiANameType;
import edu.ucsb.eucalyptus.msgs.RemoveMultiARecordType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class EucalyptusActivityTasks {
    private static final Logger LOG = Logger.getLogger(EucalyptusActivityTask.class);
    private static EucalyptusActivityTasks _instance = new EucalyptusActivityTasks();

    private EucalyptusActivityTasks() {
    }

    public static EucalyptusActivityTasks getInstance() {
        return _instance;
    }

    public List<RunningInstancesItemType> describeSystemInstances(List<String> instances, boolean verbose) {
        if (instances.size() <= 0) {
            return Lists.newArrayList();
        }
        EucalyptusDescribeInstanceTask describeTask = new EucalyptusDescribeInstanceTask(instances, verbose);
        return this.resultOf(describeTask, new EucalyptusSystemActivity(), "failed to describe the instances");
    }

    public List<RunningInstancesItemType> describeSystemInstances(List<String> instances) {
        if (instances.size() <= 0) {
            return Lists.newArrayList();
        }
        EucalyptusDescribeInstanceTask describeTask = new EucalyptusDescribeInstanceTask(instances);
        return this.resultOf(describeTask, new EucalyptusSystemActivity(), "failed to describe the instances");
    }

    public List<RunningInstancesItemType> describeUserInstances(String userId, List<String> instances) {
        if (instances.size() <= 0) {
            return Lists.newArrayList();
        }
        EucalyptusDescribeInstanceTask describeTask = new EucalyptusDescribeInstanceTask(instances);
        return this.resultOf(describeTask, new EucalyptusUserActivity(userId), "failed to describe the instances");
    }

    public List<ServiceStatusType> describeServices(String componentType) {
        EucalyptusDescribeServicesTask serviceTask = new EucalyptusDescribeServicesTask(componentType);
        return this.resultOf(serviceTask, new EmpyreanSystemActivity(), "failed to describe services");
    }

    public List<ClusterInfoType> describeAvailabilityZones(boolean verbose) {
        return this.resultOf(new EucalyptusDescribeAvailabilityZonesTask(verbose), new EucalyptusSystemActivity(), "failed to describe the availability zones");
    }

    public void createSystemSecurityGroup(String groupName, String groupDesc) {
        EucalyptusCreateGroupTask task = new EucalyptusCreateGroupTask(groupName, groupDesc);
        this.checkResult(task, new EucalyptusSystemActivity(), "failed to create the group " + groupName);
    }

    public void deleteSystemSecurityGroup(String groupName) {
        EucalyptusDeleteGroupTask task = new EucalyptusDeleteGroupTask(groupName);
        this.checkResult(task, new EucalyptusSystemActivity(), "failed to delete the group " + groupName);
    }

    public List<SecurityGroupItemType> describeSystemSecurityGroups(List<String> groupNames) {
        EucalyptusDescribeSecurityGroupTask task = new EucalyptusDescribeSecurityGroupTask(null, groupNames, null, null);
        return this.resultOf(task, new EucalyptusSystemActivity(), "failed to describe security groups");
    }

    public void authorizeSystemSecurityGroup(String groupNameOrId, String protocol, int portNum) {
        EucalyptusAuthorizeIngressRuleTask task = new EucalyptusAuthorizeIngressRuleTask(groupNameOrId, protocol, portNum);
        this.checkResult(task, new EucalyptusSystemActivity(), String.format("failed to authorize:%s, %s, %d ", groupNameOrId, protocol, portNum));
    }

    public void revokeSystemSecurityGroup(String groupName, String protocol, int portNum) {
        EucalyptusRevokeIngressRuleTask task = new EucalyptusRevokeIngressRuleTask(groupName, protocol, portNum);
        this.checkResult(task, new EucalyptusSystemActivity(), String.format("failed to revoke:%s, %s, %d ", groupName, protocol, portNum));
    }

    public List<SecurityGroupItemType> describeUserSecurityGroupsByName(String userId, String vpcId, String groupNameFilter) {
        EucalyptusDescribeSecurityGroupTask task = new EucalyptusDescribeSecurityGroupTask(null, null, Lists.newArrayList((Object[])new String[]{groupNameFilter}), vpcId);
        return this.resultOf(task, new EucalyptusUserActivity(userId), "failed to describe security groups");
    }

    public void createUserSecurityGroup(String userId, String groupName, String groupDesc) {
        EucalyptusCreateGroupTask task = new EucalyptusCreateGroupTask(groupName, groupDesc);
        this.checkResult(task, new EucalyptusUserActivity(userId), "failed to create the group " + groupName);
    }

    public void createARecord(String zone, String name) {
        DnsCreateNameRecordTask task = new DnsCreateNameRecordTask(zone, name);
        this.checkResult(task, new DnsSystemActivity(), "failed to create multi A record ");
    }

    public void addARecord(String zone, String name, String address) {
        DnsAddARecordTask task = new DnsAddARecordTask(zone, name, address);
        this.checkResult(task, new DnsSystemActivity(), "failed to add A record ");
    }

    public void removeARecord(String zone, String name, String address) {
        DnsRemoveARecordTask task = new DnsRemoveARecordTask(zone, name, address);
        this.checkResult(task, new DnsSystemActivity(), "failed to remove A record ");
    }

    public void removeMultiARecord(String zone, String name) {
        DnsRemoveMultiARecordTask task = new DnsRemoveMultiARecordTask(zone, name);
        this.checkResult(task, new DnsSystemActivity(), "failed to remove multi A records ");
    }

    public void putCloudWatchMetricData(String userId, String namespace, MetricData data) {
        CloudWatchPutMetricDataTask task = new CloudWatchPutMetricDataTask(namespace, data);
        this.checkResult(task, new CloudWatchUserActivity(userId), "failed to put metric data");
    }

    public void createLaunchConfiguration(String imageId, String instanceType, String instanceProfileName, String launchConfigName, Collection<String> securityGroupNamesOrIds, String keyName, String userData, boolean associatePublicIp) {
        AutoScalingCreateLaunchConfigTask task = new AutoScalingCreateLaunchConfigTask(imageId, instanceType, instanceProfileName, launchConfigName, securityGroupNamesOrIds, keyName, userData, associatePublicIp);
        this.checkResult(task, new AutoScalingSystemActivity(), "failed to create launch configuration");
    }

    public void createAutoScalingGroup(String groupName, List<String> availabilityZones, String vpcZoneIdentifier, int capacity, String launchConfigName, String tagKey, String tagValue) {
        AutoScalingCreateGroupTask task = new AutoScalingCreateGroupTask(groupName, availabilityZones, vpcZoneIdentifier, capacity, launchConfigName, tagKey, tagValue);
        this.checkResult(task, new AutoScalingSystemActivity(), "failed to create autoscaling group");
    }

    public void createOrUpdateAutoscalingTags(String tagKey, String tagValue, String asgName) {
        AutoscalingCreateOrUpdateTagsTask task = new AutoscalingCreateOrUpdateTagsTask(tagKey, tagValue, asgName);
        this.checkResult(task, new AutoScalingSystemActivity(), "failed to create/update autoscaling tags");
    }

    public LaunchConfigurationType describeLaunchConfiguration(String launchConfigName) {
        return this.resultOf(new AutoScalingDescribeLaunchConfigsTask(launchConfigName), new AutoScalingSystemActivity(), "failed to describe launch configuration");
    }

    public void deleteLaunchConfiguration(String launchConfigName) {
        this.checkResult(new AutoScalingDeleteLaunchConfigTask(launchConfigName), new AutoScalingSystemActivity(), "failed to delete launch configuration");
    }

    public void deleteAutoScalingGroup(String groupName, boolean terminateInstances) {
        this.checkResult(new AutoScalingDeleteGroupTask(groupName, terminateInstances), new AutoScalingSystemActivity(), "failed to delete autoscaling group");
    }

    public DescribeAutoScalingGroupsResponseType describeAutoScalingGroups(List<String> groupNames) {
        return this.resultOf(new AutoScalingDescribeGroupsTask(groupNames), new AutoScalingSystemActivity(), "failed to describe autoscaling groups");
    }

    public void updateAutoScalingGroup(String groupName, List<String> zones, int capacity) {
        this.updateAutoScalingGroup(groupName, zones, capacity, null);
    }

    public void updateAutoScalingGroup(String groupName, List<String> zones, Integer capacity, String launchConfigName) {
        this.checkResult(new AutoScalingUpdateGroupTask(groupName, zones, capacity, launchConfigName), new AutoScalingSystemActivity(), "failed to update autoscaling group");
    }

    public List<RoleType> listRoles(String pathPrefix) {
        return this.resultOf(new EuareListRolesTask(pathPrefix), new EuareSystemActivity(), "failed to list IAM roles");
    }

    public RoleType createRole(String roleName, String path, String assumeRolePolicy) {
        return this.resultOf(new EuareCreateRoleTask(roleName, path, assumeRolePolicy), new EuareSystemActivity(), "failed to create IAM role");
    }

    public List<DescribeKeyPairsResponseItemType> describeKeyPairs(List<String> keyNames) {
        return this.resultOf(new EucaDescribeKeyPairsTask(keyNames), new EucalyptusSystemActivity(), "failed to describe keypairs");
    }

    public List<SecurityGroupItemType> describeUserSecurityGroupsById(String userId, String vpcId, Collection<String> securityGroupIds) {
        return this.resultOf(new EucaDescribeSecurityGroupsTask(vpcId, securityGroupIds), new EucalyptusUserActivity(userId), "failed to describe security groups");
    }

    public void modifySecurityGroups(String instanceId, Collection<String> securityGroupIds) {
        this.checkResult(new EucalyptusModifySecurityGroupsTask(instanceId, securityGroupIds), new EucalyptusSystemActivity(), "failed to modify security groups");
    }

    public List<VpcType> describeVpcs(Collection<String> vpcIds) {
        return this.resultOf(new EucaDescribeVpcsTask(vpcIds), new EucalyptusSystemActivity(), "failed to describe vpcs");
    }

    public Optional<VpcType> defaultVpc(String userId) {
        return Iterables.tryFind((Iterable)this.resultOf(new EucaDescribeVpcsTask((Boolean)true), new EucalyptusUserActivity(userId), "failed to describe default vpc"), (Predicate)Predicates.alwaysTrue());
    }

    public List<SubnetType> describeSubnets(Collection<String> subnetIds) {
        return this.resultOf(new EucaDescribeSubnetsTask(subnetIds), new EucalyptusSystemActivity(), "failed to describe subnets");
    }

    public List<SubnetType> describeSubnetsByZone(String vpcId, Boolean defaultSubnet, Collection<String> zones) {
        return this.resultOf(new EucaDescribeSubnetsTask(vpcId, defaultSubnet, zones), new EucalyptusSystemActivity(), "failed to describe subnets");
    }

    public List<InternetGatewayType> describeInternetGateways(Collection<String> vpcIds) {
        return this.resultOf(new EucaDescribeInternetGatewaysTask(vpcIds), new EucalyptusSystemActivity(), "failed to describe internet gateways");
    }

    public ServerCertificateType getServerCertificate(String userId, String certName) {
        return this.resultOf(new EuareGetServerCertificateTask(certName), new EuareUserActivity(userId), "failed to get server certificate");
    }

    public void deleteRole(String roleName) {
        this.checkResult(new EuareDeleteRoleTask(roleName), new EuareSystemActivity(), "failed to delete IAM role");
    }

    public List<InstanceProfileType> listInstanceProfiles(String pathPrefix) {
        return this.resultOf(new EuareListInstanceProfilesTask(pathPrefix), new EuareSystemActivity(), "failed to list IAM instance profile");
    }

    public InstanceProfileType createInstanceProfile(String profileName, String path) {
        return this.resultOf(new EuareCreateInstanceProfileTask(profileName, path), new EuareSystemActivity(), "failed to create IAM instance profile");
    }

    public void deleteInstanceProfile(String profileName) {
        this.checkResult(new EuareDeleteInstanceProfileTask(profileName), new EuareSystemActivity(), "failed to delete IAM instance profile");
    }

    public void addRoleToInstanceProfile(String instanceProfileName, String roleName) {
        this.checkResult(new EuareAddRoleToInstanceProfileTask(instanceProfileName, roleName), new EuareSystemActivity(), "failed to add role to the instance profile");
    }

    public void removeRoleFromInstanceProfile(String instanceProfileName, String roleName) {
        this.checkResult(new EuareRemoveRoleFromInstanceProfileTask(instanceProfileName, roleName), new EuareSystemActivity(), "failed to remove role from the instance profile");
    }

    public List<String> listRolePolicies(String roleName) {
        return this.resultOf(new EuareListRolePoliciesTask(roleName), new EuareSystemActivity(), "failed to list role's policies");
    }

    public GetRolePolicyResult getRolePolicy(String roleName, String policyName) {
        return this.resultOf(new EuareGetRolePolicyTask(roleName, policyName), new EuareSystemActivity(), "failed to get role's policy");
    }

    public void putRolePolicy(String roleName, String policyName, String policyDocument) {
        this.checkResult(new EuarePutRolePolicyTask(roleName, policyName, policyDocument), new EuareSystemActivity(), "failed to put role's policy");
    }

    public void deleteRolePolicy(String roleName, String policyName) {
        this.checkResult(new EuareDeleteRolePolicyTask(roleName, policyName), new EuareSystemActivity(), "failed to delete role's policy");
    }

    public List<ImageDetails> describeImages(List<String> imageIds) {
        return this.resultOf(new EucaDescribeImagesTask(imageIds), new EucalyptusSystemActivity(), "failed to describe images");
    }

    public void createTags(String tagKey, String tagValue, List<String> resources) {
        this.checkResult(new EucaCreateTagsTask(tagKey, tagValue, resources), new EucalyptusSystemActivity(), "failed to create tags");
    }

    public void deleteTags(String tagKey, String tagValue, List<String> resources) {
        this.checkResult(new EucaDeleteTagsTask(tagKey, tagValue, resources), new EucalyptusSystemActivity(), "failed to delete tags");
    }

    private static Filter filter(String name, String value) {
        return EucalyptusActivityTasks.filter(name, Collections.singleton(value));
    }

    private static Filter filter(String name, Iterable<String> values) {
        Filter filter = new Filter();
        filter.setName(name);
        filter.setValueSet(Lists.newArrayList(values));
        return filter;
    }

    private <TM extends BaseMessage, TC extends ComponentId> void checkResult(EucalyptusActivityTask<TM, TC> task, ActivityContext<TM, TC> context, String errorMessage) {
        CheckedListenableFuture<Boolean> result = task.dispatch(context);
        try {
            if (!((Boolean)result.get()).booleanValue()) {
                throw new EucalyptusActivityException(errorMessage);
            }
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private <TM extends BaseMessage, TC extends ComponentId, R> R resultOf(EucalyptusActivityTaskWithResult<TM, TC, R> task, ActivityContext<TM, TC> context, String errorMessage) {
        CheckedListenableFuture<Boolean> result = task.dispatch(context);
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getResult();
            }
            throw new EucalyptusActivityException(errorMessage);
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private abstract class EucalyptusActivityTaskWithResult<TM extends BaseMessage, TC extends ComponentId, R>
    extends EucalyptusActivityTask<TM, TC> {
        private final AtomicReference<R> r;

        private EucalyptusActivityTaskWithResult() {
            this.r = new AtomicReference();
        }

        abstract R extractResult(TM var1);

        final R getResult() {
            return this.r.get();
        }

        @Override
        void dispatchSuccess(ActivityContext<TM, TC> context, TM response) {
            this.r.set(this.extractResult(response));
        }
    }

    private abstract class EucalyptusActivityTask<TM extends BaseMessage, TC extends ComponentId> {
        protected EucalyptusActivityTask() {
        }

        final CheckedListenableFuture<Boolean> dispatch(final ActivityContext<TM, TC> context) {
            try {
                final CheckedListenableFuture future = Futures.newGenericeFuture();
                this.dispatchInternal(context, new Callback.Checked<TM>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void fireException(Throwable throwable) {
                        try {
                            EucalyptusActivityTask.this.dispatchFailure(context, throwable);
                        }
                        finally {
                            future.set((Object)false);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void fire(TM response) {
                        try {
                            EucalyptusActivityTask.this.dispatchSuccess(context, response);
                        }
                        finally {
                            future.set((Object)true);
                        }
                    }
                });
                return future;
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                return Futures.predestinedFuture((Object)false);
            }
        }

        abstract TM getRequest();

        final void dispatchInternal(ActivityContext<TM, TC> context, Callback.Checked<TM> callback) {
            DispatchingClient<TM, TC> client = context.getClient();
            client.dispatch(this.getRequest(), callback);
        }

        void dispatchFailure(ActivityContext<TM, TC> context, Throwable throwable) {
            LOG.error((Object)"Loadbalancer activity error", throwable);
        }

        void dispatchSuccess(ActivityContext<TM, TC> context, TM response) {
        }
    }

    private class EucalyptusModifySecurityGroupsTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private final String instanceId;
        private final Collection<String> securityGroupIds;

        EucalyptusModifySecurityGroupsTask(String instanceId, Collection<String> securityGroupIds) {
            this.instanceId = instanceId;
            this.securityGroupIds = securityGroupIds;
        }

        @Override
        ComputeMessage getRequest() {
            ModifyInstanceAttributeType modifyInstanceAttribute = new ModifyInstanceAttributeType();
            modifyInstanceAttribute.setInstanceId(this.instanceId);
            modifyInstanceAttribute.setGroupIdSet(new GroupIdSetType());
            for (String securityGroupId : this.securityGroupIds) {
                SecurityGroupIdSetItemType id = new SecurityGroupIdSetItemType();
                id.setGroupId(securityGroupId);
                modifyInstanceAttribute.getGroupIdSet().getItem().add(id);
            }
            return modifyInstanceAttribute;
        }
    }

    private class EucalyptusDescribeSecurityGroupTask
    extends EucalyptusActivityTaskWithResult<ComputeMessage, Eucalyptus, List<SecurityGroupItemType>> {
        @Nullable
        private List<String> groupIds = null;
        @Nullable
        private List<String> groupNames = null;
        @Nullable
        private List<String> groupNameFilters = null;
        @Nullable
        private String vpcId = null;

        EucalyptusDescribeSecurityGroupTask(@Nullable List<String> groupIds, @Nullable List<String> groupNames, @Nullable List<String> groupNameFilters, String vpcId) {
            this.groupIds = groupIds;
            this.groupNames = groupNames;
            this.groupNameFilters = groupNameFilters;
            this.vpcId = vpcId;
        }

        @Override
        DescribeSecurityGroupsType getRequest() {
            DescribeSecurityGroupsType req = new DescribeSecurityGroupsType();
            if (this.groupIds != null && !this.groupIds.isEmpty()) {
                req.getFilterSet().add(EucalyptusActivityTasks.filter("group-id", this.groupIds));
            }
            if (this.groupNames != null && !this.groupNames.isEmpty()) {
                req.setSecurityGroupSet(Lists.newArrayList(this.groupNames));
            }
            if (this.groupNameFilters != null && !this.groupNameFilters.isEmpty()) {
                req.getFilterSet().add(EucalyptusActivityTasks.filter("group-name", this.groupNameFilters));
            }
            if (this.vpcId != null) {
                req.getFilterSet().add(EucalyptusActivityTasks.filter("vpc-id", this.vpcId));
            }
            return req;
        }

        @Override
        List<SecurityGroupItemType> extractResult(ComputeMessage response) {
            DescribeSecurityGroupsResponseType resp = (DescribeSecurityGroupsResponseType)response;
            return resp.getSecurityGroupInfo();
        }
    }

    private class EucalyptusDeleteGroupTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private String groupName = null;

        EucalyptusDeleteGroupTask(String groupName) {
            this.groupName = groupName;
        }

        @Override
        DeleteSecurityGroupType getRequest() {
            DeleteSecurityGroupType req = new DeleteSecurityGroupType();
            req.setGroupName(this.groupName);
            return req;
        }
    }

    private class EucalyptusRevokeIngressRuleTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        String groupName = null;
        String protocol = null;
        int portNum = 1;

        EucalyptusRevokeIngressRuleTask(String groupName, String protocol, int portNum) {
            this.groupName = groupName;
            this.protocol = protocol;
            this.portNum = portNum;
        }

        @Override
        RevokeSecurityGroupIngressType getRequest() {
            RevokeSecurityGroupIngressType req = new RevokeSecurityGroupIngressType();
            req.setGroupName(this.groupName);
            IpPermissionType perm = new IpPermissionType();
            perm.setFromPort(Integer.valueOf(this.portNum));
            perm.setToPort(Integer.valueOf(this.portNum));
            perm.setCidrIpRanges((Collection)Lists.newArrayList(Arrays.asList("0.0.0.0/0")));
            perm.setIpProtocol(this.protocol);
            req.setIpPermissions(Lists.newArrayList(Arrays.asList(perm)));
            return req;
        }
    }

    private class EucalyptusAuthorizeIngressRuleTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        String groupNameOrId = null;
        String protocol = null;
        int portNum = 1;

        EucalyptusAuthorizeIngressRuleTask(String groupNameOrId, String protocol, int portNum) {
            this.groupNameOrId = groupNameOrId;
            this.protocol = protocol;
            this.portNum = portNum;
        }

        @Override
        AuthorizeSecurityGroupIngressType getRequest() {
            AuthorizeSecurityGroupIngressType req = new AuthorizeSecurityGroupIngressType();
            if (this.groupNameOrId.matches("sg-[0-9a-fA-F]{8}")) {
                req.setGroupId(this.groupNameOrId);
            } else {
                req.setGroupName(this.groupNameOrId);
            }
            IpPermissionType perm = new IpPermissionType();
            perm.setFromPort(Integer.valueOf(this.portNum));
            perm.setToPort(Integer.valueOf(this.portNum));
            perm.setCidrIpRanges(Collections.singleton("0.0.0.0/0"));
            perm.setIpProtocol(this.protocol);
            req.getIpPermissions().add(perm);
            return req;
        }
    }

    private class EucalyptusCreateGroupTask
    extends EucalyptusActivityTaskWithResult<ComputeMessage, Eucalyptus, String> {
        private String groupName = null;
        private String groupDesc = null;

        EucalyptusCreateGroupTask(String groupName, String groupDesc) {
            this.groupName = groupName;
            this.groupDesc = groupDesc;
        }

        @Override
        CreateSecurityGroupType getRequest() {
            CreateSecurityGroupType req = new CreateSecurityGroupType();
            req.setGroupName(this.groupName);
            req.setGroupDescription(this.groupDesc);
            return req;
        }

        @Override
        String extractResult(ComputeMessage response) {
            CreateSecurityGroupResponseType resp = (CreateSecurityGroupResponseType)response;
            return resp.getGroupId();
        }
    }

    private class EucalyptusDescribeInstanceTask
    extends EucalyptusActivityTaskWithResult<ComputeMessage, Eucalyptus, List<RunningInstancesItemType>> {
        private final List<String> instanceIds;
        private boolean verbose = false;

        private EucalyptusDescribeInstanceTask(List<String> instanceId) {
            this.instanceIds = instanceId;
        }

        private EucalyptusDescribeInstanceTask(List<String> instanceId, boolean verbose) {
            this.instanceIds = instanceId;
            this.verbose = verbose;
        }

        @Override
        DescribeInstancesType getRequest() {
            DescribeInstancesType req = new DescribeInstancesType();
            ArrayList instances = Lists.newArrayList(this.instanceIds);
            if (this.verbose) {
                instances.add("verbose");
            }
            req.setInstancesSet(instances);
            return req;
        }

        @Override
        List<RunningInstancesItemType> extractResult(ComputeMessage response) {
            DescribeInstancesResponseType resp = (DescribeInstancesResponseType)response;
            ArrayList resultInstances = Lists.newArrayList();
            for (ReservationInfoType res : resp.getReservationSet()) {
                resultInstances.addAll(res.getInstancesSet());
            }
            return resultInstances;
        }
    }

    private class DnsRemoveMultiARecordTask
    extends EucalyptusActivityTask<DnsMessage, Dns> {
        private String zone = null;
        private String name = null;

        private DnsRemoveMultiARecordTask(String zone, String name) {
            this.zone = zone;
            this.name = name;
        }

        @Override
        RemoveMultiANameType getRequest() {
            RemoveMultiANameType req = new RemoveMultiANameType();
            req.setZone(this.zone);
            req.setName(this.name);
            return req;
        }
    }

    private class DnsRemoveARecordTask
    extends EucalyptusActivityTask<DnsMessage, Dns> {
        private String zone = null;
        private String name = null;
        private String address = null;

        private DnsRemoveARecordTask(String zone, String name, String address) {
            this.zone = zone;
            this.name = name;
            this.address = address;
        }

        @Override
        RemoveMultiARecordType getRequest() {
            RemoveMultiARecordType req = new RemoveMultiARecordType();
            req.setZone(this.zone);
            req.setName(this.name);
            req.setAddress(this.address);
            return req;
        }
    }

    private class DnsAddARecordTask
    extends EucalyptusActivityTask<DnsMessage, Dns> {
        private String zone = null;
        private String name = null;
        private String address = null;

        private DnsAddARecordTask(String zone, String name, String address) {
            this.zone = zone;
            this.name = name;
            this.address = address;
        }

        @Override
        AddMultiARecordType getRequest() {
            AddMultiARecordType req = new AddMultiARecordType();
            req.setZone(this.zone);
            req.setName(this.name);
            req.setAddress(this.address);
            req.setTtl((long)LoadBalancerDnsRecord.getLoadbalancerTTL());
            return req;
        }
    }

    private class DnsCreateNameRecordTask
    extends EucalyptusActivityTask<DnsMessage, Dns> {
        private String zone = null;
        private String name = null;

        private DnsCreateNameRecordTask(String zone, String name) {
            this.zone = zone;
            this.name = name;
        }

        @Override
        CreateMultiARecordType getRequest() {
            CreateMultiARecordType req = new CreateMultiARecordType();
            req.setZone(this.zone);
            req.setName(this.name);
            req.setTtl((long)LoadBalancerDnsRecord.getLoadbalancerTTL());
            return req;
        }
    }

    private class EucalyptusDescribeServicesTask
    extends EucalyptusActivityTaskWithResult<EmpyreanMessage, Empyrean, List<ServiceStatusType>> {
        private String componentType = null;

        private EucalyptusDescribeServicesTask(String componentType) {
            this.componentType = componentType;
        }

        @Override
        DescribeServicesType getRequest() {
            DescribeServicesType req = new DescribeServicesType();
            req.setByServiceType(this.componentType);
            return req;
        }

        @Override
        List<ServiceStatusType> extractResult(EmpyreanMessage response) {
            DescribeServicesResponseType resp = (DescribeServicesResponseType)response;
            return resp.getServiceStatuses();
        }
    }

    private class EucalyptusDescribeAvailabilityZonesTask
    extends EucalyptusActivityTaskWithResult<ComputeMessage, Eucalyptus, List<ClusterInfoType>> {
        private boolean verbose = false;

        private EucalyptusDescribeAvailabilityZonesTask(boolean verbose) {
            this.verbose = verbose;
        }

        @Override
        DescribeAvailabilityZonesType getRequest() {
            DescribeAvailabilityZonesType req = new DescribeAvailabilityZonesType();
            if (this.verbose) {
                req.setAvailabilityZoneSet(Lists.newArrayList((Object[])new String[]{"verbose"}));
            }
            return req;
        }

        @Override
        List<ClusterInfoType> extractResult(ComputeMessage response) {
            DescribeAvailabilityZonesResponseType resp = (DescribeAvailabilityZonesResponseType)response;
            return resp.getAvailabilityZoneInfo();
        }
    }

    private class CloudWatchPutMetricDataTask
    extends EucalyptusActivityTask<CloudWatchMessage, CloudWatch> {
        private MetricData metricData = null;
        private String namespace = null;

        private CloudWatchPutMetricDataTask(String namespace, MetricData data) {
            this.namespace = namespace;
            this.metricData = data;
        }

        @Override
        PutMetricDataType getRequest() {
            PutMetricDataType request = new PutMetricDataType();
            request.setNamespace(this.namespace);
            request.setMetricData(this.metricData);
            return request;
        }
    }

    private class AutoScalingCreateLaunchConfigTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private final String imageId;
        private final String instanceType;
        private final String instanceProfileName;
        private final String launchConfigName;
        private final Collection<String> securityGroupNamesOrIds;
        private final String keyName;
        private final String userData;
        private final boolean associatePublicIp;

        private AutoScalingCreateLaunchConfigTask(String imageId, String instanceType, String instanceProfileName, String launchConfigName, Collection<String> securityGroupNamesOrIds, String keyName, String userData, boolean associatePublicIp) {
            this.imageId = imageId;
            this.instanceType = instanceType;
            this.instanceProfileName = instanceProfileName;
            this.launchConfigName = launchConfigName;
            this.securityGroupNamesOrIds = securityGroupNamesOrIds;
            this.keyName = keyName;
            this.userData = userData;
            this.associatePublicIp = associatePublicIp;
        }

        @Override
        CreateLaunchConfigurationType getRequest() {
            CreateLaunchConfigurationType req = new CreateLaunchConfigurationType();
            req.setImageId(this.imageId);
            req.setInstanceType(this.instanceType);
            req.setIamInstanceProfile(this.instanceProfileName);
            req.setKeyName(this.keyName);
            req.setLaunchConfigurationName(this.launchConfigName);
            req.setSecurityGroups(new SecurityGroups(this.securityGroupNamesOrIds));
            req.setUserData(this.userData);
            req.setAssociatePublicIpAddress(this.associatePublicIp ? Boolean.TRUE : null);
            return req;
        }
    }

    private class AutoScalingDescribeLaunchConfigsTask
    extends EucalyptusActivityTaskWithResult<AutoScalingMessage, AutoScaling, LaunchConfigurationType> {
        private String launchConfigName = null;

        private AutoScalingDescribeLaunchConfigsTask(String launchConfigName) {
            this.launchConfigName = launchConfigName;
        }

        @Override
        DescribeLaunchConfigurationsType getRequest() {
            DescribeLaunchConfigurationsType req = new DescribeLaunchConfigurationsType();
            LaunchConfigurationNames names = new LaunchConfigurationNames();
            names.setMember(Lists.newArrayList((Object[])new String[]{this.launchConfigName}));
            req.setLaunchConfigurationNames(names);
            return req;
        }

        @Override
        LaunchConfigurationType extractResult(AutoScalingMessage response) {
            DescribeLaunchConfigurationsResponseType resp = (DescribeLaunchConfigurationsResponseType)response;
            try {
                return (LaunchConfigurationType)resp.getDescribeLaunchConfigurationsResult().getLaunchConfigurations().getMember().get(0);
            }
            catch (Exception ex) {
                LOG.error((Object)"Launch configuration is not found from the response");
                return null;
            }
        }
    }

    private class AutoScalingDeleteLaunchConfigTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private String launchConfigName = null;

        private AutoScalingDeleteLaunchConfigTask(String launchConfigName) {
            this.launchConfigName = launchConfigName;
        }

        @Override
        DeleteLaunchConfigurationType getRequest() {
            DeleteLaunchConfigurationType req = new DeleteLaunchConfigurationType();
            req.setLaunchConfigurationName(this.launchConfigName);
            return req;
        }
    }

    private class AutoScalingDeleteGroupTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private String groupName = null;
        private boolean terminateInstances = false;

        private AutoScalingDeleteGroupTask(String groupName, boolean terminateInstances) {
            this.groupName = groupName;
            this.terminateInstances = terminateInstances;
        }

        @Override
        DeleteAutoScalingGroupType getRequest() {
            DeleteAutoScalingGroupType req = new DeleteAutoScalingGroupType();
            req.setAutoScalingGroupName(this.groupName);
            req.setForceDelete(Boolean.valueOf(this.terminateInstances));
            return req;
        }
    }

    private class AutoscalingCreateOrUpdateTagsTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private String tagKey = null;
        private String tagValue = null;
        private String asgName = null;

        private AutoscalingCreateOrUpdateTagsTask(String tagKey, String tagValue, String asgName) {
            this.tagKey = tagKey;
            this.tagValue = tagValue;
            this.asgName = asgName;
        }

        @Override
        AutoScalingMessage getRequest() {
            CreateOrUpdateTagsType req = new CreateOrUpdateTagsType();
            Tags tags = new Tags();
            TagType tag = new TagType();
            tag.setKey(this.tagKey);
            tag.setValue(this.tagValue);
            tag.setPropagateAtLaunch(Boolean.valueOf(true));
            tag.setResourceType("auto-scaling-group");
            tag.setResourceId(this.asgName);
            tags.setMember(Lists.newArrayList((Object[])new TagType[]{tag}));
            req.setTags(tags);
            return req;
        }
    }

    private class AutoScalingCreateGroupTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private String groupName = null;
        private List<String> availabilityZones = null;
        private String vpcZoneIdentifier;
        private int capacity = 1;
        private String launchConfigName = null;
        private String tagKey = null;
        private String tagValue = null;

        private AutoScalingCreateGroupTask(String groupName, List<String> zones, String vpcZoneIdentifier, int capacity, String launchConfig, String tagKey, String tagValue) {
            this.groupName = groupName;
            this.availabilityZones = zones;
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            this.capacity = capacity;
            this.launchConfigName = launchConfig;
            this.tagKey = tagKey;
            this.tagValue = tagValue;
        }

        @Override
        CreateAutoScalingGroupType getRequest() {
            CreateAutoScalingGroupType req = new CreateAutoScalingGroupType();
            req.setAutoScalingGroupName(this.groupName);
            req.setAvailabilityZones(new AvailabilityZones(this.availabilityZones));
            req.setVpcZoneIdentifier(this.vpcZoneIdentifier);
            req.setDesiredCapacity(Integer.valueOf(this.capacity));
            req.setMaxSize(Integer.valueOf(this.capacity));
            req.setMinSize(Integer.valueOf(this.capacity));
            req.setHealthCheckType("EC2");
            req.setLaunchConfigurationName(this.launchConfigName);
            Tags tags = new Tags();
            TagType tag = new TagType();
            tag.setKey(this.tagKey);
            tag.setValue(this.tagValue);
            tag.setPropagateAtLaunch(Boolean.valueOf(true));
            tag.setResourceType("auto-scaling-group");
            tag.setResourceId(this.groupName);
            tags.setMember(Lists.newArrayList((Object[])new TagType[]{tag}));
            req.setTags(tags);
            return req;
        }
    }

    private class AutoScalingDescribeGroupsTask
    extends EucalyptusActivityTaskWithResult<AutoScalingMessage, AutoScaling, DescribeAutoScalingGroupsResponseType> {
        private List<String> groupNames = null;

        private AutoScalingDescribeGroupsTask(List<String> groupNames) {
            this.groupNames = groupNames;
        }

        @Override
        DescribeAutoScalingGroupsType getRequest() {
            DescribeAutoScalingGroupsType req = new DescribeAutoScalingGroupsType();
            AutoScalingGroupNames names = new AutoScalingGroupNames();
            names.setMember(Lists.newArrayList());
            names.getMember().addAll(this.groupNames);
            req.setAutoScalingGroupNames(names);
            return req;
        }

        @Override
        DescribeAutoScalingGroupsResponseType extractResult(AutoScalingMessage response) {
            return (DescribeAutoScalingGroupsResponseType)response;
        }
    }

    private class AutoScalingUpdateGroupTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private String groupName = null;
        private List<String> availabilityZones = null;
        private Integer capacity = null;
        private String launchConfigName = null;

        private AutoScalingUpdateGroupTask(String groupName, List<String> zones, Integer capacity, String launchConfig) {
            this.groupName = groupName;
            this.availabilityZones = zones;
            this.capacity = capacity;
            this.launchConfigName = launchConfig;
        }

        @Override
        UpdateAutoScalingGroupType getRequest() {
            UpdateAutoScalingGroupType req = new UpdateAutoScalingGroupType();
            req.setAutoScalingGroupName(this.groupName);
            if (this.availabilityZones != null && this.availabilityZones.size() > 0) {
                AvailabilityZones zones = new AvailabilityZones();
                zones.setMember(Lists.newArrayList());
                zones.getMember().addAll(this.availabilityZones);
                req.setAvailabilityZones(zones);
            }
            if (this.capacity != null) {
                req.setDesiredCapacity(this.capacity);
                req.setMaxSize(this.capacity);
                req.setMinSize(this.capacity);
            }
            if (this.launchConfigName != null) {
                req.setLaunchConfigurationName(this.launchConfigName);
            }
            return req;
        }
    }

    private class EuareDeleteRolePolicyTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String roleName = null;
        private String policyName = null;

        private EuareDeleteRolePolicyTask(String roleName, String policyName) {
            this.roleName = roleName;
            this.policyName = policyName;
        }

        @Override
        DeleteRolePolicyType getRequest() {
            DeleteRolePolicyType req = new DeleteRolePolicyType();
            req.setRoleName(this.roleName);
            req.setPolicyName(this.policyName);
            return req;
        }
    }

    private class EuareGetRolePolicyTask
    extends EucalyptusActivityTaskWithResult<EuareMessage, Euare, GetRolePolicyResult> {
        private String roleName = null;
        private String policyName = null;

        private EuareGetRolePolicyTask(String roleName, String policyName) {
            this.roleName = roleName;
            this.policyName = policyName;
        }

        @Override
        GetRolePolicyType getRequest() {
            GetRolePolicyType req = new GetRolePolicyType();
            req.setRoleName(this.roleName);
            req.setPolicyName(this.policyName);
            return req;
        }

        @Override
        GetRolePolicyResult extractResult(EuareMessage response) {
            try {
                GetRolePolicyResponseType resp = (GetRolePolicyResponseType)response;
                return resp.getGetRolePolicyResult();
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    private class EuareListRolePoliciesTask
    extends EucalyptusActivityTaskWithResult<EuareMessage, Euare, List<String>> {
        private String roleName = null;

        private EuareListRolePoliciesTask(String roleName) {
            this.roleName = roleName;
        }

        @Override
        ListRolePoliciesType getRequest() {
            ListRolePoliciesType req = new ListRolePoliciesType();
            req.setRoleName(this.roleName);
            return req;
        }

        @Override
        List<String> extractResult(EuareMessage response) {
            try {
                ListRolePoliciesResponseType resp = (ListRolePoliciesResponseType)response;
                return resp.getListRolePoliciesResult().getPolicyNames().getMemberList();
            }
            catch (Exception ex) {
                return Lists.newArrayList();
            }
        }
    }

    private class EuarePutRolePolicyTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String roleName = null;
        private String policyName = null;
        private String policyDocument = null;

        private EuarePutRolePolicyTask(String roleName, String policyName, String policyDocument) {
            this.roleName = roleName;
            this.policyName = policyName;
            this.policyDocument = policyDocument;
        }

        @Override
        PutRolePolicyType getRequest() {
            PutRolePolicyType req = new PutRolePolicyType();
            req.setRoleName(this.roleName);
            req.setPolicyName(this.policyName);
            req.setPolicyDocument(this.policyDocument);
            return req;
        }
    }

    private class EuareListRolesTask
    extends EucalyptusActivityTaskWithResult<EuareMessage, Euare, List<RoleType>> {
        private String pathPrefix = null;

        private EuareListRolesTask(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        @Override
        ListRolesType getRequest() {
            ListRolesType req = new ListRolesType();
            req.setPathPrefix(this.pathPrefix);
            return req;
        }

        @Override
        List<RoleType> extractResult(EuareMessage response) {
            ListRolesResponseType resp = (ListRolesResponseType)response;
            try {
                return resp.getListRolesResult().getRoles().getMember();
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    private class EuareCreateRoleTask
    extends EucalyptusActivityTaskWithResult<EuareMessage, Euare, RoleType> {
        String roleName = null;
        String path = null;
        String assumeRolePolicy = null;

        private EuareCreateRoleTask(String roleName, String path, String assumeRolePolicy) {
            this.roleName = roleName;
            this.path = path;
            this.assumeRolePolicy = assumeRolePolicy;
        }

        @Override
        CreateRoleType getRequest() {
            CreateRoleType req = new CreateRoleType();
            req.setRoleName(this.roleName);
            req.setPath(this.path);
            req.setAssumeRolePolicyDocument(this.assumeRolePolicy);
            return req;
        }

        @Override
        RoleType extractResult(EuareMessage response) {
            CreateRoleResponseType resp = (CreateRoleResponseType)response;
            try {
                return resp.getCreateRoleResult().getRole();
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    private class EuareDeleteRoleTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String roleName = null;

        private EuareDeleteRoleTask(String roleName) {
            this.roleName = roleName;
        }

        @Override
        DeleteRoleType getRequest() {
            DeleteRoleType req = new DeleteRoleType();
            req.setRoleName(this.roleName);
            return req;
        }
    }

    private class EuareCreateInstanceProfileTask
    extends EucalyptusActivityTaskWithResult<EuareMessage, Euare, InstanceProfileType> {
        private String profileName = null;
        private String path = null;

        private EuareCreateInstanceProfileTask(String profileName, String path) {
            this.profileName = profileName;
            this.path = path;
        }

        @Override
        CreateInstanceProfileType getRequest() {
            CreateInstanceProfileType req = new CreateInstanceProfileType();
            req.setInstanceProfileName(this.profileName);
            req.setPath(this.path);
            return req;
        }

        @Override
        InstanceProfileType extractResult(EuareMessage response) {
            CreateInstanceProfileResponseType resp = (CreateInstanceProfileResponseType)response;
            try {
                return resp.getCreateInstanceProfileResult().getInstanceProfile();
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    private class EuareListInstanceProfilesTask
    extends EucalyptusActivityTaskWithResult<EuareMessage, Euare, List<InstanceProfileType>> {
        private String pathPrefix = null;

        private EuareListInstanceProfilesTask(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        @Override
        ListInstanceProfilesType getRequest() {
            ListInstanceProfilesType req = new ListInstanceProfilesType();
            req.setPathPrefix(this.pathPrefix);
            return req;
        }

        @Override
        List<InstanceProfileType> extractResult(EuareMessage response) {
            ListInstanceProfilesResponseType resp = (ListInstanceProfilesResponseType)response;
            try {
                return resp.getListInstanceProfilesResult().getInstanceProfiles().getMember();
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    private class EuareRemoveRoleFromInstanceProfileTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String instanceProfileName = null;
        private String roleName = null;

        private EuareRemoveRoleFromInstanceProfileTask(String instanceProfileName, String roleName) {
            this.instanceProfileName = instanceProfileName;
            this.roleName = roleName;
        }

        @Override
        RemoveRoleFromInstanceProfileType getRequest() {
            RemoveRoleFromInstanceProfileType req = new RemoveRoleFromInstanceProfileType();
            req.setRoleName(this.roleName);
            req.setInstanceProfileName(this.instanceProfileName);
            return req;
        }
    }

    private class EuareAddRoleToInstanceProfileTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String instanceProfileName = null;
        private String roleName = null;

        private EuareAddRoleToInstanceProfileTask(String instanceProfileName, String roleName) {
            this.instanceProfileName = instanceProfileName;
            this.roleName = roleName;
        }

        @Override
        AddRoleToInstanceProfileType getRequest() {
            AddRoleToInstanceProfileType req = new AddRoleToInstanceProfileType();
            req.setRoleName(this.roleName);
            req.setInstanceProfileName(this.instanceProfileName);
            return req;
        }
    }

    private class EuareDeleteInstanceProfileTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String profileName = null;

        private EuareDeleteInstanceProfileTask(String profileName) {
            this.profileName = profileName;
        }

        @Override
        DeleteInstanceProfileType getRequest() {
            DeleteInstanceProfileType req = new DeleteInstanceProfileType();
            req.setInstanceProfileName(this.profileName);
            return req;
        }
    }

    private class EuareGetServerCertificateTask
    extends EucalyptusActivityTaskWithResult<EuareMessage, Euare, ServerCertificateType> {
        private String certName = null;

        private EuareGetServerCertificateTask(String certName) {
            this.certName = certName;
        }

        @Override
        GetServerCertificateType getRequest() {
            GetServerCertificateType req = new GetServerCertificateType();
            req.setServerCertificateName(this.certName);
            return req;
        }

        @Override
        ServerCertificateType extractResult(EuareMessage response) {
            GetServerCertificateResponseType resp = (GetServerCertificateResponseType)response;
            if (resp.getGetServerCertificateResult() != null) {
                return resp.getGetServerCertificateResult().getServerCertificate();
            }
            return null;
        }
    }

    private class EucaDescribeInternetGatewaysTask
    extends EucalyptusActivityTaskWithResult<ComputeMessage, Eucalyptus, List<InternetGatewayType>> {
        private Collection<String> vpcIds = null;

        private EucaDescribeInternetGatewaysTask(Collection<String> vpcIds) {
            this.vpcIds = vpcIds;
        }

        @Override
        ComputeMessage getRequest() {
            DescribeInternetGatewaysType req = new DescribeInternetGatewaysType();
            req.setInternetGatewayIdSet(new InternetGatewayIdSetType());
            req.getInternetGatewayIdSet().getItem().add(new InternetGatewayIdSetItemType());
            ((InternetGatewayIdSetItemType)req.getInternetGatewayIdSet().getItem().get(0)).setInternetGatewayId("verbose");
            if (this.vpcIds != null) {
                req.getFilterSet().add(EucalyptusActivityTasks.filter("attachment.vpc-id", this.vpcIds));
            }
            return req;
        }

        @Override
        List<InternetGatewayType> extractResult(ComputeMessage response) {
            DescribeInternetGatewaysResponseType resp = (DescribeInternetGatewaysResponseType)response;
            return resp.getInternetGatewaySet().getItem();
        }
    }

    private class EucaDescribeSubnetsTask
    extends EucalyptusActivityTaskWithResult<ComputeMessage, Eucalyptus, List<SubnetType>> {
        private String vpcId = null;
        private Collection<String> subnetIds = null;
        private Collection<String> zones = null;
        private Boolean defaultSubnet = null;

        private EucaDescribeSubnetsTask(Collection<String> subnetIds) {
            this.subnetIds = subnetIds;
        }

        private EucaDescribeSubnetsTask(String vpcId, Boolean defaultSubnet, Collection<String> zones) {
            this.vpcId = vpcId;
            this.defaultSubnet = defaultSubnet;
            this.zones = zones;
        }

        @Override
        ComputeMessage getRequest() {
            DescribeSubnetsType req = new DescribeSubnetsType();
            req.setSubnetSet(new SubnetIdSetType());
            req.getSubnetSet().getItem().add(new SubnetIdSetItemType());
            ((SubnetIdSetItemType)req.getSubnetSet().getItem().get(0)).setSubnetId("verbose");
            if (this.vpcId != null) {
                req.getFilterSet().add(EucalyptusActivityTasks.filter("vpc-id", this.vpcId));
            }
            if (this.subnetIds != null) {
                req.getFilterSet().add(EucalyptusActivityTasks.filter("subnet-id", this.subnetIds));
            }
            if (this.zones != null) {
                req.getFilterSet().add(EucalyptusActivityTasks.filter("availability-zone", this.zones));
            }
            if (this.defaultSubnet != null) {
                req.getFilterSet().add(EucalyptusActivityTasks.filter("default-for-az", String.valueOf(this.defaultSubnet)));
            }
            return req;
        }

        @Override
        List<SubnetType> extractResult(ComputeMessage response) {
            DescribeSubnetsResponseType resp = (DescribeSubnetsResponseType)response;
            return resp.getSubnetSet().getItem();
        }
    }

    private class EucaDescribeVpcsTask
    extends EucalyptusActivityTaskWithResult<ComputeMessage, Eucalyptus, List<VpcType>> {
        private Collection<String> vpcIds;
        private final Boolean defaultVpc;

        private EucaDescribeVpcsTask(Boolean defaultVpc) {
            this(defaultVpc, (Collection<String>)null);
        }

        private EucaDescribeVpcsTask(Collection<String> vpcIds) {
            this(null, vpcIds);
        }

        private EucaDescribeVpcsTask(Boolean defaultVpc, Collection<String> vpcIds) {
            this.defaultVpc = defaultVpc;
            this.vpcIds = vpcIds;
        }

        @Override
        ComputeMessage getRequest() {
            DescribeVpcsType req = new DescribeVpcsType();
            if (this.defaultVpc != null) {
                req.getFilterSet().add(EucalyptusActivityTasks.filter("isDefault", String.valueOf(this.defaultVpc)));
            }
            if (this.vpcIds != null) {
                req.getFilterSet().add(EucalyptusActivityTasks.filter("vpc-id", this.vpcIds));
            }
            return req;
        }

        @Override
        List<VpcType> extractResult(ComputeMessage response) {
            DescribeVpcsResponseType resp = (DescribeVpcsResponseType)response;
            return resp.getVpcSet().getItem();
        }
    }

    private class EucaDescribeSecurityGroupsTask
    extends EucalyptusActivityTaskWithResult<ComputeMessage, Eucalyptus, List<SecurityGroupItemType>> {
        private String vpcId = null;
        private Collection<String> securityGroupIds = null;

        private EucaDescribeSecurityGroupsTask(String vpcId, Collection<String> securityGroupIds) {
            this.vpcId = vpcId;
            this.securityGroupIds = securityGroupIds;
        }

        @Override
        DescribeSecurityGroupsType getRequest() {
            DescribeSecurityGroupsType req = new DescribeSecurityGroupsType();
            if (this.vpcId != null) {
                req.getFilterSet().add(EucalyptusActivityTasks.filter("vpc-id", this.vpcId));
            }
            req.getFilterSet().add(EucalyptusActivityTasks.filter("group-id", this.securityGroupIds));
            return req;
        }

        @Override
        List<SecurityGroupItemType> extractResult(ComputeMessage response) {
            DescribeSecurityGroupsResponseType resp = (DescribeSecurityGroupsResponseType)response;
            return resp.getSecurityGroupInfo();
        }
    }

    private class EucaDescribeKeyPairsTask
    extends EucalyptusActivityTaskWithResult<ComputeMessage, Eucalyptus, List<DescribeKeyPairsResponseItemType>> {
        private List<String> keyNames = null;

        private EucaDescribeKeyPairsTask(List<String> keyNames) {
            this.keyNames = keyNames;
        }

        @Override
        DescribeKeyPairsType getRequest() {
            DescribeKeyPairsType req = new DescribeKeyPairsType();
            if (this.keyNames != null) {
                req.setKeySet(new ArrayList<String>(this.keyNames));
            }
            return req;
        }

        @Override
        List<DescribeKeyPairsResponseItemType> extractResult(ComputeMessage response) {
            DescribeKeyPairsResponseType resp = (DescribeKeyPairsResponseType)response;
            return resp.getKeySet();
        }
    }

    private class EucaCreateTagsTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private String tagKey = null;
        private String tagValue = null;
        private List<String> resources = null;

        private EucaCreateTagsTask(String tagKey, String tagValue, List<String> resources) {
            this.tagKey = tagKey;
            this.tagValue = tagValue;
            this.resources = resources;
        }

        @Override
        CreateTagsType getRequest() {
            CreateTagsType req = new CreateTagsType();
            req.setResourcesSet(Lists.newArrayList(this.resources));
            ResourceTag tag = new ResourceTag();
            tag.setKey(this.tagKey);
            tag.setValue(this.tagValue);
            req.setTagSet(Lists.newArrayList((Object[])new ResourceTag[]{tag}));
            return req;
        }
    }

    private class EucaDeleteTagsTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private String tagKey = null;
        private String tagValue = null;
        private List<String> resources = null;

        private EucaDeleteTagsTask(String tagKey, String tagValue, List<String> resources) {
            this.tagKey = tagKey;
            this.tagValue = tagValue;
            this.resources = resources;
        }

        @Override
        DeleteTagsType getRequest() {
            DeleteTagsType req = new DeleteTagsType();
            req.setResourcesSet(Lists.newArrayList(this.resources));
            DeleteResourceTag tag = new DeleteResourceTag();
            tag.setKey(this.tagKey);
            tag.setValue(this.tagValue);
            req.setTagSet(Lists.newArrayList((Object[])new DeleteResourceTag[]{tag}));
            return req;
        }
    }

    private class EucaDescribeImagesTask
    extends EucalyptusActivityTaskWithResult<ComputeMessage, Eucalyptus, List<ImageDetails>> {
        private List<String> imageIds = null;

        private EucaDescribeImagesTask(List<String> imageIds) {
            this.imageIds = imageIds;
        }

        @Override
        DescribeImagesType getRequest() {
            DescribeImagesType req = new DescribeImagesType();
            if (this.imageIds != null && this.imageIds.size() > 0) {
                req.setImagesSet(new ArrayList<String>(this.imageIds));
            }
            return req;
        }

        @Override
        List<ImageDetails> extractResult(ComputeMessage response) {
            DescribeImagesResponseType resp = (DescribeImagesResponseType)response;
            return resp.getImagesSet();
        }
    }

    private class EucalyptusUserActivity
    extends UserActivityContextSupport<ComputeMessage, Eucalyptus> {
        private EucalyptusUserActivity(String userId) {
            super(Eucalyptus.class, userId);
        }
    }

    private class EucalyptusSystemActivity
    extends SystemActivityContextSupport<ComputeMessage, Eucalyptus> {
        private EucalyptusSystemActivity() {
            super(Eucalyptus.class);
        }
    }

    private class EmpyreanSystemActivity
    extends SystemActivityContextSupport<EmpyreanMessage, Empyrean> {
        private EmpyreanSystemActivity() {
            super(Empyrean.class);
        }
    }

    private class DnsSystemActivity
    extends SystemActivityContextSupport<DnsMessage, Dns> {
        private DnsSystemActivity() {
            super(Dns.class);
        }
    }

    private class CloudWatchUserActivity
    extends UserActivityContextSupport<CloudWatchMessage, CloudWatch> {
        private CloudWatchUserActivity(String userId) {
            super(CloudWatch.class, userId);
        }
    }

    private class AutoScalingSystemActivity
    extends SystemActivityContextSupport<AutoScalingMessage, AutoScaling> {
        private AutoScalingSystemActivity() {
            super(AutoScaling.class);
        }
    }

    private class EuareUserActivity
    extends UserActivityContextSupport<EuareMessage, Euare> {
        private EuareUserActivity(String userId) {
            super(Euare.class, userId);
        }
    }

    private class EuareSystemActivity
    extends SystemActivityContextSupport<EuareMessage, Euare> {
        private EuareSystemActivity() {
            super(Euare.class);
        }
    }

    private abstract class UserActivityContextSupport<TM extends BaseMessage, TC extends ComponentId>
    extends ActivityContextSupport<TM, TC> {
        private String userId;

        private UserActivityContextSupport(Class<TC> componentIdClass, String userId) {
            super(componentIdClass);
            this.userId = null;
            this.userId = userId;
        }

        @Override
        public final String getUserId() {
            return this.userId;
        }
    }

    private abstract class SystemActivityContextSupport<TM extends BaseMessage, TC extends ComponentId>
    extends ActivityContextSupport<TM, TC> {
        private SystemActivityContextSupport(Class<TC> componentIdClass) {
            super(componentIdClass);
        }

        @Override
        public final String getUserId() {
            try {
                return Accounts.lookupSystemAdmin().getUserId();
            }
            catch (AuthException ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    private abstract class ActivityContextSupport<TM extends BaseMessage, TC extends ComponentId>
    implements ActivityContext<TM, TC> {
        private final Class<TC> componentIdClass;

        private ActivityContextSupport(Class<TC> componentIdClass) {
            this.componentIdClass = componentIdClass;
        }

        abstract String getUserId();

        @Override
        public DispatchingClient<TM, TC> getClient() {
            try {
                DispatchingClient client = new DispatchingClient(this.getUserId(), this.componentIdClass);
                client.init();
                return client;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    private static interface ActivityContext<TM extends BaseMessage, TC extends ComponentId> {
        public DispatchingClient<TM, TC> getClient();
    }
}

