/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.activities;

import com.eucalyptus.event.Event;
import com.eucalyptus.event.EventFailedException;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.ListenerRegistry;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.loadbalancing.activities.ApplySecurityGroupsEvent;
import com.eucalyptus.loadbalancing.activities.CreateListenerEvent;
import com.eucalyptus.loadbalancing.activities.DeleteListenerEvent;
import com.eucalyptus.loadbalancing.activities.DeleteLoadbalancerEvent;
import com.eucalyptus.loadbalancing.activities.DeregisterInstancesEvent;
import com.eucalyptus.loadbalancing.activities.DisabledZoneEvent;
import com.eucalyptus.loadbalancing.activities.EnabledZoneEvent;
import com.eucalyptus.loadbalancing.activities.EventHandlerChainException;
import com.eucalyptus.loadbalancing.activities.EventHandlerChains;
import com.eucalyptus.loadbalancing.activities.LoadbalancingEvent;
import com.eucalyptus.loadbalancing.activities.NewLoadbalancerEvent;
import com.eucalyptus.loadbalancing.activities.RegisterInstancesEvent;
import com.eucalyptus.util.Exceptions;
import org.apache.log4j.Logger;

public class ActivityManager {
    private static final Logger LOG = Logger.getLogger(ActivityManager.class);
    private static ActivityManager _instance = new ActivityManager();

    private ActivityManager() {
        LoadbalancerEventListener.register();
    }

    public static ActivityManager getInstance() {
        return _instance;
    }

    public void fire(LoadbalancingEvent evt) throws EventFailedException {
        ListenerRegistry.getInstance().fireThrowableEvent((Event)evt);
    }

    static enum LoadbalancerEventListener implements EventListener<LoadbalancingEvent>
    {
        NewLoadbalancer(NewLoadbalancerEvent.class){

            public void fireEvent(LoadbalancingEvent event) {
                try {
                    EventHandlerChains.onNewLoadbalancer().execute((NewLoadbalancerEvent)event);
                }
                catch (EventHandlerChainException ex) {
                    throw Exceptions.toUndeclared((Throwable)((Object)ex));
                }
            }
        }
        ,
        DeleteLoadbalancer(DeleteLoadbalancerEvent.class){

            public void fireEvent(LoadbalancingEvent event) {
                try {
                    EventHandlerChains.onDeleteLoadbalancer().execute((DeleteLoadbalancerEvent)event);
                }
                catch (EventHandlerChainException ex) {
                    throw Exceptions.toUndeclared((Throwable)((Object)ex));
                }
            }
        }
        ,
        CreateListener(CreateListenerEvent.class){

            public void fireEvent(LoadbalancingEvent event) {
                try {
                    EventHandlerChains.onCreateListener().execute((CreateListenerEvent)event);
                }
                catch (EventHandlerChainException ex) {
                    throw Exceptions.toUndeclared((Throwable)((Object)ex));
                }
            }
        }
        ,
        DeleteListener(DeleteListenerEvent.class){

            public void fireEvent(LoadbalancingEvent event) {
                try {
                    EventHandlerChains.onDeleteListener().execute((DeleteListenerEvent)event);
                }
                catch (EventHandlerChainException ex) {
                    throw Exceptions.toUndeclared((Throwable)((Object)ex));
                }
            }
        }
        ,
        RegisterInstances(RegisterInstancesEvent.class){

            public void fireEvent(LoadbalancingEvent event) {
                try {
                    EventHandlerChains.onRegisterInstances().execute((RegisterInstancesEvent)event);
                }
                catch (EventHandlerChainException ex) {
                    throw Exceptions.toUndeclared((Throwable)((Object)ex));
                }
            }
        }
        ,
        DeregisterInstances(DeregisterInstancesEvent.class){

            public void fireEvent(LoadbalancingEvent event) {
                try {
                    EventHandlerChains.onDeregisterInstances().execute((DeregisterInstancesEvent)event);
                }
                catch (EventHandlerChainException ex) {
                    throw Exceptions.toUndeclared((Throwable)((Object)ex));
                }
            }
        }
        ,
        EnabledZone(EnabledZoneEvent.class){

            public void fireEvent(LoadbalancingEvent event) {
                try {
                    EventHandlerChains.onEnableZones().execute((EnabledZoneEvent)event);
                }
                catch (EventHandlerChainException ex) {
                    throw Exceptions.toUndeclared((Throwable)((Object)ex));
                }
            }
        }
        ,
        DisabledZone(DisabledZoneEvent.class){

            public void fireEvent(LoadbalancingEvent event) {
                try {
                    EventHandlerChains.onDisableZones().execute((DisabledZoneEvent)event);
                }
                catch (EventHandlerChainException ex) {
                    throw Exceptions.toUndeclared((Throwable)((Object)ex));
                }
            }
        }
        ,
        ApplySecurityGroups(ApplySecurityGroupsEvent.class){

            public void fireEvent(LoadbalancingEvent event) {
                try {
                    EventHandlerChains.onApplySecurityGroups().execute((ApplySecurityGroupsEvent)event);
                }
                catch (EventHandlerChainException ex) {
                    throw Exceptions.toUndeclared((Throwable)((Object)ex));
                }
            }
        };

        private final Class<? extends LoadbalancingEvent> evtType;

        private LoadbalancerEventListener(Class<? extends LoadbalancingEvent> type) {
            this.evtType = type;
        }

        public static void register() {
            for (LoadbalancerEventListener listener : LoadbalancerEventListener.values()) {
                Listeners.register(listener.evtType, (EventListener)listener);
            }
        }
    }
}

