/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.euare.ServerCertificateType;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.context.Context;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancerBackendInstance;
import com.eucalyptus.loadbalancing.LoadBalancerDnsRecord;
import com.eucalyptus.loadbalancing.LoadBalancerListener;
import com.eucalyptus.loadbalancing.LoadBalancerSecurityGroupRef;
import com.eucalyptus.loadbalancing.LoadBalancerZone;
import com.eucalyptus.loadbalancing.activities.EucalyptusActivityTasks;
import com.eucalyptus.loadbalancing.activities.LoadBalancerServoInstance;
import com.eucalyptus.loadbalancing.backend.AccessPointNotFoundException;
import com.eucalyptus.loadbalancing.backend.CertificateNotFoundException;
import com.eucalyptus.loadbalancing.backend.DuplicateAccessPointName;
import com.eucalyptus.loadbalancing.backend.DuplicateListenerException;
import com.eucalyptus.loadbalancing.backend.InternalFailure400Exception;
import com.eucalyptus.loadbalancing.backend.InvalidConfigurationRequestException;
import com.eucalyptus.loadbalancing.backend.ListenerNotFoundException;
import com.eucalyptus.loadbalancing.backend.LoadBalancingException;
import com.eucalyptus.loadbalancing.backend.UnsupportedParameterException;
import com.eucalyptus.loadbalancing.common.LoadBalancingMetadata;
import com.eucalyptus.loadbalancing.common.msgs.Listener;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class LoadBalancers {
    private static Logger LOG = Logger.getLogger(LoadBalancers.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<LoadBalancer> listLoadbalancers() {
        try (TransactionResource db = Entities.transactionFor(LoadBalancer.class);){
            List list = Entities.query((Object)((Object)LoadBalancer.named()));
            return list;
        }
        catch (NoSuchElementException ex) {
            return Lists.newArrayList();
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<LoadBalancer> listLoadbalancers(String accountNumber) {
        try (TransactionResource db = Entities.transactionFor(LoadBalancer.class);){
            List list = Entities.query((Object)((Object)LoadBalancer.ownedByAccount(accountNumber)));
            return list;
        }
        catch (NoSuchElementException ex) {
            return Lists.newArrayList();
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    @Nonnull
    public static LoadBalancer getLoadbalancer(Context ctx, String lbName) {
        return LoadBalancers.getLoadbalancer(ctx.getAccount().getAccountNumber(), lbName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LoadBalancer getLoadbalancer(String accountNumber, String lbName) {
        LoadBalancer lb = null;
        try (TransactionResource db = Entities.transactionFor(LoadBalancer.class);){
            lb = (LoadBalancer)((Object)Entities.uniqueResult((Object)((Object)LoadBalancer.namedByAccountId(accountNumber, lbName))));
            db.commit();
            LoadBalancer loadBalancer = lb;
            return loadBalancer;
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (lb == null) throw Exceptions.toUndeclared((Throwable)ex);
            return lb;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LoadBalancer getLoadBalancerByDnsName(String dnsName) throws NoSuchElementException {
        try (TransactionResource db = Entities.transactionFor(LoadBalancerDnsRecord.class);){
            List dnsList = Entities.query((Object)((Object)LoadBalancerDnsRecord.named()));
            db.commit();
            LoadBalancer.LoadBalancerCoreView lbView = null;
            for (LoadBalancerDnsRecord dns : dnsList) {
                if (dns.getDnsName() == null || !dns.getDnsName().equals(dnsName)) continue;
                lbView = dns.getLoadbalancer();
            }
            if (lbView == null) {
                throw new NoSuchElementException();
            }
            LoadBalancer loadBalancer = LoadBalancer.LoadBalancerEntityTransform.INSTANCE.apply(lbView);
            return loadBalancer;
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LoadBalancer addLoadbalancer(UserFullName user, String lbName, String vpcId, LoadBalancer.Scheme scheme, Map<String, String> securityGroupIdsToNames, Map<String, String> tags) throws LoadBalancingException {
        List<LoadBalancer> accountLbs = LoadBalancers.listLoadbalancers(user.getAccountNumber());
        for (LoadBalancer lb : accountLbs) {
            if (!lbName.toLowerCase().equals(lb.getDisplayName().toLowerCase())) continue;
            throw new DuplicateAccessPointName();
        }
        try (TransactionResource db = Entities.transactionFor(LoadBalancer.class);){
            try {
                if (Entities.uniqueResult((Object)((Object)LoadBalancer.namedByAccountId(user.getAccountNumber(), lbName))) == null) throw new LoadBalancingException("Failed to create a new load-balancer instance");
                throw new DuplicateAccessPointName();
            }
            catch (NoSuchElementException e) {
                ArrayList refs = Lists.newArrayList();
                for (Map.Entry<String, String> groupIdToNameEntry : securityGroupIdsToNames.entrySet()) {
                    refs.add(new LoadBalancerSecurityGroupRef(groupIdToNameEntry.getKey(), groupIdToNameEntry.getValue()));
                }
                Collections.sort(refs, Ordering.natural().onResultOf(LoadBalancerSecurityGroupRef.groupId()));
                LoadBalancer lb = LoadBalancer.newInstance((OwnerFullName)user, lbName);
                lb.setVpcId(vpcId);
                lb.setScheme(scheme);
                lb.setSecurityGroupRefs(refs);
                lb.setTags(tags);
                Entities.persist((Object)((Object)lb));
                db.commit();
                LoadBalancer loadBalancer = lb;
                if (db == null) return loadBalancer;
                if (throwable != null) {
                    try {
                        db.close();
                        return loadBalancer;
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                        return loadBalancer;
                    }
                }
                db.close();
                return loadBalancer;
            }
        }
        catch (LoadBalancingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"failed to persist a new loadbalancer", (Throwable)ex);
            throw new LoadBalancingException("Failed to persist a new load-balancer because of: " + ex.getMessage(), ex);
        }
    }

    public static void deleteLoadbalancer(final UserFullName user, final String lbName) throws LoadBalancingException {
        Predicate<Void> delete = new Predicate<Void>(){

            public boolean apply(@Nullable Void arg0) {
                try {
                    LoadBalancer toDelete = (LoadBalancer)((Object)Entities.uniqueResult((Object)((Object)LoadBalancer.named((OwnerFullName)user, lbName))));
                    Entities.delete((Object)((Object)toDelete));
                }
                catch (Exception ex) {
                    return false;
                }
                return true;
            }
        };
        Entities.asTransaction(LoadBalancer.class, (Predicate)delete).apply(null);
    }

    public static void validateListener(List<Listener> listeners) throws LoadBalancingException, EucalyptusCloudException {
        LoadBalancers.validateListener(null, listeners);
    }

    public static void validateListener(LoadBalancer lb, List<Listener> listeners) throws LoadBalancingException, EucalyptusCloudException {
        for (Listener listener : listeners) {
            LoadBalancerListener.LoadBalancerListenerCoreView existing;
            String sslId;
            if (!LoadBalancerListener.protocolSupported(listener)) {
                throw new UnsupportedParameterException("The requested protocol is not supported");
            }
            if (!LoadBalancerListener.acceptable(listener)) {
                throw new InvalidConfigurationRequestException("Invalid listener format");
            }
            if (!LoadBalancerListener.validRange(listener)) {
                throw new InvalidConfigurationRequestException("Invalid port range");
            }
            if (!LoadBalancerListener.portAvailable(listener)) {
                throw new EucalyptusCloudException("The specified port is restricted for use as a loadbalancer port");
            }
            LoadBalancerListener.PROTOCOL protocol = LoadBalancerListener.PROTOCOL.valueOf(listener.getProtocol().toUpperCase());
            if ((protocol.equals((Object)LoadBalancerListener.PROTOCOL.HTTPS) || protocol.equals((Object)LoadBalancerListener.PROTOCOL.SSL)) && ((sslId = listener.getSSLCertificateId()) == null || sslId.length() <= 0)) {
                throw new InvalidConfigurationRequestException("SSLCertificateId is required for HTTPS or SSL protocol");
            }
            if (lb == null || !lb.hasListener(listener.getLoadBalancerPort()) || (existing = lb.findListener(listener.getLoadBalancerPort())).getInstancePort() == listener.getInstancePort().intValue() && existing.getProtocol().name().toLowerCase().equals(listener.getProtocol().toLowerCase()) && existing.getCertificateId() != null && existing.getCertificateId().equals(listener.getSSLCertificateId())) continue;
            throw new DuplicateListenerException();
        }
    }

    public static void createLoadbalancerListener(String lbName, Context ctx, final List<Listener> listeners) throws LoadBalancingException, EucalyptusCloudException {
        LoadBalancer lb;
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (Exception ex) {
            throw new InternalFailure400Exception("unable to find the loadbalancer");
        }
        LoadBalancers.validateListener(lb, listeners);
        Predicate<LoadBalancer> creator = new Predicate<LoadBalancer>(){

            public boolean apply(LoadBalancer lb) {
                for (Listener listener : listeners) {
                    try {
                        if (lb.hasListener(listener.getLoadBalancerPort())) continue;
                        LoadBalancerListener.Builder builder = new LoadBalancerListener.Builder(lb, listener.getInstancePort(), listener.getLoadBalancerPort(), LoadBalancerListener.PROTOCOL.valueOf(listener.getProtocol().toUpperCase()));
                        if (!Strings.isNullOrEmpty((String)listener.getInstanceProtocol())) {
                            builder.instanceProtocol(LoadBalancerListener.PROTOCOL.valueOf(listener.getInstanceProtocol()));
                        }
                        if (!Strings.isNullOrEmpty((String)listener.getSSLCertificateId())) {
                            builder.withSSLCerntificate(listener.getSSLCertificateId());
                        }
                        Entities.persist((Object)((Object)builder.build()));
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"failed to create the listener object", (Throwable)ex);
                    }
                }
                return true;
            }
        };
        Entities.asTransaction(LoadBalancerListener.class, (Predicate)creator).apply((Object)lb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addZone(String lbName, Context ctx, Collection<String> zones, Map<String, String> zoneToSubnetIdMap) throws LoadBalancingException {
        LoadBalancer lb;
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (Exception ex) {
            throw new AccessPointNotFoundException();
        }
        try {
            for (String zone : zones) {
                try {
                    TransactionResource db = Entities.transactionFor(LoadBalancerZone.class);
                    Throwable throwable = null;
                    try {
                        try {
                            LoadBalancerZone sample = LoadBalancerZone.named(lb, zone);
                            LoadBalancerZone exist = (LoadBalancerZone)((Object)Entities.uniqueResult((Object)((Object)sample)));
                            exist.setState(LoadBalancerZone.STATE.InService);
                        }
                        catch (NoSuchElementException ex) {
                            LoadBalancerZone newZone = LoadBalancerZone.create(lb, zone, zoneToSubnetIdMap.get(zone));
                            newZone.setState(LoadBalancerZone.STATE.InService);
                            Entities.persist((Object)((Object)newZone));
                        }
                        db.commit();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (db == null) continue;
                        if (throwable != null) {
                            try {
                                db.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        db.close();
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)("failed to persist the zone " + zone), (Throwable)ex);
                    throw ex;
                    return;
                }
            }
        }
        catch (Exception ex) {
            throw new InternalFailure400Exception("Failed to persist the zone");
        }
    }

    public static void removeZone(String lbName, Context ctx, Collection<String> zones) throws LoadBalancingException {
        LoadBalancer lb;
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, lbName);
        }
        catch (Exception ex) {
            throw new AccessPointNotFoundException();
        }
        for (String zone : zones) {
            try {
                TransactionResource db = Entities.transactionFor(LoadBalancerZone.class);
                Throwable throwable = null;
                try {
                    LoadBalancerZone exist = (LoadBalancerZone)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerZone.named(lb, zone))));
                    Entities.delete((Object)((Object)exist));
                    db.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (db == null) continue;
                    if (throwable != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    db.close();
                }
            }
            catch (NoSuchElementException ex) {
                LOG.debug((Object)String.format("zone %s not found for %s", zone, lbName));
            }
            catch (Exception ex) {
                LOG.error((Object)("failed to delete the zone " + zone), (Throwable)ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LoadBalancerZone findZone(LoadBalancer lb, String zoneName) {
        try (TransactionResource db = Entities.transactionFor(LoadBalancerZone.class);){
            LoadBalancerZone exist = (LoadBalancerZone)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerZone.named(lb, zoneName))));
            db.commit();
            LoadBalancerZone loadBalancerZone = exist;
            return loadBalancerZone;
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public static List<LoadBalancerZone.LoadBalancerZoneCoreView> findZonesInService(LoadBalancer lb) {
        ArrayList inService = Lists.newArrayList();
        for (LoadBalancerZone.LoadBalancerZoneCoreView zone : lb.getZones()) {
            if (!zone.getState().equals((Object)LoadBalancerZone.STATE.InService)) continue;
            inService.add(zone);
        }
        return inService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LoadBalancerDnsRecord getDnsRecord(LoadBalancer lb) throws LoadBalancingException {
        try {
            Throwable throwable = null;
            try (TransactionResource db = Entities.transactionFor(LoadBalancerDnsRecord.class);){
                LoadBalancerDnsRecord loadBalancerDnsRecord = (LoadBalancerDnsRecord)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerDnsRecord.named(lb))));
                return loadBalancerDnsRecord;
            }
            catch (NoSuchElementException ex) {
                LoadBalancerDnsRecord newRec = LoadBalancerDnsRecord.named(lb);
                Entities.persist((Object)((Object)newRec));
                db.commit();
                LoadBalancerDnsRecord loadBalancerDnsRecord = newRec;
                return loadBalancerDnsRecord;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception ex) {
            throw new LoadBalancingException("failed to query dns record", ex);
        }
    }

    public static void deleteDnsRecord(LoadBalancerDnsRecord dns) throws LoadBalancingException {
        try (TransactionResource db2 = Entities.transactionFor(LoadBalancerDnsRecord.class);){
            LoadBalancerDnsRecord exist = (LoadBalancerDnsRecord)((Object)Entities.uniqueResult((Object)((Object)dns)));
            Entities.delete((Object)((Object)exist));
            db2.commit();
        }
        catch (NoSuchElementException db2) {
        }
        catch (Exception ex) {
            throw new LoadBalancingException("failed to delete dns record", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LoadBalancerServoInstance lookupServoInstance(String instanceId) throws LoadBalancingException {
        try (TransactionResource db = Entities.transactionFor(LoadBalancerServoInstance.class);){
            LoadBalancerServoInstance sample = LoadBalancerServoInstance.named(instanceId);
            LoadBalancerServoInstance exist = (LoadBalancerServoInstance)((Object)Entities.uniqueResult((Object)((Object)sample)));
            db.commit();
            LoadBalancerServoInstance loadBalancerServoInstance = exist;
            return loadBalancerServoInstance;
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new LoadBalancingException("failed to query servo instances", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LoadBalancerBackendInstance lookupBackendInstance(LoadBalancer lb, String instanceId) {
        try (TransactionResource db = Entities.transactionFor(LoadBalancerBackendInstance.class);){
            LoadBalancerBackendInstance found = (LoadBalancerBackendInstance)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerBackendInstance.named(lb, instanceId))));
            db.commit();
            LoadBalancerBackendInstance loadBalancerBackendInstance = found;
            return loadBalancerBackendInstance;
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public static void deleteBackendInstance(LoadBalancer lb, String instanceId) {
        try (TransactionResource db = Entities.transactionFor(LoadBalancerBackendInstance.class);){
            LoadBalancerBackendInstance toDelete = (LoadBalancerBackendInstance)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerBackendInstance.named(lb, instanceId))));
            Entities.delete((Object)((Object)toDelete));
            db.commit();
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public static void unsetForeignKeys(Context ctx, String loadbalancer) {
        LoadBalancer lb;
        Predicate<LoadBalancerServoInstance> unsetServoInstanceKey = new Predicate<LoadBalancerServoInstance>(){

            public boolean apply(@Nullable LoadBalancerServoInstance arg0) {
                try {
                    LoadBalancerServoInstance update = (LoadBalancerServoInstance)((Object)Entities.uniqueResult((Object)((Object)arg0)));
                    update.setAvailabilityZone(null);
                    update.setAutoScalingGroup(null);
                    update.setDns(null);
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        };
        try {
            lb = LoadBalancers.getLoadbalancer(ctx, loadbalancer);
        }
        catch (Exception ex) {
            return;
        }
        if (lb != null && lb.getZones() != null) {
            for (LoadBalancerZone.LoadBalancerZoneCoreView zoneView : lb.getZones()) {
                LoadBalancerZone zone;
                try {
                    zone = LoadBalancerZone.LoadBalancerZoneEntityTransform.INSTANCE.apply(zoneView);
                }
                catch (Exception ex) {
                    continue;
                }
                for (LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView servo : zone.getServoInstances()) {
                    try {
                        LoadBalancerServoInstance instance = LoadBalancerServoInstance.LoadBalancerServoInstanceEntityTransform.INSTANCE.apply(servo);
                        Entities.asTransaction(LoadBalancerServoInstance.class, (Predicate)unsetServoInstanceKey).apply((Object)instance);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static void setLoadBalancerListenerSSLCertificate(LoadBalancer lb, int lbPort, String certArn) throws LoadBalancingException {
        Collection<LoadBalancerListener.LoadBalancerListenerCoreView> listeners = lb.getListeners();
        LoadBalancerListener.LoadBalancerListenerCoreView listener = null;
        for (LoadBalancerListener.LoadBalancerListenerCoreView l : listeners) {
            if (l.getLoadbalancerPort() != lbPort) continue;
            listener = l;
            break;
        }
        if (listener == null) {
            throw new ListenerNotFoundException();
        }
        if (!LoadBalancerListener.PROTOCOL.HTTPS.equals((Object)listener.getProtocol()) && !LoadBalancerListener.PROTOCOL.SSL.equals((Object)listener.getProtocol())) {
            throw new InvalidConfigurationRequestException("Listener's protocol is not HTTPS or SSL");
        }
        LoadBalancers.checkSSLCertificate(lb.getOwnerUserId(), certArn);
        LoadBalancers.updateIAMRolePolicy(lb.getOwnerAccountNumber(), lb.getDisplayName(), listener.getCertificateId(), certArn);
        try (TransactionResource db = Entities.transactionFor(LoadBalancerListener.class);){
            LoadBalancerListener update = (LoadBalancerListener)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerListener.named(lb, lbPort))));
            update.setSSLCertificateId(certArn);
            Entities.persist((Object)((Object)update));
            db.commit();
        }
        catch (NoSuchElementException ex) {
            throw new ListenerNotFoundException();
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private static void updateIAMRolePolicy(String accountId, String lbName, String oldCertArn, String newCertArn) throws LoadBalancingException {
        String prefix = String.format("arn:aws:iam::%s:server-certificate", accountId);
        String oldCertName = oldCertArn.replace(prefix, "").substring(oldCertArn.replace(prefix, "").lastIndexOf("/") + 1);
        String newCertName = newCertArn.replace(prefix, "").substring(newCertArn.replace(prefix, "").lastIndexOf("/") + 1);
        String roleName = String.format("%s-%s-%s", "loadbalancer-vm", accountId, lbName);
        String oldPolicyName = String.format("%s-%s-%s-%s", "loadbalancer-iam-policy", accountId, lbName, oldCertName);
        try {
            EucalyptusActivityTasks.getInstance().deleteRolePolicy(roleName, oldPolicyName);
        }
        catch (Exception ex) {
            throw new LoadBalancingException("Failed to delete old role policy " + oldPolicyName, ex);
        }
        String newPolicyName = String.format("%s-%s-%s-%s", "loadbalancer-iam-policy", accountId, lbName, newCertName);
        String newPolicyDoc = "{\"Statement\":[{\"Action\": [\"iam:DownloadServerCertificate\"],\"Effect\": \"Allow\",\"Resource\": \"CERT_ARN_PLACEHOLDER\"}]}".replace("CERT_ARN_PLACEHOLDER", newCertArn);
        try {
            EucalyptusActivityTasks.getInstance().putRolePolicy(roleName, newPolicyName, newPolicyDoc);
        }
        catch (Exception ex) {
            throw new LoadBalancingException("Failed to add new role policy " + newPolicyName, ex);
        }
    }

    public static void checkSSLCertificate(String userId, String certArn) throws LoadBalancingException {
        String acctNumber;
        try {
            User user = Accounts.lookupUserById((String)userId);
            acctNumber = user.getAccountNumber();
        }
        catch (Exception ex) {
            throw new InternalFailure400Exception("Unable to check ssl certificate Id", ex);
        }
        try {
            String prefix = String.format("arn:aws:iam::%s:server-certificate", acctNumber);
            if (!certArn.startsWith(prefix)) {
                throw new CertificateNotFoundException();
            }
            String pathAndName = certArn.replace(prefix, "");
            String certName = pathAndName.substring(pathAndName.lastIndexOf("/") + 1);
            ServerCertificateType cert = EucalyptusActivityTasks.getInstance().getServerCertificate(userId, certName);
            if (cert == null) {
                throw new CertificateNotFoundException();
            }
            if (!certArn.equals(cert.getServerCertificateMetadata().getArn())) {
                throw new CertificateNotFoundException();
            }
        }
        catch (Exception ex) {
            throw new CertificateNotFoundException();
        }
    }

    @RestrictedTypes.QuantityMetricFunction(value=LoadBalancingMetadata.LoadBalancerMetadata.class)
    public static enum CountLoadBalancers implements Function<OwnerFullName, Long>
    {
        INSTANCE;


        public Long apply(OwnerFullName input) {
            try (TransactionResource db = Entities.transactionFor(LoadBalancer.class);){
                Long l = Entities.count((Object)((Object)LoadBalancer.named(input, null)));
                return l;
            }
        }
    }
}

