/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing;

import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancerBackendInstance;
import com.eucalyptus.loadbalancing.activities.LoadBalancerServoInstance;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.NonNullFunction;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_loadbalancing")
@Table(name="metadata_zone")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class LoadBalancerZone
extends AbstractPersistent {
    private static final long serialVersionUID = 1L;
    @Transient
    private transient LoadBalancerZoneRelationView view;
    @ManyToOne
    @JoinColumn(name="metadata_loadbalancer_fk", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private LoadBalancer loadbalancer = null;
    @Column(name="zone_name", nullable=false)
    private String zoneName;
    @Column(name="subnetId")
    private String subnetId;
    @Column(name="unique_name", nullable=false, unique=true)
    private String uniqueName;
    @Column(name="zone_state", nullable=true)
    private String zoneState;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="zone")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Collection<LoadBalancerServoInstance> servoInstances = null;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="zone")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Collection<LoadBalancerBackendInstance> backendInstances;

    @PostLoad
    private void onLoad() {
        if (this.view == null) {
            this.view = new LoadBalancerZoneRelationView(this);
        }
    }

    protected LoadBalancerZone() {
    }

    private LoadBalancerZone(LoadBalancer lb, String zone, String subnetId) {
        this.loadbalancer = lb;
        this.zoneName = zone;
        this.subnetId = subnetId;
        this.uniqueName = this.createUniqueName();
        this.view = new LoadBalancerZoneRelationView(this);
    }

    public static LoadBalancerZone create(LoadBalancer lb, String zone, String subnetId) {
        return new LoadBalancerZone(lb, zone, subnetId);
    }

    public static LoadBalancerZone named(LoadBalancer lb, String zone) {
        return new LoadBalancerZone(lb, zone, null);
    }

    public String getName() {
        return this.zoneName;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public LoadBalancer.LoadBalancerCoreView getLoadbalancer() {
        return this.view.getLoadBalancer();
    }

    public Collection<LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView> getServoInstances() {
        return this.view.getServoInstances();
    }

    public Collection<LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView> getBackendInstances() {
        return this.view.getBackendInstances();
    }

    public void setState(STATE state) {
        this.zoneState = state.name();
    }

    public STATE getState() {
        return Enum.valueOf(STATE.class, this.zoneState);
    }

    @PrePersist
    private void generateOnCommit() {
        if (this.uniqueName == null) {
            this.uniqueName = this.createUniqueName();
        }
    }

    protected String createUniqueName() {
        return String.format("zone-%s-%s-%s", this.loadbalancer.getOwnerAccountNumber(), this.loadbalancer.getDisplayName(), this.zoneName);
    }

    public String toString() {
        String name = "unassigned";
        if (this.loadbalancer != null && this.zoneName != null) {
            name = String.format("loadbalancer-zone-%s-%s", this.loadbalancer.getDisplayName(), this.zoneName);
        }
        return name;
    }

    public static class LoadBalancerZoneRelationView {
        private LoadBalancer loadbalancer = null;
        private ImmutableList<LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView> backendInstances = null;
        private ImmutableList<LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView> servoInstances = null;

        LoadBalancerZoneRelationView(LoadBalancerZone zone) {
            if (zone.loadbalancer != null) {
                Entities.initialize((Object)((Object)zone.loadbalancer));
                this.loadbalancer = zone.loadbalancer;
            }
            if (zone.backendInstances != null) {
                this.backendInstances = ImmutableList.copyOf((Collection)Collections2.transform((Collection)zone.backendInstances, (Function)LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreViewTransform.INSTANCE));
            }
            if (zone.servoInstances != null) {
                this.servoInstances = ImmutableList.copyOf((Collection)Collections2.transform((Collection)zone.servoInstances, (Function)LoadBalancerServoInstance.LoadBalancerServoInstanceCoreViewTransform.INSTANCE));
            }
        }

        public ImmutableList<LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView> getBackendInstances() {
            return this.backendInstances;
        }

        public ImmutableList<LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView> getServoInstances() {
            return this.servoInstances;
        }

        public LoadBalancer.LoadBalancerCoreView getLoadBalancer() {
            return this.loadbalancer.getCoreView();
        }
    }

    public static enum LoadBalancerZoneEntityTransform implements NonNullFunction<LoadBalancerZoneCoreView, LoadBalancerZone>
    {
        INSTANCE;


        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nonnull
        public LoadBalancerZone apply(LoadBalancerZoneCoreView arg0) {
            try (TransactionResource db = Entities.transactionFor(LoadBalancerZone.class);){
                LoadBalancerZone loadBalancerZone = (LoadBalancerZone)((Object)Entities.uniqueResult((Object)((Object)arg0.zone)));
                return loadBalancerZone;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    @TypeMapper
    public static enum LoadBalancerZoneCoreViewTransform implements Function<LoadBalancerZone, LoadBalancerZoneCoreView>
    {
        INSTANCE;


        @Nullable
        public LoadBalancerZoneCoreView apply(@Nullable LoadBalancerZone arg0) {
            return new LoadBalancerZoneCoreView(arg0);
        }
    }

    public static class LoadBalancerZoneCoreView {
        private final LoadBalancerZone zone;

        LoadBalancerZoneCoreView(LoadBalancerZone zone) {
            this.zone = zone;
        }

        public String getName() {
            return this.zone.getName();
        }

        public String getSubnetId() {
            return this.zone.getSubnetId();
        }

        public STATE getState() {
            return this.zone.getState();
        }

        public static NonNullFunction<LoadBalancerZoneCoreView, String> name() {
            return StringPropertyFunctions.Name;
        }

        public static NonNullFunction<LoadBalancerZoneCoreView, String> subnetId() {
            return StringPropertyFunctions.SubnetId;
        }

        private static enum StringPropertyFunctions implements NonNullFunction<LoadBalancerZoneCoreView, String>
        {
            Name{

                @Nonnull
                public String apply(LoadBalancerZoneCoreView loadBalancerZoneCoreView) {
                    return loadBalancerZoneCoreView.getName();
                }
            }
            ,
            SubnetId{

                @Nonnull
                public String apply(LoadBalancerZoneCoreView loadBalancerZoneCoreView) {
                    return loadBalancerZoneCoreView.getSubnetId();
                }
            };

        }
    }

    public static enum STATE {
        InService,
        OutOfService;

    }
}

