/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing;

import com.eucalyptus.compute.common.SecurityGroupItemType;
import com.eucalyptus.util.NonNullFunction;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Embeddable;

@Embeddable
public class LoadBalancerSecurityGroupRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="metadata_group_id", nullable=false, updatable=false)
    private String groupId;
    @Column(name="metadata_group_name", nullable=false, updatable=false)
    private String groupName;

    public LoadBalancerSecurityGroupRef() {
    }

    public LoadBalancerSecurityGroupRef(String groupId, String groupName) {
        this.groupId = groupId;
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadBalancerSecurityGroupRef that = (LoadBalancerSecurityGroupRef)o;
        return this.groupId.equals(that.groupId);
    }

    public int hashCode() {
        return this.groupId.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("groupId", (Object)this.getGroupId()).add("groupName", (Object)this.getGroupName()).toString();
    }

    public static NonNullFunction<LoadBalancerSecurityGroupRef, String> groupId() {
        return StringPropertyFunctions.GroupId;
    }

    public static NonNullFunction<LoadBalancerSecurityGroupRef, String> groupName() {
        return StringPropertyFunctions.GroupName;
    }

    @TypeMapper
    public static enum SecurityGroupItemTypeToLoadBalancerSecurityGroupRefTransform implements Function<SecurityGroupItemType, LoadBalancerSecurityGroupRef>
    {
        INSTANCE;


        @Nullable
        public LoadBalancerSecurityGroupRef apply(@Nullable SecurityGroupItemType securityGroupItemType) {
            return securityGroupItemType == null ? null : new LoadBalancerSecurityGroupRef(securityGroupItemType.getGroupId(), securityGroupItemType.getGroupName());
        }
    }

    private static enum StringPropertyFunctions implements NonNullFunction<LoadBalancerSecurityGroupRef, String>
    {
        GroupId{

            @Nonnull
            public String apply(LoadBalancerSecurityGroupRef loadBalancerSecurityGroupRef) {
                return loadBalancerSecurityGroupRef.getGroupId();
            }
        }
        ,
        GroupName{

            @Nonnull
            public String apply(LoadBalancerSecurityGroupRef loadBalancerSecurityGroupRef) {
                return loadBalancerSecurityGroupRef.getGroupName();
            }
        };

    }
}

