/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing;

import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.activities.LoadBalancerServoInstance;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.NonNullFunction;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_loadbalancing")
@Table(name="metadata_group")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class LoadBalancerSecurityGroup
extends AbstractPersistent {
    @Transient
    private static final long serialVersionUID = 1L;
    @Transient
    private LoadBalancerSecurityGroupRelationView view = null;
    @OneToOne
    @JoinColumn(name="metadata_loadbalancer_fk", nullable=true)
    private LoadBalancer loadbalancer = null;
    @Column(name="group_name", nullable=false)
    private String groupName = null;
    @Column(name="group_owner_account_id", nullable=false)
    private String ownerAccountId = null;
    @Column(name="metadata_state", nullable=false)
    private String state = null;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="security_group")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Collection<LoadBalancerServoInstance> servoInstances = null;
    @Column(name="metadata_unique_name", nullable=false, unique=true)
    private String uniqueName = null;

    private LoadBalancerSecurityGroup() {
    }

    @PostLoad
    private void onLoad() {
        if (this.view == null) {
            this.view = new LoadBalancerSecurityGroupRelationView(this);
        }
    }

    private LoadBalancerSecurityGroup(LoadBalancer lb, String ownerAccountId, String groupName) {
        this.loadbalancer = lb;
        this.groupName = groupName;
        this.ownerAccountId = ownerAccountId;
        this.state = STATE.InService.name();
    }

    public static LoadBalancerSecurityGroup create(LoadBalancer lb, String ownerAccountId, String groupName) {
        LoadBalancerSecurityGroup instance = new LoadBalancerSecurityGroup(lb, ownerAccountId, groupName);
        instance.uniqueName = instance.createUniqueName();
        return instance;
    }

    public static LoadBalancerSecurityGroup named(LoadBalancer lb, String ownerAccountId, String groupName) {
        LoadBalancerSecurityGroup instance = new LoadBalancerSecurityGroup(lb, ownerAccountId, groupName);
        instance.uniqueName = instance.createUniqueName();
        return instance;
    }

    public static LoadBalancerSecurityGroup named(LoadBalancer lb, String ownerAccountId, String groupName, STATE state) {
        LoadBalancerSecurityGroup instance = new LoadBalancerSecurityGroup(lb, ownerAccountId, groupName);
        instance.state = state.name();
        instance.uniqueName = instance.createUniqueName();
        return instance;
    }

    public static LoadBalancerSecurityGroup withState(STATE state) {
        LoadBalancerSecurityGroup instance = new LoadBalancerSecurityGroup();
        instance.state = state.name();
        return instance;
    }

    public String getName() {
        return this.groupName;
    }

    public String getGroupOwnerAccountId() {
        return this.ownerAccountId;
    }

    public Collection<LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView> getServoInstances() {
        return this.view.getServoInstances();
    }

    public LoadBalancer.LoadBalancerCoreView getLoadBalancer() {
        return this.view.getLoadBalancer();
    }

    public void setLoadBalancer(LoadBalancer lb) {
        this.loadbalancer = lb;
    }

    public void setState(STATE state) {
        this.state = state.name();
    }

    public STATE getState() {
        return Enum.valueOf(STATE.class, this.state);
    }

    @PrePersist
    private void generateOnCommit() {
        if (this.uniqueName == null) {
            this.uniqueName = this.createUniqueName();
        }
    }

    private String createUniqueName() {
        return String.format("loadbalancer-sgroup-%s-%s-%s-%s", this.loadbalancer.getOwnerAccountNumber(), this.loadbalancer.getDisplayName(), this.ownerAccountId, this.groupName);
    }

    public String toString() {
        return this.uniqueName;
    }

    public static class LoadBalancerSecurityGroupRelationView {
        private LoadBalancer loadBalancer = null;
        private ImmutableList<LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView> servoViews = null;

        LoadBalancerSecurityGroupRelationView(LoadBalancerSecurityGroup group) {
            if (group.loadbalancer != null) {
                Entities.initialize((Object)((Object)group.loadbalancer));
                this.loadBalancer = group.loadbalancer;
            }
            if (group.servoInstances != null) {
                this.servoViews = ImmutableList.copyOf((Collection)Collections2.transform((Collection)group.servoInstances, (Function)LoadBalancerServoInstance.LoadBalancerServoInstanceCoreViewTransform.INSTANCE));
            }
        }

        LoadBalancer.LoadBalancerCoreView getLoadBalancer() {
            return this.loadBalancer.getCoreView();
        }

        public ImmutableList<LoadBalancerServoInstance.LoadBalancerServoInstanceCoreView> getServoInstances() {
            return this.servoViews;
        }
    }

    public static enum LoadBalancerSecurityGroupEntityTransform implements NonNullFunction<LoadBalancerSecurityGroupCoreView, LoadBalancerSecurityGroup>
    {
        INSTANCE;


        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nonnull
        public LoadBalancerSecurityGroup apply(LoadBalancerSecurityGroupCoreView arg0) {
            try (TransactionResource db = Entities.transactionFor(LoadBalancerSecurityGroup.class);){
                LoadBalancerSecurityGroup loadBalancerSecurityGroup = (LoadBalancerSecurityGroup)((Object)Entities.uniqueResult((Object)((Object)arg0.group)));
                return loadBalancerSecurityGroup;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    @TypeMapper
    public static enum LoadBalancerSecurityGroupCoreViewTransform implements Function<LoadBalancerSecurityGroup, LoadBalancerSecurityGroupCoreView>
    {
        INSTANCE;


        public LoadBalancerSecurityGroupCoreView apply(LoadBalancerSecurityGroup group) {
            return new LoadBalancerSecurityGroupCoreView(group);
        }
    }

    public static class LoadBalancerSecurityGroupCoreView {
        private LoadBalancerSecurityGroup group = null;

        LoadBalancerSecurityGroupCoreView(LoadBalancerSecurityGroup group) {
            this.group = group;
        }

        public String getName() {
            return this.group.getName();
        }

        public String getGroupOwnerAccountId() {
            return this.group.getGroupOwnerAccountId();
        }

        public STATE getState() {
            return this.group.getState();
        }
    }

    public static enum STATE {
        InService,
        OutOfService;

    }
}

