/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing;

import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.loadbalancing.LoadBalancerPolicyAttributeTypeDescription;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_loadbalancing")
@Table(name="metadata_policy_type_description")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class LoadBalancerPolicyTypeDescription
extends AbstractPersistent {
    private static Logger LOG = Logger.getLogger(LoadBalancerPolicyTypeDescription.class);
    @Transient
    private static final long serialVersionUID = 1L;
    @Transient
    private LoadBalancerPolicyTypeDescriptionRelationView view = null;
    @Column(name="description", nullable=true)
    private String description = null;
    @Column(name="policy_type_name", nullable=true)
    private String policyTypeName = null;
    @ElementCollection
    @CollectionTable(name="metadata_policy_attr_type_description")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<LoadBalancerPolicyAttributeTypeDescription> policyAttributeTypeDescriptions = null;

    public LoadBalancerPolicyTypeDescription() {
    }

    public LoadBalancerPolicyTypeDescription(String typeName) {
        this.policyTypeName = typeName;
        this.view = new LoadBalancerPolicyTypeDescriptionRelationView(this);
    }

    public LoadBalancerPolicyTypeDescription(String typeName, String description) {
        this(typeName);
        this.description = description;
    }

    public LoadBalancerPolicyTypeDescription(String typeName, String description, List<LoadBalancerPolicyAttributeTypeDescription> attributeTypes) {
        this(typeName, description);
        this.policyAttributeTypeDescriptions = attributeTypes;
    }

    public static LoadBalancerPolicyTypeDescription named(String typeName) {
        return new LoadBalancerPolicyTypeDescription(typeName);
    }

    @PostLoad
    private void onLoad() {
        if (this.view == null) {
            this.view = new LoadBalancerPolicyTypeDescriptionRelationView(this);
        }
    }

    public String getPolicyTypeName() {
        return this.policyTypeName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public List<LoadBalancerPolicyAttributeTypeDescription.LoadBalancerPolicyAttributeTypeDescriptionCoreView> getPolicyAttributeTypeDescriptions() {
        return this.view.getAttributeTypeDescription();
    }

    void addPolicyAttributeTypeDescription(LoadBalancerPolicyAttributeTypeDescription attrDesc) {
        if (this.policyAttributeTypeDescriptions == null) {
            this.policyAttributeTypeDescriptions = Lists.newArrayList();
        }
        this.removePolicyAttributeTypeDescription(attrDesc);
        this.policyAttributeTypeDescriptions.add(attrDesc);
    }

    void removePolicyAttributeTypeDescription(LoadBalancerPolicyAttributeTypeDescription attrDesc) {
        if (this.policyAttributeTypeDescriptions == null) {
            return;
        }
        this.policyAttributeTypeDescriptions.remove(attrDesc);
    }

    public String toString() {
        return String.format("PolicyTypeDescription: %s", this.policyTypeName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.policyTypeName == null ? 0 : this.policyTypeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancerPolicyTypeDescription other = (LoadBalancerPolicyTypeDescription)((Object)obj);
        return !(this.policyTypeName == null ? other.policyTypeName != null : !this.policyTypeName.equals(other.policyTypeName));
    }

    public static class LoadBalancerPolicyTypeDescriptionRelationView {
        private ImmutableList<LoadBalancerPolicyAttributeTypeDescription.LoadBalancerPolicyAttributeTypeDescriptionCoreView> attrTypeDescs = null;

        private LoadBalancerPolicyTypeDescriptionRelationView(LoadBalancerPolicyTypeDescription policyDesc) {
            if (policyDesc.policyAttributeTypeDescriptions != null) {
                this.attrTypeDescs = ImmutableList.copyOf((Collection)Collections2.transform((Collection)policyDesc.policyAttributeTypeDescriptions, (Function)LoadBalancerPolicyAttributeTypeDescription.LoadBalancerPolicyAttributeTypeDescriptionCoreViewTransform.INSTANCE));
            }
        }

        public ImmutableList<LoadBalancerPolicyAttributeTypeDescription.LoadBalancerPolicyAttributeTypeDescriptionCoreView> getAttributeTypeDescription() {
            return this.attrTypeDescs;
        }
    }
}

