/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing;

import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancerListener;
import com.eucalyptus.loadbalancing.LoadBalancerPolicies;
import com.eucalyptus.loadbalancing.LoadBalancerPolicyAttributeDescription;
import com.eucalyptus.loadbalancing.LoadBalancerPolicyAttributeTypeDescription;
import com.eucalyptus.loadbalancing.LoadBalancerPolicyTypeDescription;
import com.eucalyptus.loadbalancing.backend.InvalidConfigurationRequestException;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_loadbalancing")
@Table(name="metadata_policy_description")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class LoadBalancerPolicyDescription
extends AbstractPersistent {
    private static Logger LOG = Logger.getLogger(LoadBalancerPolicyDescription.class);
    @Transient
    private static final long serialVersionUID = 1L;
    @Transient
    private LoadBalancerPolicyDescriptionRelationView view = null;
    @ManyToOne
    @JoinColumn(name="metadata_loadbalancer_fk", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private LoadBalancer loadbalancer = null;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="policies", cascade={CascadeType.REMOVE})
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<LoadBalancerListener> listeners = null;
    @Column(name="policy_name", nullable=false)
    private String policyName = null;
    @Column(name="policy_type_name", nullable=true)
    private String policyTypeName = null;
    @Column(name="unique_name", unique=true, nullable=false)
    private String uniqueName = null;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="policyDescription")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<LoadBalancerPolicyAttributeDescription> policyAttrDescription = null;
    @Transient
    private LoadBalancerPolicyTypeDescription policyType = null;

    private LoadBalancerPolicyDescription() {
    }

    private LoadBalancerPolicyDescription(LoadBalancer lb, String policyName) {
        this.loadbalancer = lb;
        this.policyName = policyName;
    }

    public LoadBalancerPolicyDescription(LoadBalancer lb, String policyName, String policyTypeName) {
        this(lb, policyName);
        this.policyTypeName = policyTypeName;
    }

    public LoadBalancerPolicyDescription(LoadBalancer lb, String policyName, String policyTypeName, List<LoadBalancerPolicyAttributeDescription> descs) {
        this(lb, policyName, policyTypeName);
        this.policyAttrDescription = descs;
    }

    public static LoadBalancerPolicyDescription named(LoadBalancer lb, String policyName) {
        LoadBalancerPolicyDescription instance = new LoadBalancerPolicyDescription(lb, policyName);
        instance.uniqueName = instance.createUniqueName();
        return instance;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getPolicyTypeName() {
        return this.policyTypeName;
    }

    public LoadBalancerPolicyTypeDescription getPolicyTypeDescription() {
        if (this.policyType == null) {
            this.policyType = LoadBalancerPolicies.findLoadBalancerPolicyTypeDescription(this.policyTypeName);
        }
        return this.policyType;
    }

    public void addPolicyAttributeDescription(String attrName, String attrValue) throws InvalidConfigurationRequestException {
        if (this.getPolicyTypeDescription() != null) {
            LoadBalancerPolicyAttributeTypeDescription.LoadBalancerPolicyAttributeTypeDescriptionCoreView attrType = null;
            for (LoadBalancerPolicyAttributeTypeDescription.LoadBalancerPolicyAttributeTypeDescriptionCoreView type : this.policyType.getPolicyAttributeTypeDescriptions()) {
                if (!attrName.equals(type.getAttributeName())) continue;
                attrType = type;
                break;
            }
            if (attrType == null) {
                throw new InvalidConfigurationRequestException(String.format("Attribute %s is not defined in the policy type", attrName));
            }
            if (!LoadBalancerPolicies.isAttributeValueValid(attrType.getAttributeType(), attrType.getCardinality(), attrValue)) {
                throw new InvalidConfigurationRequestException(String.format("Attribute value %s is not valid", attrValue));
            }
        }
        LoadBalancerPolicyAttributeDescription attr = new LoadBalancerPolicyAttributeDescription(this, attrName, attrValue);
        if (this.policyAttrDescription == null) {
            this.policyAttrDescription = Lists.newArrayList();
        }
        this.removePolicyAttributeDescription(attr);
        this.policyAttrDescription.add(attr);
    }

    public void removePolicyAttributeDescription(LoadBalancerPolicyAttributeDescription desc) {
        if (this.policyAttrDescription == null) {
            return;
        }
        this.policyAttrDescription.remove((Object)desc);
    }

    public List<LoadBalancerPolicyAttributeDescription.LoadBalancerPolicyAttributeDescriptionCoreView> getPolicyAttributeDescription() {
        return this.view.getPolicyAttributeDescription();
    }

    public LoadBalancerPolicyAttributeDescription findAttributeDescription(String attrName) throws NoSuchElementException {
        for (LoadBalancerPolicyAttributeDescription.LoadBalancerPolicyAttributeDescriptionCoreView attrView : this.getPolicyAttributeDescription()) {
            if (!attrView.getAttributeName().equals(attrName)) continue;
            return LoadBalancerPolicyAttributeDescription.LoadBalancerPolicyAtttributeDescriptionEntityTransform.INSTANCE.apply(attrView);
        }
        throw new NoSuchElementException();
    }

    public List<LoadBalancerListener.LoadBalancerListenerCoreView> getListeners() {
        return this.view.getListeners();
    }

    @PostLoad
    private void onLoad() {
        if (this.view == null) {
            this.view = new LoadBalancerPolicyDescriptionRelationView(this);
        }
    }

    @PrePersist
    private void generateOnCommit() {
        if (this.uniqueName == null) {
            this.uniqueName = this.createUniqueName();
        }
    }

    protected String createUniqueName() {
        return String.format("policy-%s-%s-%s", this.loadbalancer.getOwnerAccountNumber(), this.loadbalancer.getDisplayName(), this.policyName);
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancerPolicyDescription other = (LoadBalancerPolicyDescription)((Object)obj);
        if (this.loadbalancer == null ? other.loadbalancer != null : !this.loadbalancer.equals((Object)other.loadbalancer)) {
            return false;
        }
        return !(this.policyName == null ? other.policyName != null : !this.policyName.equals(other.policyName));
    }

    public final String getRecordId() {
        return this.getId();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.loadbalancer == null ? 0 : this.loadbalancer.hashCode());
        result = 31 * result + (this.policyName == null ? 0 : this.policyName.hashCode());
        return result;
    }

    public String toString() {
        return String.format("LoadBalancer Policy Description for (%s):%s-%s", new Object[]{this.loadbalancer, this.policyName, this.policyTypeName});
    }

    public static enum LoadBalancerPolicyDescriptionEntityTransform implements Function<LoadBalancerPolicyDescriptionCoreView, LoadBalancerPolicyDescription>
    {
        INSTANCE;


        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public LoadBalancerPolicyDescription apply(LoadBalancerPolicyDescriptionCoreView arg0) {
            try (TransactionResource db = Entities.transactionFor(LoadBalancerPolicyDescription.class);){
                LoadBalancerPolicyDescription loadBalancerPolicyDescription = (LoadBalancerPolicyDescription)((Object)Entities.uniqueResult((Object)((Object)arg0.policyDesc)));
                return loadBalancerPolicyDescription;
            }
            catch (NoSuchElementException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    public static enum LoadBalancerPolicyDescriptionCoreViewTransform implements Function<LoadBalancerPolicyDescription, LoadBalancerPolicyDescriptionCoreView>
    {
        INSTANCE;


        public LoadBalancerPolicyDescriptionCoreView apply(LoadBalancerPolicyDescription arg0) {
            return new LoadBalancerPolicyDescriptionCoreView(arg0);
        }
    }

    public static class LoadBalancerPolicyDescriptionCoreView {
        private LoadBalancerPolicyDescription policyDesc = null;

        LoadBalancerPolicyDescriptionCoreView(LoadBalancerPolicyDescription desc) {
            this.policyDesc = desc;
        }

        public String getPolicyName() {
            return this.policyDesc.policyName;
        }

        public String getPolicyTypeName() {
            return this.policyDesc.policyTypeName;
        }
    }

    public static class LoadBalancerPolicyDescriptionRelationView {
        private LoadBalancerPolicyDescription policyDesc = null;
        private ImmutableList<LoadBalancerPolicyAttributeDescription.LoadBalancerPolicyAttributeDescriptionCoreView> policyAttrDesc = null;
        private ImmutableList<LoadBalancerListener.LoadBalancerListenerCoreView> listeners = null;

        LoadBalancerPolicyDescriptionRelationView(LoadBalancerPolicyDescription desc) {
            this.policyDesc = desc;
            if (desc.policyAttrDescription != null) {
                this.policyAttrDesc = ImmutableList.copyOf((Collection)Collections2.transform((Collection)desc.policyAttrDescription, (Function)LoadBalancerPolicyAttributeDescription.LoadBalancerPolicyAttributeDescriptionCoreViewTransform.INSTANCE));
            }
            if (desc.listeners != null) {
                this.listeners = ImmutableList.copyOf((Collection)Collections2.transform((Collection)desc.listeners, (Function)LoadBalancerListener.LoadBalancerListenerCoreViewTransform.INSTANCE));
            }
        }

        public ImmutableList<LoadBalancerPolicyAttributeDescription.LoadBalancerPolicyAttributeDescriptionCoreView> getPolicyAttributeDescription() {
            return this.policyAttrDesc;
        }

        public ImmutableList<LoadBalancerListener.LoadBalancerListenerCoreView> getListeners() {
            return this.listeners;
        }
    }
}

