/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing;

import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.loadbalancing.LoadBalancerPolicyDescription;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import java.util.NoSuchElementException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_loadbalancing")
@Table(name="metadata_policy_attr_description")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class LoadBalancerPolicyAttributeDescription
extends AbstractPersistent {
    private static Logger LOG = Logger.getLogger(LoadBalancerPolicyAttributeDescription.class);
    @Transient
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="metadata_policy_desc_fk", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    LoadBalancerPolicyDescription policyDescription = null;
    @Column(name="attribute_name", nullable=true)
    private String attributeName = null;
    @Column(name="attribute_value", nullable=true)
    private String attributeValue = null;

    private LoadBalancerPolicyAttributeDescription() {
    }

    public LoadBalancerPolicyAttributeDescription(LoadBalancerPolicyDescription policyDesc, String attrName, String attrValue) {
        this.policyDescription = policyDesc;
        this.attributeName = attrName;
        this.attributeValue = attrValue;
    }

    public LoadBalancerPolicyDescription getPolicyDescription() {
        return this.policyDescription;
    }

    public void setPolicyDescription(LoadBalancerPolicyDescription desc) {
        this.policyDescription = desc;
    }

    public void setAttributeName(String attrName) {
        this.attributeName = attrName;
    }

    public void setAttributeValue(String attrValue) {
        this.attributeValue = attrValue;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancerPolicyAttributeDescription other = (LoadBalancerPolicyAttributeDescription)((Object)obj);
        if (this.policyDescription == null ? other.policyDescription != null : !this.policyDescription.equals((Object)other.policyDescription)) {
            return false;
        }
        return !(this.attributeName == null ? other.attributeName != null : !this.attributeName.equals(other.attributeName));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.policyDescription == null ? 0 : this.policyDescription.hashCode());
        result = 31 * result + (this.attributeName == null ? 0 : this.attributeName.hashCode());
        return result;
    }

    public String toString() {
        return String.format("LoadBalancer Policy Attribute Description %s: %s-%s", this.policyDescription.getPolicyName(), this.attributeName, this.attributeValue);
    }

    public static enum LoadBalancerPolicyAtttributeDescriptionEntityTransform implements Function<LoadBalancerPolicyAttributeDescriptionCoreView, LoadBalancerPolicyAttributeDescription>
    {
        INSTANCE;


        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public LoadBalancerPolicyAttributeDescription apply(LoadBalancerPolicyAttributeDescriptionCoreView arg0) {
            try (TransactionResource db = Entities.transactionFor(LoadBalancerPolicyAttributeDescription.class);){
                LoadBalancerPolicyAttributeDescription loadBalancerPolicyAttributeDescription = (LoadBalancerPolicyAttributeDescription)((Object)Entities.uniqueResult((Object)((Object)arg0.policyDesc)));
                return loadBalancerPolicyAttributeDescription;
            }
            catch (NoSuchElementException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    public static enum LoadBalancerPolicyAttributeDescriptionCoreViewTransform implements Function<LoadBalancerPolicyAttributeDescription, LoadBalancerPolicyAttributeDescriptionCoreView>
    {
        INSTANCE;


        public LoadBalancerPolicyAttributeDescriptionCoreView apply(LoadBalancerPolicyAttributeDescription arg0) {
            return new LoadBalancerPolicyAttributeDescriptionCoreView(arg0);
        }
    }

    public static class LoadBalancerPolicyAttributeDescriptionCoreView {
        private LoadBalancerPolicyAttributeDescription policyDesc = null;

        public LoadBalancerPolicyAttributeDescriptionCoreView(LoadBalancerPolicyAttributeDescription policyDesc) {
            this.policyDesc = policyDesc;
        }

        public String getAttributeName() {
            return this.policyDesc.attributeName;
        }

        public String getAttributeValue() {
            return this.policyDesc.attributeValue;
        }
    }
}

