/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancerListener;
import com.eucalyptus.loadbalancing.LoadBalancerPolicyAttributeDescription;
import com.eucalyptus.loadbalancing.LoadBalancerPolicyAttributeTypeDescription;
import com.eucalyptus.loadbalancing.LoadBalancerPolicyDescription;
import com.eucalyptus.loadbalancing.LoadBalancerPolicyTypeDescription;
import com.eucalyptus.loadbalancing.backend.DuplicatePolicyNameException;
import com.eucalyptus.loadbalancing.backend.InvalidConfigurationRequestException;
import com.eucalyptus.loadbalancing.backend.LoadBalancingException;
import com.eucalyptus.loadbalancing.backend.PolicyTypeNotFoundException;
import com.eucalyptus.loadbalancing.common.msgs.PolicyAttribute;
import com.eucalyptus.loadbalancing.common.msgs.PolicyAttributeDescription;
import com.eucalyptus.loadbalancing.common.msgs.PolicyAttributeDescriptions;
import com.eucalyptus.loadbalancing.common.msgs.PolicyAttributeTypeDescription;
import com.eucalyptus.loadbalancing.common.msgs.PolicyAttributeTypeDescriptions;
import com.eucalyptus.loadbalancing.common.msgs.PolicyDescription;
import com.eucalyptus.loadbalancing.common.msgs.PolicyTypeDescription;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class LoadBalancerPolicies {
    private static Logger LOG = Logger.getLogger(LoadBalancerPolicies.class);

    public static void initialize() {
        ArrayList requiredPolicyTypes = Lists.newArrayList(LoadBalancerPolicies.initialize40());
        for (LoadBalancerPolicyTypeDescription policyType : requiredPolicyTypes) {
            try {
                TransactionResource db = Entities.transactionFor(LoadBalancerPolicyTypeDescription.class);
                Throwable throwable = null;
                try {
                    try {
                        Entities.uniqueResult((Object)((Object)policyType));
                    }
                    catch (NoSuchElementException ex) {
                        Entities.persist((Object)((Object)policyType));
                        db.commit();
                        LOG.debug((Object)String.format("New policy type has been added: %s", new Object[]{policyType}));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (db == null) continue;
                    if (throwable != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    db.close();
                }
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    private static List<LoadBalancerPolicyTypeDescription> initialize40() {
        ArrayList requiredPolicyTypes = Lists.newArrayList();
        requiredPolicyTypes.add(new LoadBalancerPolicyTypeDescription("AppCookieStickinessPolicyType", "Stickiness policy with session lifetimes controlled by the lifetime of the application-generated cookie. This policy can be associated only with HTTP/HTTPS listeners.", Lists.newArrayList((Object[])new LoadBalancerPolicyAttributeTypeDescription[]{new LoadBalancerPolicyAttributeTypeDescription("CookieName", "String", LoadBalancerPolicyAttributeTypeDescription.Cardinality.ONE)})));
        requiredPolicyTypes.add(new LoadBalancerPolicyTypeDescription("LBCookieStickinessPolicyType", "Stickiness policy with session lifetimes controlled by the browser (user-agent) or a specified expiration period. This policy can be associated only with HTTP/HTTPS listeners.", Lists.newArrayList((Object[])new LoadBalancerPolicyAttributeTypeDescription[]{new LoadBalancerPolicyAttributeTypeDescription("CookieExpirationPeriod", "Long", LoadBalancerPolicyAttributeTypeDescription.Cardinality.ZERO_OR_ONE)})));
        return requiredPolicyTypes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<LoadBalancerPolicyTypeDescription> getLoadBalancerPolicyTypeDescriptions() {
        try (TransactionResource db = Entities.transactionFor(LoadBalancerPolicyTypeDescription.class);){
            List list = Entities.query((Object)((Object)new LoadBalancerPolicyTypeDescription()));
            return list;
        }
        catch (NoSuchElementException ex) {
            return Lists.newArrayList();
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LoadBalancerPolicyTypeDescription findLoadBalancerPolicyTypeDescription(String policyTypeName) throws NoSuchElementException {
        try (TransactionResource db = Entities.transactionFor(LoadBalancerPolicyTypeDescription.class);){
            LoadBalancerPolicyTypeDescription loadBalancerPolicyTypeDescription = (LoadBalancerPolicyTypeDescription)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerPolicyTypeDescription.named(policyTypeName))));
            return loadBalancerPolicyTypeDescription;
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAttributeValueValid(String attrType, String cardinality, String attrValue) {
        if (attrType == null) {
            return true;
        }
        try {
            if (attrType.toLowerCase().equals("boolean")) {
                Boolean.parseBoolean(attrValue);
                return true;
            }
            if (attrType.toLowerCase().equals("integer")) {
                Integer.parseInt(attrValue);
                return true;
            }
            if (attrType.toLowerCase().equals("long")) {
                Long.parseLong(attrValue);
                return true;
            }
            if (!attrType.toLowerCase().equals("string")) return true;
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static void addLoadBalancerPolicy(LoadBalancer lb, String policyName, String policyTypeName, List<PolicyAttribute> attributes) throws LoadBalancingException {
        for (LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionCoreView current : lb.getPolicies()) {
            if (!policyName.equals(current.getPolicyName())) continue;
            throw new DuplicatePolicyNameException();
        }
        boolean typeFound = false;
        for (LoadBalancerPolicyTypeDescription type : LoadBalancerPolicies.getLoadBalancerPolicyTypeDescriptions()) {
            if (!policyTypeName.equals(type.getPolicyTypeName())) continue;
            typeFound = true;
            break;
        }
        if (!typeFound) {
            throw new PolicyTypeNotFoundException();
        }
        LoadBalancerPolicyDescription policyDesc = new LoadBalancerPolicyDescription(lb, policyName, policyTypeName);
        for (PolicyAttribute attr : attributes) {
            policyDesc.addPolicyAttributeDescription(attr.getAttributeName(), attr.getAttributeValue());
        }
        try (TransactionResource db = Entities.transactionFor(LoadBalancerPolicyDescription.class);){
            Entities.persist((Object)((Object)policyDesc));
            db.commit();
        }
    }

    public static void deleteLoadBalancerPolicy(LoadBalancer lb, String policyName) throws LoadBalancingException {
        Throwable throwable;
        TransactionResource db;
        List<LoadBalancerPolicyDescription> policies = LoadBalancerPolicies.getLoadBalancerPolicyDescription(lb, Lists.newArrayList((Object[])new String[]{policyName}));
        if (policies == null || policies.size() <= 0) {
            return;
        }
        LoadBalancerPolicyDescription toDelete = policies.get(0);
        List<LoadBalancerListener.LoadBalancerListenerCoreView> listeners = toDelete.getListeners();
        if (listeners != null && listeners.size() > 0) {
            throw new InvalidConfigurationRequestException("The policy is enabled for listeners");
        }
        try {
            db = Entities.transactionFor(LoadBalancerPolicyAttributeDescription.class);
            throwable = null;
            try {
                Entities.deleteAllMatching(LoadBalancerPolicyAttributeDescription.class, (String)"WHERE metadata_policy_desc_fk = :metadata_policy_desc_fk", Collections.singletonMap("metadata_policy_desc_fk", toDelete.getRecordId()));
                db.commit();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (db != null) {
                    if (throwable != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        db.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to delete policy attributes", (Throwable)ex);
        }
        try {
            db = Entities.transactionFor(LoadBalancerPolicyDescription.class);
            throwable = null;
            try {
                Entities.deleteAllMatching(LoadBalancerPolicyDescription.class, (String)"WHERE unique_name = :unique_name", Collections.singletonMap("unique_name", toDelete.getUniqueName()));
                db.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (db != null) {
                    if (throwable != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        db.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public static List<LoadBalancerPolicyDescription> getLoadBalancerPolicyDescription(LoadBalancer lb) {
        ArrayList policyViews = Lists.newArrayList(lb.getPolicies());
        ArrayList policies = Lists.newArrayList();
        for (LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionCoreView policyView : policyViews) {
            policies.add(LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionEntityTransform.INSTANCE.apply(policyView));
        }
        return policies;
    }

    public static LoadBalancerPolicyDescription getLoadBalancerPolicyDescription(LoadBalancer lb, String policyName) throws NoSuchElementException {
        LoadBalancerPolicyDescription policy = null;
        for (LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionCoreView p : lb.getPolicies()) {
            if (!p.getPolicyName().equals(policyName)) continue;
            policy = LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionEntityTransform.INSTANCE.apply(p);
            break;
        }
        if (policy != null) {
            return policy;
        }
        throw new NoSuchElementException();
    }

    public static List<LoadBalancerPolicyDescription> getLoadBalancerPolicyDescription(LoadBalancer lb, final List<String> policyNames) {
        List<LoadBalancerPolicyDescription> allPolicies = LoadBalancerPolicies.getLoadBalancerPolicyDescription(lb);
        ArrayList filtered = Lists.newArrayList((Iterable)Collections2.filter(allPolicies, (Predicate)new Predicate<LoadBalancerPolicyDescription>(){

            public boolean apply(LoadBalancerPolicyDescription arg0) {
                return policyNames.contains(arg0.getPolicyName());
            }
        }));
        return filtered;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<LoadBalancerPolicyDescription> getPoliciesOfListener(LoadBalancerListener listener) {
        try (TransactionResource db = Entities.transactionFor(LoadBalancerListener.class);){
            LoadBalancerListener found = (LoadBalancerListener)((Object)Entities.uniqueResult((Object)((Object)listener)));
            List<LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionCoreView> policies = found.getPolicies();
            db.commit();
            List list = Lists.transform(policies, (Function)LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionEntityTransform.INSTANCE);
            return list;
        }
        catch (NoSuchElementException ex) {
            return Lists.newArrayList();
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public static void removePoliciesFromListener(LoadBalancerListener listener) {
        try (TransactionResource db = Entities.transactionFor(LoadBalancerListener.class);){
            LoadBalancerListener update = (LoadBalancerListener)((Object)Entities.uniqueResult((Object)((Object)listener)));
            update.resetPolicies();
            Entities.persist((Object)((Object)update));
            db.commit();
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public static void removePolicyFromListener(LoadBalancerListener listener, LoadBalancerPolicyDescription policy) {
        try (TransactionResource db = Entities.transactionFor(LoadBalancerListener.class);){
            LoadBalancerListener update = (LoadBalancerListener)((Object)Entities.uniqueResult((Object)((Object)listener)));
            update.removePolicy(policy);
            db.commit();
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public static void addPoliciesToListener(LoadBalancerListener listener, List<LoadBalancerPolicyDescription> policies) throws LoadBalancingException {
        if (policies != null && policies.size() > 0) {
            int numCookies = 0;
            for (LoadBalancerPolicyDescription policy : policies) {
                if ("LBCookieStickinessPolicyType".equals(policy.getPolicyTypeName())) {
                    ++numCookies;
                    if (listener.getProtocol().equals((Object)LoadBalancerListener.PROTOCOL.HTTP) || listener.getProtocol().equals((Object)LoadBalancerListener.PROTOCOL.HTTPS)) continue;
                    throw new InvalidConfigurationRequestException("Session stickiness policy can be associated with only HTTP/HTTPS");
                }
                if (!"AppCookieStickinessPolicyType".equals(policy.getPolicyTypeName())) continue;
                ++numCookies;
                if (listener.getProtocol().equals((Object)LoadBalancerListener.PROTOCOL.HTTP) || listener.getProtocol().equals((Object)LoadBalancerListener.PROTOCOL.HTTPS)) continue;
                throw new InvalidConfigurationRequestException("Session stickiness policy can be associated with only HTTP/HTTPS");
            }
            if (numCookies > 1) {
                throw new InvalidConfigurationRequestException("Only one cookie stickiness policy can be set");
            }
        }
        try (TransactionResource db = Entities.transactionFor(LoadBalancerListener.class);){
            LoadBalancerListener update = (LoadBalancerListener)((Object)Entities.uniqueResult((Object)((Object)listener)));
            for (LoadBalancerPolicyDescription policy : policies) {
                update.removePolicy(policy);
                update.addPolicy(policy);
            }
            db.commit();
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public static List<PolicyDescription> getSamplePolicyDescription() {
        return Lists.newArrayList(LoadBalancerPolicies.getSamplePolicyDescription40());
    }

    private static List<PolicyDescription> getSamplePolicyDescription40() {
        ArrayList sampleList = Lists.newArrayList();
        PolicyDescription appCookieStick = new PolicyDescription();
        appCookieStick.setPolicyName("ELBSample-AppCookieStickinessPolicy");
        appCookieStick.setPolicyTypeName("AppCookieStickinessPolicyType");
        PolicyAttributeDescription appCookieAttr = new PolicyAttributeDescription();
        appCookieAttr.setAttributeName("CookieName");
        appCookieAttr.setAttributeValue("ELBSampleCookie");
        PolicyAttributeDescriptions appCookieAttrs = new PolicyAttributeDescriptions();
        appCookieAttrs.setMember(Lists.newArrayList((Object[])new PolicyAttributeDescription[]{appCookieAttr}));
        appCookieStick.setPolicyAttributeDescriptions(appCookieAttrs);
        sampleList.add(appCookieStick);
        PolicyDescription lbCookieStick = new PolicyDescription();
        lbCookieStick.setPolicyName("ELBSample-LBCookieStickinessPolicy");
        lbCookieStick.setPolicyTypeName("LBCookieStickinessPolicyType");
        PolicyAttributeDescription lbCookieAttr = new PolicyAttributeDescription();
        lbCookieAttr.setAttributeName("CookieExpirationPeriod");
        lbCookieAttr.setAttributeValue("100");
        PolicyAttributeDescriptions lbCookieAttrs = new PolicyAttributeDescriptions();
        lbCookieAttrs.setMember(Lists.newArrayList((Object[])new PolicyAttributeDescription[]{lbCookieAttr}));
        lbCookieStick.setPolicyAttributeDescriptions(lbCookieAttrs);
        sampleList.add(lbCookieStick);
        return sampleList;
    }

    public static enum AsPolicyTypeDescription implements Function<LoadBalancerPolicyTypeDescription, PolicyTypeDescription>
    {
        INSTANCE;


        public PolicyTypeDescription apply(LoadBalancerPolicyTypeDescription arg0) {
            if (arg0 == null) {
                return null;
            }
            PolicyTypeDescription policyType = new PolicyTypeDescription();
            policyType.setPolicyTypeName(arg0.getPolicyTypeName());
            policyType.setDescription(arg0.getDescription());
            List<LoadBalancerPolicyAttributeTypeDescription.LoadBalancerPolicyAttributeTypeDescriptionCoreView> policyAttributeTypeDesc = arg0.getPolicyAttributeTypeDescriptions();
            if (policyAttributeTypeDesc != null && policyAttributeTypeDesc.size() > 0) {
                ArrayList attrTypes = Lists.newArrayList();
                for (LoadBalancerPolicyAttributeTypeDescription.LoadBalancerPolicyAttributeTypeDescriptionCoreView from : policyAttributeTypeDesc) {
                    PolicyAttributeTypeDescription to = new PolicyAttributeTypeDescription();
                    to.setAttributeName(from.getAttributeName());
                    to.setAttributeType(from.getAttributeType());
                    to.setCardinality(from.getCardinality());
                    to.setDefaultValue(from.getDefaultValue());
                    to.setDescription(from.getDescription());
                    attrTypes.add(to);
                }
                PolicyAttributeTypeDescriptions attrDescs = new PolicyAttributeTypeDescriptions();
                attrDescs.setMember(attrTypes);
                policyType.setPolicyAttributeTypeDescriptions(attrDescs);
            }
            return policyType;
        }
    }

    public static enum AsPolicyDescription implements Function<LoadBalancerPolicyDescription, PolicyDescription>
    {
        INSTANCE;


        public PolicyDescription apply(LoadBalancerPolicyDescription arg0) {
            if (arg0 == null) {
                return null;
            }
            PolicyDescription policy = new PolicyDescription();
            policy.setPolicyName(arg0.getPolicyName());
            policy.setPolicyTypeName(arg0.getPolicyTypeName());
            ArrayList attrDescs = Lists.newArrayList();
            for (LoadBalancerPolicyAttributeDescription.LoadBalancerPolicyAttributeDescriptionCoreView descView : arg0.getPolicyAttributeDescription()) {
                PolicyAttributeDescription desc = new PolicyAttributeDescription();
                desc.setAttributeName(descView.getAttributeName());
                desc.setAttributeValue(descView.getAttributeValue());
                attrDescs.add(desc);
            }
            PolicyAttributeDescriptions descs = new PolicyAttributeDescriptions();
            descs.setMember(attrDescs);
            policy.setPolicyAttributeDescriptions(descs);
            return policy;
        }
    }
}

