/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.activities.LoadBalancerServoInstance;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import com.google.common.net.HostSpecifier;
import edu.ucsb.eucalyptus.cloud.entities.SystemConfiguration;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@ConfigurableClass(root="services.loadbalancing", description="Parameters controlling loadbalancing")
@Entity
@PersistenceContext(name="eucalyptus_loadbalancing")
@Table(name="metadata_dns")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class LoadBalancerDnsRecord
extends AbstractPersistent {
    private static Logger LOG = Logger.getLogger(LoadBalancerDnsRecord.class);
    @ConfigurableField(displayName="loadbalancer_dns_subdomain", description="loadbalancer dns subdomain", initial="lb", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=ELBDnsChangeListener.class)
    public static String DNS_SUBDOMAIN = "lb";
    @ConfigurableField(displayName="loadbalancer_dns_ttl", description="loadbalancer dns ttl value", initial="60", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=ELBDnsTtlChangeListener.class)
    public static String DNS_TTL = "60";
    @Transient
    private static final long serialVersionUID = 1L;
    @Transient
    private LoadBalancerDnsRecordRelationView view = null;
    @OneToOne
    @JoinColumn(name="metadata_loadbalancer_fk", nullable=false)
    private LoadBalancer loadbalancer = null;
    @Column(name="dns_name", nullable=false, unique=true)
    private String dnsName = null;
    @Column(name="dns_zone", nullable=false)
    private String dnsZone = null;
    @Column(name="unique_name", nullable=false, unique=true)
    private String uniqueName = null;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="dns")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Collection<LoadBalancerServoInstance> servoInstances = null;

    public static int getLoadbalancerTTL() {
        return Integer.parseInt(DNS_TTL);
    }

    @PostLoad
    private void onLoad() {
        if (this.view == null) {
            this.view = new LoadBalancerDnsRecordRelationView(this);
        }
    }

    private LoadBalancerDnsRecord() {
    }

    private LoadBalancerDnsRecord(LoadBalancer lb) {
        this.loadbalancer = lb;
    }

    public static LoadBalancerDnsRecord named() {
        return new LoadBalancerDnsRecord();
    }

    public static LoadBalancerDnsRecord named(LoadBalancer lb) {
        LoadBalancerDnsRecord instance = new LoadBalancerDnsRecord(lb);
        String dnsPrefix = String.format("%s-%s", lb.getDisplayName(), lb.getOwnerAccountNumber());
        dnsPrefix = dnsPrefix.replace(".", "_");
        int maxPrefixLength = 253 - String.format(".%s.%s", DNS_SUBDOMAIN, SystemConfiguration.getSystemConfiguration().getDnsDomain()).length();
        if (maxPrefixLength < 0) {
            throw Exceptions.toUndeclared((String)"invalid dns name length", (Throwable[])new Throwable[0]);
        }
        if (dnsPrefix.length() > maxPrefixLength) {
            dnsPrefix = dnsPrefix.substring(0, maxPrefixLength);
        }
        instance.dnsName = dnsPrefix;
        instance.dnsZone = DNS_SUBDOMAIN;
        instance.uniqueName = instance.createUniqueName();
        return instance;
    }

    public String getZone() {
        return this.dnsZone;
    }

    public void setLoadbalancer(LoadBalancer lb) {
        this.loadbalancer = lb;
    }

    public LoadBalancer.LoadBalancerCoreView getLoadbalancer() {
        return this.view.getLoadBalancer();
    }

    public String getName() {
        return String.format("%s.%s", this.dnsName, this.dnsZone);
    }

    public String getDnsName() {
        return String.format("%s.%s.%s", this.dnsName, this.dnsZone, SystemConfiguration.getSystemConfiguration().getDnsDomain());
    }

    @PrePersist
    private void generateOnCommit() {
        if (this.uniqueName == null) {
            this.uniqueName = this.createUniqueName();
        }
    }

    protected String createUniqueName() {
        return String.format("dns-%s-%s-%s", this.loadbalancer.getOwnerAccountNumber(), this.loadbalancer.getDisplayName(), this.getDnsName());
    }

    public String toString() {
        String name = "unassigned";
        if (this.dnsName != null && this.dnsZone != null) {
            name = String.format("Loadbalancer DNS record - %s", this.getDnsName());
        }
        return name;
    }

    public static class LoadBalancerDnsRecordRelationView {
        private LoadBalancerDnsRecord dns = null;
        private LoadBalancer loadbalancer = null;

        LoadBalancerDnsRecordRelationView(LoadBalancerDnsRecord dns) {
            this.dns = dns;
            Entities.initialize((Object)((Object)dns.loadbalancer));
            this.loadbalancer = dns.loadbalancer;
        }

        public LoadBalancer.LoadBalancerCoreView getLoadBalancer() {
            return this.loadbalancer.getCoreView();
        }
    }

    public static enum LoadBalancerDnsRecordEntityTransform implements Function<LoadBalancerDnsRecordCoreView, LoadBalancerDnsRecord>
    {
        INSTANCE;


        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        public LoadBalancerDnsRecord apply(@Nullable LoadBalancerDnsRecordCoreView arg0) {
            try (TransactionResource db = Entities.transactionFor(LoadBalancerDnsRecord.class);){
                LoadBalancerDnsRecord loadBalancerDnsRecord = (LoadBalancerDnsRecord)((Object)Entities.uniqueResult((Object)((Object)arg0.dns)));
                return loadBalancerDnsRecord;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    @TypeMapper
    public static enum LoadBalancerDnsRecordCoreViewTransform implements Function<LoadBalancerDnsRecord, LoadBalancerDnsRecordCoreView>
    {
        INSTANCE;


        @Nullable
        public LoadBalancerDnsRecordCoreView apply(@Nullable LoadBalancerDnsRecord arg0) {
            return new LoadBalancerDnsRecordCoreView(arg0);
        }
    }

    public static class LoadBalancerDnsRecordCoreView {
        private LoadBalancerDnsRecord dns = null;

        LoadBalancerDnsRecordCoreView(LoadBalancerDnsRecord dns) {
            this.dns = dns;
        }

        public String getZone() {
            return this.dns.getZone();
        }

        public String getName() {
            return this.dns.getName();
        }

        public String getDnsName() {
            return this.dns.getDnsName();
        }
    }

    public static class ELBDnsTtlChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                int n = Integer.parseInt((String)newValue);
            }
            catch (Exception ex) {
                throw new ConfigurablePropertyException("Malformed ttl value");
            }
        }
    }

    public static class ELBDnsChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                if (newValue instanceof String && !HostSpecifier.isValid((String)String.format("%s.com", (String)newValue))) {
                    throw new ConfigurablePropertyException("Malformed domain name");
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Malformed domain name");
            }
        }
    }
}

