/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing;

import com.eucalyptus.cloudwatch.common.msgs.Dimension;
import com.eucalyptus.cloudwatch.common.msgs.Dimensions;
import com.eucalyptus.cloudwatch.common.msgs.MetricData;
import com.eucalyptus.cloudwatch.common.msgs.MetricDatum;
import com.eucalyptus.cloudwatch.common.msgs.StatisticSet;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancerBackendInstance;
import com.eucalyptus.loadbalancing.LoadBalancerZone;
import com.eucalyptus.loadbalancing.LoadBalancers;
import com.eucalyptus.loadbalancing.activities.EucalyptusActivityTasks;
import com.eucalyptus.loadbalancing.activities.LoadBalancerServoInstance;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class LoadBalancerCwatchMetrics {
    private static Logger LOG = Logger.getLogger(LoadBalancerCwatchMetrics.class);
    private static LoadBalancerCwatchMetrics _instance = new LoadBalancerCwatchMetrics();
    private Map<ElbDimension, ElbAggregate> metricsMap = new ConcurrentHashMap<ElbDimension, ElbAggregate>();
    private Map<BackendInstance, Boolean> instanceHealthMap = new ConcurrentHashMap<BackendInstance, Boolean>();
    private Map<BackendInstance, ElbDimension> instanceToDimensionMap = new ConcurrentHashMap<BackendInstance, ElbDimension>();
    private Map<String, Date> lastReported = new ConcurrentHashMap<String, Date>();
    private final int CLOUDWATCH_REPORTING_INTERVAL_SEC = 60;
    private final String CLOUDWATCH_ELB_METRIC_NAMESPACE = "AWS/ELB";
    private Object lock = new Object();

    private LoadBalancerCwatchMetrics() {
    }

    public static LoadBalancerCwatchMetrics getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetric(String servoId, MetricData metric) {
        LoadBalancerZone.LoadBalancerZoneCoreView lbZone;
        try (TransactionResource db = Entities.transactionFor(LoadBalancerServoInstance.class);){
            LoadBalancerServoInstance servo = (LoadBalancerServoInstance)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerServoInstance.named(servoId))));
            lbZone = servo.getAvailabilityZone();
            db.commit();
        }
        catch (NoSuchElementException ex) {
            throw Exceptions.toUndeclared((String)("Failed to find the servo instance " + servoId), (Throwable[])new Throwable[0]);
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((String)("database error while querying " + servoId), (Throwable[])new Throwable[0]);
        }
        LoadBalancerZone zone = null;
        LoadBalancer.LoadBalancerCoreView lb = null;
        try {
            zone = LoadBalancerZone.LoadBalancerZoneEntityTransform.INSTANCE.apply(lbZone);
            lb = zone.getLoadbalancer();
        }
        catch (Exception ex) {
            return;
        }
        String userId = lb.getOwnerUserId();
        String lbName = lb.getDisplayName();
        String zoneName = lbZone.getName();
        ElbDimension dim = new ElbDimension(userId, lbName, zoneName);
        Object object = this.lock;
        synchronized (object) {
            if (!this.metricsMap.containsKey(dim)) {
                this.metricsMap.put(dim, new ElbAggregate(lbName, zoneName));
            }
            this.metricsMap.get(dim).addMetric(metric);
        }
        try {
            this.maybeReport(userId);
        }
        catch (Exception ex) {
            LOG.error((Object)String.format("Failed to report cloudwatch metrics: %s-%s", lb.getOwnerUserName(), lb.getDisplayName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHealthy(LoadBalancer.LoadBalancerCoreView lb, String zone, String instanceId) {
        ElbDimension dim = new ElbDimension(lb.getOwnerUserId(), lb.getDisplayName(), zone);
        BackendInstance key = new BackendInstance(lb, instanceId);
        Object object = this.lock;
        synchronized (object) {
            if (!this.instanceToDimensionMap.containsKey(key)) {
                this.instanceToDimensionMap.put(key, dim);
            }
            this.instanceHealthMap.put(key, Boolean.TRUE);
            if (!this.metricsMap.containsKey(dim)) {
                this.metricsMap.put(dim, new ElbAggregate(lb.getDisplayName(), zone));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUnHealthy(LoadBalancer.LoadBalancerCoreView lb, String zone, String instanceId) {
        ElbDimension dim = new ElbDimension(lb.getOwnerUserId(), lb.getDisplayName(), zone);
        BackendInstance key = new BackendInstance(lb, instanceId);
        Object object = this.lock;
        synchronized (object) {
            if (!this.instanceToDimensionMap.containsKey(key)) {
                this.instanceToDimensionMap.put(key, dim);
            }
            this.instanceHealthMap.put(key, Boolean.FALSE);
            if (!this.metricsMap.containsKey(dim)) {
                this.metricsMap.put(dim, new ElbAggregate(lb.getDisplayName(), zone));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeReport(String userId) {
        MetricData data = null;
        if (!this.lastReported.containsKey(userId)) {
            this.lastReported.put(userId, new Date(System.currentTimeMillis()));
            return;
        }
        Date lastReport = this.lastReported.get(userId);
        long currentTime = System.currentTimeMillis();
        int diffSec = (int)((double)(currentTime - lastReport.getTime()) / 1000.0);
        if (diffSec >= 60) {
            data = this.getDataAndClear(userId);
        }
        if (data != null && data.getMember() != null && data.getMember().size() > 0) {
            try {
                EucalyptusActivityTasks.getInstance().putCloudWatchMetricData(userId, "AWS/ELB", data);
            }
            catch (Exception ex) {
                Exceptions.toUndeclared((Throwable)ex);
            }
            finally {
                this.lastReported.put(userId, new Date(currentTime));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetricData getDataAndClear(final String userId) {
        MetricData data = new MetricData();
        data.setMember(Lists.newArrayList());
        ArrayList toCleanup = Lists.newArrayList();
        HashMap<ElbDimension, Integer> healthyCountMap = new HashMap<ElbDimension, Integer>();
        HashMap<ElbDimension, Integer> unhealthyCountMap = new HashMap<ElbDimension, Integer>();
        ArrayList candidates = Lists.newArrayList((Iterable)Iterables.filter(this.instanceHealthMap.keySet(), (Predicate)new Predicate<BackendInstance>(){

            public boolean apply(@Nullable BackendInstance instance) {
                try {
                    if (instance.getLoadBalancer() == null) {
                        return false;
                    }
                    if (!userId.equals(instance.getLoadBalancer().getOwnerUserId())) {
                        return false;
                    }
                    LoadBalancer lb = LoadBalancer.LoadBalancerEntityTransform.INSTANCE.apply(instance.getLoadBalancer());
                    LoadBalancerBackendInstance be = LoadBalancers.lookupBackendInstance(lb, instance.getInstanceId());
                    if (be == null) {
                        return false;
                    }
                    if (be.getAvailabilityZone() == null || !LoadBalancerZone.STATE.InService.equals((Object)be.getAvailabilityZone().getState())) {
                        return false;
                    }
                    return LoadBalancerBackendInstance.STATE.InService.equals(be.getState()) || LoadBalancerBackendInstance.STATE.OutOfService.equals(be.getState());
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }));
        Object object = this.lock;
        synchronized (object) {
            for (BackendInstance instance : candidates) {
                ElbDimension thisDim = this.instanceToDimensionMap.get(instance);
                if (this.instanceHealthMap.get(instance).booleanValue()) {
                    if (!healthyCountMap.containsKey(thisDim)) {
                        healthyCountMap.put(thisDim, 0);
                    }
                    healthyCountMap.put(thisDim, (Integer)healthyCountMap.get(thisDim) + 1);
                    continue;
                }
                if (!unhealthyCountMap.containsKey(thisDim)) {
                    unhealthyCountMap.put(thisDim, 0);
                }
                unhealthyCountMap.put(thisDim, (Integer)unhealthyCountMap.get(thisDim) + 1);
            }
            for (ElbDimension dim : this.metricsMap.keySet()) {
                int numUnhealthy;
                StatisticSet sset;
                MetricDatum datum;
                int numHealthy;
                if (!dim.getUserId().equals(userId)) continue;
                ElbAggregate aggr = this.metricsMap.get(dim);
                List<MetricDatum> datumList = aggr.toELBStatistics();
                Dimensions dims = new Dimensions();
                Dimension lb = new Dimension();
                lb.setName("LoadBalancerName");
                lb.setValue(dim.getLoadbalancer());
                Dimension az = new Dimension();
                az.setName("AvailabilityZone");
                az.setValue(dim.getAvailabilityZone());
                dims.setMember(Lists.newArrayList((Object[])new Dimension[]{lb, az}));
                if (healthyCountMap.containsKey(dim) && (numHealthy = ((Integer)healthyCountMap.get(dim)).intValue()) > 0) {
                    datum = new MetricDatum();
                    datum.setDimensions(dims);
                    datum.setMetricName("HealthyHostCount");
                    datum.setUnit("Count");
                    sset = new StatisticSet();
                    sset.setSampleCount(Double.valueOf(1.0));
                    sset.setMaximum(Double.valueOf(numHealthy));
                    sset.setMinimum(Double.valueOf(numHealthy));
                    sset.setSum(Double.valueOf(numHealthy));
                    datum.setStatisticValues(sset);
                    datumList.add(datum);
                }
                if (unhealthyCountMap.containsKey(dim) && (numUnhealthy = ((Integer)unhealthyCountMap.get(dim)).intValue()) > 0) {
                    datum = new MetricDatum();
                    datum.setDimensions(dims);
                    datum.setMetricName("UnHealthyHostCount");
                    datum.setUnit("Count");
                    sset = new StatisticSet();
                    sset.setSampleCount(Double.valueOf(1.0));
                    sset.setMaximum(Double.valueOf(numUnhealthy));
                    sset.setMinimum(Double.valueOf(numUnhealthy));
                    sset.setSum(Double.valueOf(numUnhealthy));
                    datum.setStatisticValues(sset);
                    datumList.add(datum);
                }
                if (datumList.size() > 0) {
                    data.getMember().addAll(datumList);
                }
                toCleanup.add(dim);
            }
            for (ElbDimension cleanup : toCleanup) {
                this.metricsMap.remove(cleanup);
                healthyCountMap.remove(cleanup);
                unhealthyCountMap.remove(cleanup);
            }
            for (BackendInstance instance : candidates) {
                this.instanceHealthMap.remove(instance);
                this.instanceToDimensionMap.remove(instance);
            }
        }
        return data;
    }

    private static class ElbDimension {
        private String userId = null;
        private String loadbalancer = null;
        private String availabilityZone = null;

        public ElbDimension(String userId, String lb, String zone) {
            this.userId = userId;
            this.loadbalancer = lb;
            this.availabilityZone = zone;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getLoadbalancer() {
            return this.loadbalancer;
        }

        public String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ElbDimension.class) {
                return false;
            }
            ElbDimension other = (ElbDimension)obj;
            if (this.userId == null ? other.userId != null : !this.userId.equals(other.userId)) {
                return false;
            }
            if (this.loadbalancer == null ? other.loadbalancer != null : !this.loadbalancer.equals(other.loadbalancer)) {
                return false;
            }
            return !(this.availabilityZone == null ? other.availabilityZone != null : !this.availabilityZone.equals(other.availabilityZone));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
            result = 31 * result + (this.loadbalancer == null ? 0 : this.loadbalancer.hashCode());
            result = 31 * result + (this.availabilityZone == null ? 0 : this.availabilityZone.hashCode());
            return result;
        }

        public String toString() {
            return String.format("dimension-%s-%s-%s", this.userId, this.loadbalancer, this.availabilityZone);
        }
    }

    private static class BackendInstance {
        private String instanceId = null;
        private LoadBalancer.LoadBalancerCoreView loadbalancer = null;
        private String userId = null;
        private String loadbalancerName = null;

        private BackendInstance(LoadBalancer.LoadBalancerCoreView lb, String instanceId) {
            this.loadbalancer = lb;
            this.instanceId = instanceId;
            this.userId = lb.getOwnerUserId();
            this.loadbalancerName = lb.getDisplayName();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != BackendInstance.class) {
                return false;
            }
            BackendInstance other = (BackendInstance)obj;
            if (this.userId == null ? other.userId != null : !this.userId.equals(other.userId)) {
                return false;
            }
            if (this.loadbalancerName == null ? other.loadbalancerName != null : !this.loadbalancerName.equals(other.loadbalancerName)) {
                return false;
            }
            return !(this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId));
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public LoadBalancer.LoadBalancerCoreView getLoadBalancer() {
            return this.loadbalancer;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
            result = 31 * result + (this.loadbalancerName == null ? 0 : this.loadbalancerName.hashCode());
            result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
            return result;
        }

        public String toString() {
            return String.format("backend instance-%s-%s-%s", this.userId, this.loadbalancerName, this.instanceId);
        }
    }

    public static class ElbAggregate {
        private double latency = 0.0;
        private long requestCount = 0L;
        private long httpCode_ELB_4XX = 0L;
        private long httpCode_ELB_5XX = 0L;
        private long httpCode_Backend_2XX = 0L;
        private long httpCode_Backend_3XX = 0L;
        private long httpCode_Backend_4XX = 0L;
        private long httpCode_Backend_5XX = 0L;
        private String loadbalancer = null;
        private String availabilityZone = null;

        public ElbAggregate(String loadbalancer, String availabilityZone) {
            this.loadbalancer = loadbalancer;
            this.availabilityZone = availabilityZone;
        }

        public void addMetric(MetricData metric) {
            if (metric.getMember() != null) {
                for (MetricDatum datum : metric.getMember()) {
                    String name = datum.getMetricName();
                    double value = datum.getValue();
                    if (name.equals("Latency")) {
                        this.latency += (value /= 1000.0);
                        continue;
                    }
                    if (name.equals("RequestCount")) {
                        this.requestCount += (long)value;
                        continue;
                    }
                    if (name.equals("HTTPCode_ELB_4XX")) {
                        this.httpCode_ELB_4XX += (long)value;
                        continue;
                    }
                    if (name.equals("HTTPCode_ELB_5XX")) {
                        this.httpCode_ELB_5XX += (long)value;
                        continue;
                    }
                    if (name.equals("HTTPCode_Backend_2XX")) {
                        this.httpCode_Backend_2XX += (long)value;
                        continue;
                    }
                    if (name.equals("HTTPCode_Backend_3XX")) {
                        this.httpCode_Backend_3XX += (long)value;
                        continue;
                    }
                    if (name.equals("HTTPCode_Backend_4XX")) {
                        this.httpCode_Backend_4XX += (long)value;
                        continue;
                    }
                    if (!name.equals("HTTPCode_Backend_5XX")) continue;
                    this.httpCode_Backend_5XX += (long)value;
                }
            }
        }

        public List<MetricDatum> toELBStatistics() {
            ArrayList result = Lists.newArrayList();
            Dimensions dims = new Dimensions();
            Dimension lb = new Dimension();
            lb.setName("LoadBalancerName");
            lb.setValue(this.loadbalancer);
            Dimension az = new Dimension();
            az.setName("AvailabilityZone");
            az.setValue(this.availabilityZone);
            dims.setMember(Lists.newArrayList((Object[])new Dimension[]{lb, az}));
            if (this.latency > 0.0 && this.requestCount > 0L) {
                MetricDatum latencyData = new MetricDatum();
                latencyData.setDimensions(dims);
                latencyData.setMetricName("Latency");
                latencyData.setUnit("Seconds");
                double latency = this.latency / (double)this.requestCount;
                latencyData.setValue(Double.valueOf(latency));
                result.add(latencyData);
            }
            if (this.requestCount > 0L) {
                MetricDatum reqCountData = new MetricDatum();
                reqCountData.setDimensions(dims);
                reqCountData.setMetricName("RequestCount");
                reqCountData.setUnit("Count");
                StatisticSet sset = new StatisticSet();
                sset.setSampleCount(Double.valueOf(this.requestCount));
                sset.setMaximum(Double.valueOf(1.0));
                sset.setMinimum(Double.valueOf(1.0));
                sset.setSum(Double.valueOf(this.requestCount));
                reqCountData.setStatisticValues(sset);
                result.add(reqCountData);
            }
            if (this.httpCode_ELB_4XX > 0L) {
                MetricDatum httpCode_ELB_4XX = new MetricDatum();
                httpCode_ELB_4XX.setDimensions(dims);
                httpCode_ELB_4XX.setMetricName("HTTPCode_ELB_4XX");
                httpCode_ELB_4XX.setUnit("Count");
                StatisticSet sset = new StatisticSet();
                sset.setSampleCount(Double.valueOf(this.httpCode_ELB_4XX));
                sset.setMaximum(Double.valueOf(0.0));
                sset.setMinimum(Double.valueOf(0.0));
                sset.setSum(Double.valueOf(this.httpCode_ELB_4XX));
                httpCode_ELB_4XX.setStatisticValues(sset);
                result.add(httpCode_ELB_4XX);
            }
            if (this.httpCode_ELB_5XX > 0L) {
                MetricDatum httpCode_ELB_5XX = new MetricDatum();
                httpCode_ELB_5XX.setDimensions(dims);
                httpCode_ELB_5XX.setMetricName("HTTPCode_ELB_5XX");
                httpCode_ELB_5XX.setUnit("Count");
                StatisticSet sset = new StatisticSet();
                sset.setSampleCount(Double.valueOf(this.httpCode_ELB_5XX));
                sset.setMaximum(Double.valueOf(0.0));
                sset.setMinimum(Double.valueOf(0.0));
                sset.setSum(Double.valueOf(this.httpCode_ELB_5XX));
                httpCode_ELB_5XX.setStatisticValues(sset);
                result.add(httpCode_ELB_5XX);
            }
            if (this.httpCode_Backend_2XX > 0L) {
                MetricDatum httpCode_Backend_2XX = new MetricDatum();
                httpCode_Backend_2XX.setDimensions(dims);
                httpCode_Backend_2XX.setMetricName("HTTPCode_Backend_2XX");
                httpCode_Backend_2XX.setUnit("Count");
                StatisticSet sset = new StatisticSet();
                sset.setSampleCount(Double.valueOf(this.httpCode_Backend_2XX));
                sset.setMaximum(Double.valueOf(0.0));
                sset.setMinimum(Double.valueOf(0.0));
                sset.setSum(Double.valueOf(this.httpCode_Backend_2XX));
                httpCode_Backend_2XX.setStatisticValues(sset);
                result.add(httpCode_Backend_2XX);
            }
            if (this.httpCode_Backend_3XX > 0L) {
                MetricDatum httpCode_Backend_3XX = new MetricDatum();
                httpCode_Backend_3XX.setDimensions(dims);
                httpCode_Backend_3XX.setMetricName("HTTPCode_Backend_3XX");
                httpCode_Backend_3XX.setUnit("Count");
                StatisticSet sset = new StatisticSet();
                sset.setSampleCount(Double.valueOf(this.httpCode_Backend_3XX));
                sset.setMaximum(Double.valueOf(0.0));
                sset.setMinimum(Double.valueOf(0.0));
                sset.setSum(Double.valueOf(this.httpCode_Backend_3XX));
                httpCode_Backend_3XX.setStatisticValues(sset);
                result.add(httpCode_Backend_3XX);
            }
            if (this.httpCode_Backend_4XX > 0L) {
                MetricDatum httpCode_Backend_4XX = new MetricDatum();
                httpCode_Backend_4XX.setDimensions(dims);
                httpCode_Backend_4XX.setMetricName("HTTPCode_Backend_4XX");
                httpCode_Backend_4XX.setUnit("Count");
                StatisticSet sset = new StatisticSet();
                sset.setSampleCount(Double.valueOf(this.httpCode_Backend_4XX));
                sset.setMaximum(Double.valueOf(0.0));
                sset.setMinimum(Double.valueOf(0.0));
                sset.setSum(Double.valueOf(this.httpCode_Backend_4XX));
                httpCode_Backend_4XX.setStatisticValues(sset);
                result.add(httpCode_Backend_4XX);
            }
            if (this.httpCode_Backend_5XX > 0L) {
                MetricDatum httpCode_Backend_5XX = new MetricDatum();
                httpCode_Backend_5XX.setDimensions(dims);
                httpCode_Backend_5XX.setMetricName("HTTPCode_Backend_5XX");
                httpCode_Backend_5XX.setUnit("Count");
                StatisticSet sset = new StatisticSet();
                sset.setSampleCount(Double.valueOf(this.httpCode_Backend_5XX));
                sset.setMaximum(Double.valueOf(0.0));
                sset.setMinimum(Double.valueOf(0.0));
                sset.setSum(Double.valueOf(this.httpCode_Backend_5XX));
                httpCode_Backend_5XX.setStatisticValues(sset);
                result.add(httpCode_Backend_5XX);
            }
            return result;
        }

        public String toString() {
            return String.format("aggregate=%.2f %d %d %d %d %d %d %d", this.latency, this.requestCount, this.httpCode_ELB_4XX, this.httpCode_ELB_5XX, this.httpCode_Backend_2XX, this.httpCode_Backend_3XX, this.httpCode_Backend_4XX, this.httpCode_Backend_5XX);
        }
    }
}

