/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.loadbalancing.LoadBalancer;
import com.eucalyptus.loadbalancing.LoadBalancerZone;
import com.eucalyptus.loadbalancing.activities.EucalyptusActivityTasks;
import com.eucalyptus.loadbalancing.backend.InternalFailure400Exception;
import com.eucalyptus.loadbalancing.backend.InvalidEndPointException;
import com.eucalyptus.loadbalancing.backend.LoadBalancingException;
import com.eucalyptus.loadbalancing.common.LoadBalancingBackend;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.NonNullFunction;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_loadbalancing")
@Table(name="metadata_backend_instance")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class LoadBalancerBackendInstance
extends UserMetadata<STATE> {
    private static Logger LOG = Logger.getLogger(LoadBalancerBackendInstance.class);
    @Transient
    private static final long serialVersionUID = 1L;
    @Transient
    private String partition = null;
    @Transient
    private LoadBalancerBackendInstanceRelationView view;
    @ManyToOne
    @JoinColumn(name="metadata_loadbalancer_fk")
    private LoadBalancer loadbalancer = null;
    @ManyToOne
    @JoinColumn(name="metadata_zone_fk")
    private LoadBalancerZone zone = null;
    @Transient
    private RunningInstancesItemType vmInstance = null;
    @Column(name="reason_code", nullable=true)
    private String reasonCode = null;
    @Column(name="description", nullable=true)
    private String description = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="instance_update_timestamp", nullable=true)
    private Date instanceUpdateTimestamp = null;

    @PostLoad
    private void onLoad() {
        if (this.view == null) {
            this.view = new LoadBalancerBackendInstanceRelationView(this);
        }
    }

    private LoadBalancerBackendInstance() {
        super(null, null);
    }

    private LoadBalancerBackendInstance(OwnerFullName userFullName, LoadBalancer lb, String vmId) throws LoadBalancingException {
        super(userFullName, vmId);
        this.loadbalancer = lb;
        this.setState(STATE.OutOfService);
        this.setReasonCode("ELB");
        this.setDescription("Instance registration is still in progress.");
        if (this.getVmInstance() == null) {
            throw new InvalidEndPointException();
        }
        try (TransactionResource db2 = Entities.transactionFor(LoadBalancerZone.class);){
            LoadBalancerZone found = (LoadBalancerZone)((Object)Entities.uniqueResult((Object)((Object)LoadBalancerZone.named(lb, this.vmInstance.getPlacement()))));
            this.setAvailabilityZone(found);
            db2.commit();
        }
        catch (NoSuchElementException db2) {
            if (this.zone == null) {
                throw new InternalFailure400Exception("unable to find the instance's zone");
            }
        }
        catch (Exception ex) {
            throw new InternalFailure400Exception("unable to find the zone");
        }
        finally {
            if (this.zone == null) {
                throw new InternalFailure400Exception("unable to find the instance's zone");
            }
        }
    }

    public static LoadBalancerBackendInstance newInstance(OwnerFullName userFullName, LoadBalancer lb, String vmId) throws LoadBalancingException {
        return new LoadBalancerBackendInstance(userFullName, lb, vmId);
    }

    public static LoadBalancerBackendInstance newInstance(OwnerFullName userFullName, LoadBalancer lb, String vmId, STATE state) throws LoadBalancingException {
        LoadBalancerBackendInstance instance = new LoadBalancerBackendInstance(userFullName, lb, vmId);
        instance.setBackendState(state);
        return instance;
    }

    public static LoadBalancerBackendInstance named(LoadBalancer lb, String vmId) {
        LoadBalancerBackendInstance instance = new LoadBalancerBackendInstance();
        instance.setOwner(null);
        instance.setDisplayName(vmId);
        instance.setLoadBalancer(lb);
        instance.setState(null);
        instance.setStateChangeStack(null);
        instance.getUniqueName();
        return instance;
    }

    private static LoadBalancerBackendInstance named() {
        return new LoadBalancerBackendInstance();
    }

    public String getInstanceId() {
        return this.getDisplayName();
    }

    private void setVmInstance(RunningInstancesItemType vmInstance) {
        this.vmInstance = vmInstance;
    }

    public RunningInstancesItemType getVmInstance() {
        block3: {
            try {
                if (this.vmInstance != null) break block3;
                List<RunningInstancesItemType> instanceIds = EucalyptusActivityTasks.getInstance().describeUserInstances(this.getOwnerUserId(), Lists.newArrayList((Object[])new String[]{this.displayName}));
                for (RunningInstancesItemType instance : instanceIds) {
                    if (!instance.getInstanceId().equals(this.getDisplayName()) || !instance.getStateName().equals("running")) continue;
                    this.vmInstance = instance;
                    this.partition = instance.getPlacement();
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.vmInstance;
    }

    private void setLoadBalancer(LoadBalancer lb) {
        this.loadbalancer = lb;
    }

    public LoadBalancer.LoadBalancerCoreView getLoadBalancer() {
        return this.view.getLoadBalancer();
    }

    public void setBackendState(STATE state) {
        this.setState(state);
    }

    public STATE getBackendState() {
        return (STATE)this.getState();
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reason) {
        this.reasonCode = reason;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAvailabilityZone(LoadBalancerZone zone) {
        this.zone = zone;
    }

    public LoadBalancerZone.LoadBalancerZoneCoreView getAvailabilityZone() {
        return this.view.getZone();
    }

    public void updateInstanceStateTimestamp() {
        long currentTime = System.currentTimeMillis();
        this.instanceUpdateTimestamp = new Date(currentTime);
    }

    public String getPartition() {
        if (this.partition != null) {
            return this.partition;
        }
        RunningInstancesItemType vm = this.getVmInstance();
        return vm != null ? vm.getPlacement() : null;
    }

    public String getIpAddress() {
        RunningInstancesItemType vm = this.getVmInstance();
        return vm != null ? vm.getIpAddress() : null;
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"loadbalancer-backend-instance", this.vmInstance.getInstanceId() != null ? this.vmInstance.getInstanceId() : ""});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != LoadBalancerBackendInstance.class) {
            return false;
        }
        LoadBalancerBackendInstance other = (LoadBalancerBackendInstance)((Object)obj);
        if (this.loadbalancer == null ? other.loadbalancer != null : (this.loadbalancer.getOwnerUserId() == null ? other.loadbalancer.getOwnerUserId() != null : !this.loadbalancer.getOwnerUserId().equals(other.loadbalancer.getOwnerUserId()))) {
            return false;
        }
        if (this.loadbalancer == null ? other.loadbalancer != null : (this.loadbalancer.getDisplayName() == null ? other.loadbalancer.getDisplayName() != null : !this.loadbalancer.getDisplayName().equals(other.loadbalancer.getDisplayName()))) {
            return false;
        }
        return !(this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName));
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.loadbalancer == null || this.loadbalancer.getOwnerUserId() == null ? 0 : this.loadbalancer.getOwnerUserId().hashCode());
        result = 31 * result + (this.loadbalancer == null || this.loadbalancer.getDisplayName() == null ? 0 : this.loadbalancer.getDisplayName().hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        return result;
    }

    public String toString() {
        return String.format("%s backend instance - %s", new Object[]{this.loadbalancer, this.getDisplayName()});
    }

    protected String createUniqueName() {
        return this.loadbalancer != null && this.getDisplayName() != null ? this.loadbalancer.getOwnerAccountNumber() + ":" + this.loadbalancer.getDisplayName() + ":" + this.getDisplayName() : null;
    }

    private static class LoadBalancerBackendInstanceRelationView {
        private LoadBalancerZone.LoadBalancerZoneCoreView zone = null;
        private LoadBalancer loadbalancer = null;

        LoadBalancerBackendInstanceRelationView(LoadBalancerBackendInstance instance) {
            if (instance.zone != null) {
                this.zone = (LoadBalancerZone.LoadBalancerZoneCoreView)TypeMappers.transform((Object)((Object)instance.zone), LoadBalancerZone.LoadBalancerZoneCoreView.class);
            }
            if (instance.loadbalancer != null) {
                Entities.initialize((Object)((Object)instance.loadbalancer));
                this.loadbalancer = instance.loadbalancer;
            }
        }

        public LoadBalancerZone.LoadBalancerZoneCoreView getZone() {
            return this.zone;
        }

        public LoadBalancer.LoadBalancerCoreView getLoadBalancer() {
            return this.loadbalancer.getCoreView();
        }
    }

    public static enum LoadBalancerBackendInstanceEntityTransform implements Function<LoadBalancerBackendInstanceCoreView, LoadBalancerBackendInstance>
    {
        INSTANCE;


        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        public LoadBalancerBackendInstance apply(@Nullable LoadBalancerBackendInstanceCoreView arg0) {
            try (TransactionResource db = Entities.transactionFor(LoadBalancerBackendInstance.class);){
                LoadBalancerBackendInstance loadBalancerBackendInstance = (LoadBalancerBackendInstance)((Object)Entities.uniqueResult((Object)((Object)arg0.instance)));
                return loadBalancerBackendInstance;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    @TypeMapper
    public static enum LoadBalancerBackendInstanceCoreViewTransform implements Function<LoadBalancerBackendInstance, LoadBalancerBackendInstanceCoreView>
    {
        INSTANCE;


        @Nullable
        public LoadBalancerBackendInstanceCoreView apply(@Nullable LoadBalancerBackendInstance arg0) {
            return new LoadBalancerBackendInstanceCoreView(arg0);
        }
    }

    public static class LoadBalancerBackendInstanceCoreView {
        private LoadBalancerBackendInstance instance = null;

        LoadBalancerBackendInstanceCoreView(LoadBalancerBackendInstance instance) {
            this.instance = instance;
        }

        public String getDisplayName() {
            return this.instance.getDisplayName();
        }

        public STATE getState() {
            return (STATE)this.instance.getState();
        }

        public String getInstanceId() {
            return this.instance.getInstanceId();
        }

        public RunningInstancesItemType getVmInstance() {
            return this.instance.getVmInstance();
        }

        public STATE getBackendState() {
            return this.instance.getBackendState();
        }

        public String getReasonCode() {
            return this.instance.getReasonCode();
        }

        public String getDescription() {
            return this.instance.getDescription();
        }

        public String getIpAddress() {
            return this.instance.getIpAddress();
        }

        public Date instanceStateLastUpdated() {
            return this.instance.instanceUpdateTimestamp;
        }

        public static NonNullFunction<LoadBalancerBackendInstanceCoreView, String> instanceId() {
            return StringPropertyFunctions.InstanceId;
        }

        private static enum StringPropertyFunctions implements NonNullFunction<LoadBalancerBackendInstanceCoreView, String>
        {
            InstanceId{

                @Nonnull
                public String apply(LoadBalancerBackendInstanceCoreView loadBalancerBackendInstanceCoreView) {
                    return loadBalancerBackendInstanceCoreView.getInstanceId();
                }
            };

        }
    }

    public static class BackendInstanceChecker
    implements EventListener<ClockTick> {
        private static final int CHECK_EVERY_SECONDS = 5;

        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new BackendInstanceChecker());
        }

        public void fireEvent(ClockTick event) {
            Throwable throwable;
            TransactionResource db4;
            if (!(Bootstrap.isFinished().booleanValue() && Topology.isEnabledLocally(LoadBalancingBackend.class) && Topology.isEnabled(Eucalyptus.class))) {
                return;
            }
            ArrayList allInstances = Lists.newArrayList();
            ArrayList stateOutdated = Lists.newArrayList();
            try (TransactionResource db22 = Entities.transactionFor(LoadBalancerBackendInstance.class);){
                allInstances.addAll(Entities.query((Object)((Object)LoadBalancerBackendInstance.named())));
                db22.commit();
            }
            catch (Exception db22) {
                // empty catch block
            }
            Date current = new Date(System.currentTimeMillis());
            for (Object be : allInstances) {
                Date lastUpdate = be.getLastUpdateTimestamp();
                int elapsedSec = (int)((double)(current.getTime() - lastUpdate.getTime()) / 1000.0);
                if (elapsedSec <= 5) continue;
                stateOutdated.add(be);
            }
            try {
                Object be;
                TransactionResource db3 = Entities.transactionFor(LoadBalancerBackendInstance.class);
                be = null;
                try {
                    for (LoadBalancerBackendInstance be2 : stateOutdated) {
                        LoadBalancerBackendInstance update = (LoadBalancerBackendInstance)((Object)Entities.uniqueResult((Object)((Object)be2)));
                        update.setLastUpdateTimestamp(current);
                    }
                    db3.commit();
                }
                catch (Throwable x2) {
                    be = x2;
                    throw x2;
                }
                finally {
                    if (db3 != null) {
                        if (be != null) {
                            try {
                                db3.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)be).addSuppressed(x2);
                            }
                        } else {
                            db3.close();
                        }
                    }
                }
            }
            catch (Exception db3) {
                // empty catch block
            }
            List instancesToCheck = Lists.transform((List)stateOutdated, (Function)new Function<LoadBalancerBackendInstance, String>(){

                @Nullable
                public String apply(@Nullable LoadBalancerBackendInstance arg0) {
                    return arg0.getInstanceId();
                }
            });
            List<RunningInstancesItemType> result = null;
            try {
                result = EucalyptusActivityTasks.getInstance().describeSystemInstances(instancesToCheck, true);
                if (result == null) {
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"failed to query instances", (Throwable)ex);
                return;
            }
            HashSet instancesToDelete = Sets.newHashSet();
            HashMap<String, STATE> stateMap = new HashMap<String, STATE>();
            HashMap<String, RunningInstancesItemType> instanceMap = new HashMap<String, RunningInstancesItemType>();
            for (RunningInstancesItemType instance : result) {
                String state = instance.getStateName();
                if ("pending".equals(state)) {
                    stateMap.put(instance.getInstanceId(), STATE.OutOfService);
                    continue;
                }
                if ("running".equals(state)) {
                    instanceMap.put(instance.getInstanceId(), instance);
                    continue;
                }
                if ("shutting-down".equals(state)) {
                    stateMap.put(instance.getInstanceId(), STATE.Error);
                    continue;
                }
                if ("terminated".equals(state)) {
                    stateMap.put(instance.getInstanceId(), STATE.Error);
                    instancesToDelete.add(instance.getInstanceId());
                    continue;
                }
                if ("stopping".equals(state)) {
                    stateMap.put(instance.getInstanceId(), STATE.Error);
                    continue;
                }
                if (!"stopped".equals(state)) continue;
                stateMap.put(instance.getInstanceId(), STATE.Error);
            }
            ArrayList beToDelete = Lists.newArrayList();
            try {
                db4 = Entities.transactionFor(LoadBalancerBackendInstance.class);
                throwable = null;
                try {
                    for (LoadBalancerBackendInstance be : stateOutdated) {
                        if (instancesToDelete.contains(be.getInstanceId())) {
                            beToDelete.add(be);
                            continue;
                        }
                        if (stateMap.containsKey(be.getInstanceId())) {
                            STATE trueState = (STATE)((Object)stateMap.get(be.getInstanceId()));
                            LoadBalancerBackendInstance update = (LoadBalancerBackendInstance)((Object)Entities.uniqueResult((Object)((Object)be)));
                            update.setBackendState(trueState);
                            Entities.persist((Object)((Object)update));
                            continue;
                        }
                        if (!instanceMap.containsKey(be.getInstanceId())) continue;
                        LoadBalancerBackendInstance update = (LoadBalancerBackendInstance)((Object)Entities.uniqueResult((Object)((Object)be)));
                        update.setVmInstance((RunningInstancesItemType)instanceMap.get(be.getInstanceId()));
                        Entities.persist((Object)((Object)update));
                    }
                    db4.commit();
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (db4 != null) {
                        if (throwable != null) {
                            try {
                                db4.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            db4.close();
                        }
                    }
                }
            }
            catch (Exception db4) {
                // empty catch block
            }
            try {
                db4 = Entities.transactionFor(LoadBalancerBackendInstance.class);
                throwable = null;
                try {
                    for (LoadBalancerBackendInstance be : beToDelete) {
                        LoadBalancerBackendInstance entity = (LoadBalancerBackendInstance)((Object)Entities.uniqueResult((Object)((Object)be)));
                        Entities.delete((Object)((Object)entity));
                        LOG.info((Object)("Instance " + be.getInstanceId() + " is terminated and removed from ELB"));
                    }
                    db4.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (db4 != null) {
                        if (throwable != null) {
                            try {
                                db4.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            db4.close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum STATE {
        InService,
        OutOfService,
        Error;

    }
}

