/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing;

import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.loadbalancing.LoadBalancerBackendInstance;
import com.eucalyptus.loadbalancing.LoadBalancerDnsRecord;
import com.eucalyptus.loadbalancing.LoadBalancerListener;
import com.eucalyptus.loadbalancing.LoadBalancerPolicyDescription;
import com.eucalyptus.loadbalancing.LoadBalancerSecurityGroup;
import com.eucalyptus.loadbalancing.LoadBalancerSecurityGroupRef;
import com.eucalyptus.loadbalancing.LoadBalancerZone;
import com.eucalyptus.loadbalancing.activities.LoadBalancerAutoScalingGroup;
import com.eucalyptus.loadbalancing.common.LoadBalancingMetadata;
import com.eucalyptus.loadbalancing.common.msgs.AccessLog;
import com.eucalyptus.loadbalancing.common.msgs.ConnectionDraining;
import com.eucalyptus.loadbalancing.common.msgs.ConnectionSettings;
import com.eucalyptus.loadbalancing.common.msgs.CrossZoneLoadBalancing;
import com.eucalyptus.loadbalancing.common.msgs.LoadBalancerAttributes;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.NonNullFunction;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.CaseFormat;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parent;

@Entity
@PersistenceContext(name="eucalyptus_loadbalancing")
@Table(name="metadata_loadbalancer")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class LoadBalancer
extends UserMetadata<STATE>
implements LoadBalancingMetadata.LoadBalancerMetadata {
    @Transient
    private transient LoadBalancerCoreView coreView = null;
    @Transient
    private transient LoadBalancerRelationView relationView = null;
    @Transient
    private static final long serialVersionUID = 1L;
    @Column(name="loadbalancer_vpc_id", nullable=true, updatable=false)
    private String vpcId;
    @Column(name="loadbalancer_scheme", nullable=true)
    @Enumerated(value=EnumType.STRING)
    private Scheme scheme;
    @Column(name="loadbalancer_connection_idle_timeout")
    private Integer connectionIdleTimeout;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="loadbalancer")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Collection<LoadBalancerBackendInstance> backendInstances = null;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="loadbalancer")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Collection<LoadBalancerListener> listeners = null;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="loadbalancer")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Collection<LoadBalancerZone> zones = null;
    @OneToOne(fetch=FetchType.LAZY, orphanRemoval=false, mappedBy="loadbalancer")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private LoadBalancerSecurityGroup group = null;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="loadbalancer")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private LoadBalancerAutoScalingGroup autoscale_group = null;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="loadbalancer")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private LoadBalancerDnsRecord dns = null;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="loadbalancer")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Collection<LoadBalancerPolicyDescription> policies = null;
    @ElementCollection
    @CollectionTable(name="metadata_loadbalancer_security_groups")
    @JoinColumn(name="metadata_loadbalancer_id")
    @OrderColumn(name="metadata_security_group_ordinal")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<LoadBalancerSecurityGroupRef> securityGroupRefs = Lists.newArrayList();
    @ElementCollection
    @CollectionTable(name="metadata_loadbalancer_tag")
    @MapKeyColumn(name="metadata_key")
    @Column(name="metadata_value")
    @JoinColumn(name="metadata_loadbalancer_id")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Map<String, String> tags;
    @Embedded
    private LoadBalancerHealthCheckConfig healthConfig = null;

    @PostLoad
    private void onLoad() {
        if (this.coreView == null) {
            this.coreView = new LoadBalancerCoreView(this);
        }
        if (this.relationView == null) {
            this.relationView = new LoadBalancerRelationView(this);
        }
    }

    private LoadBalancer() {
        super(null, null);
    }

    private LoadBalancer(OwnerFullName userFullName, String lbName) {
        super(userFullName, lbName);
    }

    static LoadBalancer newInstance(OwnerFullName userFullName, String lbName) {
        LoadBalancer instance = new LoadBalancer(userFullName, lbName);
        if (userFullName != null) {
            instance.setOwnerAccountNumber(userFullName.getAccountNumber());
        }
        return instance;
    }

    static LoadBalancer named() {
        return new LoadBalancer();
    }

    public static LoadBalancer named(OwnerFullName userFullName, String lbName) {
        LoadBalancer instance = new LoadBalancer(null, lbName);
        if (userFullName != null) {
            instance.setOwnerAccountNumber(userFullName.getAccountNumber());
        }
        return instance;
    }

    public static LoadBalancer ownedByAccount(String accountNumber) {
        LoadBalancer instance = new LoadBalancer();
        instance.setOwnerAccountNumber(accountNumber);
        return instance;
    }

    public static LoadBalancer namedByAccountId(String accountId, String lbName) {
        LoadBalancer instance = new LoadBalancer(null, lbName);
        instance.setOwnerAccountNumber(accountId);
        return instance;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public void setScheme(Scheme scheme) {
        this.scheme = scheme;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public Integer getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public void setConnectionIdleTimeout(Integer connectionIdleTimeout) {
        this.connectionIdleTimeout = connectionIdleTimeout;
    }

    public List<LoadBalancerSecurityGroupRef> getSecurityGroupRefs() {
        return this.securityGroupRefs;
    }

    public void setSecurityGroupRefs(List<LoadBalancerSecurityGroupRef> securityGroupRefs) {
        this.securityGroupRefs = securityGroupRefs;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView findBackendInstance(String instanceId) {
        return this.relationView.findBackendInstance(instanceId);
    }

    public boolean hasBackendInstance(String instanceId) {
        return this.relationView.hasBackendInstance(instanceId);
    }

    public Collection<LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView> getBackendInstances() {
        return this.relationView.getBackendInstances();
    }

    public LoadBalancerListener.LoadBalancerListenerCoreView findListener(int lbPort) {
        return this.relationView.findListener(lbPort);
    }

    public boolean hasListener(int lbPort) {
        return this.relationView.hasListener(lbPort);
    }

    public void setDns(LoadBalancerDnsRecord dns) {
        this.dns = dns;
    }

    public LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView getDns() {
        return this.relationView.getDns();
    }

    public Collection<LoadBalancerListener.LoadBalancerListenerCoreView> getListeners() {
        return this.relationView.getListeners();
    }

    public Collection<LoadBalancerZone.LoadBalancerZoneCoreView> getZones() {
        return this.relationView.getZones();
    }

    public LoadBalancerSecurityGroup.LoadBalancerSecurityGroupCoreView getGroup() {
        return this.relationView.getGroup();
    }

    public LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupCoreView getAutoScaleGroup() {
        return this.relationView.getAutoScaleGroup();
    }

    public void addPolicyDescription(LoadBalancerPolicyDescription desc) {
        if (this.policies == null) {
            this.policies = Lists.newArrayList();
        }
        this.policies.remove((Object)desc);
        this.policies.add(desc);
    }

    public void removePolicyDescription(LoadBalancerPolicyDescription desc) {
        if (this.policies == null) {
            return;
        }
        this.policies.remove((Object)desc);
    }

    public LoadBalancerCoreView getCoreView() {
        return this.coreView;
    }

    public Collection<LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionCoreView> getPolicies() {
        return this.relationView.getPolicies();
    }

    public void setHealthCheck(int healthyThreshold, int interval, String target, int timeout, int unhealthyThreshold) throws IllegalArgumentException {
        block14: {
            if (healthyThreshold < 0) {
                throw new IllegalArgumentException("healthyThreshold must be > 0");
            }
            if (interval < 0) {
                throw new IllegalArgumentException("interval must be > 0");
            }
            if (timeout < 0) {
                throw new IllegalArgumentException("timeout must be > 0");
            }
            if (unhealthyThreshold < 0) {
                throw new IllegalArgumentException("unhealthyThreshold must be > 0");
            }
            if (!(target.startsWith("HTTP") || target.startsWith("HTTPS") || target.startsWith("TCP") || target.startsWith("SSL"))) {
                throw new IllegalArgumentException("target must starts with one of HTTP, HTTPS, TCP, SSL");
            }
            if (target.startsWith("HTTP") || target.startsWith("HTTPS")) {
                int idxPort = target.indexOf(":");
                int idxPath = target.indexOf("/");
                if (idxPort < 0 || idxPath < 0 || idxPath - idxPort <= 1) {
                    throw new IllegalArgumentException("Port and Path must be specified for HTTP");
                }
                String port = target.substring(idxPort + 1, idxPath);
                try {
                    int portNum = Integer.parseInt(port);
                    if (portNum <= 0 || portNum >= 65536) {
                        throw new Exception("invalid port number");
                    }
                    break block14;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Invalid target specified", ex);
                }
            }
            if (target.startsWith("TCP") || target.startsWith("SSL")) {
                String copy = target;
                copy = copy.replace("TCP:", "").replace("SSL:", "");
                try {
                    int portNum = Integer.parseInt(copy);
                    if (portNum <= 0 || portNum >= 65536) {
                        throw new Exception("invalid port number");
                    }
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Invalid target specified", ex);
                }
            }
        }
        this.healthConfig = new LoadBalancerHealthCheckConfig(healthyThreshold, interval, target, timeout, unhealthyThreshold);
        this.healthConfig.setLoadBalancer(this);
    }

    public boolean isHealthcheckConfigured() {
        return this.healthConfig != null;
    }

    public int getHealthyThreshold() {
        if (this.healthConfig != null) {
            return this.healthConfig.HealthyThreshold;
        }
        throw new IllegalStateException("health check is not configured");
    }

    public int getHealthCheckInterval() {
        if (this.healthConfig != null) {
            return this.healthConfig.Interval;
        }
        throw new IllegalStateException("health check is not configured");
    }

    public String getHealthCheckTarget() {
        if (this.healthConfig != null) {
            return this.healthConfig.Target;
        }
        throw new IllegalStateException("health check is not configured");
    }

    public int getHealthCheckTimeout() {
        if (this.healthConfig != null) {
            return this.healthConfig.Timeout;
        }
        throw new IllegalStateException("health check is not configured");
    }

    public int getHealthCheckUnhealthyThreshold() {
        if (this.healthConfig != null) {
            return this.healthConfig.UnhealthyThreshold;
        }
        throw new IllegalStateException("health check is not configured");
    }

    public String toString() {
        return String.format("loadbalancer %s", this.displayName);
    }

    public String getPartition() {
        return ((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name();
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"loadbalancer", this.getDisplayName()});
    }

    public static enum LoadBalancerEntityTransform implements NonNullFunction<LoadBalancerCoreView, LoadBalancer>
    {
        INSTANCE;


        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nonnull
        public LoadBalancer apply(LoadBalancerCoreView arg0) {
            try (TransactionResource db = Entities.transactionFor(LoadBalancer.class);){
                LoadBalancer loadBalancer = (LoadBalancer)((Object)Entities.uniqueResult((Object)((Object)arg0.loadbalancer)));
                return loadBalancer;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    @TypeMapper
    public static enum LoadBalancerCoreViewToLoadBalancerAttributesTransform implements Function<LoadBalancer, LoadBalancerAttributes>
    {
        INSTANCE;


        @Nullable
        public LoadBalancerAttributes apply(@Nullable LoadBalancer loadBalancer) {
            LoadBalancerAttributes attributes = null;
            if (loadBalancer != null) {
                attributes = new LoadBalancerAttributes();
                AccessLog accessLog = new AccessLog();
                accessLog.setEnabled(Boolean.valueOf(false));
                attributes.setAccessLog(accessLog);
                ConnectionDraining connectionDraining = new ConnectionDraining();
                connectionDraining.setEnabled(Boolean.valueOf(false));
                attributes.setConnectionDraining(connectionDraining);
                ConnectionSettings connectionSettings = new ConnectionSettings();
                connectionSettings.setIdleTimeout((Integer)Objects.firstNonNull((Object)loadBalancer.getConnectionIdleTimeout(), (Object)60));
                attributes.setConnectionSettings(connectionSettings);
                CrossZoneLoadBalancing crossZoneLoadBalancing = new CrossZoneLoadBalancing();
                crossZoneLoadBalancing.setEnabled(Boolean.valueOf(false));
                attributes.setCrossZoneLoadBalancing(crossZoneLoadBalancing);
            }
            return attributes;
        }
    }

    public static class LoadBalancerCoreView {
        private LoadBalancer loadbalancer;
        private ImmutableMap<String, String> securityGroupIdsToNames;

        LoadBalancerCoreView(LoadBalancer lb) {
            this.loadbalancer = lb;
            this.securityGroupIdsToNames = ImmutableMap.copyOf((Map)CollectionUtils.putAll(lb.getSecurityGroupRefs(), (Map)Maps.newLinkedHashMap(), LoadBalancerSecurityGroupRef.groupId(), LoadBalancerSecurityGroupRef.groupName()));
        }

        public String getDisplayName() {
            return this.loadbalancer.getDisplayName();
        }

        public String getOwnerUserId() {
            return this.loadbalancer.getOwnerUserId();
        }

        public String getOwnerUserName() {
            return this.loadbalancer.getOwnerUserName();
        }

        public String getOwnerAccountNumber() {
            return this.loadbalancer.getOwnerAccountNumber();
        }

        public Date getCreationTimestamp() {
            return this.loadbalancer.getCreationTimestamp();
        }

        public String getVpcId() {
            return this.loadbalancer.getVpcId();
        }

        public Scheme getScheme() {
            return this.loadbalancer.getScheme();
        }

        public Integer getConnectionIdleTimeout() {
            return this.loadbalancer.getConnectionIdleTimeout();
        }

        public Map<String, String> getSecurityGroupIdsToNames() {
            return this.securityGroupIdsToNames;
        }

        public boolean isHealthcheckConfigured() {
            return this.loadbalancer.isHealthcheckConfigured();
        }

        public int getHealthyThreshold() {
            return this.loadbalancer.getHealthyThreshold();
        }

        public int getHealthCheckInterval() {
            return this.loadbalancer.getHealthCheckInterval();
        }

        public String getHealthCheckTarget() {
            return this.loadbalancer.getHealthCheckTarget();
        }

        public int getHealthCheckTimeout() {
            return this.loadbalancer.getHealthCheckTimeout();
        }

        public int getHealthCheckUnhealthyThreshold() {
            return this.loadbalancer.getHealthCheckUnhealthyThreshold();
        }
    }

    public static class LoadBalancerRelationView {
        private LoadBalancer loadbalancer = null;
        private LoadBalancerSecurityGroup.LoadBalancerSecurityGroupCoreView group = null;
        private LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupCoreView autoscale_group = null;
        private LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView dns = null;
        private ImmutableList<LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView> backendInstances = null;
        private ImmutableList<LoadBalancerListener.LoadBalancerListenerCoreView> listeners = null;
        private ImmutableList<LoadBalancerZone.LoadBalancerZoneCoreView> zones = null;
        private ImmutableList<LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionCoreView> policies = null;

        LoadBalancerRelationView(LoadBalancer lb) {
            this.loadbalancer = lb;
            if (lb.group != null) {
                this.group = (LoadBalancerSecurityGroup.LoadBalancerSecurityGroupCoreView)TypeMappers.transform((Object)((Object)lb.group), LoadBalancerSecurityGroup.LoadBalancerSecurityGroupCoreView.class);
            }
            if (lb.autoscale_group != null) {
                this.autoscale_group = (LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupCoreView)TypeMappers.transform((Object)((Object)lb.autoscale_group), LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupCoreView.class);
            }
            if (lb.dns != null) {
                this.dns = (LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView)TypeMappers.transform((Object)((Object)lb.dns), LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView.class);
            }
            if (lb.backendInstances != null) {
                this.backendInstances = ImmutableList.copyOf((Collection)Collections2.transform((Collection)lb.backendInstances, (Function)LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreViewTransform.INSTANCE));
            }
            if (lb.listeners != null) {
                this.listeners = ImmutableList.copyOf((Collection)Collections2.transform((Collection)lb.listeners, (Function)LoadBalancerListener.LoadBalancerListenerCoreViewTransform.INSTANCE));
            }
            if (lb.zones != null) {
                this.zones = ImmutableList.copyOf((Collection)Collections2.transform((Collection)lb.zones, (Function)LoadBalancerZone.LoadBalancerZoneCoreViewTransform.INSTANCE));
            }
            if (lb.policies != null) {
                this.policies = ImmutableList.copyOf((Collection)Collections2.transform((Collection)lb.policies, (Function)LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionCoreViewTransform.INSTANCE));
            }
        }

        public LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView findBackendInstance(final String instanceId) {
            if (this.backendInstances != null) {
                try {
                    return (LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView)Iterables.find(this.backendInstances, (Predicate)new Predicate<LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView>(){

                        public boolean apply(LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView input) {
                            return input.getInstanceId().contentEquals(instanceId);
                        }
                    });
                }
                catch (NoSuchElementException ex) {
                    return null;
                }
            }
            return null;
        }

        public boolean hasBackendInstance(String instanceId) {
            return this.findBackendInstance(instanceId) != null;
        }

        public Collection<LoadBalancerBackendInstance.LoadBalancerBackendInstanceCoreView> getBackendInstances() {
            return this.backendInstances;
        }

        public LoadBalancerListener.LoadBalancerListenerCoreView findListener(final int lbPort) {
            if (this.listeners != null) {
                try {
                    return (LoadBalancerListener.LoadBalancerListenerCoreView)Iterables.find(this.listeners, (Predicate)new Predicate<LoadBalancerListener.LoadBalancerListenerCoreView>(){

                        public boolean apply(LoadBalancerListener.LoadBalancerListenerCoreView input) {
                            return input.getLoadbalancerPort() == lbPort;
                        }
                    });
                }
                catch (NoSuchElementException ex) {
                    return null;
                }
            }
            return null;
        }

        public boolean hasListener(int lbPort) {
            return this.findListener(lbPort) != null;
        }

        public LoadBalancerDnsRecord.LoadBalancerDnsRecordCoreView getDns() {
            return this.dns;
        }

        public Collection<LoadBalancerListener.LoadBalancerListenerCoreView> getListeners() {
            return this.listeners;
        }

        public Collection<LoadBalancerZone.LoadBalancerZoneCoreView> getZones() {
            return this.zones;
        }

        public LoadBalancerSecurityGroup.LoadBalancerSecurityGroupCoreView getGroup() {
            return this.group;
        }

        public LoadBalancerAutoScalingGroup.LoadBalancerAutoScalingGroupCoreView getAutoScaleGroup() {
            return this.autoscale_group;
        }

        public Collection<LoadBalancerPolicyDescription.LoadBalancerPolicyDescriptionCoreView> getPolicies() {
            return this.policies;
        }
    }

    @Embeddable
    private static class LoadBalancerHealthCheckConfig {
        @Parent
        private LoadBalancer loadBalancer = null;
        @Column(name="loadbalancer_healthy_threshold", nullable=true)
        private Integer HealthyThreshold = null;
        @Column(name="loadbalancer_healthcheck_interval", nullable=true)
        private Integer Interval = null;
        @Column(name="loadbalancer_healthcheck_target", nullable=true)
        private String Target = null;
        @Column(name="loadbalancer_healthcheck_timeout", nullable=true)
        private Integer Timeout = null;
        @Column(name="loadbalancer_unhealthy_threshold", nullable=true)
        private Integer UnhealthyThreshold = null;

        private LoadBalancerHealthCheckConfig() {
        }

        private LoadBalancerHealthCheckConfig(int healthyThreshold, int interval, String target, int timeout, int unhealthyThreshold) {
            this.HealthyThreshold = new Integer(healthyThreshold);
            this.Interval = new Integer(interval);
            this.Target = target;
            this.Timeout = new Integer(timeout);
            this.UnhealthyThreshold = new Integer(unhealthyThreshold);
        }

        void setLoadBalancer(LoadBalancer balancer) {
            this.loadBalancer = balancer;
        }

        LoadBalancer getLoadBalancer() {
            return this.loadBalancer;
        }
    }

    public static enum STATE {
        pending,
        available,
        failed;

    }

    public static enum Scheme {
        Internal,
        InternetFacing;


        public String toString() {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public static Optional<Scheme> fromString(String scheme) {
            return Enums.getIfPresent(Scheme.class, (String)CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, Strings.nullToEmpty((String)scheme)));
        }
    }
}

