/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.service.ws;

import com.eucalyptus.cloudwatch.common.msgs.CloudWatchErrorResponse;
import com.eucalyptus.cloudwatch.common.msgs.Error;
import com.eucalyptus.cloudwatch.service.ws.CloudWatchQueryBinding;
import com.eucalyptus.ws.Role;
import com.eucalyptus.ws.util.ErrorHandlerSupport;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import org.apache.log4j.Logger;

public class CloudWatchErrorHandler
extends ErrorHandlerSupport {
    private static final Logger LOG = Logger.getLogger(CloudWatchErrorHandler.class);
    private static final String INTERNAL_FAILURE = "InternalFailure";

    public CloudWatchErrorHandler() {
        super(LOG, CloudWatchQueryBinding.CLOUDWATCH_DEFAULT_NAMESPACE, INTERNAL_FAILURE);
    }

    protected BaseMessage buildErrorResponse(String correlationId, Role role, String code, String message) {
        CloudWatchErrorResponse errorResp = new CloudWatchErrorResponse();
        errorResp.setCorrelationId(correlationId);
        errorResp.setRequestId(correlationId);
        Error error = new Error();
        error.setType(role == Role.Receiver ? "Receiver" : "Sender");
        error.setCode(code);
        error.setMessage(message);
        errorResp.getError().add(error);
        return errorResp;
    }
}

