/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.service;

import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.cloudwatch.common.CloudWatchBackend;
import com.eucalyptus.cloudwatch.common.backend.msgs.CloudWatchBackendMessage;
import com.eucalyptus.cloudwatch.common.msgs.CloudWatchMessage;
import com.eucalyptus.cloudwatch.service.CloudWatchAuthorizationException;
import com.eucalyptus.cloudwatch.service.CloudWatchClientException;
import com.eucalyptus.cloudwatch.service.CloudWatchException;
import com.eucalyptus.cloudwatch.service.CloudWatchNotFoundException;
import com.eucalyptus.cloudwatch.service.CloudWatchUnavailableException;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.ServiceDispatchException;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.FailedRequestException;
import com.eucalyptus.ws.EucalyptusRemoteFault;
import com.eucalyptus.ws.EucalyptusWebServiceException;
import com.eucalyptus.ws.Role;
import com.google.common.base.Objects;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.BaseMessages;
import java.util.NoSuchElementException;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.mule.component.ComponentException;

public class CloudWatchService {
    public CloudWatchMessage dispatchAction(CloudWatchMessage request) throws EucalyptusCloudException {
        AuthContextSupplier user = Contexts.lookup().getAuthContext();
        if (!Permissions.perhapsAuthorized((String)"cloudwatch", (String)RestrictedTypes.getIamActionByMessageType((BaseMessage)request), (AuthContextSupplier)user)) {
            throw new CloudWatchAuthorizationException("UnauthorizedOperation", "You are not authorized to perform this operation.");
        }
        try {
            CloudWatchBackendMessage backendRequest = (CloudWatchBackendMessage)BaseMessages.deepCopy((BaseMessage)request, (Class)CloudWatchService.getBackendMessageClass((BaseMessage)request));
            BaseMessage backendResponse = CloudWatchService.send((BaseMessage)backendRequest);
            CloudWatchMessage response = (CloudWatchMessage)BaseMessages.deepCopy((BaseMessage)backendResponse, request.getReply().getClass());
            response.setCorrelationId(request.getCorrelationId());
            return response;
        }
        catch (Exception e) {
            this.handleRemoteException(e);
            Exceptions.findAndRethrow((Throwable)e, EucalyptusWebServiceException.class, EucalyptusCloudException.class);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    private static Class getBackendMessageClass(BaseMessage request) throws ClassNotFoundException {
        return Class.forName(request.getClass().getName().replace(".common.msgs.", ".common.backend.msgs."));
    }

    private static BaseMessage send(BaseMessage request) throws Exception {
        try {
            return AsyncRequests.sendSyncWithCurrentIdentity((ServiceConfiguration)Topology.lookup(CloudWatchBackend.class, (Partition[])new Partition[0]), (BaseMessage)request);
        }
        catch (NoSuchElementException e) {
            throw new CloudWatchUnavailableException("Service Unavailable");
        }
        catch (ServiceDispatchException e) {
            ComponentException componentException = (ComponentException)Exceptions.findCause((Throwable)e, ComponentException.class);
            if (componentException != null && componentException.getCause() instanceof Exception) {
                throw (Exception)componentException.getCause();
            }
            throw e;
        }
        catch (FailedRequestException e) {
            if (request.getReply().getClass().isInstance(e.getRequest())) {
                return e.getRequest();
            }
            throw e.getRequest() == null ? e : new CloudWatchException("InternalError", Role.Receiver, "Internal error " + e.getRequest().getClass().getSimpleName() + ":false");
        }
    }

    private void handleRemoteException(Exception e) throws EucalyptusCloudException {
        EucalyptusRemoteFault remoteFault = (EucalyptusRemoteFault)Exceptions.findCause((Throwable)e, EucalyptusRemoteFault.class);
        if (remoteFault != null) {
            HttpResponseStatus status = (HttpResponseStatus)Objects.firstNonNull((Object)remoteFault.getStatus(), (Object)HttpResponseStatus.INTERNAL_SERVER_ERROR);
            String code = remoteFault.getFaultCode();
            String message = remoteFault.getFaultDetail();
            switch (status.getCode()) {
                case 400: {
                    throw new CloudWatchClientException(code, message);
                }
                case 403: {
                    throw new CloudWatchAuthorizationException(code, message);
                }
                case 404: {
                    throw new CloudWatchNotFoundException(code, message);
                }
                case 503: {
                    throw new CloudWatchUnavailableException(message);
                }
            }
            throw new CloudWatchException(code, Role.Receiver, message);
        }
    }
}

