/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.san.common;

import com.eucalyptus.blockstorage.san.common.AbstractSANTask;
import com.eucalyptus.blockstorage.san.common.SessionManager;
import com.eucalyptus.blockstorage.san.common.entities.SANInfo;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class ShellSessionManager
implements SessionManager,
SessionManager.TaskRunner {
    private BufferedWriter writer;
    private BufferedReader reader;
    private Channel channel;
    private static Logger LOG = Logger.getLogger(ShellSessionManager.class);
    private static long promptTimeout = Long.parseLong(System.getProperty("com.eucalyptus.blockstorage.shell.promptTimeout", "15000"));
    private static boolean logTiming = Boolean.valueOf(System.getProperty("com.eucalyptus.blockstorage.shell.logTiming"));

    private void readToPrompt(long timeout) throws IOException, InterruptedException {
        String text = "";
        char[] buffer = new char[512];
        long until = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < until) {
            while (this.reader.ready()) {
                int read = this.reader.read(buffer);
                text = text + new String(buffer, 0, read);
            }
            if (!(text.isEmpty() || text.endsWith("\r") || text.endsWith("\n"))) {
                return;
            }
            Thread.sleep(50L);
        }
        LOG.warn((Object)"Timed out reading prompt");
    }

    @Override
    public synchronized void connect() throws EucalyptusCloudException {
        try {
            JSch jsch = new JSch();
            SANInfo sanInfo = SANInfo.getStorageInfo();
            Session session = jsch.getSession(sanInfo.getSanUser(), sanInfo.getSanHost());
            session.setConfig("StrictHostKeyChecking", "no");
            session.setPassword(sanInfo.getSanPassword());
            session.connect();
            this.channel = session.openChannel("shell");
            PipedOutputStream outStream = new PipedOutputStream();
            this.channel.setInputStream((InputStream)new PipedInputStream(outStream));
            PipedInputStream inStream = new PipedInputStream();
            this.channel.setOutputStream((OutputStream)new PipedOutputStream(inStream));
            this.channel.connect();
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outStream, "utf-8"));
            this.reader = new BufferedReader(new InputStreamReader((InputStream)inStream, "utf-8"));
            this.readToPrompt(promptTimeout);
        }
        catch (JSchException | IOException | InterruptedException e) {
            throw new EucalyptusCloudException(e);
        }
    }

    public SessionManager.TaskRunner getTaskRunner(String description) {
        return this.getTaskRunner(description, null);
    }

    private SessionManager.TaskRunner getTaskRunner(final String description, final @Nullable Map<String, Long> timings) {
        return new SessionManager.TaskRunner(){
            private boolean connected = false;
            private int taskNumber = 1;
            private Map<String, Long> timingMap = timings == null ? Maps.newLinkedHashMap() : timings;

            private void init() {
                try {
                    ShellSessionManager.this.connect();
                    this.connected = true;
                }
                catch (EucalyptusCloudException e) {
                    LOG.error((Object)e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String runTask(AbstractSANTask task) throws InterruptedException {
                String returnValue = "";
                if (!this.connected) {
                    this.timingMap.put("begin", System.currentTimeMillis());
                    this.init();
                    this.timingMap.put("connect", System.currentTimeMillis());
                }
                if (!this.connected) {
                    return returnValue;
                }
                this.timingMap.put("pre-task-" + this.taskNumber, System.currentTimeMillis());
                try {
                    ShellSessionManager.this.writer.write("" + task.getCommand() + task.getEOFCommand());
                    ShellSessionManager.this.writer.flush();
                    String line = null;
                    while ((line = ShellSessionManager.this.reader.readLine()) != null) {
                        if ((line = line + "\r").contains("" + task.getEOFCommand())) {
                            break;
                        }
                        returnValue = returnValue + line;
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)e, (Throwable)e);
                }
                finally {
                    this.timingMap.put("task-" + this.taskNumber, System.currentTimeMillis());
                    ++this.taskNumber;
                }
                return returnValue;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                this.timingMap.put("pre-close", System.currentTimeMillis());
                try {
                    if (ShellSessionManager.this.writer != null) {
                        try {
                            ShellSessionManager.this.writer.write("logout\r");
                            ShellSessionManager.this.writer.flush();
                        }
                        catch (Exception e) {
                            LOG.warn((Object)"Error logging out of session", (Throwable)e);
                        }
                    }
                    if (ShellSessionManager.this.reader != null) {
                        Closeables.close((Closeable)ShellSessionManager.this.reader, (boolean)true);
                        ShellSessionManager.this.reader = null;
                    }
                    if (ShellSessionManager.this.writer != null) {
                        Closeables.close((Closeable)ShellSessionManager.this.writer, (boolean)true);
                        ShellSessionManager.this.writer = null;
                    }
                    if (ShellSessionManager.this.channel != null) {
                        ShellSessionManager.this.channel.getSession().disconnect();
                        ShellSessionManager.this.channel.disconnect();
                        ShellSessionManager.this.channel = null;
                    }
                }
                catch (JSchException | IOException e) {
                    LOG.error((Object)e, e);
                }
                finally {
                    this.timingMap.put("close", System.currentTimeMillis());
                    if (logTiming) {
                        ShellSessionManager.this.dumpTiming(this.timingMap, description);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String runTask(AbstractSANTask task) throws InterruptedException {
        String returnValue = "";
        LinkedHashMap timingMap = Maps.newLinkedHashMap();
        timingMap.put("start", System.currentTimeMillis());
        ShellSessionManager shellSessionManager = this;
        synchronized (shellSessionManager) {
            try (SessionManager.TaskRunner runner = this.getTaskRunner(String.valueOf(task.getCommand()));){
                returnValue = runner.runTask(task);
            }
        }
        return returnValue;
    }

    private void dumpTiming(Map<String, Long> timings, String command) {
        ArrayList timingInfo = Lists.newArrayList();
        Long firstTime = 0L;
        Long lastTime = 0L;
        for (Map.Entry<String, Long> timingEntry : timings.entrySet()) {
            if (lastTime != 0L) {
                timingInfo.add(timingEntry.getKey() + ": " + (timingEntry.getValue() - lastTime) + "ms");
            } else {
                firstTime = timingEntry.getValue();
            }
            lastTime = timingEntry.getValue();
        }
        LOG.debug((Object)("Command '" + command.replace('\r', ';') + "', took " + (lastTime - firstTime) + "ms " + timingInfo));
    }

    public void stop() throws EucalyptusCloudException {
    }

    @Override
    public void close() {
    }
}

