/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.san.common;

import com.eucalyptus.blockstorage.LogicalStorageManager;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.StorageManagers;
import com.eucalyptus.blockstorage.StorageResource;
import com.eucalyptus.blockstorage.config.StorageControllerConfiguration;
import com.eucalyptus.blockstorage.entities.StorageInfo;
import com.eucalyptus.blockstorage.san.common.SANProvider;
import com.eucalyptus.blockstorage.san.common.entities.SANInfo;
import com.eucalyptus.blockstorage.san.common.entities.SANVolumeInfo;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyDirectory;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.storage.common.CheckerTask;
import com.eucalyptus.system.BaseDirectory;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Strings;
import edu.ucsb.eucalyptus.cloud.VolumeAlreadyExistsException;
import edu.ucsb.eucalyptus.msgs.ComponentProperty;
import edu.ucsb.eucalyptus.util.SystemUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.persistence.EntityTransaction;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SANManager
implements LogicalStorageManager {
    private SANProvider connectionManager;
    private static SANManager singleton;
    private static Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogicalStorageManager getInstance() {
        Class<SANManager> clazz = SANManager.class;
        synchronized (SANManager.class) {
            if (singleton == null) {
                singleton = new SANManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public SANManager() {
        Component sc = Components.lookup(Storage.class);
        if (sc == null) {
            throw Exceptions.toUndeclared((String)"Cannot instantiate SANManager, no SC component found", (Throwable[])new Throwable[0]);
        }
        ServiceConfiguration scConfig = sc.getLocalServiceConfiguration();
        if (scConfig == null) {
            throw Exceptions.toUndeclared((String)"Cannot instantiate SANManager without SC service configuration", (Throwable[])new Throwable[0]);
        }
        String sanProvider = null;
        EntityTransaction trans = Entities.get(StorageControllerConfiguration.class);
        try {
            StorageControllerConfiguration config = (StorageControllerConfiguration)Entities.uniqueResult((Object)((StorageControllerConfiguration)scConfig));
            sanProvider = config.getBlockStorageManager();
            trans.commit();
        }
        catch (Exception e) {
            throw Exceptions.toUndeclared((String)"Cannot get backend configuration for SC.", (Throwable[])new Throwable[0]);
        }
        finally {
            trans.rollback();
        }
        if (sanProvider == null) {
            throw Exceptions.toUndeclared((String)"Cannot instantiate SAN Provider, none specified", (Throwable[])new Throwable[0]);
        }
        Class providerClass = StorageManagers.lookupProvider(sanProvider);
        if (providerClass != null && SANProvider.class.isAssignableFrom(providerClass)) {
            try {
                this.connectionManager = (SANProvider)providerClass.newInstance();
            }
            catch (IllegalAccessException e) {
                throw Exceptions.toUndeclared((String)"Cannot create SANManager.", (Throwable[])new IllegalAccessException[]{e});
            }
            catch (InstantiationException e) {
                throw Exceptions.toUndeclared((String)"Cannot create SANManager. Cannot instantiate the SAN Provider", (Throwable[])new InstantiationException[]{e});
            }
        } else {
            throw Exceptions.toUndeclared((String)"Provider not of correct type or not found.", (Throwable[])new Throwable[0]);
        }
    }

    SANManager(SANProvider connectionManager) {
        this.connectionManager = connectionManager;
    }

    private boolean checkSANCredentialsExist() {
        SANInfo info = SANInfo.getStorageInfo();
        return info != null && !"sanHost".equals(info.getSanHost()) && !"sanPassword".equals(info.getSanPassword()) && !"sanUser".equals(info.getSanUser());
    }

    @Override
    public void addSnapshot(String snapshotId) throws EucalyptusCloudException {
        this.finishVolume(snapshotId);
    }

    @Override
    public void checkPreconditions() throws EucalyptusCloudException {
        if (!new File(BaseDirectory.LIB.toString() + File.separator + "connect_iscsitarget_sc.pl").exists()) {
            throw new EucalyptusCloudException("connect_iscitarget_sc.pl not found");
        }
        if (!new File(BaseDirectory.LIB.toString() + File.separator + "disconnect_iscsitarget_sc.pl").exists()) {
            throw new EucalyptusCloudException("disconnect_iscitarget_sc.pl not found");
        }
        if (this.connectionManager == null) {
            LOG.warn((Object)"Cannot configure SANManager because the connectionManager is null. Please configure the sanprovider, sanuser, sanhost, and sanpassword.");
            throw new EucalyptusCloudException("SAN Provider not fully configured.");
        }
        this.connectionManager.checkPreconditions();
    }

    @Override
    public void cleanSnapshot(String snapshotId) {
        Throwable throwable;
        TransactionResource tran;
        String sanSnapshotId = null;
        try {
            tran = Entities.transactionFor(SANVolumeInfo.class);
            throwable = null;
            try {
                SANVolumeInfo volumeInfo = (SANVolumeInfo)Entities.uniqueResult((Object)new SANVolumeInfo(snapshotId));
                if (volumeInfo == null || StringUtils.isBlank((String)volumeInfo.getSanVolumeId())) {
                    throw new EucalyptusCloudException(snapshotId + ": Backend ID not found");
                }
                sanSnapshotId = volumeInfo.getSanVolumeId();
                tran.commit();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (tran != null) {
                    if (throwable != null) {
                        try {
                            tran.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        tran.close();
                    }
                }
            }
        }
        catch (TransactionException | EucalyptusCloudException | NoSuchElementException ex) {
            LOG.debug((Object)(snapshotId + ": Snapshot not found"), ex);
            return;
        }
        LOG.info((Object)("Deleting backend snapshot " + sanSnapshotId + " mapping to " + snapshotId));
        if (this.connectionManager.deleteVolume(sanSnapshotId)) {
            try {
                tran = Entities.transactionFor(SANVolumeInfo.class);
                throwable = null;
                try {
                    SANVolumeInfo snapInfo = (SANVolumeInfo)Entities.uniqueResult((Object)new SANVolumeInfo(snapshotId).withSanVolumeId(sanSnapshotId));
                    Entities.delete((Object)snapInfo);
                    tran.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tran != null) {
                        if (throwable != null) {
                            try {
                                tran.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            tran.close();
                        }
                    }
                }
            }
            catch (TransactionException | NoSuchElementException ex) {
                LOG.error((Object)(snapshotId + ": Unable to clean failed snapshot"), ex);
                return;
            }
        }
    }

    @Override
    public void cleanVolume(String volumeId) {
        SANVolumeInfo volumeInfo;
        Throwable throwable;
        TransactionResource tran;
        String sanVolumeId = null;
        try {
            tran = Entities.transactionFor(SANVolumeInfo.class);
            throwable = null;
            try {
                volumeInfo = (SANVolumeInfo)Entities.uniqueResult((Object)new SANVolumeInfo(volumeId));
                if (volumeInfo == null || StringUtils.isBlank((String)volumeInfo.getSanVolumeId())) {
                    throw new EucalyptusCloudException(volumeId + ": Backend ID not found");
                }
                sanVolumeId = volumeInfo.getSanVolumeId();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (tran != null) {
                    if (throwable != null) {
                        try {
                            tran.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        tran.close();
                    }
                }
            }
        }
        catch (TransactionException | EucalyptusCloudException | NoSuchElementException ex) {
            LOG.debug((Object)(volumeId + ": Volume not found"), ex);
            return;
        }
        LOG.info((Object)("Deleting backend volume " + sanVolumeId + " mapping to " + volumeId));
        if (this.connectionManager.deleteVolume(sanVolumeId)) {
            try {
                tran = Entities.transactionFor(SANVolumeInfo.class);
                throwable = null;
                try {
                    volumeInfo = (SANVolumeInfo)Entities.uniqueResult((Object)new SANVolumeInfo(volumeId).withSanVolumeId(sanVolumeId));
                    Entities.delete((Object)volumeInfo);
                    tran.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tran != null) {
                        if (throwable != null) {
                            try {
                                tran.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            tran.close();
                        }
                    }
                }
            }
            catch (TransactionException | NoSuchElementException ex) {
                LOG.error((Object)("Unable to clean failed volume: " + volumeId));
                return;
            }
        }
    }

    @Override
    public void configure() throws EucalyptusCloudException {
        LOG.info((Object)("Configuring block storage backend for partition: " + StorageInfo.getStorageInfo().getName()));
        if (this.connectionManager == null || !this.connectionManager.checkSANCredentialsExist()) {
            LOG.warn((Object)"Cannot configure blockstorage backend because of missing properties");
            throw new EucalyptusCloudException("Blockstorage backend not configured.");
        }
        this.connectionManager.configure();
    }

    @Override
    public StorageResource createSnapshot(String volumeId, String snapshotId, String snapshotPointId, Boolean shouldTransferSnapshots) throws EucalyptusCloudException {
        String sanSnapshotId = this.resourceIdOnSan(snapshotId);
        String sanVolumeId = null;
        SANVolumeInfo snapInfo = new SANVolumeInfo(snapshotId);
        int size = -1;
        StorageResource storageResource = null;
        try (TransactionResource tran = Entities.transactionFor(SANVolumeInfo.class);){
            try {
                SANVolumeInfo volumeInfo = (SANVolumeInfo)Entities.uniqueResult((Object)new SANVolumeInfo(volumeId));
                if (volumeInfo == null || StringUtils.isBlank((String)volumeInfo.getSanVolumeId())) {
                    throw new EucalyptusCloudException("Backend ID not found for " + volumeId);
                }
                sanVolumeId = volumeInfo.getSanVolumeId();
                size = volumeInfo.getSize();
            }
            catch (TransactionException | NoSuchElementException ex) {
                LOG.error((Object)(volumeId + ": Failed to lookup source volume entity"), ex);
                throw new EucalyptusCloudException("Failed to lookup source volume entity for " + volumeId, ex);
            }
            try {
                SANVolumeInfo existingSnap = (SANVolumeInfo)Entities.uniqueResult((Object)snapInfo);
                if (this.connectionManager.snapshotExists(existingSnap.getSanVolumeId())) {
                    throw new VolumeAlreadyExistsException("Snapshot already exists on storage backend for " + snapshotId);
                }
                LOG.debug((Object)(snapshotId + ": Found the database entity but the snapshot does not exist on SAN. Deleting the database entity"));
                Entities.delete((Object)existingSnap);
                tran.commit();
            }
            catch (TransactionException | VolumeAlreadyExistsException ex) {
                throw new EucalyptusCloudException(ex);
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
        }
        try {
            Transactions.save((Object)snapInfo.withSanVolumeId(sanSnapshotId).withSize(Integer.valueOf(size)).withSnapshotOf(volumeId));
        }
        catch (Exception ex) {
            LOG.error((Object)(snapshotId + ": Failed to add database entity" + snapshotId), (Throwable)ex);
            throw new EucalyptusCloudException("Failed to add database entity for " + snapshotId, (Throwable)ex);
        }
        LOG.info((Object)("Creating backend snapshot " + sanSnapshotId + " mapping to " + snapshotId + " from backend volume " + sanVolumeId + " mapping to " + volumeId + " using snapshot point " + snapshotPointId));
        String iqn = this.connectionManager.createSnapshot(sanVolumeId, sanSnapshotId, snapshotPointId);
        if (iqn != null) {
            try (TransactionResource tran = Entities.transactionFor(SANVolumeInfo.class);){
                SANVolumeInfo existingSnap = (SANVolumeInfo)Entities.uniqueResult((Object)snapInfo);
                existingSnap.setIqn(iqn);
                Entities.merge((Object)existingSnap);
                tran.commit();
            }
            catch (Exception ex) {
                LOG.error((Object)(snapshotId + ": Failed to update database entity with IQN post snapshot creation"));
                throw new EucalyptusCloudException("Failed to update database entity with IQN post snapshot creation for " + snapshotId, (Throwable)ex);
            }
            if (shouldTransferSnapshots.booleanValue()) {
                storageResource = this.connectionManager.connectTarget(iqn);
                storageResource.setId(snapshotId);
            } else {
                this.connectionManager.removeAllInitiatorRules(sanSnapshotId);
            }
        } else {
            throw new EucalyptusCloudException("Unable to create snapshot: " + snapshotId + " from volume: " + volumeId);
        }
        return storageResource;
    }

    @Override
    public void createVolume(String volumeId, int size) throws EucalyptusCloudException {
        block47: {
            Throwable throwable;
            TransactionResource tran;
            String sanVolumeId = this.resourceIdOnSan(volumeId);
            SANVolumeInfo volumeInfo = new SANVolumeInfo(volumeId);
            try {
                tran = Entities.transactionFor(SANVolumeInfo.class);
                throwable = null;
                try {
                    SANVolumeInfo existingVol = (SANVolumeInfo)Entities.uniqueResult((Object)volumeInfo);
                    if (this.connectionManager.volumeExists(existingVol.getSanVolumeId())) {
                        throw new VolumeAlreadyExistsException("Volume already exists on storage backend for " + volumeId);
                    }
                    LOG.debug((Object)(volumeId + ": Found the database entity but the volume does not exist on SAN. Deleting the database entity"));
                    Entities.delete((Object)existingVol);
                    tran.commit();
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (tran != null) {
                        if (throwable != null) {
                            try {
                                tran.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            tran.close();
                        }
                    }
                }
            }
            catch (VolumeAlreadyExistsException ex) {
                throw ex;
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                tran = Entities.transactionFor(SANVolumeInfo.class);
                throwable = null;
                try {
                    Entities.persist((Object)volumeInfo.withSanVolumeId(sanVolumeId).withSize(Integer.valueOf(size)));
                    tran.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tran != null) {
                        if (throwable != null) {
                            try {
                                tran.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            tran.close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOG.error((Object)(volumeId + ": Failed to add database entity"), (Throwable)ex);
                throw new EucalyptusCloudException("Failed to add database entity for " + volumeId, (Throwable)ex);
            }
            LOG.info((Object)("Creating backend volume " + sanVolumeId + " mapping to " + volumeId));
            String iqn = this.connectionManager.createVolume(sanVolumeId, size);
            if (iqn != null) {
                try (TransactionResource tran2 = Entities.transactionFor(SANVolumeInfo.class);){
                    SANVolumeInfo existingVol = (SANVolumeInfo)Entities.uniqueResult((Object)volumeInfo);
                    existingVol.setIqn(iqn);
                    tran2.commit();
                    break block47;
                }
                catch (Exception ex) {
                    LOG.error((Object)(volumeId + ": Failed to update database entity with IQN post volume creation"));
                    throw new EucalyptusCloudException("Failed to update database entity with IQN post volume creation for " + volumeId, (Throwable)ex);
                }
            }
            throw new EucalyptusCloudException("Unable to create volume: " + volumeId);
        }
    }

    private String resourceIdOnSan(String resourceId) {
        try {
            SANInfo sanInfo = (SANInfo)Transactions.one((Object)new SANInfo(), (Function)Functions.identity());
            return StringUtils.trimToEmpty((String)sanInfo.getResourcePrefix()) + resourceId + StringUtils.trimToEmpty((String)sanInfo.getResourceSuffix());
        }
        catch (TransactionException ex) {
            LOG.error((Object)"Unable to retrieve resource prefix/suffix from databse", (Throwable)ex);
            return resourceId;
        }
    }

    @Override
    public int createVolume(String volumeId, String snapshotId, int size) throws EucalyptusCloudException {
        block39: {
            String sanSnapshotId = null;
            String sanVolumeId = this.resourceIdOnSan(volumeId);
            SANVolumeInfo volumeInfo = new SANVolumeInfo(volumeId);
            int snapSize = -1;
            try (TransactionResource tran = Entities.transactionFor(SANVolumeInfo.class);){
                try {
                    SANVolumeInfo snapInfo = (SANVolumeInfo)Entities.uniqueResult((Object)new SANVolumeInfo(snapshotId));
                    if (snapInfo == null || StringUtils.isBlank((String)snapInfo.getSanVolumeId())) {
                        throw new EucalyptusCloudException("Backend ID not found for " + snapshotId);
                    }
                    sanSnapshotId = snapInfo.getSanVolumeId();
                    snapSize = snapInfo.getSize();
                    if (size <= 0) {
                        size = snapSize;
                    }
                }
                catch (TransactionException | NoSuchElementException ex) {
                    LOG.error((Object)(snapshotId + ": Failed to lookup source snapshot entity"), ex);
                    throw new EucalyptusCloudException("Failed to lookup source snapshot entity for " + snapshotId, ex);
                }
                try {
                    SANVolumeInfo existingVol = (SANVolumeInfo)Entities.uniqueResult((Object)volumeInfo);
                    if (this.connectionManager.volumeExists(existingVol.getSanVolumeId())) {
                        throw new VolumeAlreadyExistsException("Volume already exists on storage backend for " + volumeId);
                    }
                    LOG.debug((Object)(volumeId + ": Found the database entity but the volume does not exist on SAN. Deleting the database entity"));
                    Entities.delete((Object)existingVol);
                    tran.commit();
                }
                catch (VolumeAlreadyExistsException ex) {
                    throw ex;
                }
                catch (NoSuchElementException ex) {
                }
                catch (Exception ex) {
                    throw new EucalyptusCloudException((Throwable)ex);
                }
            }
            try {
                Transactions.save((Object)volumeInfo.withSanVolumeId(sanVolumeId).withSize(Integer.valueOf(size)));
            }
            catch (Exception ex) {
                LOG.error((Object)(volumeId + ": Failed to add database entity"), (Throwable)ex);
                throw new EucalyptusCloudException("Failed to add database entity for " + volumeId, (Throwable)ex);
            }
            LOG.info((Object)("Creating backend volume " + sanVolumeId + " mapping to " + volumeId + " from backend snapshot " + sanSnapshotId + " mapping to " + snapshotId));
            String iqn = this.connectionManager.createVolume(sanVolumeId, sanSnapshotId, snapSize, size);
            if (iqn != null) {
                try (TransactionResource tran = Entities.transactionFor(SANVolumeInfo.class);){
                    SANVolumeInfo existingVol = (SANVolumeInfo)Entities.uniqueResult((Object)volumeInfo);
                    existingVol.setIqn(iqn);
                    Entities.merge((Object)existingVol);
                    tran.commit();
                    break block39;
                }
                catch (Exception ex) {
                    LOG.error((Object)(volumeId + ": Failed to update database entity with IQN post volume creation"));
                    throw new EucalyptusCloudException("Failed to update database entity with IQN post volume creation for " + volumeId, (Throwable)ex);
                }
            }
            throw new EucalyptusCloudException("Unable to create volume: " + volumeId + " from snapshot: " + snapshotId);
        }
        return size;
    }

    @Override
    public void cloneVolume(String volumeId, String parentVolumeId) throws EucalyptusCloudException {
        block37: {
            String sanVolumeId = this.resourceIdOnSan(volumeId);
            String sanParentVolumeId = null;
            SANVolumeInfo volInfo = new SANVolumeInfo(volumeId);
            int size = -1;
            try {
                SANVolumeInfo parentVolumeInfo = (SANVolumeInfo)Transactions.find((Object)new SANVolumeInfo(parentVolumeId));
                if (parentVolumeInfo == null || StringUtils.isBlank((String)parentVolumeInfo.getSanVolumeId())) {
                    throw new EucalyptusCloudException("Backend ID not found for " + parentVolumeId);
                }
                sanParentVolumeId = parentVolumeInfo.getSanVolumeId();
                size = parentVolumeInfo.getSize();
            }
            catch (TransactionException | NoSuchElementException ex) {
                LOG.error((Object)(volumeId + ": Failed to lookup source volume entity"), ex);
                throw new EucalyptusCloudException("Failed to lookup source volume entity for " + parentVolumeId, ex);
            }
            try (TransactionResource tran = Entities.transactionFor(SANVolumeInfo.class);){
                SANVolumeInfo existingVol = (SANVolumeInfo)Entities.uniqueResult((Object)volInfo);
                if (this.connectionManager.snapshotExists(existingVol.getSanVolumeId())) {
                    throw new VolumeAlreadyExistsException("Volume already exists on storage backend for " + volumeId);
                }
                LOG.debug((Object)(volumeId + ": Found the database entity but the volume does not exist on SAN. Deleting the database entity"));
                Entities.delete((Object)existingVol);
                tran.commit();
            }
            catch (VolumeAlreadyExistsException ex) {
                throw ex;
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                Transactions.save((Object)volInfo.withSanVolumeId(sanVolumeId).withSize(Integer.valueOf(size)));
            }
            catch (Exception ex) {
                LOG.error((Object)(volumeId + ": Failed to add database entity" + volumeId), (Throwable)ex);
                throw new EucalyptusCloudException("Failed to add database entity for " + volumeId, (Throwable)ex);
            }
            LOG.info((Object)("Cloning backend volume " + sanVolumeId + " mapping to " + volumeId + " from backend volume " + sanParentVolumeId + " mapping to " + parentVolumeId));
            String iqn = this.connectionManager.cloneVolume(sanVolumeId, sanParentVolumeId);
            if (iqn != null) {
                try (TransactionResource tran = Entities.transactionFor(SANVolumeInfo.class);){
                    SANVolumeInfo existingVol = (SANVolumeInfo)Entities.uniqueResult((Object)volInfo);
                    existingVol.setIqn(iqn);
                    Entities.merge((Object)existingVol);
                    tran.commit();
                    break block37;
                }
                catch (Exception ex) {
                    LOG.error((Object)(volumeId + ": Failed to update database entity with IQN post volume creation"));
                    throw new EucalyptusCloudException("Failed to update database entity with IQN post volume creation for " + volumeId, (Throwable)ex);
                }
            }
            throw new EucalyptusCloudException("Unable to create volume: " + volumeId);
        }
    }

    @Override
    public void deleteSnapshot(String snapshotId) throws EucalyptusCloudException {
        String sanSnapshotId = null;
        try (TransactionResource tran = Entities.transactionFor(SANVolumeInfo.class);){
            SANVolumeInfo volumeInfo = (SANVolumeInfo)Entities.uniqueResult((Object)new SANVolumeInfo(snapshotId));
            if (volumeInfo == null || StringUtils.isBlank((String)volumeInfo.getSanVolumeId())) {
                throw new EucalyptusCloudException(snapshotId + ": Backend ID not found");
            }
            sanSnapshotId = volumeInfo.getSanVolumeId();
        }
        catch (NoSuchElementException ex) {
            throw new EucalyptusCloudException(snapshotId + ": Backend ID not found");
        }
        catch (Exception ex) {
            throw new EucalyptusCloudException("caught exception while querying the database for snapshot " + snapshotId, (Throwable)ex);
        }
        LOG.info((Object)("Deleting backend snapshot " + sanSnapshotId + " mapping to " + snapshotId));
        boolean deleteEntity = false;
        if (this.connectionManager.deleteVolume(sanSnapshotId)) {
            deleteEntity = true;
        } else {
            LOG.debug((Object)("Unable to delete backend snapshot " + sanSnapshotId + ". Checking to see if the snapshot exists"));
            if (!this.connectionManager.snapshotExists(sanSnapshotId)) {
                LOG.debug((Object)("Backend snapshot " + sanSnapshotId + " not found. Safe to delete database entity"));
                deleteEntity = true;
            } else {
                LOG.warn((Object)("Failed to delete backend snapshot " + sanSnapshotId + " mapping to " + snapshotId));
                throw new EucalyptusCloudException("Failed to delete " + snapshotId + " on storage backend");
            }
        }
        if (deleteEntity) {
            try (TransactionResource tran = Entities.transactionFor(SANVolumeInfo.class);){
                SANVolumeInfo snapInfo = (SANVolumeInfo)Entities.uniqueResult((Object)new SANVolumeInfo(snapshotId).withSanVolumeId(sanSnapshotId));
                Entities.delete((Object)snapInfo);
                tran.commit();
            }
            catch (TransactionException | NoSuchElementException ex) {
                LOG.error((Object)("Failed to delete database entity post deletion for " + snapshotId), ex);
                throw new EucalyptusCloudException("Failed to delete database entity post deletion for " + snapshotId, ex);
            }
        }
    }

    @Override
    public void deleteVolume(String volumeId) throws EucalyptusCloudException {
        block31: {
            Throwable throwable;
            TransactionResource tran;
            String sanVolumeId = null;
            try {
                tran = Entities.transactionFor(SANVolumeInfo.class);
                throwable = null;
                try {
                    SANVolumeInfo volumeInfo = (SANVolumeInfo)Entities.uniqueResult((Object)new SANVolumeInfo(volumeId));
                    if (volumeInfo == null || StringUtils.isBlank((String)volumeInfo.getSanVolumeId())) {
                        throw new EucalyptusCloudException(volumeId + ": Backend ID not found");
                    }
                    sanVolumeId = volumeInfo.getSanVolumeId();
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (tran != null) {
                        if (throwable != null) {
                            try {
                                tran.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            tran.close();
                        }
                    }
                }
            }
            catch (TransactionException | NoSuchElementException ex) {
                throw new EucalyptusCloudException(ex);
            }
            LOG.info((Object)("Deleting backend volume " + sanVolumeId + " mapping to " + volumeId));
            if (this.connectionManager.deleteVolume(sanVolumeId)) {
                try {
                    tran = Entities.transactionFor(SANVolumeInfo.class);
                    throwable = null;
                    try {
                        SANVolumeInfo snapInfo = (SANVolumeInfo)Entities.uniqueResult((Object)new SANVolumeInfo(volumeId).withSanVolumeId(sanVolumeId));
                        Entities.delete((Object)snapInfo);
                        tran.commit();
                        break block31;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tran != null) {
                            if (throwable != null) {
                                try {
                                    tran.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                tran.close();
                            }
                        }
                    }
                }
                catch (TransactionException | NoSuchElementException ex) {
                    LOG.error((Object)("Failed to delete database entity post deletion for " + volumeId), ex);
                    throw new EucalyptusCloudException("Failed to delete database entity post deletion for " + volumeId, ex);
                }
            }
            throw new EucalyptusCloudException("Failed to delete " + volumeId + " on storage backend");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getSnapshotSize(String snapshotId) throws EucalyptusCloudException {
        try (TransactionResource tran = Entities.transactionFor(SANVolumeInfo.class);){
            SANVolumeInfo snapInfo = (SANVolumeInfo)Entities.uniqueResult((Object)new SANVolumeInfo(snapshotId));
            int n = snapInfo.getSize();
            return n;
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            throw new EucalyptusCloudException((Throwable)ex);
        }
    }

    @Override
    public String getVolumeConnectionString(String volumeId) throws EucalyptusCloudException {
        return this.connectionManager.getVolumeConnectionString(volumeId);
    }

    @Override
    public void initialize() {
        LOG.info((Object)"Initializing SANInfo entity");
        SANInfo.getStorageInfo();
        this.connectionManager.initialize();
    }

    @Override
    public void loadSnapshots(List<String> snapshotSet, List<String> snapshotFileNames) throws EucalyptusCloudException {
    }

    @Override
    public List<String> prepareForTransfer(String snapshotId) throws EucalyptusCloudException {
        return new ArrayList<String>();
    }

    @Override
    public void reload() {
    }

    @Override
    public void startupChecks() throws EucalyptusCloudException {
        try {
            this.connectionManager.configure();
        }
        catch (EucalyptusCloudException e) {
            LOG.error((Object)e);
            throw e;
        }
        this.connectionManager.checkConnection();
    }

    @Override
    public void finishVolume(String snapshotId) throws EucalyptusCloudException {
        try (TransactionResource tran = Entities.transactionFor(SANVolumeInfo.class);){
            SANVolumeInfo snapInfo = (SANVolumeInfo)Entities.uniqueResult((Object)new SANVolumeInfo(snapshotId));
            String iqn = snapInfo.getIqn();
            String sanVolumeId = snapInfo.getSanVolumeId();
            tran.commit();
            this.connectionManager.disconnectTarget(sanVolumeId, iqn);
        }
        catch (TransactionException | NoSuchElementException ex) {
            LOG.error((Object)ex);
            throw new EucalyptusCloudException("Unable to finalize snapshot: " + snapshotId);
        }
    }

    @Override
    public StorageResource prepareSnapshot(String snapshotId, int sizeExpected, long actualSizeInMB) throws EucalyptusCloudException {
        LOG.info((Object)("Preparing snapshot " + snapshotId + " of size: " + sizeExpected));
        try {
            SANVolumeInfo volInfo = new SANVolumeInfo(snapshotId);
            SANVolumeInfo foundVolInfo = (SANVolumeInfo)Transactions.find((Object)volInfo);
            LOG.debug((Object)("Found an existing snapshot record for " + snapshotId + " and will use that lun and record."));
            return null;
        }
        catch (TransactionException | NoSuchElementException volInfo) {
            LOG.debug((Object)(snapshotId + " not found on this SC's SAN. Now creating a lun on the SAN for the snapshot to be copied from ObjectStorage."));
            String sanSnapshotId = this.resourceIdOnSan(snapshotId);
            String iqn = null;
            try {
                LOG.info((Object)("Creating backend snapshot holder " + sanSnapshotId + " mapping to " + snapshotId));
                iqn = this.connectionManager.createSnapshotHolder(sanSnapshotId, actualSizeInMB);
            }
            catch (EucalyptusCloudException e) {
                LOG.error((Object)("Could not create a volume to hold snapshot " + snapshotId));
                iqn = null;
            }
            if (iqn != null) {
                try {
                    String scIqn = StorageProperties.getStorageIqn();
                    if (scIqn == null) {
                        throw new EucalyptusCloudException("Could not get the SC's initiator IQN, found null.");
                    }
                    String lun = null;
                    try {
                        LOG.info((Object)("Exporting backend snapshot holder " + sanSnapshotId + " mapping to " + snapshotId + " to SC host IQN " + scIqn));
                        lun = this.connectionManager.addInitiatorRule(sanSnapshotId, scIqn);
                    }
                    catch (EucalyptusCloudException attEx) {
                        LOG.debug((Object)("Failed to setup attachment for snapshot " + snapshotId + " to SC"), (Throwable)attEx);
                        throw new EucalyptusCloudException("Could not setup snapshot volume " + snapshotId + " to SC because of error in attach prep", (Throwable)attEx);
                    }
                    if (lun == null) {
                        throw new EucalyptusCloudException("Failed to export backend snapshot holder " + sanSnapshotId + " mapping to " + snapshotId + " to SC host IQN " + scIqn);
                    }
                    iqn = iqn + ',' + lun;
                    StorageResource storageResource = null;
                    try {
                        storageResource = this.connectionManager.connectTarget(iqn);
                        storageResource.setId(snapshotId);
                    }
                    catch (Exception connEx) {
                        LOG.debug((Object)("Failed to connect SC to snapshot volume on SAN for snapshot " + snapshotId + ". Detaching and cleaning up."));
                        try {
                            LOG.info((Object)("Unexporting backend snapshot holder " + sanSnapshotId + " mapping to " + snapshotId + " from SC host IQN " + scIqn));
                            this.connectionManager.removeInitiatorRule(sanSnapshotId, scIqn);
                        }
                        catch (EucalyptusCloudException detEx) {
                            LOG.debug((Object)("Could not detach snapshot volume " + snapshotId + " during cleanup of failed connection"));
                        }
                        throw new EucalyptusCloudException("Could not connect SC to target snapshot volume to prep for snapshot download from ObjectStorage", (Throwable)connEx);
                    }
                    SANVolumeInfo snapInfo = new SANVolumeInfo(snapshotId, iqn, sizeExpected).withSanVolumeId(sanSnapshotId);
                    try {
                        Transactions.save((Object)snapInfo);
                    }
                    catch (TransactionException e) {
                        LOG.error((Object)"Error occured trying to save the snapshot info to the database", (Throwable)e);
                        throw new EucalyptusCloudException((Throwable)e);
                    }
                    return storageResource;
                }
                catch (EucalyptusCloudException e) {
                    LOG.error((Object)"Error occured trying to connect the SC to the snapshot lun on the SAN.", (Throwable)e);
                    if (!this.connectionManager.deleteVolume(snapshotId)) {
                        LOG.error((Object)("Failed to delete the snapshot volume during cleanup of failed snapshot prep for " + snapshotId));
                    }
                    throw new EucalyptusCloudException("Failed to create new LUN for snapshot " + snapshotId, (Throwable)e);
                }
            }
            return null;
        }
    }

    @Override
    public ArrayList<ComponentProperty> getStorageProps() {
        String alias;
        String root;
        ArrayList componentProperties = null;
        ConfigurableClass configurableClass = StorageInfo.class.getAnnotation(ConfigurableClass.class);
        if (configurableClass != null) {
            root = configurableClass.root();
            alias = configurableClass.alias();
            componentProperties = (ArrayList)PropertyDirectory.getComponentPropertySet((String)(StorageProperties.NAME + "." + root), (String)alias);
        }
        if ((configurableClass = SANInfo.class.getAnnotation(ConfigurableClass.class)) != null) {
            root = configurableClass.root();
            alias = configurableClass.alias();
            if (componentProperties == null) {
                componentProperties = (ArrayList)PropertyDirectory.getComponentPropertySet((String)(StorageProperties.NAME + "." + root), (String)alias);
            } else {
                componentProperties.addAll(PropertyDirectory.getComponentPropertySet((String)(StorageProperties.NAME + "." + root), (String)alias));
            }
        }
        this.connectionManager.getStorageProps(componentProperties);
        return componentProperties;
    }

    @Override
    public void setStorageProps(ArrayList<ComponentProperty> storageProps) {
        for (ComponentProperty prop : storageProps) {
            try {
                ConfigurableProperty entry = PropertyDirectory.getPropertyEntry((String)prop.getQualifiedName());
                entry.setValue(prop.getValue());
            }
            catch (ConfigurablePropertyException | IllegalAccessException e) {
                LOG.error((Object)e, e);
            }
        }
        this.connectionManager.setStorageProps(storageProps);
    }

    @Override
    public String getStorageRootDirectory() {
        return StorageProperties.storageRootDirectory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getVolumePath(String volumeId) throws EucalyptusCloudException {
        try (TransactionResource tran = Entities.transactionFor(SANVolumeInfo.class);){
            String deviceName;
            SANVolumeInfo volumeInfo = (SANVolumeInfo)Entities.uniqueResult((Object)new SANVolumeInfo(volumeId));
            String iqn = volumeInfo.getIqn();
            String string = deviceName = this.connectionManager.connectTarget(iqn).getPath();
            return string;
        }
        catch (TransactionException | NoSuchElementException ex) {
            LOG.error((Object)("Unable to find volume: " + volumeId));
            throw new EucalyptusCloudException("Unable to find volume path for volume: " + volumeId, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importVolume(String volumeId, String volumePath, int size) throws EucalyptusCloudException {
        try {
            TransactionResource tran = Entities.transactionFor(SANVolumeInfo.class);
            Throwable throwable = null;
            try {
                try {
                    Entities.uniqueResult((Object)new SANVolumeInfo(volumeId));
                    throw new EucalyptusCloudException("Volume " + volumeId + " already exists. Import failed.");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (tran != null) {
                    if (throwable != null) {
                        try {
                            tran.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        tran.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (NoSuchElementException tran) {
        }
        catch (TransactionException ex) {
            throw new EucalyptusCloudException((Throwable)ex);
        }
        String sanVolumeId = this.resourceIdOnSan(volumeId);
        String iqn = this.connectionManager.createVolume(sanVolumeId, size);
        if (iqn != null) {
            String deviceName = this.connectionManager.connectTarget(iqn).getPath();
            try {
                SystemUtil.run((String[])new String[]{StorageProperties.EUCA_ROOT_WRAPPER, "dd", "if=" + volumePath, "of=" + deviceName, "bs=1M"});
            }
            finally {
                this.connectionManager.disconnectTarget(sanVolumeId, iqn);
            }
            SANVolumeInfo volumeInfo = new SANVolumeInfo(volumeId, iqn, size).withSanVolumeId(sanVolumeId);
            try (TransactionResource tran = Entities.transactionFor(SANVolumeInfo.class);){
                Entities.persist((Object)volumeInfo);
                tran.commit();
            }
        }
    }

    @Override
    public String getSnapshotPath(String snapshotId) throws EucalyptusCloudException {
        return this.getVolumePath(snapshotId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importSnapshot(String snapshotId, String volumeId, String snapPath, int size) throws EucalyptusCloudException {
        try {
            TransactionResource tran = Entities.transactionFor(SANVolumeInfo.class);
            Throwable throwable = null;
            try {
                try {
                    Entities.uniqueResult((Object)new SANVolumeInfo(snapshotId));
                    throw new EucalyptusCloudException("Snapshot " + snapshotId + " already exists. Import failed.");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (tran != null) {
                    if (throwable != null) {
                        try {
                            tran.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        tran.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (NoSuchElementException tran) {
        }
        catch (TransactionException ex) {
            throw new EucalyptusCloudException((Throwable)ex);
        }
        String sanSnapshotId = this.resourceIdOnSan(snapshotId);
        String iqn = this.connectionManager.createVolume(sanSnapshotId, size);
        if (iqn != null) {
            String deviceName = this.connectionManager.connectTarget(iqn).getPath();
            try {
                SystemUtil.run((String[])new String[]{StorageProperties.EUCA_ROOT_WRAPPER, "dd", "if=" + snapPath, "of=" + deviceName, "bs=1M"});
            }
            finally {
                this.connectionManager.disconnectTarget(sanSnapshotId, iqn);
            }
            SANVolumeInfo volumeInfo = new SANVolumeInfo(snapshotId, iqn, size).withSanVolumeId(sanSnapshotId).withSnapshotOf(volumeId);
            try (TransactionResource tran = Entities.transactionFor(SANVolumeInfo.class);){
                Entities.persist((Object)volumeInfo);
                tran.commit();
            }
        }
    }

    @Override
    public String exportVolume(String volumeId, String nodeIqn) throws EucalyptusCloudException {
        String sanVolumeId = null;
        try {
            SANVolumeInfo volumeInfo = (SANVolumeInfo)Transactions.find((Object)new SANVolumeInfo(volumeId));
            if (volumeInfo == null || StringUtils.isBlank((String)volumeInfo.getSanVolumeId())) {
                throw new EucalyptusCloudException("Backend ID not found for " + volumeId);
            }
            sanVolumeId = volumeInfo.getSanVolumeId();
        }
        catch (TransactionException | NoSuchElementException ex) {
            throw new EucalyptusCloudException("Backend ID not found for " + volumeId, ex);
        }
        LOG.info((Object)("Exporting backend volume " + sanVolumeId + " mapping to " + volumeId + " to NC host IQN " + nodeIqn));
        String lun = this.connectionManager.addInitiatorRule(sanVolumeId, nodeIqn);
        if (lun == null) {
            throw new EucalyptusCloudException("No LUN found from connection manager");
        }
        String volumeConnectionString = this.connectionManager.getVolumeConnectionString(volumeId);
        if (Strings.isNullOrEmpty((String)volumeConnectionString)) {
            throw new EucalyptusCloudException("Could not get valid volume property");
        }
        String auth = this.connectionManager.getAuthType();
        String optionalUser = this.connectionManager.getOptionalChapUser();
        StringBuilder sb = new StringBuilder();
        sb.append(this.connectionManager.getProtocol()).append(',');
        sb.append(this.connectionManager.getProviderName()).append(',');
        sb.append(optionalUser == null ? "" : optionalUser).append(',');
        sb.append(auth == null ? "" : auth).append(',');
        sb.append(lun).append(',');
        sb.append(volumeConnectionString);
        return sb.toString();
    }

    @Override
    public void unexportVolumeFromAll(String volumeId) throws EucalyptusCloudException {
        String sanVolumeId = null;
        try {
            SANVolumeInfo volumeInfo = (SANVolumeInfo)Transactions.find((Object)new SANVolumeInfo(volumeId));
            if (volumeInfo == null || StringUtils.isBlank((String)volumeInfo.getSanVolumeId())) {
                throw new EucalyptusCloudException("Backend ID not found for " + volumeId);
            }
            sanVolumeId = volumeInfo.getSanVolumeId();
        }
        catch (EucalyptusCloudException ex) {
            throw ex;
        }
        catch (TransactionException | NoSuchElementException ex) {
            throw new EucalyptusCloudException("Backend ID not found for " + volumeId, ex);
        }
        LOG.info((Object)("Unexporting backend volume " + sanVolumeId + " mapping to " + volumeId + " from all hosts"));
        this.connectionManager.removeAllInitiatorRules(sanVolumeId);
    }

    @Override
    public void unexportVolume(String volumeId, String nodeIqn) throws EucalyptusCloudException, UnsupportedOperationException {
        String sanVolumeId = null;
        try {
            SANVolumeInfo volumeInfo = (SANVolumeInfo)Transactions.find((Object)new SANVolumeInfo(volumeId));
            if (volumeInfo == null || StringUtils.isBlank((String)volumeInfo.getSanVolumeId())) {
                throw new EucalyptusCloudException("Backend ID not found for " + volumeId);
            }
            sanVolumeId = volumeInfo.getSanVolumeId();
        }
        catch (EucalyptusCloudException ex) {
            throw ex;
        }
        catch (TransactionException | NoSuchElementException ex) {
            throw new EucalyptusCloudException("Backend ID not found for " + volumeId, ex);
        }
        LOG.info((Object)("Unexporting backend volume " + sanVolumeId + " mapping to " + volumeId + " from NC host IQN " + nodeIqn));
        this.connectionManager.removeInitiatorRule(sanVolumeId, nodeIqn);
    }

    @Override
    public void checkReady() throws EucalyptusCloudException {
        if (Component.State.ENABLED.equals((Object)Components.lookup(Storage.class).getState())) {
            this.connectionManager.checkConnection();
        }
    }

    @Override
    public void stop() throws EucalyptusCloudException {
        try {
            this.connectionManager.stop();
        }
        catch (EucalyptusCloudException e) {
            LOG.error((Object)"Exception stopping connection manager", (Throwable)e);
            throw e;
        }
        finally {
            this.connectionManager = null;
        }
    }

    @Override
    public void disable() throws EucalyptusCloudException {
        this.connectionManager.stop();
    }

    @Override
    public void enable() throws EucalyptusCloudException {
        this.connectionManager.configure();
        this.connectionManager.checkConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean getFromBackend(String snapshotId, int size) throws EucalyptusCloudException {
        Throwable throwable;
        TransactionResource tran2;
        SANVolumeInfo snapInfo = new SANVolumeInfo(snapshotId);
        try {
            tran2 = Entities.transactionFor(SANVolumeInfo.class);
            throwable = null;
            try {
                SANVolumeInfo foundSnapInfo = (SANVolumeInfo)Entities.uniqueResult((Object)snapInfo);
                if (foundSnapInfo == null) throw new EucalyptusCloudException("Backend ID not found for " + snapshotId);
                if (StringUtils.isBlank((String)foundSnapInfo.getSanVolumeId())) {
                    throw new EucalyptusCloudException("Backend ID not found for " + snapshotId);
                }
                LOG.info((Object)("Checking for backend snapshot " + foundSnapInfo.getSanVolumeId() + " mapping to " + snapshotId));
                if (this.connectionManager.snapshotExists(foundSnapInfo.getSanVolumeId())) {
                    boolean bl = true;
                    return bl;
                }
                Entities.delete((Object)foundSnapInfo);
                tran2.commit();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (tran2 != null) {
                    if (throwable != null) {
                        try {
                            tran2.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        tran2.close();
                    }
                }
            }
        }
        catch (Exception tran2) {
            // empty catch block
        }
        snapInfo.setScName(null);
        try {
            tran2 = Entities.transactionFor(SANVolumeInfo.class);
            throwable = null;
            try {
                SANVolumeInfo foundSnapInfo;
                List foundSnapInfos = Entities.query((Object)snapInfo);
                Iterator i$ = foundSnapInfos.iterator();
                do {
                    if (!i$.hasNext()) return false;
                    foundSnapInfo = (SANVolumeInfo)i$.next();
                    LOG.info((Object)("Checking for backend snapshot " + foundSnapInfo.getSanVolumeId() + " mapping to " + snapshotId));
                } while (!this.connectionManager.snapshotExists(foundSnapInfo.getSanVolumeId()));
                SANVolumeInfo newSnapInfo = new SANVolumeInfo(snapshotId, foundSnapInfo.getIqn(), foundSnapInfo.getSize().intValue()).withSanVolumeId(foundSnapInfo.getSanVolumeId()).withSnapshotOf(foundSnapInfo.getSnapshotOf());
                Entities.persist((Object)newSnapInfo);
                tran2.commit();
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tran2 != null) {
                    if (throwable != null) {
                        try {
                            tran2.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        tran2.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void checkVolume(String volumeId) throws EucalyptusCloudException {
    }

    @Override
    public List<CheckerTask> getCheckers() {
        return new ArrayList<CheckerTask>();
    }

    @Override
    public String createSnapshotPoint(String parentVolumeId, String volumeId) throws EucalyptusCloudException {
        if (this.connectionManager != null) {
            String sanParentVolumeId = null;
            try {
                SANVolumeInfo parentVolInfo = (SANVolumeInfo)Transactions.find((Object)new SANVolumeInfo(parentVolumeId));
                if (parentVolInfo == null || StringUtils.isBlank((String)parentVolInfo.getSanVolumeId())) {
                    throw new EucalyptusCloudException("Backend ID not found for " + parentVolumeId);
                }
                sanParentVolumeId = parentVolInfo.getSanVolumeId();
            }
            catch (TransactionException | NoSuchElementException ex) {
                LOG.error((Object)(parentVolumeId + ": Failed to lookup source volume entity"), ex);
                throw new EucalyptusCloudException("Failed to lookup source snapshot volume for " + parentVolumeId, ex);
            }
            String snapshotPoint = this.resourceIdOnSan(volumeId);
            LOG.info((Object)("Creating backend snapshot point " + snapshotPoint + " against backend parent volume " + sanParentVolumeId + " mapping to " + parentVolumeId));
            return this.connectionManager.createSnapshotPoint(sanParentVolumeId, snapshotPoint);
        }
        throw new EucalyptusCloudException("Cannot create snapshot point, no SAN provider found");
    }

    @Override
    public void deleteSnapshotPoint(String parentVolumeId, String volumeId, String snapshotPointId) throws EucalyptusCloudException {
        if (this.connectionManager == null) {
            throw new EucalyptusCloudException("Cannot delete snapshot point, no SAN provider found");
        }
        this.connectionManager.deleteSnapshotPoint(parentVolumeId, snapshotPointId);
    }

    static {
        LOG = Logger.getLogger(SANManager.class);
    }
}

