/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.san.common;

import com.eucalyptus.blockstorage.san.common.entities.SANInfo;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.log4j.Logger;

public class Paths {
    private static final Logger LOG = Logger.getLogger(Paths.class);
    protected String currentPathsProperty = null;
    protected List<SANInfo.Path> paths = Lists.newArrayList();

    public synchronized int size() {
        return this.paths.size();
    }

    public synchronized Paths update(String value) {
        if (value != null && !value.equals(this.currentPathsProperty)) {
            try {
                List newPaths = SANInfo.parsePaths((String)value);
                this.paths.clear();
                this.paths.addAll(newPaths);
                this.currentPathsProperty = value;
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        return this;
    }

    public synchronized String getPathsForVolumeProperty() {
        StringBuilder sb = new StringBuilder();
        for (SANInfo.Path path : this.paths) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(path.iface).append(',').append(path.ip).append(',').append(path.iqn);
        }
        return sb.toString();
    }

    public synchronized String getPathsForVolumeProperty(String iqn) {
        StringBuilder sb = new StringBuilder();
        for (SANInfo.Path path : this.paths) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(path.iface).append(',').append(path.ip).append(',').append(iqn);
        }
        return sb.toString();
    }

    public synchronized String getFirstTargetIqn() {
        if (this.paths.size() > 0) {
            return this.paths.get((int)0).iqn;
        }
        return null;
    }
}

