/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.pipelines;

import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.ws.Handlers;
import com.eucalyptus.ws.handlers.BindingHandler;
import com.eucalyptus.ws.server.FilteredPipeline;
import com.eucalyptus.ws.stages.ExternalSCAuthenticationStage;
import com.eucalyptus.ws.stages.UnrollableStage;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.HttpRequest;

@ComponentPart(value=Storage.class)
public class ExternalStorageControllerSoapPipeline
extends FilteredPipeline {
    private static final String SC_EXTERNAL_SOAP_NAMESPACE = "storagecontroller_eucalyptus_ucsb_edu";
    private final UnrollableStage auth = new ExternalSCAuthenticationStage();

    public boolean checkAccepts(HttpRequest message) {
        return (message.getUri().endsWith("/services/Storage") || message.getUri().endsWith("/services/Storage/")) && message.getHeaderNames().contains("SOAPAction") && message.getHeader("SOAPAction").trim().startsWith("\"EucalyptusSC#");
    }

    public String getName() {
        return "storage-controller-external-soap";
    }

    public ChannelPipeline addHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("deserialize", Handlers.soapMarshalling());
        this.auth.unrollStage(pipeline);
        pipeline.addLast("ws-addressing", Handlers.newAddressingHandler((String)"EucalyptusSC#"));
        pipeline.addLast("build-soap-envelope", Handlers.soapHandler());
        pipeline.addLast("binding", (ChannelHandler)new BindingHandler(BindingManager.getBinding((String)SC_EXTERNAL_SOAP_NAMESPACE)));
        return pipeline;
    }
}

