/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.config;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.StorageManagers;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.config.ComponentConfiguration;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableIdentifier;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.MultiDatabasePropertyEntry;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.system.BaseDirectory;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Internets;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_config")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ComponentPart(value=Storage.class)
@ConfigurableClass(root="storage", alias="basic", description="Basic cluster controller configuration.", singleton=false, deferred=true)
public class StorageControllerConfiguration
extends ComponentConfiguration
implements Serializable {
    @Transient
    private static String DEFAULT_SERVICE_PATH = "/services/Storage";
    @Transient
    @ConfigurableIdentifier
    private String propertyPrefix;
    @ConfigurableField(description="EBS Block Storage Manager to use for backend", displayName="EBS Block Storage Manager", changeListener=StorageBackendChangeListener.class)
    @Column(name="system_storage_ebs_backend")
    private String blockStorageManager;
    @Column(name="available_storage_backends")
    private String availableBackends;
    private static final String BLOCK_STORAGE_MANAGER_OVERLAY = "overlay";
    private static final String BLOCK_STORAGE_MANAGER_DAS = "das";
    private static final String BLOCK_STORAGE_MANAGER_EQUALLOGIC = "equallogic";
    private static final String BLOCK_STORAGE_MANAGER_NETAPP = "netapp";
    private static final Pattern EBS_STORAGE_MANAGER_PATTERN = Pattern.compile(".*-Debs\\.storage\\.manager=(\\w+).*");
    private static final Pattern EBS_SAN_PROVIDER_PATTERN = Pattern.compile(".*-Debs\\.san\\.provider=(\\w+).*");

    @PrePersist
    private void updateRedundantConfig() {
        if (this.blockStorageManager == null && this.getPartition() != null) {
            for (ServiceConfiguration s : ServiceConfigurations.listPartition(Storage.class, (String)this.getPartition())) {
                StorageControllerConfiguration otherSc = (StorageControllerConfiguration)s;
                this.blockStorageManager = otherSc.getBlockStorageManager() != null ? otherSc.getBlockStorageManager() : null;
            }
        }
    }

    public StorageControllerConfiguration() {
    }

    public StorageControllerConfiguration(String name) {
        super.setName(name);
    }

    public StorageControllerConfiguration(String partition, String name, String hostName, Integer port) {
        super(partition, name, hostName, port, DEFAULT_SERVICE_PATH);
    }

    public StorageControllerConfiguration(String partition, String name, String hostName, Integer port, String storageManager) {
        super(partition, name, hostName, port, DEFAULT_SERVICE_PATH);
        this.blockStorageManager = storageManager;
    }

    public String getBlockStorageManager() {
        return this.blockStorageManager;
    }

    public void setBlockStorageManager(String m) {
        this.blockStorageManager = m;
    }

    public String getPropertyPrefix() {
        return this.getPartition();
    }

    public void setPropertyPrefix(String p) {
        this.setPartition(p);
    }

    private static String matchParameter(Pattern pattern, String text) {
        Matcher matcher = pattern.matcher(text);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public String getAvailableBackends() {
        return this.availableBackends;
    }

    public void setAvailableBackends(String availableBackends) {
        this.availableBackends = availableBackends;
    }

    @Upgrades.EntityUpgrade(entities={StorageControllerConfiguration.class}, since=Upgrades.Version.v3_2_0, value=Storage.class)
    public static enum StorageControllerConfigurationUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        private static String loadLocalBlockStorageManagerConfig() throws Exception {
            String line;
            String manager = StorageControllerConfiguration.BLOCK_STORAGE_MANAGER_OVERLAY;
            BufferedReader fileReader = new BufferedReader(new FileReader(BaseDirectory.HOME + "/etc/eucalyptus/eucalyptus.conf"));
            String ebsStorageManager = null;
            String ebsSanProvider = null;
            while ((line = fileReader.readLine()) != null) {
                line.trim();
                if (!line.startsWith("CLOUD_OPTS")) continue;
                ebsStorageManager = StorageControllerConfiguration.matchParameter(EBS_STORAGE_MANAGER_PATTERN, line);
                ebsSanProvider = StorageControllerConfiguration.matchParameter(EBS_SAN_PROVIDER_PATTERN, line);
                break;
            }
            fileReader.close();
            if (Strings.isNullOrEmpty(ebsStorageManager)) {
                manager = StorageControllerConfiguration.BLOCK_STORAGE_MANAGER_OVERLAY;
            } else if ("DASManager".equals(ebsStorageManager)) {
                manager = StorageControllerConfiguration.BLOCK_STORAGE_MANAGER_DAS;
            } else if ("OverlayManager".equals(ebsStorageManager)) {
                manager = StorageControllerConfiguration.BLOCK_STORAGE_MANAGER_OVERLAY;
            } else if ("SANManager".equals(ebsStorageManager)) {
                if ("EquallogicProvider".equals(ebsSanProvider)) {
                    manager = StorageControllerConfiguration.BLOCK_STORAGE_MANAGER_EQUALLOGIC;
                } else if ("NetappProvider".equals(ebsSanProvider)) {
                    manager = StorageControllerConfiguration.BLOCK_STORAGE_MANAGER_NETAPP;
                } else {
                    LOG.error((Object)("Invalid SAN provider name: " + ebsSanProvider));
                }
            } else {
                LOG.error((Object)("Invalid storage manager name: " + ebsStorageManager));
            }
            return manager;
        }

        public boolean apply(Class arg0) {
            EntityTransaction db = Entities.get(StorageControllerConfiguration.class);
            try {
                Set localAddresses = Internets.getAllLocalHostNamesIps();
                List entities = Entities.query((Object)new StorageControllerConfiguration());
                for (StorageControllerConfiguration entry : entities) {
                    if (!localAddresses.contains(entry.getHostName())) continue;
                    LOG.debug((Object)("Upgrading SC config " + entry.getPartition()));
                    entry.setBlockStorageManager(StorageControllerConfigurationUpgrade.loadLocalBlockStorageManagerConfig());
                    LOG.debug((Object)("Set storage manager " + entry.getBlockStorageManager() + " for SC " + entry.getPartition()));
                    break;
                }
                db.commit();
                return true;
            }
            catch (Exception ex) {
                db.rollback();
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }

        static {
            LOG = Logger.getLogger(StorageControllerConfigurationUpgrade.class);
        }
    }

    public static class StorageBackendChangeListener
    implements PropertyChangeListener<String> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            String existingValue = t.getValue();
            if (existingValue != null && !"<unset>".equals(existingValue)) {
                if (newValue != null && !newValue.equals(existingValue)) {
                    throw new ConfigurablePropertyException("Cannot change extant storage backend configuration. You must deregister all SCs in the partition before you can change the configuration value");
                }
            } else {
                String probablePartitionName = ((MultiDatabasePropertyEntry)t).getEntrySetName();
                if (probablePartitionName == null) {
                    throw new ConfigurablePropertyException("Could not determing partition name from property to check validity");
                }
                String[] parts = probablePartitionName.split("\\.");
                if (parts == null || parts.length == 0) {
                    throw new ConfigurablePropertyException("Could not determing partition name from property to check validity: " + probablePartitionName);
                }
                probablePartitionName = parts[0];
                List scConfigs = null;
                try {
                    scConfigs = ServiceConfigurations.listPartition(Storage.class, (String)probablePartitionName);
                }
                catch (NoSuchElementException e) {
                    throw new ConfigurablePropertyException("No Storage Controller configurations found for partition: " + probablePartitionName);
                }
                final String proposedValue = newValue;
                final HashSet validEntries = Sets.newHashSet();
                EntityTransaction tx = Entities.get(StorageControllerConfiguration.class);
                try {
                    if (!Iterables.any((Iterable)scConfigs, (Predicate)new Predicate<ServiceConfiguration>(){

                        public boolean apply(ServiceConfiguration config) {
                            if (config.isVmLocal().booleanValue()) {
                                validEntries.addAll(StorageManagers.list());
                                return StorageManagers.contains(proposedValue);
                            }
                            try {
                                StorageControllerConfiguration scConfig = (StorageControllerConfiguration)Entities.uniqueResult((Object)((StorageControllerConfiguration)config));
                                for (String entry : Splitter.on((String)",").split((CharSequence)scConfig.getAvailableBackends())) {
                                    validEntries.add(entry);
                                }
                                return validEntries.contains(proposedValue);
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                    })) {
                        throw new ConfigurablePropertyException("Cannot modify " + t.getQualifiedName() + "." + t.getFieldName() + " new value is not a valid value.  " + "Legal values are: " + Joiner.on((String)",").join((Iterable)Sets.filter((Set)validEntries, StorageManagers.SUPPORTED_PROVIDER_PREDICATE)));
                    }
                }
                finally {
                    tx.rollback();
                }
            }
        }
    }
}

