/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.config;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.StorageManagers;
import com.eucalyptus.blockstorage.config.StorageControllerConfiguration;
import com.eucalyptus.blockstorage.msgs.DeregisterStorageControllerType;
import com.eucalyptus.blockstorage.msgs.DescribeStorageControllersType;
import com.eucalyptus.blockstorage.msgs.ModifyStorageControllerAttributeType;
import com.eucalyptus.blockstorage.msgs.RegisterStorageControllerType;
import com.eucalyptus.bootstrap.Handles;
import com.eucalyptus.component.AbstractServiceBuilder;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceRegistrationException;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.LogUtil;
import com.google.common.base.Joiner;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

@ComponentPart(value=Storage.class)
@Handles(value={RegisterStorageControllerType.class, DeregisterStorageControllerType.class, DescribeStorageControllersType.class, ModifyStorageControllerAttributeType.class})
public class StorageControllerBuilder
extends AbstractServiceBuilder<StorageControllerConfiguration> {
    private static Logger LOG = Logger.getLogger(StorageControllerBuilder.class);

    public void fireLoad(ServiceConfiguration parent) throws ServiceRegistrationException {
        block4: {
            try {
                if (!parent.isVmLocal().booleanValue()) break block4;
                LOG.info((Object)("Firing LOAD for local config: " + parent.getName()));
                EntityTransaction tx = Entities.get((Object)parent);
                try {
                    parent = (ServiceConfiguration)Entities.merge((Object)parent);
                    ((StorageControllerConfiguration)parent).setAvailableBackends(Joiner.on((String)",").join(StorageManagers.list()));
                    tx.commit();
                }
                catch (Exception ex) {
                    LOG.debug((Object)"Error merging parent transaction. Rolling back.");
                    tx.rollback();
                }
                String propertyBackend = ((StorageControllerConfiguration)parent).getBlockStorageManager();
                StorageManagers.getInstance(propertyBackend);
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    public ComponentId getComponentId() {
        return ComponentIds.lookup(Storage.class);
    }

    public StorageControllerConfiguration newInstance() {
        return new StorageControllerConfiguration();
    }

    public StorageControllerConfiguration newInstance(String partition, String name, String host, Integer port) {
        return new StorageControllerConfiguration(partition, name, host, port);
    }

    public boolean checkAdd(String partition, String name, String host, Integer port) throws ServiceRegistrationException {
        try {
            Partition part = Partitions.lookup((ServiceConfiguration)this.newInstance(partition, name, host, port));
            part.syncKeysToDisk();
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw new ServiceRegistrationException(String.format("Unexpected error caused storage controller registration to fail for: partition=%s name=%s host=%s port=%d", partition, name, host, port), (Throwable)ex);
        }
        return super.checkAdd(partition, name, host, port);
    }

    public void fireStop(ServiceConfiguration config) throws ServiceRegistrationException {
        try {
            if (config.isVmLocal().booleanValue()) {
                LOG.info((Object)("Firing STOP for local config: " + config.getName()));
                StorageManagers.flushManagerInstances();
            }
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void fireStart(ServiceConfiguration config) throws ServiceRegistrationException {
        if (config.isVmLocal().booleanValue()) {
            LOG.info((Object)("Firing START for local config: " + config.getName()));
            System.setProperty("euca.storage.name", config.getName());
            LOG.info((Object)LogUtil.subheader((String)("Setting euca.storage.name=" + config.getName() + " for: " + LogUtil.dumpObject((Object)config))));
        }
    }

    public void fireEnable(ServiceConfiguration config) throws ServiceRegistrationException {
    }

    public void fireDisable(ServiceConfiguration config) throws ServiceRegistrationException {
    }

    public void fireCheck(ServiceConfiguration config) throws ServiceRegistrationException {
    }
}

